/* (c) 2004 Stefan Bogner <bochi@online.ms>
    See COPYING file for licensing information */
    
#ifndef _KAMMU_H_
#define _KAMMU_H_

#ifndef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapplication.h>
#include <kmainwindow.h>
#include "statusbar.h"
#include <ksystemtray.h>
#include "kammumain.h"

class KPrinter;
class KToggleAction;
class KURL;
class KStatusBar;
class KSystemTray;

class Kammu : public KMainWindow
{
    Q_OBJECT

public:
    
    Kammu();

    virtual ~Kammu();

public slots:
    void keepTray( QWidget*, QEvent* );
    void operationInProgress(int);
        
private slots:
    void optionsShowToolbar();
    void optionsShowStatusbar();
    void optionsConfigureKeys();
    void optionsConfigureToolbars();
    void optionsPreferences();
    void newToolbarConfig();
    void changeCaption(const QString& text);
    void settingsChanged();
    void setupOpProgress(int p);
    void incOpProgress();
    

private:
    void setupAccel();
    void setupActions();

private:
    KammuMain *m_view;
    StatusBar::StatusBar *m_statusbar;
    KPrinter   *m_printer;
    KToggleAction *m_toolbarAction;
    KToggleAction *m_statusbarAction;
    KSystemTray *m_trayicon;
};

#endif // _KAMMU_H_

