/* (c) 2004 Stefan Bogner <bochi@online.ms>
    See COPYING file for licensing information */
    
#include "options1.h"
#include "options2.h"  
#include "options3.h"
#include "configdialog.h"
#include "settings.h"

#include <kconfig.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <kdebug.h>
#include <klocale.h>
#include <kmessagebox.h>

#include <qtextstream.h>
#include <qfile.h>
#include <qvbox.h>

ConfigDialog::ConfigDialog( QWidget *parent, const char* name, KConfigSkeleton *config )
    : KConfigDialog( parent, name, config )
{
    setWFlags( WDestructiveClose );
    
    readGammuRc();
    
    Options1 *opt1 = new Options1( 0, "General" );
    Options2 *opt2 = new Options2( 0, "Gammu" );
    Options3 *opt3 = new Options3( 0, "Appearance" );   
    
    opt2->kcfg_Port->setCurrentText( KammuConfig::port() );
    opt2->kcfg_Connection->setCurrentText( KammuConfig::connection() );
    opt2->kcfg_Model->setCurrentText( KammuConfig::model() );
    opt2->kcfg_GammuCoding->setCurrentText( KammuConfig::gammuCoding() );
    if( KammuConfig::syncTime() ) opt2->kcfg_SyncTime->setChecked( true );
    if( KammuConfig::startInfo() ) opt2->kcfg_StartInfo->setChecked( true );
    if( KammuConfig::useLocking() ) opt2->kcfg_UseLocking->setChecked( true );
    
    addPage( opt1, i18n( "General" ), "kammu", i18n( "Configure General Options" ) );
    addPage( opt2, i18n( "Gammu" ), "misc", i18n( "Configure Gammu Options" ) );    
    addPage( opt3, i18n( "Appearance" ), "colorize", i18n( "Configure Appearance" ) );    
    
    connect( this, SIGNAL(settingsChanged()), this, SLOT(writeGammuRc()));
    
    show();
}

ConfigDialog::~ConfigDialog()
{
}

void ConfigDialog::readGammuRc()
{
    QString line;
    QString home( ::getenv( "HOME" ) );
    QFile file( home + "/.gammurc" );
        
    if( !QFile::exists( home + "/.gammurc" ) ) {
        
        file.setName( "/etc/gammurc" );
        
        if( !QFile::exists( "/etc/gammurc" ) ) {
                
            KMessageBox::error( this, "No gammu configuration file found. Creating a new one in ~/.gammurc. Please update your Gammu configuration in the 'Gammu'-Menu.", "No Gammu configuration found" );
                
            file.setName( home + "/.gammurc" );
                                
            if ( file.open( IO_WriteOnly ) ) {
                    
                QTextStream stream( &file );
                stream << "[gammu]" << "\n" << "bleh" << "\n" << "test";
                file.close();
            }
        } 
        else {
            
            QFile input( "/etc/gammurc" );
            QFile output( home + "/.gammurc" );
            
            if( !input.open( IO_ReadOnly ) ) {
                
                KMessageBox::error( this, "Can't open /etc/gammurc for reading.", "Can't open file" );
                return;
            }
            
            if( !output.open( IO_WriteOnly ) ) {
                
                KMessageBox::error( this, "Can't open ~/.gammurc for writing.", "Can't open file" );
                return;
            }
            
            QTextStream instream( &input );
            QTextStream outstream( &output );
            outstream << instream.read();
            output.close();
            input.close();
        }
    }
    
    if ( file.open( IO_ReadOnly ) ) {
            
        QTextStream stream( &file );

        while ( !stream.atEnd() ) {
                
            line = stream.readLine();
                
            if ( line.startsWith("port = " ) ) KammuConfig::setPort( line.section("port = ", 1, 1 ) );
            else if ( line.startsWith("connection = " ) ) KammuConfig::setConnection( line.section("connection = ", 1, 1 ) );
            else if ( line.startsWith("model = " ) ) KammuConfig::setModel( line.section("model = ", 1, 1 ) );
            else if ( line.startsWith("logfile = " ) ) KammuConfig::setLogFile( line.section("logfile = ", 1, 1 ) );
            else if ( line.startsWith("logformat = " ) ) KammuConfig::setLogLevel( line.section("logformat = ", 1, 1 ) );
            else if ( line.startsWith("gammucoding = " ) ) KammuConfig::setGammuCoding( line.section("gammucoding = ", 1, 1 ) );
            else if ( line.startsWith("syncronizetime = " ) ) {
                
                line = line.section("syncronizetime = ", 1, 1 );
                if( line.contains( "yes"  ) ) KammuConfig::setSyncTime( true );
                else KammuConfig::setSyncTime( false );
            }
            else if ( line.startsWith("startinfo = " ) ) {
                
                line = line.section("startinfo = ", 1, 1 );
                if( line.contains( "yes"  ) ) KammuConfig::setStartInfo( true );
                else KammuConfig::setStartInfo( false );
            }
            else if ( line.startsWith("use_locking = " ) ) {
                
                line = line.section("use_locking = ", 1, 1 );
                if( line.contains( "yes"  ) ) KammuConfig::setUseLocking( true );
                else KammuConfig::setUseLocking( false );
            }
        }
    }
}

void ConfigDialog::writeGammuRc() 
{
    QString line;
    QString home( ::getenv( "HOME" ) );
    QFile file( home + "/.gammurc" );
    
    if ( file.open( IO_WriteOnly ) ) {
                    
        QTextStream stream( &file );
        
        stream << "[gammu]" << "\n";
        
        if( KammuConfig::port() != "" ) stream << "port = " << KammuConfig::port() << "\n";
        if( KammuConfig::connection() != "" ) stream << "connection = " << KammuConfig::connection() << "\n";
        if( KammuConfig::model() != "" ) stream << "model = " << KammuConfig::model() << "\n";
        if( KammuConfig::logFile() != "" && KammuConfig::logging() ) stream << "logfile = " << KammuConfig::logFile() << "\n";
        if( KammuConfig::logLevel() != "" && KammuConfig::logging() ) stream << "logformat = " << KammuConfig::logLevel() << "\n";
        if( KammuConfig::gammuCoding() != "" ) stream << "gammucoding = " << KammuConfig::gammuCoding() << "\n";
        if( KammuConfig::syncTime() ) stream << "syncronizetime = yes" << "\n";
        if( KammuConfig::startInfo() ) stream << "startinfo = yes" << "\n";
        if( KammuConfig::useLocking() ) stream << "use_locking = yes" << "\n";
         
        file.close();
    }
}

#include "configdialog.moc"
