#include <sys/types.h>
#include <sys/socket.h>

#include <netinet/in.h>      
#include <netdb.h>
#include <time.h>

#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <setjmp.h>

/* difference between Unix time and net time */
#define BASE1970	2208988800UL

jmp_buf	jmp;

void alarm_handler(int signum)
{
	signal(SIGALRM, alarm_handler);
	alarm(5);
	longjmp(jmp, 1);
}

time_t
RemoteDate_UDP(char *host)
{
	struct	servent *timeServ;	/* sevice file entry */
#ifndef INET6
	struct  hostent *him;           /* host table entry */
	struct	sockaddr_in sin;	/* socket address */
#else
        struct  addrinfo hints, *res, *res0;
	struct  sockaddr_storage sin;   /* socket address */
	int     err = -1;               /* error handling */
	char    myhost[NI_MAXHOST];     /* hostname */
#endif
	int	fd;			/* network file descriptor */
	time_t	unixTime;		/* time in Unix format */
	u_char  netTime[4];		/* time in network format */
	int	i;			/* loop variable */
	int	n, jmpstatus;

#ifndef INET6
	if ((him = gethostbyname(host)) == NULL) {
		fprintf(stderr, "rdate: Unknown host %s\n", host);
		return(-1);
	}

        if ((timeServ = getservbyname("time","udp")) == NULL) {
                fprintf(stderr, "rdate: time/udp: unknown service\n");
                return(-1);
        }

	if ((fd = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
		perror("rdate");
		return(-1);
	}

        sin.sin_family = him->h_addrtype;      
        memcpy(&sin.sin_addr, him->h_addr, him->h_length);
        sin.sin_port = timeServ->s_port;

	if (sendto(fd, netTime, 0, 0, (struct sockaddr *)&sin, sizeof(sin)) < 0) {
#else
        snprintf(myhost, sizeof(myhost), host);
        memset(&hints, 0, sizeof(hints));
        hints.ai_family   = AF_UNSPEC;
	hints.ai_socktype = SOCK_DGRAM;
        err = getaddrinfo(host, "time", &hints, &res0);
        if (err < 0) {
                fprintf(stderr, "rdate %s", gai_strerror(err));
                return(-1);
        }
        err = -1;

        for (res = res0; res; res = res->ai_next) {
                if ((fd = socket(res->ai_family, res->ai_socktype, res->ai_protocol)) >= 0) {
			err = 0;
			break;
		}
	}
        freeaddrinfo(res0);
        if (err < 0) {
                perror("rdate");
                return(-1);
        }

	if (sendto(fd, netTime, 0, 0, res->ai_addr, res->ai_addrlen) < 0) {
#endif
		perror("rdate");
		close(fd);
		return (-1);
	}

	/* read in the response, with an alarm */

	signal(SIGALRM, alarm_handler);
	alarm(5);
#ifndef INET6
	i = sizeof(sin);
	if ((jmpstatus = setjmp(jmp)) == 0 &&
	  (n = recvfrom(fd, netTime, sizeof(netTime), 0, (struct sockaddr *)&sin, &i)) < 0) {
#else
	if ((jmpstatus = setjmp(jmp)) == 0 &&
	  (n = recvfrom(fd, netTime, sizeof(netTime), 0, res->ai_addr, &res->ai_addrlen)) < 0) {
#endif
		perror("rdate");
		close(fd);
		return (-1);
	}
	if (jmpstatus != 0) {
		fprintf(stderr, "rdate: timed out waiting for data from %s\n", host);
		close(fd);
		return (-1);
	}
	if (n < sizeof(netTime)) {
		fprintf(stderr, "rdate: partial data read from %s\n", host);
		close(fd);
		return (-1);
	}

	close(fd);

	unixTime = ((time_t)netTime[0] << 24 |
		    (time_t)netTime[1] << 16 |
		    (time_t)netTime[2] << 8  |
		    (time_t)netTime[3] << 0  ) - BASE1970;

	return unixTime;
}

time_t
RemoteDate(char *host)
{
	struct	servent *timeServ;	/* sevice file entry */
#ifndef INET6
	struct  hostent *him;           /* host table entry */
	struct	sockaddr_in sin;	/* socket address */
#else
	struct  addrinfo hints, *res, *res0;
	struct  sockaddr_storage sin;   /* socket address */
	int     err = -1;		/* error handling */
	char	myhost[NI_MAXHOST];	/* hostname */
#endif
	int	fd;			/* network file descriptor */
	time_t	unixTime;		/* time in Unix format */
	u_char  netTime[4];		/* time in network format */
	int	i;			/* loop variable */

#ifndef INET6
	if ((him = gethostbyname(host)) == NULL) {
		fprintf(stderr, "rdate: Unknown host %s\n", host);
		return(-1);
	}

        if ((timeServ = getservbyname("time","tcp")) == NULL) {
                fprintf(stderr, "rdate: time/tcp: unknown service\n");
                return(-1);
        }

	if ((fd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
		perror("rdate");
		return(-1);
	}

        sin.sin_family = him->h_addrtype;      
        memcpy(&sin.sin_addr, him->h_addr, him->h_length);
        sin.sin_port = timeServ->s_port;

        if (connect(fd, &sin, sizeof(sin)) < 0) {
		perror("rdate");
		close(fd);
		return(-1);
	}
#else
	snprintf(myhost, sizeof(myhost), host);
	memset(&hints, 0, sizeof(hints));
	hints.ai_family   = AF_UNSPEC;
	hints.ai_socktype = SOCK_STREAM;
	err = getaddrinfo(host, "time", &hints, &res0);
	if (err < 0) {
		fprintf(stderr, "rdate %s", gai_strerror(err));
		return(-1);
	}
	err = -1;

	for (res = res0; res; res = res->ai_next) {
		if ((fd = socket(res->ai_family, res->ai_socktype, res->ai_protocol)) < 0)
			continue;
		if (connect(fd, res->ai_addr, res->ai_addrlen) < 0)
			close(fd);
		else {
			err = 0;
			break;
		}
	}
	freeaddrinfo(res0);
	if (err < 0) {
		perror("rdate");
		return(-1);
	}
#endif

	/* read in the response */
	for (i = 0; i < 4; ) {
		int l = read(fd, &netTime[i], 4-i);
		if (l <= 0) {
			perror("rdate");
			close(fd);
			return(-1);
		}
		i += l;
	}

	close(fd);

	unixTime = ((time_t)netTime[0] << 24 |
		    (time_t)netTime[1] << 16 |
		    (time_t)netTime[2] << 8  |
		    (time_t)netTime[3] << 0  ) - BASE1970;

	return unixTime;
}

int 
main(int argc, char *argv[])
{
	int o, mode = 0;
	time_t t;

	while ((o = getopt(argc, argv, "spu")) != EOF)
		switch (o) {
		  case 'p':
			mode |= 1;
			break;
		  case 's':
			mode |= 2;
			break;
		  case 'u':
			mode |= 4;
			break;
		  default:
		  usage:
			fprintf(stderr, "Usage: rdate [-s] [-p] [-u] <host> ...\n");
			return 1;
		}
	if (optind >= argc)
		goto usage;
	if ((mode & 3) == 0)
		mode |= 1;

	for (o = optind; o < argc; ++o) {
		t = (mode & 4) ? RemoteDate_UDP(argv[o]) : RemoteDate(argv[o]);
		if (t == (time_t)-1)
			continue;
		if (mode & 1)
			printf("[%s]\t%s", argv[o], ctime(&t));
		if (mode & 2)
			if (stime(&t) < 0) {
				perror("rdate");
				return 1;
			}
	}

	return 0;
}
