/* $Id: sp_ip_fragbits.h,v 1.2.4.2 2002/04/23 23:44:53 chrisgreen Exp $ */

/*
** Copyright (C) 1998-2002 Martin Roesch <roesch@sourcefire.com>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
/* Snort Detection Plugin Header for IP Fragment Bits plugin*/

#ifndef __SP_IP_FRAGBITS_H__
#define __SP_IP_FRAGBITS_H__

#include "snort.h"

#define PLUGIN_FRAG_BITS  21
#define PLUGIN_FRAG_OFFSET 29

#define GREATER_THAN            1
#define LESS_THAN               2


#define FB_NORMAL   0
#define FB_ALL      1
#define FB_ANY      2
#define FB_NOT      3

#define FB_RB  0x8000
#define FB_DF  0x4000
#define FB_MF  0x2000

typedef struct _FragBitsData
{
    char mode;
    u_int16_t frag_bits;

} FragBitsData;

typedef struct _FragOffsetData
{
    u_int8_t  comparison_flag;
    u_int8_t  not_flag;
    u_int16_t offset;
} FragOffsetData;


void FragBitsInit(char *, OptTreeNode *, int);
void SetupFragBits();
void ParseFragBits(char *, OptTreeNode *);
int CheckFragBits(Packet *, struct _OptTreeNode *, OptFpList *);



void SetupFragOffset();
void FragOffsetInit(char *, OptTreeNode *, int);
void ParseFragOffset(char *, OptTreeNode *);
int CheckFragOffset(Packet *, struct _OptTreeNode *, OptFpList *);

#endif  /* __SP_IP_FRAGBITS_H__ */
