/*  This file is part of the KDE Libraries
 *  Copyright (C) 1999-2000 Espen Sand (espen@kde.org)
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

/*
****************************************************************************
*
* $Log: kxtextbrowser.cpp,v $
* Revision 1.1  2001/06/03 17:18:17  herwinjs
* 	* fixed a little bug in the reply button
* 	* did some GUI changes in the Message Chat dialog
* 	* all URL's in messages are now parsed and can open Konq on a mouse click
* 	* switched from QTextBrowser to kxTextBrowser (changed version of KTextBrowser
* 	* start developing in KDeveloper
* 	* I have started again ;-)
*
*
* Revision 1.3  2001/06/04 17:28:12  herwin
*
* Added for KXicq2
*
* Revision 1.2  2001/05/22 02:41:12  spiderbarker
*
* added AboutKDE widget and renamed KTextBrowser class to KaimTextBrowser
*
* Revision 1.1  2001/05/06 21:15:21  icefox
* now using ktextbrower with right click addition
*
* Revision 1.8  2000/06/01 09:36:12  gehrmab
* We like orthogonal APIs
*
* Revision 1.7  2000/05/26 04:20:33  granroth
* Use the KCursor::handCursor instead of the Qt hand cursor with
* KTextBrowser.  This is for consistency.
*
* There is a little bit of flicker when it switches to the hand, though.
* That's because it first switches to the Qt version in the
* QTextBrowser code and I use that in the KTextBrowser version to know
* when to switch to the hand.  I couldn't figure out any other way to do
* this without completely reimplementing all of the enter events -- what
* a pain.
*
* Revision 1.6  2000/01/03 18:48:57  espen
* The widget will ignore a key sequence
* containing F1. Since this widget is used
* in dialogs (eg KDialogBase), F1 and Shift+F1
* can be used to start the help operation.
*
*
****************************************************************************
*/

#include <kapp.h>
#include "kxtextbrowser.h"
#include <kcursor.h>
#include <qclipboard.h>
#include <kpopupmenu.h>

kxTextBrowser::kxTextBrowser( QWidget *parent, const char *name,
			    bool notifyClick )
  : QTextBrowser( parent, name ), mNotifyClick(notifyClick)
{
  //
  //1999-10-04 Espen Sand: Not required anymore ?
  //connect( this, SIGNAL(highlighted(const QString &)),
  //   this, SLOT(refChanged(const QString &)));
 
	copyURL = false;
	URLRightClick = new KPopupMenu(this, "RightClick");
  URLRightClick->insertItem("&Open", this, SLOT(slotRightClick_Open()));
	URLRightClick->insertItem("&Copy URL", this, SLOT(slotRightClick_Copy()));
	URLMouseEvent = NULL;
	URLMouseEventPress = NULL;
  URLMouseEventRelease = NULL;
	testing = false;

}

kxTextBrowser::~kxTextBrowser( void )
{
  if (URLMouseEvent != NULL )
		delete URLMouseEvent;
	if (URLMouseEventRelease != NULL )
	  delete URLMouseEventRelease;
	if (URLMouseEventPress != NULL )
		delete URLMouseEventPress;
}


void kxTextBrowser::setNotifyClick( bool notifyClick )
{
  mNotifyClick = notifyClick;
}


bool kxTextBrowser::isNotifyClick() const
{
  return mNotifyClick;
}


void kxTextBrowser::setSource( const QString& name )
{
  if( name.isNull() == true )
  {
    return;
  }

  if (testing == true)
  {
		testing = false;
		URLRightClick->exec(tempPointGlobal);
    return;
	}
	
  if (copyURL == true)
  {
    QClipboard *cb = qApp->clipboard();
    cb->setText(name);
    copyURL = false;
    return;
  }
		  
  if( name.contains('@') == true )
  {
    if( mNotifyClick == false )
    {
      kapp->invokeMailer( name, QString::null );
    }
    else
    {
      emit mailClick( QString::null, name );
    }
  }
  else
  {
    if( mNotifyClick == false )
    {
      kapp->invokeBrowser( name );
    }
    else
    {
      emit urlClick( name );
    }
  }
}


void kxTextBrowser::keyPressEvent(QKeyEvent *e)
{
  if( e->key() == Key_Escape )
  {
    e->ignore();
  }
  else if( e->key() == Key_F1 )
  {
    e->ignore();
  }
  else
  {
    QTextBrowser::keyPressEvent(e);
  }
}

void kxTextBrowser::viewportMouseMoveEvent( QMouseEvent* e)
{
  if ( e->state() == 0 )
  {
    if (this->hasSelectedText() == true)
      copy();
	}
  // do this first so we get the right type of cursor
  QTextBrowser::viewportMouseMoveEvent(e);

  if ( viewport()->cursor().shape() == PointingHandCursor )
    viewport()->setCursor( KCursor::handCursor() );
}

/***************************************************************************
 * Brings up the Menu when the right mouse is clicked.
 ***************************************************************************/
void kxTextBrowser::viewportMousePressEvent(QMouseEvent* event){
	QTextBrowser::viewportMousePressEvent(event);
  // Right click was called
	if (event->button() == RightButton){
		// Save mouse position for posible menu exec call
		tempPointGlobal = event->globalPos();
		tempPointPos = event->pos();
		
		// General memory goodness
		if (URLMouseEvent != NULL )
		  delete URLMouseEvent;
		URLMouseEvent = new QMouseEvent(QEvent::MouseButtonPress,tempPointPos,tempPointGlobal,LeftButton,LeftButton);
	  
		// Call left click with testing on and if setSource gets called then we 
		// know it is a link and can show the menu.
		// Set up the two events
		if (URLMouseEventRelease != NULL )
		  delete URLMouseEventRelease;
    URLMouseEventRelease = new QMouseEvent(QEvent::MouseButtonRelease,tempPointPos,tempPointGlobal,LeftButton,LeftButton);
	  if (URLMouseEventPress != NULL )
		  delete URLMouseEventPress;
    URLMouseEventPress = new QMouseEvent(QEvent::MouseButtonPress,tempPointPos,tempPointGlobal,LeftButton,LeftButton);
    // Set testing to true and call both events.
		testing = true;
		this->viewportMousePressEvent(URLMouseEventPress);
		this->viewportMouseReleaseEvent(URLMouseEventRelease);
	}
}

/***************************************************************************
 * Copy the url highlighted
 ***************************************************************************/
void kxTextBrowser::slotRightClick_Copy(){
  copyURL = true;
	if (URLMouseEventRelease != NULL )
	  delete URLMouseEventRelease;
  URLMouseEventRelease = new QMouseEvent(QEvent::MouseButtonRelease,tempPointPos,tempPointGlobal,LeftButton,LeftButton);
	this->viewportMousePressEvent(URLMouseEvent);
  this->viewportMouseReleaseEvent(URLMouseEventRelease);
}


/***************************************************************************
 * Simply do a leftClick
 ***************************************************************************/
void kxTextBrowser::slotRightClick_Open(){
  if (URLMouseEventRelease != NULL )
	  delete URLMouseEventRelease;
  URLMouseEventRelease = new QMouseEvent(QEvent::MouseButtonRelease,tempPointPos,tempPointGlobal,LeftButton,LeftButton);
  this->viewportMousePressEvent(URLMouseEvent);
  this->viewportMouseReleaseEvent(URLMouseEventRelease);
}













