#ifndef KXSENDMESSAGESIMPL_H
#define KXSENDMESSAGESIMPL_H
#include <qtimer.h>
#include <kanimwidget.h>
#include "kxsendmessages.h"
#include <kxmessage.h>
#include <v2_codes.h>
#include <kxsend.h>
#include <qlayout.h>
#include <kxhistorywidget.h>

void parseHTMLtoHRef(QString &);

class kxSendMessagesImpl : public kxSendMessages
{ 
    Q_OBJECT

public:
  kxSendMessagesImpl(UIN, QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
  kxSendMessagesImpl(UIN, bool, QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );  
  kxSendMessagesImpl(UIN, bool, QString, QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );  
  
  void init();
  
  bool showFirst;
  Q_UINT32 uin;
  bool clean;
  KAnimWidget *sendAnim;  
  
  bool doSend;
  int sendSeq;
  kxSend *send;
  QString messageToSend;
  QString nick;
  kxHistoryWidget *historyView;
  QVBoxLayout* vbox_2;
  QTimer alertTimer;
  bool alert;
  bool showAlert;
  
  void makeCaption(int);
  void stopAlert();
  bool useColor;
  QColor fgColor;
  QColor bgColor;

  
public slots:
  void SlotCancelButton();  
  void SlotSendButton();
  void SlotNewMessage(UIN, kxMessageStruct);
  void SlotMessagePos(UIN,int);
  void SlotTextChanged();

  void SlotFGColor();
	void SlotBGColor();
  
  void SlotHistoryButton();
  
  void SlotSendToClientError(int);
  void SlotSendToClientOk(int);
  void SlotSendToServerError(int);
  void SlotSendToServerOk(int);
  void SlotContactStatusChange(UIN , Q_UINT16, Q_UINT16 );
  void SlotStayOnTop(bool);
  void SlotInfoButton();  
  void SlotAlertTimeout();
  /** There has been clicked on a Email referenct,
lets start eg kmail  */
  void slotEMailClick(const QString &, const QString &);
  /** there is clicked on a URL in the output widget, now we must handle the URL
start Konq. for example */
  void slotURLClick(const QString &);
  virtual void hide();  

protected:
  void enterEvent(QEvent *); 
  void focusInEvent(QFocusEvent *);     
  void mousePressEvent(QMouseEvent *);
  void keyPressEvent(QKeyEvent *);
};


#endif // KXSENDMESSAGESIMPL_H
