#include "kxlabel.h"
#include <qpixmap.h>
#include <qpainter.h>
#include <qcolor.h>
#include <qpalette.h>
#include <qfontmetrics.h>
#include <kxengine.h>
#include "kxcontact.h"
#include "kxmessage.h"
#include <kxmainwindow.h>

kxLabel::kxLabel(QWidget *_parent, const char *_name)
  : QLabel(_parent, _name)
{
  QObject::connect(ENGINE, SIGNAL(SignalUpdateDock()), this, SLOT(SlotUpdatePixmap()));
  QObject::connect(ENGINE->CONTACT, SIGNAL(recountMessages(UIN)), this, SLOT(SlotRecount(UIN)));  
}

void kxLabel::mouseReleaseEvent(QMouseEvent *e)
{
  QLabel::mouseReleaseEvent(e);
  emit clicked();
}
void kxLabel::setText(const QString &_txt)
{
  text=_txt;
  repaint();
}  
void kxLabel::SlotUpdatePixmap()
{
  repaint();
}
void kxLabel::SlotRecount(UIN)
{
  repaint();
}
void kxLabel::paintEvent(QPaintEvent *_p)
{
  QPainter paint(this);
  paint.setBrush(colorGroup().base());
  paint.setPen(colorGroup().text());  
  paint.drawRect(0,0,width()-1, height());

  int x=0;
  QPixmap pixmap;

  switch(ENGINE->currentStatus)
  {
    case STATUS_OFFLINE: 			
      pixmap=MAINWINDOW->kxIcons.offline; 	
	  	break;
    case STATUS_DND: 			
      pixmap=MAINWINDOW->kxIcons.dnd; 	
	  	break;
	  case STATUS_OCCUPIED: 	
      pixmap=MAINWINDOW->kxIcons.occupied;
	  	break;
	  case STATUS_NA: 				
	  	pixmap=MAINWINDOW->kxIcons.na; 	
	  	break;
	  case STATUS_AWAY: 			
	  	pixmap=MAINWINDOW->kxIcons.away; 	
	  	break;
	  case STATUS_FFC: 			
	  	pixmap=MAINWINDOW->kxIcons.ffc; 	
	  	break;
	  case STATUS_INVISIBLE:
  	  pixmap=MAINWINDOW->kxIcons.invisible;
  	  break;
    case STATUS_ONLINE: 			
    default:
      pixmap=MAINWINDOW->kxIcons.online; 	
	  	break;  	
  }

  if (ENGINE->MESSAGE->countUnreadMessages(0)>0)
  {    
    pixmap=MAINWINDOW->kxIcons.message;
  }

  paint.drawPixmap(3,(height()/2)-(pixmap.height()/2),pixmap);
  x=pixmap.width();

  paint.drawText(x+3+2,(height()/2)-(fontMetrics().height()/2), width()-4, height()-2, AlignLeft, text.latin1());
}
