#ifndef KXHISTORYWIDGET_H
#define KXHISTORYWIDGET_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <qsize.h>
#include <qlistview.h>
#include <v2_codes.h>

#define VIEW_SEND 0
#define VIEW_RECEIVE 1

class kxHistoryWidgetItem : public QListViewItem
{
public:
  kxHistoryWidgetItem(int,bool,QListView *);
  
  void paintCell(QPainter *, const QColorGroup &, int, int, int);
  QString text(int) const;
  virtual QString key(int, bool) const;
  int width(const QFontMetrics &, const QListView*, int) const;
  
  QString message;  
  QString date;
  QString sDate;
  bool send;
  int pos;
  bool showUin;
};
      
class kxHistoryWidget : public QListView
{
  Q_OBJECT
public:

  kxHistoryWidget(UIN,QWidget *, const char *);
  kxHistoryWidget(UIN,int, QWidget *, const char *);
  UIN uin;
  int type;
  
  void init(UIN);
  void changeUin(UIN);
  
public slots:
  void newMessage(UIN,int);
  void SlotClicked(QListViewItem *);

};

#endif

