#include <qpushbutton.h>
#include <kxengine.h>
#include <kxcontact.h>
#include <klocale.h>
#include <qfiledialog.h>
#include <kmessagebox.h>
#include "kxfiledialogimpl.h"
#include <qlabel.h>
#include <qprogressbar.h>

kxFileDialogImpl::kxFileDialogImpl(UIN _uin,KServerSocket *_sock, QString _fileName, int _size, int _port,QWidget* parent,  const char* name, int _seq) :
  kxFileDialog(parent,name)
{
  uin=_uin;
  sock=_sock;
  fileName=_fileName;
  localFileName->setText(_fileName);
  size=_size;
  port=_port;
  if (_sock==0L) type=SEND_FILE;
  else type=GOT_FILE;
  current=0;

  uinLabel->setText(QString().setNum(uin));  
  if (strlen(ENGINE->CONTACT->getContact(uin).nick)>0)
    nickLabel->setText(ENGINE->CONTACT->getContact(uin).nick); 
  else
    nickLabel->setText(i18n("<Unknown> ")+QString().setNum(uin));
  
  QStringList list;
  QString tmp;
  for (int t=1; t<=50; t++)
  {
    tmp.sprintf("kde/%04d",t);
    list.append(tmp);
  }

  sendAnim=new KAnimWidget(list, 22, animLabel, "anim");
  sendAnim->resize(25,25);
 
  fileEngine=new kxFile(_uin,_sock,_port,type,_fileName, _size, _seq);
  QObject::connect(fileEngine, SIGNAL(SignalConnectError()), SLOT(SlotConnectError()));
  QObject::connect(fileEngine, SIGNAL(SignalProcessInit(int,int)), SLOT(SlotProcessInit(int,int)));
  QObject::connect(fileEngine, SIGNAL(SignalSaveFile(QString, int, int, int)), SLOT(SlotSaveFile(QString, int, int, int)));
  QObject::connect(fileEngine, SIGNAL(SignalServerInfo(int, int, QString, QString)), SLOT(SlotServerInfo(int,int,QString, QString)));
  QObject::connect(fileEngine, SIGNAL(SignalSizeUpdate(int)), SLOT(SlotSizeUpdate(int)));
  QObject::connect(fileEngine, SIGNAL(SignalCanNotConnect()), SLOT(SlotCanNotConnect()));
  QObject::connect(fileEngine, SIGNAL(SignalGotConnection()), SLOT(SlotGotConnection()));
  QObject::connect(fileEngine, SIGNAL(SignalFileComplete()), SLOT(SlotFileComplete()));
  QObject::connect(fileEngine, SIGNAL(SignalAllDone()), SLOT(SlotAllDone()));
  QObject::connect(fileEngine, SIGNAL(SignalSendOk()), SLOT(SlotSendOk()));
  QObject::connect(CancelButton, SIGNAL(clicked()), SLOT(SlotCancelButton()));
}

void kxFileDialogImpl::SlotConnectError()
{
  //todo
}
void kxFileDialogImpl::SlotProcessInit(int _batch, int _size) // batch len, total file size
{
  totalBatch=_batch;
  totalSize->setText(QString().setNum(_size));
  totalFiles->setText(QString().setNum(_batch));
  batchStatus->reset();
  batchStatus->setTotalSteps(_batch);
  batchStatus->setProgress(0);  
}
void kxFileDialogImpl::SlotSaveFile(QString _fileName, int _num, int _size, int _speed)  // fileName, file num, size, speed
{
debug("Safe filename: %s",_fileName.latin1());
//return;
  remoteName->setText(_fileName);
  fileSize->setText(QString().setNum(_size));
  localStatus->reset();
  localStatus->setTotalSteps(_size);
  localStatus->setProgress(0);  
  batchStatus->setProgress(++current-1);
  
  QFile *file=NULL;
  QString _file;
  if (file) 
  {
    delete file;
    file=NULL;
  }
  bool openFile=FALSE;
  int start=0;
  	    
  while(_file.isEmpty() || openFile==FALSE)
  {
    _file=QFileDialog::getSaveFileName(_fileName,"*",this);
//"/tmp"+_fileName;//
    if (!_file.isEmpty())
    {
      file=new QFile(_file); // open file..
      openFile=TRUE;
      if (file->exists())
      {
        int ret=0;
        if ((int)file->size()<(int)size)
          ret=KMessageBox::warningYesNoCancel(this,i18n("Save File"),i18n("The file already exsist"),i18n("Overwrite"),i18n("Append"));
        else
          ret=10+KMessageBox::warningYesNo(this,i18n("Save File"),i18n("The file already exsist"),i18n("Overwrite"),i18n("Select other file"));
        if (ret==14)
        {
          openFile=FALSE;
          delete file;
          file=NULL;
        }
        if (ret==4)
        {
          start=file->size();
          file->at(file->size());
        }                
      }
      if (openFile==TRUE)
        if (!file->open(IO_ReadWrite))
	      {
	        openFile=FALSE;
	        delete file;
	        file=NULL;
	        KMessageBox::sorry(this,i18n("File Save error"),i18n("The file could not be saved, please choose a different place."));
	      }
    } 
  }            
  if (file)
  {
    debug("Save File");
    fileEngine->saveFile(_file,file,start);  
    localFileName->setText(_file);
    localStatus->setProgress(start);
    sendAnim->start();
  }
}

void kxFileDialogImpl::SlotServerInfo(int _totSize, int _batch, QString _localname, QString _remoteName)// total Size, total Files, localname, remote name
{
  totalBatch=_batch;
  totalSize->setText(QString().setNum(_totSize));
  totalFiles->setText(QString().setNum(_batch));
  batchStatus->reset();
  batchStatus->setTotalSteps(_batch);
  batchStatus->setProgress(0);  
  localStatus->reset();
  localStatus->setTotalSteps(_totSize);
  localStatus->setProgress(0);  
  batchStatus->setProgress(++current-1);  
  remoteName->setText(_remoteName);
  localFileName->setText(_localname);
  fileSize->setText(QString().setNum(_totSize));
}
void kxFileDialogImpl::SlotSizeUpdate(int _size)
{
  localStatus->setProgress(_size);
}
void kxFileDialogImpl::SlotCanNotConnect()
{
  sendAnim->stop();
  KMessageBox::sorry(this, i18n("Cannot connect to the contact..."),i18n("File transfer connection error"));
  hide();
}
void kxFileDialogImpl::SlotGotConnection()
{
  sendAnim->start();
}
void kxFileDialogImpl::SlotFileComplete()
{
  sendAnim->stop();
}
void kxFileDialogImpl::SlotAllDone()
{
  sendAnim->stop();
  KMessageBox::information(this, i18n("The file(s) are received OK\n\nPress OK to close this dialog."),i18n("Files received OK"),i18n("Shot this message again?")); 
  hide();
}
void kxFileDialogImpl::SlotSendOk()
{
  sendAnim->stop();
  KMessageBox::information(this, i18n("The file(s) are send OK\n\nPress OK to close this dialog."),i18n("Files send OK"),i18n("Shot this message again?")); 
  hide();
}
void kxFileDialogImpl::hide()
{
  sendAnim->stop();
  debug("Close FileDialog");
  fileEngine->closeNow();
  delete fileEngine;
  delete this;
}
void kxFileDialogImpl::SlotCancelButton()
{
  hide();
}
