#include <kxcontactlist.h>
#include <kxcontact.h>
#include <kxengine.h>
#include <qstring.h>
#include <qlistview.h>
#include <qheader.h>
#include <kxmainwindow.h>
#include <qfont.h>
#include <qpainter.h>
#include <qcolor.h>
#include <qpalette.h>
#include <kmessagebox.h>
#include <qfontmetrics.h>
#include <klocale.h>
#include <qpixmap.h>
#include <kimageeffect.h>
#include <qpixmap.h>
#include <kglobalsettings.h>
#include <qobject.h>
#include <kxchangenickdialogimpl.h>
#include "kxSendMessageImpl.h"
#include "kxsendmessagesimpl.h"
#include "kxreceivedmessageimpl.h"
#include <kpopupmenu.h>
#include <kxinfodialogimpl.h>
#include <kxhistorydialogimpl.h>
#include <kxcontacttransferdialogimpl.h>
#include <kpixmapeffect.h>
#include <kpixmap.h>
#include <qimage.h>
#include <kimageeffect.h>

kxContactList::kxContactList(QWidget* parent=0, const char* name=0):
	QListView(parent, name)
{
	removeColumn(0);
	addColumn("leeg",-1);
	header()->hide();	
	setSorting(0);
	showGroups=MAINWINDOW->kxConfig.useGroups;
	setMouseTracking(TRUE);
	clipper()->setMouseTracking(TRUE);
	viewport()->setMouseTracking(TRUE);
	viewport()->setAcceptDrops(TRUE);	
	setColumnWidthMode(0, QListView::Maximum);
	setHScrollBarMode(AlwaysOff);
	setTreeStepSize(0);
	QObject::connect(ENGINE->CONTACT, SIGNAL(repaintContact(UIN)), this, SLOT(repaintContact(UIN)));	
	QObject::connect(ENGINE->CONTACT, SIGNAL(contactAdded(UIN, QString)), this, SLOT(SlotContactAdded(UIN, QString)));
}

void kxContactList::init()
{
	showGroups=MAINWINDOW->kxConfig.useGroups;
	clear();
	if (showGroups)
	{
		if (ENGINE->CONTACT->getGroupCount()>0)
		{
			for (Q_UINT16 t=0; t<ENGINE->CONTACT->getGroupCount(); t++)
			{
				Q_UINT16 id=ENGINE->CONTACT->getGroupID(t);
				(void) new kxContactListItem(id, this);					
			}			
		}
		(void) new kxContactListItem((Q_UINT16)0, this);	 // default group
	}
	else
	{
		if (ENGINE->CONTACT->count()>0) (void) new kxContactListItem( SEP_OFFLINE, this);				
	}
  for (Q_UINT16 t=0; t<ENGINE->CONTACT->count(); t++)
  {
	  addContact(ENGINE->CONTACT->getContact(t).uin); //, STATUS_OFFLINE,TRUE);
  }
	
}

bool kxContactList::isAuth(Q_UINT32 _uin)
{
	return ((!ENGINE->CONTACT->getContact(_uin).authorized || ENGINE->CONTACT->getContact(_uin).waitAuth) && MAINWINDOW->kxConfig.showWaitAuth);
}
void kxContactList::repaintContact(UIN _uin)
{
  kxContactListItem * myChild = (kxContactListItem *)firstChild();
  kxContactListItem * myDeepChild;
  while( myChild )
  {
  	if (myChild->uin==_uin)
  	{
   		myChild->repaint();
   		return;
   	}
 	  if (myChild->childCount()>0)
 		{
 			myDeepChild = (kxContactListItem *)myChild->firstChild();
 			while (  myDeepChild )
 			{
 				if (myDeepChild->uin==_uin)
      	{
      		myDeepChild->repaint();
      		myChild->repaint();
       	}	
       	myDeepChild = (kxContactListItem *)myDeepChild->nextSibling();
      }
    }
    myChild = (kxContactListItem *)myChild->nextSibling();
  }	
}
void kxContactList::SlotContactAdded(UIN _uin, QString)
{
	addContact(_uin);
}
void kxContactList::addContact(Q_UINT32 _uin)
{
	if (showGroups)
	{
		if (countContactType(SEP_WAITAUTH)>0 && !groupExists(999)	)
			(void) new kxContactListItem( (Q_UINT16)999, this);
		if (countContactType(SEP_WAITAUTH)==0 && groupExists(999)	)
			removeGroup(999);
		if (countContactType(SEP_NONICQ)>0 && !groupExists(998)	)
			(void) new kxContactListItem( (Q_UINT16)998, this);
		if (countContactType(SEP_NONICQ)==0 && groupExists(998)	)
			removeGroup(998);
			
	
		Q_UINT16 id=ENGINE->CONTACT->getContact(_uin).groupID;
	  kxContactListItem * myChild = (kxContactListItem *)firstChild();
	  while( myChild )
	  {
	  	if (isAuth(_uin))
	  	{
	  		if (myChild->groupID==999)
		  	{
		  		(void) new kxContactListItem(_uin, 999, (QListViewItem *)myChild);	   		
		   		return;
  			}	
  		}
  		else if (myChild->groupID==id)
	  	{
	  		(void) new kxContactListItem(_uin, id, (QListViewItem *)myChild);	   		
	   		return;
	   	}
	    myChild = (kxContactListItem *)myChild->nextSibling();
  	}			
  	
	}
	else
	{
		if (countContactType(SEP_ONLINE)>0 && !typeExists(SEP_ONLINE)	)
			(void) new kxContactListItem( SEP_ONLINE, this);
		if (countContactType(SEP_ONLINE)==0 && typeExists(SEP_ONLINE)	)
			removeType(SEP_ONLINE);
		if (countContactType(SEP_OFFLINE)>0 && !typeExists(SEP_OFFLINE)	)
			(void) new kxContactListItem( SEP_OFFLINE, this);
		if (countContactType(SEP_OFFLINE)==0 && typeExists(SEP_OFFLINE)	)
			removeType(SEP_OFFLINE);
		if (countContactType(SEP_WAITAUTH)>0 && !typeExists(SEP_WAITAUTH)	)
			(void) new kxContactListItem( SEP_WAITAUTH, this);
		if (countContactType(SEP_WAITAUTH)==0 && typeExists(SEP_WAITAUTH)	)
			removeType(SEP_WAITAUTH);
		if (countContactType(SEP_NONICQ)>0 && !typeExists(SEP_NONICQ)	)
			(void) new kxContactListItem( SEP_NONICQ, this);
		if (countContactType(SEP_NONICQ)==0 && typeExists(SEP_NONICQ)	)
			removeType(SEP_NONICQ);
			
		(void) new kxContactListItem(_uin, (QListView *)this);
		sort();
	}
}
void kxContactList::removeContact(Q_UINT32 _uin)
{

  kxContactListItem * myChild = (kxContactListItem *)firstChild();
  kxContactListItem * myDeepChild;
  while( myChild )
  {
  	kxContactListItem * tm=myChild;
  	myChild = (kxContactListItem *)myChild->nextSibling();
  	if (tm->uin==_uin)
  	{
  		delete tm;
  	}
  	else
  	{
      if (tm->childCount()>0)
   		{
   			myDeepChild = (kxContactListItem *)tm->firstChild();
   			while (  myDeepChild )
   			{
   				kxContactListItem * tmp=myDeepChild;
         	myDeepChild = (kxContactListItem *)myDeepChild->nextSibling();
         	if (tmp->uin==_uin)         	
	         	delete tmp;
        }
      }   		
   	}
  }
}
void kxContactList::changeContact(Q_UINT32 _uin, Q_UINT16)
{
	if (!userExists(_uin)) addContact(_uin);
	if (showGroups)
	{		
 	  kxContactListItem * myChild = (kxContactListItem *)firstChild();
 	  kxContactListItem * myDeepChild, *tmp;
 	  bool doAdd=FALSE;
    while( myChild )
    {
   		if (myChild->childCount()>0)
   		{   			
   			myDeepChild = (kxContactListItem *)myChild->firstChild();
   			while (  myDeepChild )
   			{
   				tmp=myDeepChild;
   				myDeepChild = (kxContactListItem *)myDeepChild->nextSibling();
   				if (tmp->uin==_uin && tmp->groupID==999 && !isAuth(_uin))
        	{
         		delete tmp;
         		doAdd=TRUE;
         	}	
         	
        }
      }
      if (myChild->childCount()>0) myChild->sort();
      myChild = (kxContactListItem *)myChild->nextSibling();
    }	
    if (doAdd) addContact(_uin);			

		if (countContactType(SEP_WAITAUTH)>0 && !groupExists(999)	)
			(void) new kxContactListItem( (Q_UINT16)999, this);
		if (countContactType(SEP_WAITAUTH)==0 && groupExists(999)	)
			removeGroup(999);
		if (countContactType(SEP_NONICQ)>0 && !groupExists(998)	)
			(void) new kxContactListItem( (Q_UINT16)998, this);
		if (countContactType(SEP_NONICQ)==0 && groupExists(998)	)
			removeGroup(998);
						
		myChild = (kxContactListItem *)firstChild();
	  while( myChild )
	  {
	  	if (myChild->group)
	  	{
	  		myChild->sort();
	   		return;
	   	}
	    myChild = (kxContactListItem *)myChild->nextSibling();
  	}		
		
	}
	else
	{
		if (countContactType(SEP_ONLINE)>0 && !typeExists(SEP_ONLINE)	)
			(void) new kxContactListItem( SEP_ONLINE, this);
		if (countContactType(SEP_ONLINE)==0 && typeExists(SEP_ONLINE)	)
			removeType(SEP_ONLINE);
		if (countContactType(SEP_OFFLINE)>0 && !typeExists(SEP_OFFLINE)	)
			(void) new kxContactListItem( SEP_OFFLINE, this);
		if (countContactType(SEP_OFFLINE)==0 && typeExists(SEP_OFFLINE)	)
			removeType(SEP_OFFLINE);
		if (countContactType(SEP_WAITAUTH)>0 && !typeExists(SEP_WAITAUTH)	)
			(void) new kxContactListItem( SEP_WAITAUTH, this);
		if (countContactType(SEP_WAITAUTH)==0 && typeExists(SEP_WAITAUTH)	)
			removeType(SEP_WAITAUTH);
		if (countContactType(SEP_NONICQ)>0 && !typeExists(SEP_NONICQ)	)
			(void) new kxContactListItem( SEP_NONICQ, this);
		if (countContactType(SEP_NONICQ)==0 && typeExists(SEP_NONICQ)	)
			removeType(SEP_NONICQ);			
		sort();
	}
}

void kxContactList::removeGroup(Q_UINT16 id)
{
  kxContactListItem * myChild = (kxContactListItem *)firstChild();
  kxContactListItem * myDeepChild;
  while( myChild )
  {
  	kxContactListItem * tm=myChild;
  	myChild = (kxContactListItem *)myChild->nextSibling();
  	if (tm->groupID==id)
  	{
      if (tm->childCount()>0)
   		{
   			myDeepChild = (kxContactListItem *)tm->firstChild();
   			while (  myDeepChild )
   			{
   				kxContactListItem * tmp=myDeepChild;
         	myDeepChild = (kxContactListItem *)myDeepChild->nextSibling();
         	delete tmp;
        }
      }
   		delete tm;
   	}
  }
}
bool kxContactList::userExists(Q_UINT32 _uin)
{
  kxContactListItem * myChild = (kxContactListItem *)firstChild();
  kxContactListItem * myDeepChild;
  while( myChild )
  {
  	kxContactListItem * tm=myChild;
  	myChild = (kxContactListItem *)myChild->nextSibling();
  	if (tm->uin==_uin)
  	{
  		return TRUE;
  	}
  	else
  	{
      if (tm->childCount()>0)
   		{
   			myDeepChild = (kxContactListItem *)tm->firstChild();
   			while (  myDeepChild )
   			{
   				kxContactListItem * tmp=myDeepChild;
         	myDeepChild = (kxContactListItem *)myDeepChild->nextSibling();
         	if (tmp->uin==_uin)         	
	         	return TRUE;
        }
      }   		
   	}
  }
  return FALSE;
}
bool kxContactList::groupExists(Q_UINT16 id)
{
  kxContactListItem * myChild = (kxContactListItem *)firstChild();
  while( myChild )
  {
  	if (myChild->groupID==id)
   		return TRUE;
    myChild = (kxContactListItem *)myChild->nextSibling();
  }
  return FALSE;
}
void kxContactList::removeType(Q_UINT16 type)
{
  kxContactListItem * myChild = (kxContactListItem *)firstChild();
  while( myChild )
  {
  	kxContactListItem * tmp=myChild;
  	myChild = (kxContactListItem *)myChild->nextSibling();
  	if (tmp->type==type)
   		delete tmp;
  }
}
bool kxContactList::typeExists(Q_UINT16 type)
{
  kxContactListItem * myChild = (kxContactListItem *)firstChild();
  while( myChild )
  {
  	if (myChild->type==type)
   		return TRUE;
    myChild = (kxContactListItem *)myChild->nextSibling();
  }
	return FALSE;	
}
void kxContactList::resizeEvent(QResizeEvent *_e)
{
  viewportSize(_e->size().width(),_e->size().height());
  QListView::resizeEvent(_e);
  setColumnWidth(0, _e->size().width());
}

Q_UINT16 kxContactList::countContactType(Q_UINT16 type)
{
	Q_UINT16 num=0;
	for (int t=0; t<ENGINE->CONTACT->count(); t++)
	{
		switch(type)
		{
			case SEP_OFFLINE:
				if (ENGINE->CONTACT->getContact(t).status==STATUS_OFFLINE)
				{	
					num++;
				}	
			break;
			case SEP_ONLINE:
				if (ENGINE->CONTACT->getContact(t).status!=STATUS_OFFLINE)
				{	
					num++;
				}						
			break;
			case SEP_WAITAUTH:
				if (isAuth(t))
				{	
					num++;
				}
			break;
			case SEP_NONICQ:
				if (ENGINE->CONTACT->getContact(t).groupID==998)
				{
					num++;
				}						
			break;			
		}
	}	
	return num;			
}
void kxContactList::countMessageOnline(Q_UINT16 _id, bool *_msg, Q_UINT16 *_online)
{
	*_msg=FALSE;
	*_online=0;
  kxContactListItem * myChild = (kxContactListItem *)firstChild();
  kxContactListItem * myDeepChild;
  while( myChild )
  {
  	kxContactListItem * tm=myChild;
  	myChild = (kxContactListItem *)myChild->nextSibling();
    if (tm->childCount()>0)
 		{
 			if (tm->groupID==_id)
 			{
	 			myDeepChild = (kxContactListItem *)tm->firstChild();
	 			while (  myDeepChild )
	 			{
	 				kxContactListItem * tmp=myDeepChild;
	       	myDeepChild = (kxContactListItem *)myDeepChild->nextSibling();
	       	if (tmp->type==0 && tmp->uin>0)
	       	{
	         	if (ENGINE->MESSAGE->giveFirstUnread(tmp->uin)>0) *_msg=TRUE;
	         	if (ENGINE->CONTACT->getContact(tmp->uin).status!=STATUS_OFFLINE) (*_online)+=1;
	        }
	      }
      }         		
   	}
  }
}
void kxContactListItem::setup()
{
	if (uin>0) setHeight(25);
	else	setHeight(10);
	QListViewItem::setup();
}

kxContactListItem::kxContactListItem(Q_UINT32 _uin, QListView *parent):
	QListViewItem(parent)
{
	uin=_uin;
	type=0;
	groupID=ENGINE->CONTACT->getContact(uin).groupID;
	rootxpm=NULL;
	group=FALSE;
	setHeight(25);
}
kxContactListItem::kxContactListItem(ItemType _type, QListView *parent):
	QListViewItem(parent)
{
	rootxpm=NULL;
	uin=0;
	groupID=0;
	type=_type;
	group=FALSE;
	setHeight(10);
}
kxContactListItem::kxContactListItem(Q_UINT16 _id, QListView *parent):
	QListViewItem(parent)
{
	rootxpm=NULL;
	uin=0;
	groupID=_id;
	type=0;
	setHeight(10);
	group=TRUE;
	sortChildItems(0, FALSE);
	setOpen(ENGINE->CONTACT->getGroupStructByID(_id).open);
}
kxContactListItem::kxContactListItem(Q_UINT32 _uin, Q_UINT16 _id, QListViewItem *parent):
	QListViewItem(parent)		
{
	rootxpm=NULL;
	uin=_uin;
	groupID=_id;
	type=0;
	group=FALSE;
	setHeight(25);
}

QString kxContactListItem::key(int, bool) const
{
//  bool sortNick;
//  bool sortStatus;
//	bool sortGroup;
	QString key;
	if (type>0)
	{
		key.sprintf("%d",type);
	}
	else
	{
		if (MAINWINDOW->list->showGroups)
		{
			if (uin==0 && type==0)
			{
				if (groupID==0)
					key.append("U");
				else if (groupID==999)
					key.append("Y");					
				else if (groupID==998)
					key.append("X");										
				else
					if (!MAINWINDOW->kxConfig.sortGroup)
					{
						key.append(QString(QString::number(groupID))[0]);
					}
					else
						key.append("0");
				key.append(ENGINE->CONTACT->getGroupNameByID(groupID));
			}
			else
			{				
				if (ENGINE->CONTACT->getContact(uin).status==STATUS_OFFLINE) key.append("2");
				else	key.append("1");
				if (MAINWINDOW->kxConfig.sortStatus) key.append(ENGINE->CONTACT->getContact(uin).status);
				if (MAINWINDOW->kxConfig.sortNick) key.append(ENGINE->CONTACT->getContact(uin).nick);
			}
		}
		else
		{
			Q_UINT16 status=ENGINE->CONTACT->getContact(uin).status;
			if (((kxContactList *)listView())->isAuth(uin)) key.append(QString::number((SEP_WAITAUTH+1), 16));
			else if (ENGINE->CONTACT->getContact(uin).groupID==998) key.append(QString::number((SEP_NONICQ+1), 16));
			else if (status==STATUS_OFFLINE) key.append(QString::number((SEP_OFFLINE+1), 16));
			else if (status!=STATUS_OFFLINE) key.append(QString::number((SEP_ONLINE+1), 16));
			
			if (MAINWINDOW->kxConfig.sortStatus) key.append(ENGINE->CONTACT->getContact(uin).status);
			if (MAINWINDOW->kxConfig.sortNick) key.append(ENGINE->CONTACT->getContact(uin).nick);			
	
		}
	}
	return key;
}
void kxContactListItem::paintFocus(QPainter *p,const QColorGroup & cg,const QRect &r)
{
//	doPaint(p, cg);
}
void kxContactListItem::doPaint(QPainter *p,const QColorGroup & cg)
{
}

void kxContactListItem::paintCell(QPainter *p,const QColorGroup & cg, int column, int width, int align)
{
	focus=isSelected();
	if (type==0 && uin>0)
	{
	  QPixmap bg(listView()->width(),height());
    QPainter paint;
    paint.begin(&bg);

    QColor back, text;
    int _width=listView()->width();
    int _height=height()-1;
    int oldPrevColor=prevColor;
    int tab=3;

  //  if (!(hasFocus() || focus))
  	if ( !focus )
    {
     if (MAINWINDOW->kxConfig.useKDEColors)
     {
	     back=listView()->colorGroup().highlight();
	     text=listView()->colorGroup().highlightedText();
	   }
	   else
	   {
	   	back=MAINWINDOW->kxConfig.backgroundColor;
	   	text=MAINWINDOW->kxConfig.textColor;
	   }
     prevColor=1;

    }
    else
    {
     if (MAINWINDOW->kxConfig.useKDEColors)
     {
	     back=listView()->colorGroup().highlight().light(120);
	     text=listView()->colorGroup().highlightedText();
	   }
	   else
	   {
	   	back=MAINWINDOW->kxConfig.selectedBackgroundColor;
	   	text=MAINWINDOW->kxConfig.selectedTextColor;
	   }
	
     prevColor=2;
    }


    paint.setBrush(back);
    paint.setPen(back);
    if (rootxpm) rootxpm->setFadeEffect(.5, back);
    else
    {
    	if (!MAINWINDOW->kxConfig.effect3d)
	    	paint.drawRect(0,0,_width, _height+1);
    	else
    		paint.drawRect(1,1,_width-1, _height-1);
    }
		if (MAINWINDOW->kxConfig.effect3d)
		{
	    paint.setPen(back.light());
	    paint.drawLine(0,0,0, _height);
	    paint.drawLine(0,0,_width, 0);
	    paint.setPen(back.dark());
	    paint.drawLine(_width,1,_width, _height);
	    paint.drawLine(1,_height,_width, _height);
    }

    QString tmp=ENGINE->CONTACT->getContact(uin).nick;

    if (ENGINE->CONTACT->status2int(ENGINE->CONTACT->getContact(uin).status)==STATUS_OFFLINE && !((kxContactList *)listView())->isAuth(uin) &&
    	  ENGINE->CONTACT->getContact(uin).groupID!=998  	)
    	text=text.light(80);  	
	   paint.setPen(text);

    KPixmap pix;
    bool draw=FALSE;

    if (((kxContactList *)listView())->isAuth(uin))
    {
    	draw=TRUE;
    	pix=MAINWINDOW->kxIcons.offline;   	
    	pix=KPixmapEffect::toGray(pix, TRUE);
    }
    else if (ENGINE->CONTACT->getContact(uin).groupID==998)
    {
    	draw=FALSE;
    }
    else switch(ENGINE->CONTACT->status2int(ENGINE->CONTACT->getContact(uin).status))
    {
      case STATUS_DND: 			
        pix=MAINWINDOW->kxIcons.dnd; 	
        draw=TRUE;
  	  	break;
  	  case STATUS_OCCUPIED: 	
        pix=MAINWINDOW->kxIcons.occupied;
        draw=TRUE;
  	  	break;
  	  case STATUS_NA: 				
  	  	pix=MAINWINDOW->kxIcons.na; 	
  	  	draw=TRUE;
  	  	break;
  	  case STATUS_AWAY: 			
  	  	pix=MAINWINDOW->kxIcons.away; 	
  	  	draw=TRUE;
  	  	break;
  	  case STATUS_FFC: 			
  	  	pix=MAINWINDOW->kxIcons.ffc; 	
  	  	draw=TRUE;
  	  	break;
  	  case STATUS_INVISIBLE:
    	  draw=TRUE;
    	  pix=MAINWINDOW->kxIcons.invisible;
    	  break;
  	  default:
  	  	if (((kxContactList *)listView())->showGroups)
  	  	{
  	  	  draw=TRUE;
	    	  if (ENGINE->CONTACT->status2int(ENGINE->CONTACT->getContact(uin).status)==STATUS_OFFLINE)
	    	  {
	    	  	pix=MAINWINDOW->kxIcons.offline;	    	  	
	    	  }
	    	  else pix=MAINWINDOW->kxIcons.online;
	    	  //pix=KPixmapEffect::toGray(pix, TRUE);
	    	  //pix=KPixmapEffect::fade(pix, 0.5, back);
	    	  //paint.drawPixmap(tab+2,(height()/2)-(pix.height()/2),pix);
	    	
  	  	} else
  	    if (ENGINE->MESSAGE->isAnyMessage(uin))
  	    {
  	      pix=MAINWINDOW->kxIcons.history; 	
  	      draw=TRUE;
  	    }

  	  	break;
    }

    bool drawExtraIcon=FALSE;
	  QPixmap extraPix;
	
	  if (ENGINE->CONTACT->getContact(uin).gsm.find("SMS")>=0)
	  {
	  	drawExtraIcon=TRUE;
	  	extraPix=MAINWINDOW->kxIcons.contactSMS;
	  }

    QFont font(QFont::defaultFont());

  	font.setCharSet(QFont::charSetForLocale());

    if (ENGINE->CONTACT->getContact(uin).invisible || ENGINE->CONTACT->getContact(uin).visible)
      font.setItalic(TRUE);
    if (!MAINWINDOW->kxConfig.showWaitAuth)
    {
  	  if (ENGINE->CONTACT->getContact(uin).waitAuth)
  	  	font.setUnderline(TRUE);
  	  if (!ENGINE->CONTACT->getContact(uin).authorized)
  	  	font.setBold(TRUE);
    }	
    paint.setFont(font);

    if (ENGINE->CONTACT->countMessages(uin)>0)
    {
  		if (ENGINE->MESSAGE->giveFirstUnread(uin)>0)
  		{			
  			switch(ENGINE->MESSAGE->getMessageInfo(ENGINE->MESSAGE->giveFirstUnread(uin))->type)
  			{
  				case URL_TYPE:
  			    pix=MAINWINDOW->kxIcons.url;
  			    draw=TRUE;	
  					break;			
  				case MESSAGE_TYPE:
  				default:
  			    pix=MAINWINDOW->kxIcons.message;
  			    draw=TRUE;	
  			}			
  	  }
  	  else
  	  {
  	    pix=MAINWINDOW->kxIcons.message;
  	    draw=TRUE;	
  	  }
    }
    int pixmapWidth=MAINWINDOW->kxIcons.na.width();
    QFontMetrics fm(font);
    paint.drawText(tab+pixmapWidth+7,(height()/2)-(listView()->fontMetrics().height()/2), _width-3, _height-2, AlignLeft | ShowPrefix | DontClip, tmp);
    if (drawExtraIcon)
    {
    	paint.drawPixmap(tab+pixmapWidth+11+fm.width(tmp),(height()/2)-(extraPix.height()/2), extraPix);
    }
    if (draw) paint.drawPixmap(tab+2,(height()/2)-(pix.height()/2),pix);
//    QPainter p(this);
    paint.end();
    p->drawPixmap(0,0,bg);
//    bool ret=FALSE;
  //  if (draw)
  //  {
  //    QImage bgg=bg.convertToImage();
  //	  QImage iconImg=pix.convertToImage();
  //  	ret=KImageEffect::blendOnLower(tab+2,(getHeight()/2)-(pix.height()/2), iconImg, bgg);
  //  	p.drawImage(0,0,bgg);
  //  }
  //  KAlphaPainter::draw(&p, pix.convertToImage(), bg, tab+2,(getHeight()/2)-(pix.height()/2), tab+2,(getHeight()/2)-(pix.height()/2));
  //  debug("Alpha: %d - %d - %d",iconImg.hasAlphaBuffer(), iconImg.depth(), ret);  	
    prevColor=oldPrevColor;
		//item->resize(listView->width(), height());
  }
  else
  {
    QPainter *paint=p;
    QColor back, text;
    int x1,y1,w1,x2;
    int _width=listView()->width();
    int _height=height();

    if (MAINWINDOW->kxConfig.useKDEColors)
    {
	    back=cg.highlight();
	    text=cg.highlightedText();
	  }
	  else
	  {
	   	back=MAINWINDOW->kxConfig.backgroundColor;
	   	text=MAINWINDOW->kxConfig.textColor;
	  }

  //  back=colorGroup().base();
  //  text=colorGroup().text();

    paint->setBrush(back);
    paint->setPen(back);
    if (!rootxpm) paint->drawRect(0,0,_width, _height);
  //  rootxpm->setFadeEffect(.5, back);

    QFont font(listView()->font());
    font.setPointSize(8);
    font.setBold(TRUE);
    paint->setFont(font);
    QFontMetrics fm(font);

    QString tmp="";
    if (MAINWINDOW->list->showGroups)
    {
    	if (groupID==0)
    		tmp=i18n("Default");
    	else if (groupID==999)
					tmp=i18n("Wait Authorization");
			else if (groupID==998)
					tmp=i18n("Non ICQ contacts");
			else
	    	tmp=ENGINE->CONTACT->getGroupNameByID(groupID);
	    	
	    QString t;
	    Q_UINT16 online=0;
	    Q_UINT16 extraIconWidth=0;
	    QPixmap extraPix;
	    bool msg=FALSE;
	    ((kxContactList *)listView())->countMessageOnline(groupID, &msg, &online);
	    if (childCount()>0)
	    {
	    	if (groupID==999 || groupID==998)
	    		t.sprintf(" - %d", childCount());	    		
	    	else
			t.sprintf(" - %d/%d",online, childCount());
		tmp.append(t);
	    }

		  QPixmap pix;
		  if (isOpen()) pix=MAINWINDOW->kxIcons.groupDown;
		  else pix=MAINWINDOW->kxIcons.groupUp;		
			p->drawPixmap(1,(_height/2)-(pix.height()/2),pix);
			paint->setPen(text);
			p->drawText(20,(_height/2)-(fm.height()/2), fm.width(tmp),fm.height(), AlignLeft,tmp);
	    if (msg)
	    {
	    	extraPix=MAINWINDOW->kxIcons.message;
	    	extraIconWidth=extraPix.width()+4;
	    	p->drawPixmap(23+fm.width(tmp)+2,(_height/2)-(extraPix.height()/2),extraPix);
	    }   	
			
			y1=height()/2;	
			x2=23+fm.width(tmp)+extraIconWidth;	
			w1=_width-2;	
			
			paint->setPen(back.dark());
			paint->drawLine(13,y1+2, 16,y1+2);
			paint->drawLine(13,y1-2, 16,y1-2);
			paint->drawLine(x2,y1+2, w1,y1+2);
			paint->drawLine(x2,y1-2, w1,y1-2);
			
			paint->setPen(back.light());
			paint->drawLine(13,y1-3, 16,y1-3);
			paint->drawLine(13,y1+1, 16,y1+1);			
			paint->drawLine(x2,y1+1, w1,y1+1);
			paint->drawLine(x2,y1-3, w1,y1-3);   	
    }
    else
    {
	    tmp=i18n("Offline");
	    if (type==SEP_ONLINE) tmp=i18n("Online");
	    else if (type==SEP_OFFLINE) tmp=i18n("Offline");
	    else if (type==SEP_UNKNOWN) tmp=i18n("Unknown");
	    else if (type==SEP_NONICQ) tmp=i18n("Non ICQ contacts");
	    else if (type==SEP_WAITAUTH) tmp=i18n("Wait Authorization");
  	
      x1=3;
      y1=height()/2;
      w1=(_width/2)-(fm.width(tmp)/2);

      x2=w1+6+fm.width(tmp);

      paint->setPen(back.dark());
      paint->drawLine(x1,y1+2,w1,y1+2);
      paint->drawLine(x2,y1+2,x2+w1,y1+2);
      paint->drawLine(x1,y1-2,w1,y1-2);
      paint->drawLine(x2,y1-2,x2+w1,y1-2);

      paint->setPen(back.light());
      paint->drawLine(x1,y1-3,w1,y1-3);
      paint->drawLine(x2,y1-3,x2+w1,y1-3);
      paint->drawLine(x1,y1+1,w1,y1+1);
      paint->drawLine(x2,y1+1,x2+w1,y1+1);

      paint->setPen(text);
      paint->drawText(w1+4,(_height/2)-(fm.height()/2), fm.width(tmp),fm.height(), AlignLeft, tmp.latin1());
		}
  }
}

void kxContactList::viewportDragEnterEvent(QDragEnterEvent *e)
{
	e->accept(QTextDrag::canDecode(e) || QUriDrag::canDecode(e));
}
void kxContactList::viewportDropEvent(QDropEvent *e)
{
	kxContactListItem* i = (kxContactListItem *)itemAt(e->pos());
	
	if (i)
	{
		if (i->groupID==999 || i->groupID==998) { sort(); return; }
		
		QString uinStr;
		if (QTextDrag::decode(e, uinStr))
		{
			 Q_UINT32 uin=uinStr.toUInt();
			 if (ENGINE->CONTACT->getContact(uin).uin>0)
			 {
			 		ENGINE->CONTACT->setGroup(uin, i->groupID);
		 		  kxContactListItem * myChild = (kxContactListItem *)firstChild(), *tm=NULL;
		 		  kxContactListItem * myDeepChild, *tmp=NULL;
          while( myChild )
          {
          	tm=myChild;
          	myChild = (kxContactListItem *)myChild->nextSibling();
          	if (tm->uin==uin)
          	{
           		delete tm;
           	}
           	else
           	{
           		if (tm->childCount()>0)
           		{           			
           			myDeepChild = (kxContactListItem *)tm->firstChild();
           			while (  myDeepChild )
           			{
           				tmp=myDeepChild;
			           	myDeepChild = (kxContactListItem *)myDeepChild->nextSibling();           				
           				if (tmp->uin==uin)
			          	{
			           		delete tmp;
			           	}	
			          }
			        }
			      }           			

          }	
          addContact(uin);
			 }
			 else
			 {
			 		debug("UIN not found");
			 }
		}
	}	
	sort();
}
void kxContactList::viewportMouseMoveEvent(QMouseEvent *e)
{
  kxContactListItem *i;
  QListView::viewportMouseMoveEvent(e);

  if (parent() && e->state()==LeftButton &&
  		(i = (kxContactListItem *)currentItem()) && !pressedPoint.isNull() &&
  			i->uin>0 &&
      (QPoint(e->pos() - pressedPoint).manhattanLength() > 8))
  {
  	if (!isAuth(i->uin) && i->groupID!=998)
  	{
	    QTextDrag *d = new QTextDrag(QString::number(i->uin), this);
	    d->dragCopy();
	  }
	  else
	  {
		  pressedPoint.setX(0);
		  pressedPoint.setY(0);	
	  }
  }
//  else if(!parent() && me->state() & LeftButton) {
//    move(me->globalX()-mousePressPos.x(), me->globalY()-mousePressPos.y());
//  }
}
void kxContactList::viewportMouseReleaseEvent(QMouseEvent *e)
{	
	QListView::viewportMouseReleaseEvent(e);
  pressedPoint.setX(0);
  pressedPoint.setY(0);
	if (e->button()==LeftButton)
	{		
		kxContactListItem *i=(kxContactListItem *)itemAt(e->pos());
		if (!i) return;
		if (i->uin != uin) return;
		Q_UINT32 uin=i->uin;
		if (uin==0) return;
		
		if (i->groupID==998)
		{
			SlotSendSMS();
			return;
		}		
    int f=ENGINE->MESSAGE->giveFirstUnread(uin);
    if (f>0)
    {
      if (ENGINE->MESSAGE->getType(f)==MESSAGE_TYPE && MAINWINDOW->kxConfig.popupMessageChatOnReceive)
      {
        kxSendMessagesImpl *dialog=new kxSendMessagesImpl(uin,TRUE,0L,"SendMessages");
        dialog->resize(200,350);
        dialog->show();
      }
      else
      {
        kxReceivedMessageImpl *dialog=new kxReceivedMessageImpl(uin, 0L, "received");
        dialog->resize(200,350);
        dialog->show();
      }
    }
    else
    {
      if (ENGINE->CONTACT->getSendWidget(uin)==NULL)
      {
        if (MAINWINDOW->kxConfig.popupMessageChatOnPress)
        {
          kxSendMessagesImpl *dialog=new kxSendMessagesImpl(uin,0L,"SendMessages");
          dialog->resize(200,350);
          dialog->show();
        }
        else
        {
          kxSendMessageImpl *dialog=new kxSendMessageImpl(uin,MESSAGE_TYPE,0L,"SendMessage");
          dialog->resize(200,300);
          dialog->show();
        }
      }
			else
			{
				((QWidget *)ENGINE->CONTACT->getSendWidget(uin))->raise();
			}
    }		
	}	
}	
void kxContactList::viewportMousePressEvent(QMouseEvent *e)
{
	QListView::viewportMousePressEvent(e);
  pressedPoint.setX(0);
  pressedPoint.setY(0);
	if (e->button()==LeftButton)
	{		
		pressedPoint=e->pos();
		kxContactListItem *i=(kxContactListItem *)itemAt(e->pos());
		if (!i) return;
		uin=i->uin;
		if (i->uin==0 && i->type==0)
		{
			i->setOpen(!i->isOpen());
			ENGINE->CONTACT->setGroupOpen(i->groupID,i->isOpen());
		}
	}
	if (e->button()==RightButton)
	{
		kxContactListItem *i=(kxContactListItem *)itemAt(e->pos());
		if (!i) return;
		popupMenu(i->groupID, i->type, i->uin, QCursor::pos());
	}
}
void kxContactList::popupMenu(Q_UINT16 _groupID, Q_UINT16 type, Q_UINT32 _uin, QPoint pos)
{
	KPopupMenu popup;
	KPopupMenu options;
	bool exec=FALSE;
	uin=_uin;
	groupID=_groupID;
	
	if (groupID==998 && uin>0)
	{
		exec=TRUE;
		popup.insertTitle(i18n("Send"));	
		popup.insertItem(i18n("SMS"), this, SLOT(SlotSendSMS()));
		popup.insertTitle(i18n("Contact"));
    popup.insertItem(i18n("Delete"), this, SLOT(SlotRemove()));
    popup.insertItem(i18n("Rename Nick"), this, SLOT(SlotRenameNick()));		
    popup.insertItem(i18n("Change SMS number"), this, SLOT(SlotChangeSMS()));
	}
	else
		if (type==0 && uin==0) // groups
	{
		popup.insertItem(i18n("Add Group"), this, SLOT(slotAddGroup()));
		if (groupID>0 && groupID<900)
		{
			popup.insertItem(i18n("Rename Group"), this, SLOT(slotRenameGroup()));
			popup.insertItem(i18n("Remove Group"), this, SLOT(slotRemoveGroup()));				
		}
		exec=TRUE;
	}
	else if (uin>500)
	{   	
		int item;
    options.setCheckable(TRUE);
    options.insertTitle(i18n("Contact Options"));
    item=options.insertItem(i18n("Invisible"),this, SLOT(SlotSetInvisible()));
    options.setItemChecked(item,ENGINE->CONTACT->getContact(uin).invisible);
    item=options.insertItem(i18n("Visible"),this, SLOT(SlotSetVisible()));
    options.setItemChecked(item,ENGINE->CONTACT->getContact(uin).visible);
    item=options.insertItem(i18n("Online Notify"),this, SLOT(SlotSetOnlineNotify()));
		options.setItemChecked(item,ENGINE->CONTACT->getContact(uin).onlineNotify);
    item=options.insertItem(i18n("Always through server"),this, SLOT(SlotSetAlwaysServer()));
		options.setItemChecked(item,ENGINE->CONTACT->getContact(uin).alwaysServer);
    item=options.insertItem(i18n("Ignore"),this, SLOT(SlotSetIgnore()));
		options.setItemChecked(item,ENGINE->CONTACT->getContact(uin).ignore);
    item=options.insertItem(i18n("User internal IP"),this, SLOT(SlotSetIntIP()));
		options.setItemChecked(item,ENGINE->CONTACT->getContact(uin).intIp);

    popup.insertTitle(i18n("Send"));
    popup.insertItem(i18n("Message"),this, SLOT(SlotSendMessage()));
    if (!isAuth(uin))
    {
//	    popup.insertItem(i18n("File"), this, SLOT(SlotSendFile()));
	    popup.insertItem(i18n("Message Chat"),this, SLOT(SlotSendMessages()));
	    popup.insertItem(i18n("Url"), this, SLOT(SlotSendUrl()));
	    popup.insertItem(i18n("Contacts"), this, SLOT(SlotSendContacts()));
	    popup.insertItem(i18n("SMS"), this, SLOT(SlotSendSMS()));
	    if (!( ENGINE->CONTACT->getContact(uin).status==STATUS_OFFLINE || ENGINE->CONTACT->getContact(uin).status==STATUS_ONLINE || ENGINE->CONTACT->getContact(uin).status==STATUS_INVISIBLE))
	    {
		    popup.insertTitle(i18n("Retrieve"));
        switch(ENGINE->CONTACT->getContact(uin).status)
        {
                case STATUS_NA:
                case STATUS_NA_99:
                				popup.insertItem(i18n("N/A Status Message"), this, SLOT(SlotAskStatusMessage()));
                        break;
                case STATUS_DND:
                case STATUS_DND_KXICQ:
                				popup.insertItem(i18n("DnD Status Message"), this, SLOT(SlotAskStatusMessage()));
                        break;
                case STATUS_AWAY:
                				popup.insertItem(i18n("Away Status Message"), this, SLOT(SlotAskStatusMessage()));
                        break;
                case STATUS_FFC:
                				popup.insertItem( i18n("FFC Status Message"), this, SLOT(SlotAskStatusMessage()));                       		
                        break;
        }		
		  }
	  }
    popup.insertTitle(i18n("History"));
    popup.insertItem(i18n("History"), this, SLOT(SlotHistory()));
    popup.insertTitle(i18n("Contact"));
    popup.insertItem(i18n("Information"), this, SLOT(SlotInfo()));
    popup.insertItem(i18n("Delete"), this, SLOT(SlotRemove()));
    if (!isAuth(uin))
    {
	    popup.insertItem(i18n("Update Nick"), this, SLOT(SlotUpdateNick()));
	    popup.insertItem(i18n("Rename Nick"), this, SLOT(SlotRenameNick()));
	  }
    if (isAuth(uin))
	    popup.insertItem(i18n("Rerequest Auth"), this, SLOT(SlotReRequestAuth()));
		if (!isAuth(uin))	
    	popup.insertItem(i18n("Options"),&options);
    exec=TRUE;	
	}
	
	if (exec) popup.exec(pos);	
}
void kxContactList::slotAddGroup()
{
	kxAddGroupDialog *dialog=new kxAddGroupDialog(this, "addGroup", TRUE);
	if (dialog->exec()== QDialog::Accepted)
	{
		init();
	}
	delete dialog;
}
void kxContactList::slotRemoveGroup()
{
	if (KMessageBox::questionYesNo(this, i18n("Do you want to remove this group ?"), i18n("Remove Group ?"))==KMessageBox::No) return;
	ENGINE->CONTACT->removeGroup(groupID);
	init();
}
void kxContactList::slotRenameGroup()
{
	kxAddGroupDialog *dialog=new kxAddGroupDialog(groupID, this, "renameGroup", TRUE);
	if (dialog->exec()== QDialog::Accepted)
	{
		debug("DO rename %s",dialog->getText().latin1());
		ENGINE->CONTACT->renameGroup(groupID, dialog->getText());
		init();
	}
	delete dialog;
}

void kxContactList::SlotHistory()
{
  kxHistoryDialogImpl *dialog;
  dialog=new kxHistoryDialogImpl(uin,0L, "hist");
  dialog->show();
}
void kxContactList::SlotSendMessage()
{
  if (ENGINE->CONTACT->getSendWidget(uin)==NULL)
  {
    kxSendMessageImpl *dialog=new kxSendMessageImpl(uin,1,0L,"SendMessage");
    dialog->resize(200,300);
    dialog->show();
  }
}
void kxContactList::SlotSendMessages()
{
  if (ENGINE->CONTACT->getSendWidget(uin)==NULL)
  {
    kxSendMessagesImpl *dialog=new kxSendMessagesImpl(uin,0L,"SendMessage");
    dialog->resize(200,350);
    dialog->show();
  }
}
void kxContactList::SlotSendSMS()
{
  if (ENGINE->CONTACT->getSendWidget(uin)==NULL)
  {
  	if (ENGINE->CONTACT->getContact(uin).gsm.length()<=0)
  		ENGINE->requestInfo(uin, kxEngine::GSM);
    kxSendMessageImpl *dialog=new kxSendMessageImpl(uin,SMS_TYPE, 0L,"SendSMSMessage");
    dialog->resize(200,350);
    dialog->show();
  }
}

void kxContactList::SlotSendUrl()
{
  if (ENGINE->CONTACT->getSendWidget(uin)==NULL)
  {
    kxSendMessageImpl *dialog=new kxSendMessageImpl(uin,URL_TYPE,0L,"SendUrl");
    dialog->resize(200,300);
    dialog->show();
  }
}
void kxContactList::SlotSendContacts()
{
  if (ENGINE->CONTACT->getSendWidget(uin)==NULL)
  {
    kxContactTransferDialogImpl *dialog=new kxContactTransferDialogImpl(uin,0L,"SendUrl");
    dialog->resize(200,300);
    dialog->show();
  }
}

void kxContactList::SlotRemove()
{
	if (KMessageBox::questionYesNo(this, i18n("Do you want to remove this contact ?"), i18n("Remove Contact ?"))==KMessageBox::No) return;
  removeContact(uin);
  ENGINE->CONTACT->remove(uin);
  ENGINE->removeContactFromList(uin);
  if (showGroups)
	{
		if (countContactType(SEP_WAITAUTH)>0 && !groupExists(999)	)
			(void) new kxContactListItem( (Q_UINT16)999, this);
		if (countContactType(SEP_WAITAUTH)==0 && groupExists(999)	)
			removeGroup(999);
		if (countContactType(SEP_NONICQ)>0 && !groupExists(998)	)
			(void) new kxContactListItem( (Q_UINT16)998, this);
		if (countContactType(SEP_NONICQ)==0 && groupExists(998)	)
			removeGroup(998);
			
	}	
	else
	{
		if (countContactType(SEP_ONLINE)>0 && !typeExists(SEP_ONLINE)	)
			(void) new kxContactListItem( SEP_ONLINE, this);
		if (countContactType(SEP_ONLINE)==0 && typeExists(SEP_ONLINE)	)
			removeType(SEP_ONLINE);
		if (countContactType(SEP_OFFLINE)>0 && !typeExists(SEP_OFFLINE)	)
			(void) new kxContactListItem( SEP_OFFLINE, this);
		if (countContactType(SEP_OFFLINE)==0 && typeExists(SEP_OFFLINE)	)
			removeType(SEP_OFFLINE);
		if (countContactType(SEP_WAITAUTH)>0 && !typeExists(SEP_WAITAUTH)	)
			(void) new kxContactListItem( SEP_WAITAUTH, this);
		if (countContactType(SEP_WAITAUTH)==0 && typeExists(SEP_WAITAUTH)	)
			removeType(SEP_WAITAUTH);	
		if (countContactType(SEP_NONICQ)>0 && !typeExists(SEP_NONICQ)	)
			(void) new kxContactListItem( SEP_NONICQ, this);
		if (countContactType(SEP_NONICQ)==0 && typeExists(SEP_NONICQ)	)
			removeType(SEP_NONICQ);	
			
	}
}
void kxContactList::SlotInfo()
{
  kxInfoDialogImpl *dialog=new kxInfoDialogImpl(uin,0L,"info");
  dialog->show();
}
void kxContactList::SlotUpdateNick()
{
  (void)new kxUpdateContactNick(uin);
}
void kxContactList::SlotRenameNick()
{
  kxChangeNickDialogImpl *dialog=new kxChangeNickDialogImpl(uin,0);
  dialog->show();
}

void kxContactList::SlotAskStatusMessage()
{
  if (ENGINE->CONTACT->status2int(ENGINE->CONTACT->getContact(uin).status)!=STATUS_ONLINE  &&
  		ENGINE->CONTACT->status2int(ENGINE->CONTACT->getContact(uin).status)!=STATUS_INVISIBLE  &&
      ENGINE->CONTACT->status2int(ENGINE->CONTACT->getContact(uin).status)!=STATUS_OFFLINE )
  {
    ENGINE->getStatusMessage(uin,ENGINE->CONTACT->status2int(ENGINE->CONTACT->getContact(uin).status));
  }
}
void kxContactList::SlotSetInvisible()
{
  if (ENGINE->CONTACT->getContact(uin).invisible)
  {
    ENGINE->CONTACT->setInvisible(uin,FALSE);
    ENGINE->removeFromInvisibleList(uin);
  }
  else
  {
    ENGINE->CONTACT->setInvisible(uin,TRUE);
		ENGINE->addToInvisibleList(uin);
  }
}
void kxContactList::SlotSetOnlineNotify()
{
  if (ENGINE->CONTACT->getContact(uin).onlineNotify)
    ENGINE->CONTACT->setOnlineNotify(uin,FALSE);
  else
    ENGINE->CONTACT->setOnlineNotify(uin,TRUE);
}
void kxContactList::SlotSetVisible()
{
  if (ENGINE->CONTACT->getContact(uin).visible)
  {
    ENGINE->CONTACT->setVisible(uin,FALSE);
		ENGINE->removeFromVisibleList(uin);
  }
  else
  {
    ENGINE->CONTACT->setVisible(uin,TRUE);
    ENGINE->addToVisibleList(uin);
  }
}
void kxContactList::SlotSetAlwaysServer()
{
  if (ENGINE->CONTACT->getContact(uin).alwaysServer)
    ENGINE->CONTACT->setAlwaysServer(uin,FALSE);
  else
    ENGINE->CONTACT->setAlwaysServer(uin,TRUE);
}
void kxContactList::SlotSetIgnore()
{
  if (ENGINE->CONTACT->getContact(uin).ignore)
    ENGINE->CONTACT->setIgnore(uin,FALSE);
  else
    ENGINE->CONTACT->setIgnore(uin,TRUE);
}
void kxContactList::SlotSetIntIP()
{
  if (ENGINE->CONTACT->getContact(uin).intIp)
    ENGINE->CONTACT->setIntIp(uin,FALSE);
  else
    ENGINE->CONTACT->setIntIp(uin,TRUE);
}
void kxContactList::SlotSendFile()
{
    kxSendMessageImpl *dialog=new kxSendMessageImpl(uin,FILE_TYPE,0L,"SendMessage");
    dialog->resize(200,250);
    dialog->show();
}
void kxContactList::SlotReRequestAuth()
{
	kxSendMessageImpl *dialog;
	dialog=new kxSendMessageImpl(uin,REQUEST_TYPE,
		0L,"requestauth");
	dialog->show();
}
void kxContactList::SlotChangeSMS()
{
	kxAddPhoneDialog *dialog=new kxAddPhoneDialog(this, "email",TRUE);	
	dialog->setPhone(ENGINE->CONTACT->getGSM(uin));
	dialog->setNickString(ENGINE->CONTACT->getContact(uin).nick);
	dialog->setCaption(i18n("Change Non ICQ contact"));
	if (dialog->exec()==QDialog::Accepted)
	{
		QString gsm=dialog->getNumber();
		if (dialog->getSMS()) gsm.append(" SMS");
		ENGINE->CONTACT->rename(uin, dialog->getNick());
		ENGINE->CONTACT->setGSM(uin, gsm);
	}
}
