#ifndef KXCHANGENICKDIALOGIMPL_H
#define KXCHANGENICKDIALOGIMPL_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kxchangenickdialog.h>
#include <v2_codes.h>
#include <qstringlist.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qcheckbox.h>

class kxAddPhoneDialog : public kxChangeNickDialog
{
  Q_OBJECT
public:
  kxAddPhoneDialog(bool, QWidget* parent, const char* name = 0, bool mod=FALSE);
  kxAddPhoneDialog( QWidget* parent, const char* name = 0, bool mod=FALSE);

  void init();
  bool setSms;
  bool setNick;

  QStringList sl;
  QLineEdit  *prefixString, *numberString;
  QLineEdit  *nickString;
  QComboBox  *countryList;
  QCheckBox  *sms;

  void setPhone(QString _gsm, bool _sms=FALSE);
  void setNickString(QString);
  QString getNick();
  QString getNumber();
  bool getSMS();

public slots:
  void SlotOkButton();
  void SlotCancelButton();

};

class kxAddGroupDialog : public kxChangeNickDialog
{
  Q_OBJECT
public:
  kxAddGroupDialog(QWidget* parent, const char* name = 0, bool mod=FALSE);
  kxAddGroupDialog(Q_UINT16, QWidget* parent, const char* name = 0, bool mod=FALSE);

  Q_UINT16 groupID;
  QString getText();

public slots:
  void SlotOkButton();
  void SlotCancelButton();

};


class kxChangeNickDialogImpl : public kxChangeNickDialog
{
  Q_OBJECT
public:
  kxChangeNickDialogImpl(UIN, QWidget* parent, const char* name = 0);
    
  UIN uin;
  
public slots:
  void SlotOkButton();
  void SlotCancelButton();
  void hide();

};

#endif

