#include "kxinfo_workimpl.h"
#include <kxcountry.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qmultilineedit.h>

/* 
 *  Constructs a kxInfoWorkImpl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
kxInfoWorkImpl::kxInfoWorkImpl( QWidget* _p,QWidget* parent,  const char* name, WFlags fl )
    : kxInfoWork( parent, name, fl )
{
	dialog=(kxExtInfoDialog *)_p;
}

/*  
 *  Destroys the object and frees any allocated resources
 */
kxInfoWorkImpl::~kxInfoWorkImpl()
{
    // no need to delete child widgets, Qt does it all for us
}
void kxInfoWorkImpl::apply()
{
	kxCountry c;
	Q_UINT16 con;
	Q_UINT16 ocu;
	con=c.getCode( countryBox->currentText()).toInt();	
	ocu=c.getOccupationCode( occuBox->currentText()).toInt();

	dialog->setWork(
		nameLabel->text(),
		posLabel->text(),
		divLabel->text(),
		streetLabel->text(),
		zipLabel->text(),				
		cityLabel->text(),
		stateLabel->text(),
		urlLabel->text(),
		con,
		ocu
	);
		
}
void kxInfoWorkImpl::init()
{
    kxCountry c;
    c.init();

    QDictIterator<char> it( c.countryDict ); // iterator for dict

    while ( it.current() ) {
        sl << it.current() ;
        ++it;
    }
    sl.sort();
    countryBox->insertStringList(sl);

    c.occupationInit();

    QDictIterator<char> oit( c.occupationDict ); // iterator for dict

    while ( oit.current() ) {
        occusl << oit.current() ;
        ++oit;
    }
    occusl.sort();
    occuBox->insertStringList(occusl);


}
void kxInfoWorkImpl::disableAll()
{
	nameLabel->setEnabled(FALSE);
	posLabel->setEnabled(FALSE);
	divLabel->setEnabled(FALSE);
	streetLabel->setEnabled(FALSE);
	zipLabel->setEnabled(FALSE);
	cityLabel->setEnabled(FALSE);
	stateLabel->setEnabled(FALSE);
	urlLabel->setEnabled(FALSE);
	countryBox->setEnabled(FALSE);
	occuBox->setEnabled(FALSE);
}
void kxInfoWorkImpl::enableAll()
{
	nameLabel->setEnabled(TRUE);
	posLabel->setEnabled(TRUE);
	divLabel->setEnabled(TRUE);
	streetLabel->setEnabled(TRUE);
	zipLabel->setEnabled(TRUE);
	cityLabel->setEnabled(TRUE);
	stateLabel->setEnabled(TRUE);
	urlLabel->setEnabled(TRUE);
	countryBox->setEnabled(TRUE);
	occuBox->setEnabled(TRUE);
}
void kxInfoWorkImpl::setWork(QString _n, QString _p,QString _d, QString _s,QString _z, QString _c,QString _st, QString _url, Q_UINT16 _co, Q_UINT16 _oc)
{
	nameLabel->setText(_n);
	posLabel->setText(_p);
	divLabel->setText(_d);
	streetLabel->setText(_s);
	zipLabel->setText(_z);
	cityLabel->setText(_c);
	stateLabel->setText(_st);
	urlLabel->setText(_url);
	kxCountry c;
	QString tmp;
	tmp.sprintf("%d",_co);
  QString look=c.getCountry(tmp);	
	Q_UINT16 num=0;
  Q_UINT8 found=0;
  QStringList::Iterator it;
  it = sl.begin();
  do
  {      	
  	if ((*it).latin1()==look)
  	{      		
  		it=sl.end();
  		found=1;
  	}
  	else num++;
  	++it;
  }
  while(it != sl.end() && found==0 );
  countryBox->setCurrentItem( num );	
	tmp.sprintf("%d",_oc);
	found=0;
	if (_oc>0)
	{
  	look=c.getOccupation(tmp);	
  	num=0;	
    it = occusl.begin();
    do
    {      	
    	if ((*it).latin1()==look)
    	{      		
    		it=occusl.end();
    		found=1;
    	}
    	else if (found==0) num++;
    	++it;
    }
    while(it != occusl.end() && found==0 );
    occuBox->setCurrentItem( num );	
	}	
}
