#include "kxinfo_phoneimpl.h"
#include <klocale.h>
#include <kxmainwindow.h>
#include <kxchangenickdialogimpl.h>
#include <qpixmap.h>

/* 
 *  Constructs a kxInfoPhoneImpl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
kxInfoPhoneImpl::kxInfoPhoneImpl( QWidget*_p, QWidget* parent,  const char* name, WFlags fl )
    : kxInfoPhone( parent, name, fl )
{
	fax=NULL;
	phone=NULL;
	gsm=NULL;
	wPhone=NULL;
	wFax=NULL;
	dialog=(kxExtInfoDialog *)_p;
}

/*  
 *  Destroys the object and frees any allocated resources
 */
kxInfoPhoneImpl::~kxInfoPhoneImpl()
{
    // no need to delete child widgets, Qt does it all for us
}
void kxInfoPhoneImpl::apply()
{
	dialog->setWorkPhone(wPhone->text(1), wFax->text(1));
	QString sgsm=gsm->text(1);
	if (gsm->pixmap(2)) sgsm+=" SMS";
	dialog->setHomePhone(phone->text(1), fax->text(1), sgsm);
}
void kxInfoPhoneImpl::init()
{
	QObject::connect(editButton, SIGNAL(clicked()), SLOT(slotEditButton()));	
	QObject::connect(clearButton, SIGNAL(clicked()), SLOT(slotClearButton()));
	QObject::connect(phoneView, SIGNAL(pressed(QListViewItem *)), SLOT(slotClicked(QListViewItem *)));
	phone=new QListViewItem(phoneView, i18n("Home Phone"));
	fax=new QListViewItem(phoneView, i18n("Home Fax"));
	gsm=new QListViewItem(phoneView, i18n("Cellular"));
	wPhone=new QListViewItem(phoneView, i18n("Work Phone"));
	wFax=new QListViewItem(phoneView, i18n("Work Fax"));	
}
void kxInfoPhoneImpl::disableAll()
{
	phoneView->setEnabled(FALSE);
	editButton->setEnabled(FALSE);
	clearButton->setEnabled(FALSE);
}
void kxInfoPhoneImpl::enableAll()
{
	phoneView->setEnabled(TRUE);
}
void kxInfoPhoneImpl::setWork(QString _p, QString _f)
{
	wPhone->setText(1,_p);	
	wFax->setText(1,_f);
	debug("done");
}
void kxInfoPhoneImpl::setHome(QString _p, QString _f, QString _c)
{
	phone->setText(1, _p);	
	fax->setText(1, _f);	
	int f=_c.find(" SMS");
	if (f!=-1)
	{
		_c=_c.left(f);
		gsm->setPixmap(2,MAINWINDOW->kxIcons.contactSMS);
	}
	gsm->setText(1, _c);
	
//	gsm->setPixmap(2,MAINWINDOW->kxIcons.contactSMS);	
}
QString kxInfoPhoneImpl::parsePhone( QListViewItem *i, QString _f)
{
	if (i) i->setText(1,_f);	
}
void  kxInfoPhoneImpl::slotClearButton()
{
	phoneView->selectedItem()->setText(1,"");
	phoneView->selectedItem()->setPixmap(2,QPixmap());
	
}
void  kxInfoPhoneImpl::slotEditButton()
{
	bool sms=FALSE;
	if (phoneView->selectedItem()==gsm ) sms=TRUE;
	kxAddPhoneDialog *dialog=new kxAddPhoneDialog(sms,this, "email",TRUE);
	dialog->setPhone(phoneView->selectedItem()->text(1) ,(phoneView->selectedItem()->pixmap(2)!=NULL));
	if (dialog->exec()==QDialog::Accepted)
	{
		phoneView->selectedItem()->setText(1,dialog->getNumber());
		if (dialog->getSMS()) gsm->setPixmap(2,MAINWINDOW->kxIcons.contactSMS);
	}
}
void kxInfoPhoneImpl::slotClicked(QListViewItem *i)
{
	if (i)
	{
		clearButton->setEnabled(TRUE);
		editButton->setEnabled(TRUE);
	}
}
