#include "kxinfo_extraimpl.h"
#include <kxcountry.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include <qlineedit.h>
#include <klocale.h>
#include <qdatetime.h>

/* 
 *  Constructs a kxInfoExtraImpl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
kxInfoExtraImpl::kxInfoExtraImpl( QWidget *_p, QWidget* parent,  const char* name, WFlags fl )
    : kxInfoExtra( parent, name, fl )
{
	dialog=(kxExtInfoDialog *)_p;
	
}

/*  
 *  Destroys the object and frees any allocated resources
 */
kxInfoExtraImpl::~kxInfoExtraImpl()
{
    // no need to delete child widgets, Qt does it all for us
}
void kxInfoExtraImpl::apply()
{
	kxCountry c;

	Q_UINT8 s=0;
	Q_UINT8 m=c.getMonthCode(monthBox->currentText()).toInt();
	Q_UINT8 l1=c.getLangCode(lang1Box->currentText()).toInt(), l2=c.getLangCode(lang2Box->currentText()).toInt(), l3=c.getLangCode(lang3Box->currentText()).toInt();
	if (genderBox->currentText()==i18n("Male")) s=2;
	else if (genderBox->currentText()==i18n("Female")) s=1;
	dialog->setExtra(age->value(), s, url->text(), year->value(), dayBox->currentText().toInt(),m, l1, l2, l3);
}
void kxInfoExtraImpl::init()
{
    kxCountry c;
    c.langInit();

    QDictIterator<char> it( c.langDict ); // iterator for dict

    while ( it.current() ) {
        lang << it.current() ;
        ++it;
    }
    lang.sort();
    lang1Box->insertStringList(lang);
    lang2Box->insertStringList(lang);
    lang3Box->insertStringList(lang);
    c.monthInit();

    for (Q_UINT8 t=0; t<13; t++)
    {
    	month << c.getMonth(QString::number(t));
    }
    monthBox->insertStringList(month);

    QStringList day, gender;
    day << QString(" ");
    for (Q_UINT8 t=1; t<=31; t++)
    {
    	day << (QString::number(t));
    }
    dayBox->insertStringList(day);

    gender << QString(" ") << i18n("Male") << i18n("Female");
    genderBox->insertStringList(gender);

}
void kxInfoExtraImpl::disableAll()
{
	monthBox->setEnabled(FALSE);
	genderBox->setEnabled(FALSE);
	dayBox->setEnabled(FALSE);
	age->setEnabled(FALSE);
	year->setEnabled(FALSE);
	url->setEnabled(FALSE);
	lang1Box->setEnabled(FALSE);	
	lang2Box->setEnabled(FALSE);
	lang3Box->setEnabled(FALSE);
}
void kxInfoExtraImpl::enableAll()
{
	monthBox->setEnabled(TRUE);
	genderBox->setEnabled(TRUE);
	dayBox->setEnabled(TRUE);
	age->setEnabled(TRUE);
	year->setEnabled(TRUE);
	url->setEnabled(TRUE);
	lang1Box->setEnabled(TRUE);	
	lang2Box->setEnabled(TRUE);
	lang3Box->setEnabled(TRUE);
}
void kxInfoExtraImpl::setExtra(Q_UINT16 _a, Q_UINT8 _s, QString _h, Q_UINT16 _j,Q_UINT8 _d,Q_UINT8 _m,Q_UINT8 _l1,Q_UINT8 _l2,Q_UINT8 _l3)
{
	age->setValue(_a);
	year->setValue(_j);
	url->setText(_h);
	
	kxCountry c;
	QString tmp;
	tmp.sprintf("%d",_m);
  QString look=c.getMonth(tmp);	
	Q_UINT16 num=0;
  Q_UINT8 found=0;
  QStringList::Iterator it;
  it = month.begin();
  do
  {      	
  	if ((*it).latin1()==look)
  	{      		
  		it=month.end();
  		found=1;
  	}
  	else num++;
  	++it;
  }
  while(it != month.end() && found==0 );
  monthBox->setCurrentItem( num );	
  dayBox->setCurrentItem( _d);

  num=0;
  if (_s==1) num=2; else if (_s==2) num=1;
  genderBox->setCurrentItem(num);

	tmp.sprintf("%d",_l1);
  look=c.getLang(tmp);	
	num=0;
  found=0;
  it = lang.begin();
  do
  {      	
  	if ((*it).latin1()==look)
  	{      		
  		it=lang.end();
  		found=1;
  	}
  	else num++;
  	++it;
  }
  while(it != lang.end() && found==0 );
  lang1Box->setCurrentItem( num );
	tmp.sprintf("%d",_l2);
  look=c.getLang(tmp);	
	num=0;
  found=0;
  it = lang.begin();
  do
  {      	
  	if ((*it).latin1()==look)
  	{      		
  		it=lang.end();
  		found=1;
  	}
  	else num++;
  	++it;
  }
  while(it != lang.end() && found==0 );
  lang2Box->setCurrentItem( num );
	tmp.sprintf("%d",_l3);
  look=c.getLang(tmp);	
	num=0;
  found=0;
  it = lang.begin();
  do
  {      	
  	if ((*it).latin1()==look)
  	{      		
  		it=lang.end();
  		found=1;
  	}
  	else num++;
  	++it;
  }
  while(it != lang.end() && found==0 );
  lang3Box->setCurrentItem( num );

	QObject::connect(monthBox, SIGNAL(activated(const QString &)), SLOT(slotMonthChanged(const QString &)));
	QObject::connect(dayBox, SIGNAL(activated(const QString &)), SLOT(slotDayChanged(const QString &)));
	QObject::connect(year, SIGNAL(valueChanged(int)), SLOT(slotYearChanged(int)));

}
void kxInfoExtraImpl::slotMonthChanged(const QString &_m)
{
	calcYear();
}
void kxInfoExtraImpl::slotDayChanged(const QString &_d)
{
	calcYear();
}
void kxInfoExtraImpl::slotYearChanged(int _y)
{
	calcYear();
}
void kxInfoExtraImpl::calcYear()
{
	kxCountry c;
	Q_UINT8 m=c.getMonthCode(monthBox->currentText()).toInt();
  Q_UINT8 d=dayBox->currentText().toInt();
  Q_UINT16 y=year->value();

  if (!QDate::isValid(y,m,d)) return;
	QDate now=QDate::currentDate();
	QDate b(y, m, d);
	
	Q_UINT16 bi=0, ye=0;	
	for (Q_UINT16 t=y+1; t<now.year(); t++)
	{
		if (QDate::leapYear(t)) bi+=366; else bi+=365;
		ye++;
	}	
	Q_UINT16 ll=QDate::leapYear(y)?366:365;
	Q_UINT16 ll2=ll-b.dayOfYear();
	if (now.dayOfYear()+ll2>ll) ye++;	
	age->setValue(ye);
}
