#include <kxmainwindow.h>
#include <kconfig.h>
#include "kxsettingsdialog.h"
#include "kxsettings_general_startupimpl.h"
#include "kxsettings_connections_optionsimpl.h"
#include "kxsettings_contactlist_colorimpl.h"
#include "kxsettings_contactlist_optionsimpl.h"
#include "kxsettings_securityimpl.h"
#include <klocale.h>
#include <qhbox.h>
#include <qframe.h>
#include <qlayout.h>
#include <kiconloader.h>
#include <kdialogbase.h>

kxSettingsDialog::kxSettingsDialog(QWidget *parent=0, const char *name=0) : 
  KDialogBase(IconList, i18n("Preferences"), Ok|Apply|Cancel|Help, Ok, parent, name, false, true)
{
  setShowIconsInTreeList(true);  
  
  QStringList list;
/*
  list << QString(" ")+i18n("Contact List");
  setFolderIcon(list,BarIcon("view_right"));
  list.clear();
  list << QString(" ")+i18n("Contact List");
  setFolderIcon(list,BarIcon("colors"));
  list.clear();
  list << QString(" ")+i18n("Connections");
  setFolderIcon(list,BarIcon("connect_creating"));
  list.clear();
  list << QString(" ")+i18n("General");
  setFolderIcon(list,BarIcon("edit"));
  list.clear();
  list << QString(" ")+i18n("Security");
  setFolderIcon(list,BarIcon("edit"));
*/
  
  list.clear();  
  list << QString(" ")+i18n("Contact List") << i18n(" Contact List");
  QFrame *frame = addHBoxPage(list, i18n("Contact List"), BarIcon("config_main"));
  widgets.append(new kxSettings_ContactList_OptionsImpl(frame));
  
  list.clear();  
  list << QString(" ")+i18n("Contact List") << i18n(" Colors");
  frame = addHBoxPage(list, i18n("Colors"), BarIcon("config_color"));
  widgets.append(new kxSettings_ContactList_ColorImpl(frame));

  list.clear();  
  list << QString(" ")+i18n("Connections") << i18n(" Network");
  frame = addHBoxPage(list, i18n("Network"), BarIcon("config_network"));
  widgets.append(new kxSettings_Connections_OptionsImpl(frame));
  
  list.clear();  
  list << QString(" ")+i18n("General") << i18n(" Startup");
  frame = addHBoxPage(list, i18n("Startup"), BarIcon("config_profile"));
  widgets.append(new kxSettings_General_StartupImpl(frame));

  list.clear();
  list << QString(" ")+i18n("Security") << i18n(" Security");
  frame = addHBoxPage(list, i18n("Security"), BarIcon("config_security"));
  widgets.append(new kxSettings_SecurityImpl(frame));


//  restoreWindowSize("settingsDialog",this,QSize(510,425));
  resize(565,425);
  kxSettingsFrame *sw;
  for (Q_UINT16 t=0; t<widgets.count(); t++)
  {
    sw=(kxSettingsFrame *)widgets.at(t);
    if (sw) sw->init();
  }      
}
void kxSettingsDialog::slotOk()
{
  slotApply();
  KDialogBase::slotOk();  
}
void kxSettingsDialog::slotApply()
{
  kxSettingsFrame *sw;
  for (Q_UINT16 t=0; t<widgets.count(); t++)
  {
    sw=(kxSettingsFrame *)widgets.at(t);
    if (sw) sw->apply();
  }
  MAINWINDOW->rereadConfig();               
}

