#include <config.h>
#include <wmkxicq.h>
#include <qcolor.h>
#include <qpalette.h>
#include <kglobalaccel.h>
#include "kxreceivedmessageimpl.h"
#include <dcopclient.h>
#include <kbugreport.h>
#include <kaboutapplication.h>
#include <kxlabel.h>
#include <kxhistorydialogimpl.h>
#include <kxstatusmessagedialogimpl.h>
#include <kxsettingsdialog.h>
#include "kxSendMessageImpl.h"
#include <xautolock.h>
#include <qpoint.h>
#include <klocale.h>
#include "kxmainwindow.h"
#include <kmessagebox.h>
#include "kxengine.h"
#include <qobject.h>
#include "kxcontact.h"
#include "v2_codes.h"
#include <qlayout.h>
#include <qobject.h>
#include <kwin.h>
#include <kxaim.h>
#include <kpopupmenu.h>
#include "kxsearchdialogimpl.h"
#include <kstddirs.h>
#include <stdlib.h>
#include <kiconloader.h>
#include <kxstartupwizardimpl.h>
#include <kxpaneldock.h>
#include <kxrandomsearchimpl.h>
#include <kxrequestformimpl.h>
#include <kxcontactlist.h>
#include <kcharsets.h>
#include <kxextinfodialog.h>
#include <kxchangenickdialogimpl.h>

#define popupConnectID    101
#define popupDisconnectID 102
#define popupStatusID     104

void DebugOutput(QtMsgType _type, const char *_msg)
{
  if (MAINWINDOW) if (!MAINWINDOW->kxConfig.showDebug) return;
  if (!_msg) fprintf(stderr,"Debug Message Error: Null Pointer\n");
  switch(_type)
  {
    case QtDebugMsg:
      fprintf(stderr,"%s\n",_msg);
      break;
    case QtWarningMsg:
      fprintf(stderr,"WARNING: %s\n",_msg);
      break;
    case QtFatalMsg:
      fprintf(stderr,"FATAL: %s\n",_msg);
      abort();
      break;
  }
}

kxMainWindow *kxMainWindow::ptr=0L; 

kxMainWindow::kxMainWindow(const char *name )
: KTMainWindow(name )
{

  ptr=this;
  firstLoad=TRUE;
    
//  createGUI();
  kxConfig.showDebug=FALSE;
  qInstallMsgHandler(DebugOutput);
  wantStatus=STATUS_OFFLINE;

  kxConfig.maxPort=65000;
  kxConfig.minPort=1024;
	kxConfig.useColor=TRUE;

  waitForAutoAway=FALSE;
  manualStatusChange=FALSE;
  retryCounter=0;
  
  readConfig();

  loadIcons();
  KWin::setIcons(winId(),kxIcons.offline,kxIcons.offline);
  
  if (kxConfig.uin==0)
  {
    kxStartupWizardImpl *wizard=new kxStartupWizardImpl(0,"wizrad",TRUE);
    wizard->exec();
    readConfig();
    if (kxConfig.uin==0) exit(0);
  }  
  debug("Config loaded");
  useGroups=kxConfig.useGroups;
  showAuth=kxConfig.showWaitAuth;
  useKDEColors=kxConfig.useKDEColors;
	backgroundColor=kxConfig.backgroundColor;
	selectedBackgroundColor=kxConfig.selectedBackgroundColor;
	textColor=kxConfig.textColor;
	selectedTextColor=kxConfig.selectedTextColor;
  
  ENGINE->setUserInfo(kxConfig.uin, kxConfig.password, kxConfig.server,kxConfig.serverPort,kxConfig.minPort, kxConfig.maxPort);

  QObject::connect(ENGINE, SIGNAL(SignalNewMessage(UIN, kxMessageStruct)), this, SLOT(SlotNewMessage(UIN, kxMessageStruct)));
  QObject::connect(ENGINE, SIGNAL(SignalNewFile(UIN, int, QString,QString, int)), this, SLOT(SlotNewFile(UIN, int, QString,QString, int)));
  
  QString cap;
  cap.sprintf("%d",ENGINE->ourUin);
  setPlainCaption(cap);

  QVBoxLayout *vbox = new QVBoxLayout( this );
  vbox->setSpacing( 3 );
  vbox->setMargin( 0 );
  
  list=new kxContactList(this); 
  list->update();
  list->show();
  vbox->addWidget( list ); 
  QHBoxLayout *hbox = new QHBoxLayout;
  hbox->setSpacing( 3 );
  hbox->setMargin( 0 );
  list->setBackgroundColor(colorGroup().base());
 
  menuButton = new QPushButton( this, "PushButton5" );
  menuButton->setText( tr( "Menu"  ) );
  menuButton->setMinimumSize( QSize( 50, 25 ) );
  menuButton->setMaximumSize( QSize( 50, 25 ) );

  hbox->addWidget( menuButton );
 
  statusLabel = new kxLabel( this, "TextLabel3" );
  statusLabel->setText( tr( "KXicq 2"  ) );
  statusLabel->setLineWidth( 2 );
  statusLabel->setFrameShape( QLabel::WinPanel );
  statusLabel->setFrameShadow( QLabel::Sunken );
  QObject::connect(statusLabel, SIGNAL(clicked()), this, SLOT(SlotLabelButton()));
  
  hbox->addWidget( statusLabel );
  vbox->addLayout( hbox );        

  setView((QWidget *)vbox);

  // connect slots 
  QObject::connect(ENGINE, SIGNAL(SignalStatusUpdate(int) ),this, SLOT(SlotStatusUpdate(int) ));
  QObject::connect(ENGINE, SIGNAL(SignalStatusMessage(UIN, QString) ),this, SLOT(SlotStatusMessage(UIN, QString) ));
  QObject::connect(ENGINE, SIGNAL(SignalConnected() ),this, SLOT(SlotConnected() ));
  QObject::connect(ENGINE, SIGNAL(SignalNotLoggedOn() ),this, SLOT(SlotNotLoggedOn() ));
  QObject::connect(ENGINE, SIGNAL(SignalConnecting() ),this, SLOT(SlotConnecting() ));
  QObject::connect(ENGINE, SIGNAL(SignalConnectError(QString) ),this, SLOT(SlotErrorString(QString) ));
  QObject::connect(ENGINE, SIGNAL(SignalDisconnected(int) ),this, SLOT(SlotDisconnected(int) ));
  QObject::connect(ENGINE, SIGNAL(SignalContactStatusChange(UIN, Q_UINT16, Q_UINT16) ),this, SLOT(SlotContactStatusChange(UIN, Q_UINT16, Q_UINT16) ));
  QObject::connect(ENGINE, SIGNAL(SignalContactChange(UIN) ),this, SLOT(SlotContactChange(UIN) ));
  QObject::connect(ENGINE, SIGNAL(SignalRequestAdd2List(Q_UINT32)),this, SLOT( SlotRequestAdd2List(Q_UINT32)));
  QObject::connect(ENGINE, SIGNAL(SignalRequestInfo(Q_UINT16, Q_UINT32, bool *)), this, SLOT( SlotRequestInfo(Q_UINT16, Q_UINT32, bool *)));
  QObject::connect(&autoAwayTimer, SIGNAL(timeout()), this, SLOT(SlotCheckAutoAway()));
  QObject::connect(&waitForAutoAwayTimer, SIGNAL(timeout()), this, SLOT(SlotWaitForAutoAway()));
  QObject::connect(&tryConnect, SIGNAL(timeout()), this, SLOT(SlotTryConnect()));
  
  
  statusPopup=new KPopupMenu(this);
  statusPopup->insertTitle(i18n("Status"));  
  statusPopup->insertItem(kxIcons.available, i18n("Available"),STATUS_ONLINE);
  statusPopup->insertItem(kxIcons.away,i18n("Away"),STATUS_AWAY);  
  statusPopup->insertItem(kxIcons.dnd,i18n("Do Not Desturb"),STATUS_DND);
  statusPopup->insertItem(kxIcons.na,i18n("N/A"),STATUS_NA);
  statusPopup->insertItem(kxIcons.occupied,i18n("Occupied"),STATUS_OCCUPIED);
  statusPopup->insertItem(kxIcons.ffc,i18n("Free For Chat"),STATUS_FFC);
  statusPopup->insertItem(kxIcons.invisible,i18n("Invisible"),STATUS_INVISIBLE);
  QObject::connect(statusPopup, SIGNAL(activated(int)), this, SLOT(SlotChangeStatusByMenu(int)));

  popup=new KPopupMenu(this);
  popup->insertTitle(i18n("Connection"));
  popup->insertItem(i18n("&Connect"),this, SLOT(SlotMenuConnect()),0,popupConnectID);
  popup->insertItem(i18n("&Disconnect"),this, SLOT(SlotDisconnect()),0,popupDisconnectID);    
  popup->insertSeparator();
  popup->insertItem(i18n("&Status"),statusPopup,0,popupStatusID);   
  popup->insertSeparator();
	popup->insertItem(i18n("Add non ICQ contact"), this, SLOT(SlotAddNonICQ()),0);
//  popup->insertItem(i18n("Ra&ndom Search"), this, SLOT(SlotRandomSearch()),0);
  popup->insertItem(i18n("&Add/Search contacts"), this, SLOT(SlotSearch()),0);  
  popup->insertSeparator();
  popup->insertItem(i18n("&Change own Info"), this, SLOT(SlotChangeInfo()),0);
  popup->insertItem(i18n("&Preferences"), this, SLOT(SlotSettings()),0);  
  popup->insertSeparator();
  popup->insertItem(i18n("&Report Bug"), this, SLOT(SlotReportBug()),0);  
  popup->insertItem(i18n("A&bout"), this, SLOT(SlotAboutDialog()),0);    
  popup->insertSeparator();
  popup->insertItem(i18n("&Quit"), this, SLOT(SlotExit()),0);
  popup->setItemEnabled(popupDisconnectID,FALSE);  
  menuButton->setPopup(popup);
  
  if (kxConfig.kdeDock || kxConfig.wmDock)
  {
    kxPanelDock *panel=new kxPanelDock();
    if (kxConfig.kdeDock)
    {
	    KWin::setSystemTrayWindowFor(panel->winId(),0);
	    KWin::setType(panel->winId(),NET::Dock);
	    QApplication::syncX();
	    panel->resize(42,42);
	    panel->show();
	    panel->update();
	  }
	  else
	  {
//	  	panel->resize(0,0);
	  	panel->hide();
	  	panel->update();
	  }	  	
  }
  
  KGlobalAccel *ga = new KGlobalAccel(); 
  ga->insertItem( i18n("Monitor settings2"), "Monitor settings2", "CTRL+ALT+M" ); 
  ga->connectItem( "Monitor settings2", this, SLOT( SlotReadMessage() ) );

  if (kxConfig.saveGeometry)
  {
    KConfig *config=KGlobal::config();
    config->reparseConfiguration();
    config->setGroup("Geometry");    
    int x=config->readNumEntry("X",0);
    int y=config->readNumEntry("Y",0);        
    int w=config->readNumEntry("Width",0);
    int h=config->readNumEntry("Height",0);            
    KWin::Info i = KWin::info( winId() );
    int desktop=config->readNumEntry("Desktop",1);
    bool hi=config->readBoolEntry("Hidden",false);    
    bool mi=config->readBoolEntry("Minimized",false);    
    bool ma=config->readBoolEntry("Maximized",false);    
    if (w>0 && h>0)
    {
      QPoint p(x,y);
      QSize s(w,h);
      KWin::setCurrentDesktop(desktop);
      resize(s);
      move(p);
      if (!mi && !ma && !hi) show();
      if (mi) showMinimized();
      if (ma) showMaximized();      
      if (hi) hide();
    }
    else
    {
      resize(200,250);
      show();
    }
    config->sync();
  }
  else
  {
    resize(200,250);
    show(); 
  }
  Mpos=pos();
  Msize=size();

  startTimer(450);    
  init();
  firstLoad=FALSE;
  list->init();
  // add all contacts to the contact list
}

kxMainWindow::~kxMainWindow()
{
}

void kxMainWindow::init()
{
  KWin::clearState(this->winId(),NET::StaysOnTop | NET::Sticky);
  KWin::setState(this->winId(), kxConfig.stayOnTop ? NET::StaysOnTop : 0  | kxConfig.sticky ? NET::Sticky : 0 );
  KWin::setOnAllDesktops(this->winId(), kxConfig.sticky);
  if (!ENGINE->loggedOn() && kxConfig.autoConnect)
  {
    SlotConnect();
  }
  if (ENGINE->loggedOn() )
  {
    if (ENGINE->getStatus()==STATUS_ONLINE && kxConfig.autoAway)
    {    
      initTimeOut(kxConfig.awayTime);
      autoAwayTimer.start(360);
    }
    if (ENGINE->getStatus()==STATUS_AWAY && kxConfig.autoAway)
    {    
      initTimeOut(kxConfig.naTime);
      autoAwayTimer.start(360);
    }
  }
//todo  if (firstLoad) list->setShowOffline(kxConfig.showOffline);
  ENGINE->setSecuritySettings(kxConfig.webStatus, kxConfig.hideIP, TRUE);
  ENGINE->setServer(kxConfig.server, kxConfig.serverPort);
//todo  list->reinit();
}
void kxMainWindow::readConfig()
{
  kxConfig.askAwayMessage=TRUE;
  kxConfig.awayMessage="The User is currenty Away!";
  kxConfig.naMessage="The User is currently gone!";  
  kxConfig.dndMessage="The User is doning other things!";  
  ENGINE->setStatusMessages(kxConfig.awayMessage, kxConfig.naMessage, kxConfig.dndMessage);

  KConfig *config=KGlobal::config();
  config->reparseConfiguration();
  config->setGroup("Personal Settings");
  
  kxConfig.password = config->readEntry("Password","");
  kxConfig.nick = config->readEntry("Nick","");
  kxConfig.lastName = config->readEntry("Last Name","");
  kxConfig.firstName = config->readEntry("First Name","");
  kxConfig.email = config->readEntry("Email","");
  kxConfig.uin = config->readUnsignedLongNumEntry("UIN",0);
  if (kxConfig.uin==0) return;

  config->setGroup("Messaging");
  kxConfig.useColor = config->readBoolEntry("Use Color",TRUE);


  config->setGroup("Docking");
  if (firstLoad) kxConfig.kdeDock = config->readBoolEntry("KDE Dock",TRUE);
  if (firstLoad) kxConfig.wmDock = config->readBoolEntry("WindowMaker Dock",FALSE);
  
  config->setGroup("Auto Away");
  kxConfig.autoAway = config->readBoolEntry("Auto Away",TRUE);
  kxConfig.autoUnAway = config->readBoolEntry("Auto Un Away",TRUE);
  kxConfig.awayTime = config->readNumEntry("Away Time",10);  
  kxConfig.naTime = config->readNumEntry("N/A Time",10);    
  
  kxConfig.awayTime *= 60;
  kxConfig.naTime *= 60;

  config->setGroup("Connections");
  kxConfig.server=config->readEntry("Server", "login.icq.com");
  kxConfig.serverPort=config->readNumEntry("Port", 5190);
  
  config->setGroup("Startup");  
  kxConfig.autoConnect=config->readBoolEntry("Auto Connect",TRUE);
  kxConfig.stayOnTop=config->readBoolEntry("Stay on Top",TRUE);
  kxConfig.sticky=config->readBoolEntry("Sticky",FALSE);
  kxConfig.showDebug=config->readBoolEntry("Debug output",FALSE);
                        
  config->setGroup("Contact List");
  kxConfig.notifyContactOnAdding = config->readBoolEntry("Notify Contact On Adding",TRUE);
  kxConfig.popupMessageChatOnReceive=config->readBoolEntry("Popup Message Chat On Receive",FALSE);
  kxConfig.popupMessageChatOnPress=config->readBoolEntry("Popup Message Chat On Press",FALSE);
  kxConfig.ignoreContactAuth=config->readBoolEntry("Ignore Auth",FALSE);
  kxConfig.saveGeometry=config->readBoolEntry("Save Geometry",TRUE);
//  if (firstLoad) kxConfig.showOffline=config->readBoolEntry("Show Offline",TRUE);
//  if (firstLoad) kxConfig.showUnknown=config->readBoolEntry("Show Unknown",TRUE);
	kxConfig.showWaitAuth=config->readBoolEntry("Show Wait Auth",TRUE);
	kxConfig.effect3d=config->readBoolEntry("3D Effect",TRUE);
	
	kxConfig.useKDEColors=config->readBoolEntry("Use KDE Colors",TRUE);	
	kxConfig.backgroundColor=config->readColorEntry("Background Color");
	kxConfig.selectedBackgroundColor=config->readColorEntry("Selected Background Color");
	kxConfig.textColor=config->readColorEntry("Text Color");
	kxConfig.selectedTextColor=config->readColorEntry("Selected Text Color");

	kxConfig.useGroups=config->readBoolEntry("Use Groups",FALSE);	
	kxConfig.sortNick=config->readBoolEntry("Sort Nick",TRUE);	
	kxConfig.sortStatus=config->readBoolEntry("Sort Status",TRUE);	
	kxConfig.sortGroup=config->readBoolEntry("Sort Group",FALSE);

  kxConfig.transparant=config->readBoolEntry("Transparant",FALSE);  
  
  config->setGroup("Connections");  
  kxConfig.reconnect=config->readBoolEntry("Reconnect",TRUE);
  kxConfig.retry=config->readNumEntry("Retry",3);
  kxConfig.retryAtFailure=config->readBoolEntry("Retry at Failure",TRUE);

  config->setGroup("Security Settings");
  kxConfig.webStatus=config->readBoolEntry("Web Status",TRUE);
  kxConfig.hideIP=config->readBoolEntry("Hide IP",FALSE);
  kxConfig.rejectMessage=config->readBoolEntry("Reject Message",FALSE);
  kxConfig.rejectUrl=config->readBoolEntry("Reject URL",FALSE);
  kxConfig.rejectRest=config->readBoolEntry("Reject Rest",FALSE);
  ENGINE->setIgnore(kxConfig.rejectMessage, kxConfig.rejectUrl, kxConfig.rejectRest);

  config->setGroup("Status");
  kxConfig.saveStatus=config->readBoolEntry("Save Status",TRUE);
	kxConfig.lastStatus=config->readNumEntry("Last Status",STATUS_ONLINE);
	
	config->setGroup("Encoding");
  kxConfig.encoderLanguage=config->readEntry("Language", "KDE Default");
	ENGINE->setEncoderLanguage(kxConfig.encoderLanguage);
}
void kxMainWindow::rereadConfig()
{
  readConfig();
  init();
/*if (useGroups!=kxConfig.useGroups || showAuth != kxConfig.showWaitAuth )
  	list->init();
  if (useKDEColors != kxConfig.useKDEColors ||
	  backgroundColor!=kxConfig.backgroundColor ||
		selectedBackgroundColor!=kxConfig.selectedBackgroundColor ||
		textColor!=kxConfig.textColor ||
		selectedTextColor!=kxConfig.selectedTextColor
  )*/
  list->init();

 	backgroundColor=kxConfig.backgroundColor;
	selectedBackgroundColor=kxConfig.selectedBackgroundColor;
	textColor=kxConfig.textColor;
	selectedTextColor=kxConfig.selectedTextColor;
  useGroups=kxConfig.useGroups;
  showAuth=kxConfig.showWaitAuth;
  useKDEColors=kxConfig.useKDEColors;
}
void kxMainWindow::loadIcons()
{
  kxIcons.available=loadIcon("available.xpm");
  kxIcons.invisible=loadIcon("invisible.xpm");
  kxIcons.na=loadIcon("na.xpm");
  kxIcons.ffc=loadIcon("ffc.xpm");
  kxIcons.dnd=loadIcon("dnd.xpm");
  kxIcons.occupied=loadIcon("occupied.xpm");
  kxIcons.away=loadIcon("away.xpm");
  kxIcons.online=loadIcon("online.xpm");
  kxIcons.offline=loadIcon("offline.xpm");
  kxIcons.message=loadIcon("newmsg.xpm");
  kxIcons.file=loadIcon("file.xpm");
  kxIcons.url=loadIcon("url.xpm");
  kxIcons.history=loadIcon("history.xpm");
  kxIcons.groupUp=loadIcon("groupup.xpm");
  kxIcons.groupDown=loadIcon("groupdown.xpm");
  kxIcons.contactSMS=loadIcon("contactsms.xpm");
//  kxIcons.contactVisible=loadIcon("contactvisible.xpm");
//  kxIcons.contactInvisible=loadIcon("contactinvisible.xpm");
} 

QPixmap kxMainWindow::loadIcon(const QString& icon)
{
  QString f = KGlobal::dirs()->findResource("data","kxicq2/pics/"+icon);
  if (f == QString::null)
  {
    return QPixmap(NULL);
  }
  return QPixmap(f);
}


void kxMainWindow::SlotConnected()
{
  statusLabel->setText(ENGINE->CONTACT->status2str(ENGINE->currentStatus));
  popup->setItemEnabled(popupDisconnectID,TRUE);
  popup->setItemEnabled(popupConnectID,FALSE);
  popup->setItemEnabled(popupStatusID,TRUE);
  updateIcon();

  retryCounter=0;
  if (kxConfig.autoAway)
  {    
    initTimeOut(kxConfig.awayTime);
    autoAwayTimer.start(360);
  }
}
void kxMainWindow::SlotConnecting()
{
  statusLabel->setText(i18n("Connecting.."));
  popup->setItemEnabled(popupConnectID,FALSE);
  popup->setItemEnabled(popupDisconnectID,TRUE);
  popup->setItemEnabled(popupStatusID,FALSE);

}
void kxMainWindow::SlotErrorString(QString _s)
{
  statusLabel->setText(_s);
}
void kxMainWindow::SlotDisconnected(int e) 
{
	QString reason;
	tryConnect.stop();
	bool show=FALSE;
	bool cont=TRUE;
	switch(e)
	{
		case kxAIM::GoAway:
					reason=("for 'Go Away'");
					show=TRUE;
					break;
		case kxAIM::Manual:
					reason=("Manually");
					break;
		case kxAIM::ByServer:
					reason=("Connection closed by ICQ Server");
					cont=FALSE;
					show=TRUE;
					break;
		case kxAIM::TimeOut:
					reason=("on Time Out");
					show=TRUE;
					break;
		case kxAIM::Sending:
					reason=("on Sending");
					show=TRUE;
					break;		
		case kxAIM::NoCookie:
					reason=("for retrying");					
					show=TRUE;
					break;		
		case kxAIM::NoServer:
					reason=("without server");
					cont=FALSE;
					show=TRUE;
					break;	
		default:
					show=TRUE;
					cont=FALSE;
					Q_UINT16 re=e-0x10;
					switch(re)
					{
						case 0x01:
							reason=i18n("Bad UIN, change UIN and maby password");
							break;
						case 0x05:
						case 0x04:
							reason=i18n("Bad Password, change password");
							break;
						case 0x07:
						case 0x08:
							reason=i18n("This ICQ# doesn't exist");
							break;							
						case 0x15:
						case 0x16:
							reason=i18n("To many clients from same IP");
							break;							
						case 0x18:						
							reason=i18n("To many retries in a short time, wait 10 minutes to relogin");
							break;
						case 0x1B:
							reason=i18n("Check for a new version of KXicq on http://www.kxicq.org !");
							break;							
						case 0x1D:
							reason=i18n("To fast reconnecting, please try later");
							break;
						case 0x1E:
							reason=i18n("Can't register on the ICQ network, please try again");
							break;						
						case 0x3D:						
							reason=i18n("Other ICQ client logs in with same UIN");
							break;
						default:
							reason.sprintf("Error code: %d",e);
					}
	}
	debug("Reason: %s",reason.latin1());
  statusLabel->setText(i18n("Disconnected"));
  ENGINE->updateDock();
//2 times??  ENGINE->disconnect();
  popup->setItemEnabled(popupConnectID,TRUE);
  popup->setItemEnabled(popupDisconnectID,FALSE);
  popup->setItemEnabled(popupStatusID,FALSE);

	if (show) KMessageBox::error(this,
		i18n("You have been disconnected by\nthe server for the following reason:\n\n")+reason,
		i18n("Disconnection error"));
	if (!cont) return;

  if (kxConfig.reconnect && e!=kxAIM::Manual)
  {
    debug("Retry: %d -%d ",          retryCounter,kxConfig.retry );
    if (retryCounter++<kxConfig.retry)
    {
    	tryConnect.start(1000);
//      SlotConnect();
    }
    else
    {
    	if (kxConfig.retryAtFailure)
    	{
    		tryConnect.start(2*60*1000); // wait 2 minutes and reconnect
    	}
    	else
    	{
    		// error dialog
    		KMessageBox::error(this,  i18n("Can't connect to the ICQ login server,\nchange server or retry later."), i18n("Connection error"));
    	}
    }
  }
  else
  {  	
  	if (e!=kxAIM::Manual)
  	{
  		KMessageBox::error(this,  i18n("Can't connect to the ICQ login server,\nchange server or retry later."), i18n("Connection error"));
  		// error dialog
  	}
  }
}
void kxMainWindow::SlotContactStatusChange(UIN _uin, Q_UINT16 _status, Q_UINT16 _type)
{	
	if (_status!=STATUS_OFFLINE && ENGINE->CONTACT->getContact(_uin).status==STATUS_OFFLINE)
	{
		// online notification
		debug("Comming online..");
		if (ENGINE->CONTACT->getContact(_uin).onlineNotify) // do it
		{
			debug("Online: %s",QString(i18n("User ")+ENGINE->CONTACT->getContact(_uin).nick+i18n(" is ")+ENGINE->CONTACT->status2str(_status)).latin1());
//			KMessageBox::error(this, QString(i18n("User ")+ENGINE->CONTACT->getContact(_uin).nick+i18n(" is ")+ENGINE->CONTACT->status2str(_status)).latin1(), i18n("Online notification"));
		}
	}
  ENGINE->CONTACT->updateContact(_uin,_status);
	list->changeContact(_uin,_status);
  debug("update contact %d - status %d = %d",_uin, _status, ENGINE->CONTACT->getContact(_uin).status);
  list->repaintContact(_uin);
}
void kxMainWindow::SlotContactChange(UIN _uin)
{
	list->repaintContact(_uin);
}

void kxMainWindow::closeEvent(QCloseEvent *)
{
  debug("Close !!");
  KConfig *config=KGlobal::config();
  config->reparseConfiguration();
  if (kxConfig.saveGeometry)
  {
    config->setGroup("Geometry");
    config->writeEntry("X",pos().x());
    config->writeEntry("Y",pos().y());        
    config->writeEntry("Width",size().width());
    config->writeEntry("Height",size().height());            
    KWin::Info i = KWin::info( winId() );
    config->writeEntry("Desktop",i.desktop);
    config->writeEntry("Hidden",isHidden());    
    config->writeEntry("Minimized",isMinimized());
    config->writeEntry("Maximized",isMaximized());
  }
  config->setGroup("Status");
  if (ENGINE->currentStatus!=STATUS_OFFLINE)
	 config->writeEntry("Last Status",ENGINE->currentStatus);
  config->sync();
  ENGINE->disconnect();
  exit(0);
}
void kxMainWindow::SlotMenuConnect()
{
  retryCounter=0;
  SlotConnect();
}
void kxMainWindow::SlotConnect()
{
  ENGINE->disconnect();
  // rotaing server selection..
  if (kxConfig.server.length()<=0)
  {
  	debug("ERRO, no serevrs found..");
  	kxConfig.server="login.icq.com";
  	kxConfig.serverPort=5190;
  }
  ENGINE->setServer(kxConfig.server, kxConfig.serverPort);
  if (ENGINE->connect()>0)
  {
  	if (wantStatus!=STATUS_OFFLINE)
  	{
  		ENGINE->login(wantStatus);
  		wantStatus=STATUS_OFFLINE;	
  	}
  	else
  	{
      debug("try login.. %d - %d", kxConfig.saveStatus, kxConfig.lastStatus);
      if (kxConfig.saveStatus && kxConfig.lastStatus!=STATUS_OFFLINE)
      {
  	    ENGINE->login(kxConfig.lastStatus);
  	    manualStatusChange=TRUE;
  	  }
  	  else
  	  	ENGINE->login(STATUS_ONLINE);
  	}
    popup->setItemEnabled(popupConnectID,FALSE);
    popup->setItemEnabled(popupDisconnectID,TRUE);    
  }
  else
  {
    statusLabel->setText(i18n("Error"));
    if (kxConfig.reconnect)
    {
     if (retryCounter++<kxConfig.retry)
     {
       tryConnect.start(3000);
     }
     else
     {
    	if (kxConfig.retryAtFailure)
    	{
    		tryConnect.start(2*60*1000); // wait 2 minutes and reconnect
    	}
    	else
    		KMessageBox::error(this, i18n("Can't connect to the ICQ login server,\nchange server or retry later."), i18n("Connection error"));
     }
    }
    else
    	KMessageBox::error(this, i18n("Can't connect to the ICQ login server,\nchange server or retry later."), i18n("Connection error"));
  }
  // todo       !!
}
void kxMainWindow::SlotDisconnect()
{
	ENGINE->closeConnection();
	updateIcon();
}
void kxMainWindow::SlotExit()
{
  emit SignalExit();
  close();
}
void kxMainWindow::SlotSearch()
{
  kxSearchDialogImpl *dialog;
  dialog=new kxSearchDialogImpl(0L,"search");
  dialog->show();
}
void kxMainWindow::SlotChangeStatusByMenu(int _status)
{
  if (kxConfig.askAwayMessage)
  {
    if (_status!=STATUS_ONLINE && _status!=STATUS_INVISIBLE)
    {
      kxStatusMessageDialogImpl dialog(kxConfig.uin, _status, (QWidget *)this, "Status", TRUE);
      if (dialog.exec()==QDialog::Accepted)
      {
        if (_status!=STATUS_ONLINE) manualStatusChange=TRUE;
        else manualStatusChange=FALSE;
        SlotChangeStatus(_status);
      }    
    }
    else
    {
      if (_status!=STATUS_ONLINE) manualStatusChange=TRUE;
      else manualStatusChange=FALSE;

      SlotChangeStatus(_status);
    }
  }
  else
  {
      if (_status!=STATUS_ONLINE) manualStatusChange=TRUE;
      else manualStatusChange=FALSE;

      SlotChangeStatus(_status);
  }
}

void kxMainWindow::SlotChangeStatus(int _status)
{
  if (ENGINE->loggedOn())
  {
    ENGINE->changeStatus(_status);
    if (_status!=STATUS_OFFLINE) kxConfig.lastStatus=_status;
    updateIcon();
  }
  else
  {
  	wantStatus=_status;
    SlotMenuConnect(); 
  }
}

void kxMainWindow::updateIcon()
{
	QPixmap pixmap;
  switch(ENGINE->getStatus())
  {
    case STATUS_AWAY:
      pixmap=MAINWINDOW->kxIcons.away;
      break;
    case STATUS_NA:
      pixmap=MAINWINDOW->kxIcons.na;
      break;
    case STATUS_OCCUPIED:
      pixmap=MAINWINDOW->kxIcons.occupied;
      break;
    case STATUS_FFC:
      pixmap=MAINWINDOW->kxIcons.ffc;
      break;
    case STATUS_INVISIBLE:
      pixmap=MAINWINDOW->kxIcons.invisible;
      break;
    case STATUS_DND:
      pixmap=MAINWINDOW->kxIcons.dnd;
      break;
    case STATUS_OFFLINE:
      pixmap=MAINWINDOW->kxIcons.offline;
      break;
    case STATUS_ONLINE:
    default:
      pixmap=MAINWINDOW->kxIcons.online;
      break;
  }
  KWin::setIcons(winId(),pixmap,pixmap);
}

void kxMainWindow::SlotStatusUpdate(int _status)
{
  updateIcon();
  statusLabel->setText(ENGINE->CONTACT->status2str(_status));
  waitForAutoAway=FALSE;
  waitForAutoAwayTimer.stop();  
}
void kxMainWindow::SlotNewMessage(UIN _uin, kxMessageStruct _message)
{
	  makeSound(_message.type);
	  emit SignalNewMessage(_uin, _message);

}
void kxMainWindow::SlotWaitForAutoAway()
{                  
  waitForAutoAway=FALSE;
  waitForAutoAwayTimer.stop();
}
void kxMainWindow::SlotCheckAutoAway()
{
  int move=0;
  if (kxConfig.autoAway && ENGINE->loggedOn() && !manualStatusChange)
  {
    int check=checkTimeOut(move);
    if (move)
    {
      waitForAutoAway=FALSE;
      waitForAutoAwayTimer.stop();
    }
    if (check)
    {
      if (ENGINE->getStatus()==STATUS_ONLINE || ENGINE->getStatus()==STATUS_FFC)
      {
        SlotChangeStatus(STATUS_AWAY);
        waitForAutoAway=TRUE;
        initTimeOut(kxConfig.naTime);
        autoAwayTimer.start(360);
        waitForAutoAwayTimer.start(180);
      }
      else if (ENGINE->getStatus()==STATUS_AWAY)
      {
        SlotChangeStatus(STATUS_NA);
        waitForAutoAway=TRUE;
        waitForAutoAwayTimer.start(360);
        if (kxConfig.autoUnAway) autoAwayTimer.start(180);
        else
        {
          autoAwayTimer.stop();
          freeTimeOut();
        }
      }
    }
    else
    {
      if (kxConfig.autoUnAway && move && ENGINE->getStatus()!=STATUS_ONLINE && !waitForAutoAway)
      {
        waitForAutoAway=FALSE;
        SlotChangeStatus(STATUS_ONLINE);
        initTimeOut(kxConfig.awayTime);
        autoAwayTimer.start(180);
      }        
    }    
  }
}
void kxMainWindow::makeSound(int _type)
{
  if (ENGINE->getStatus()==STATUS_ONLINE) QApplication::beep();
}
void kxMainWindow::SlotSettings()
{
  kxSettingsDialog *dialog=new kxSettingsDialog(0L,"settings");
  dialog->show();
}
void kxMainWindow::SlotStatusMessage(UIN uin, QString message)
{
	if (!ENGINE->CONTACT->getIgnoreAway(uin))
	{
    kxStatusMessageDialog *dialog;
    dialog=new kxStatusMessageDialogImpl(uin,message, 0L,"status");
    dialog->show();
  }
}
void kxMainWindow::updateStatusMessage(int status, QString msg)
{
	switch(status)
 	{
 		case STATUS_ONLINE:
 		case STATUS_OFFLINE:
 			break;
 		case STATUS_AWAY:								
			kxConfig.awayMessage=msg;
			break;
 		case STATUS_NA:
 		case STATUS_NA_99: 		
			kxConfig.naMessage=msg;
 			break;					
 		case STATUS_DND:
 		case STATUS_DND_KXICQ:
			kxConfig.dndMessage=msg;
 			break;								
 		case STATUS_OCCUPIED:			
 			break;
 		case STATUS_FFC:											
 			break;
 	}
  ENGINE->setStatusMessages(kxConfig.awayMessage, kxConfig.naMessage, kxConfig.dndMessage);
}
void kxMainWindow::SlotReportBug()
{
  KBugReport bug(this,"Bug");
  bug.exec();
}  
void kxMainWindow::SlotAboutDialog()
{
  KAboutApplication dialog(this,"About");
  dialog.exec();
}
void kxMainWindow::SlotLabelButton()
{
  if (ENGINE->MESSAGE->countUnreadMessages(0)>0)
  {
    kxReceivedMessageImpl *dialog;
    dialog=new kxReceivedMessageImpl((UIN)0,0L,"view all");
    dialog->resize(200,300);
    dialog->show();
  }
  else
  {
    kxHistoryDialogImpl *dialog;
    dialog=new kxHistoryDialogImpl(0,0L, "hist");
    dialog->show();
  }
}
void kxMainWindow::SlotNewFile(UIN _uin,int _seq,QString _msg,QString _filename, int _size)
{ 
  kxReceivedMessageImpl *dialog=new kxReceivedMessageImpl(_uin,_seq,_msg,_filename, _size,0L,"File");
  dialog->show();  
}
void kxMainWindow::SlotReadMessage()
{
  if (ENGINE->MESSAGE->countAllUnread()>0)
  {
    kxReceivedMessageImpl *dialog;
    dialog=new kxReceivedMessageImpl(0L,"view all");
    dialog->resize(200,300);
    dialog->show();    
  }
}
void kxMainWindow::timerEvent(QTimerEvent *)
{
  if (kxConfig.wmDock) wmkxicq_loop();
}

void kxMainWindow::hideWindow()
{
  Mpos=pos();
  Msize=size();
  hide();
  debug("hide");
}
void kxMainWindow::showWindow()
{
  resize(Msize);
  move(Mpos);        
  show();        
  KWin::setActiveWindow(winId());
  debug("show");
}
/** Try a connect on a timeout of a QTimer */
void kxMainWindow::SlotTryConnect()
{
	SlotConnect();
	tryConnect.stop();
}
void kxMainWindow::SlotRandomSearch()
{
  kxRandomSearchImpl *dialog;
  dialog=new kxRandomSearchImpl(0L,"search");
  dialog->show();
}
void kxMainWindow::SlotRequestAdd2List(Q_UINT32 _uin)
{
	kxSendMessageImpl *dialog;
	dialog=new kxSendMessageImpl(_uin, REQUEST_TYPE,0L,"requestauth");
	dialog->show();
}
void kxMainWindow::SlotNotLoggedOn()
{
	KMessageBox::error(this,  i18n("You are not connected, you must be connected\nto send a action."), i18n("Not connected."));
}
void kxMainWindow::SlotRequestInfo(Q_UINT16 _s, Q_UINT32 _u, bool *status)
{
	debug("Got Emit !");
	kxRequestWidgetImpl *dialog;
	dialog=new kxRequestWidgetImpl(_s, _u,this,"requestauth", TRUE);
	if (dialog->exec()==QDialog::Accepted)
		*status=TRUE;
	delete dialog;
}
void kxMainWindow::SlotChangeInfo()
{
	kxExtInfoDialog *dialog;
	dialog=new kxExtInfoDialog(0L,"requestauth");
	dialog->show();	
}
void kxMainWindow::setBasicInfo(QString _n, QString _f, QString _l, QString _e)
{
  KConfig *config=KGlobal::config();
  config->reparseConfiguration();
  config->setGroup("Personal Settings");

  kxConfig.nick=_n;
  config->writeEntry("Nick",_n);
  kxConfig.firstName=_f;
  config->writeEntry("Last Name",_l);
  kxConfig.lastName=_l;
  config->writeEntry("First Name",_f);
  kxConfig.email = _e;
  config->writeEntry("Email",_e);

  config->sync();
}
void kxMainWindow::SlotAddNonICQ()
{
	kxAddPhoneDialog *dialog=new kxAddPhoneDialog(this, "email",TRUE);	
	if (dialog->exec()==QDialog::Accepted)
	{
		if (dialog->getNick().length()>0)
		{
			QString gsm=dialog->getNumber();
			if (dialog->getSMS()) gsm.append(" SMS");
			ENGINE->CONTACT->addNonICQ(dialog->getNick(), gsm);
		}
	}
}
