/***************************************************************************
                          kxtlv.h  -  description
                             -------------------
    begin                : Sun Nov 4 2001
    copyright            : (C) 2001 by Herwin Jan Steehouwer
    email                : steehouwer@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KXTLV_H
#define KXTLV_H

#include <qlist.h>
#include <qdatastream.h>

  // Channel 0x0001
  const unsigned short TLV_Screenname = 0x0001;
  const unsigned short TLV_Password = 0x0002;
  const unsigned short TLV_ClientProfile = 0x0003;
  const unsigned short TLV_UserInfo = 0x0005;
  const unsigned short TLV_Cookie = 0x0006;
  const unsigned short TLV_CountryCode = 0x000e;
  const unsigned short TLV_Language = 0x000f;
  const unsigned short TLV_ClientBuildMinor = 0x0014;
  const unsigned short TLV_ClientType = 0x0016;
  const unsigned short TLV_ClientVersionMajor = 0x0017;
  const unsigned short TLV_ClientVersionMinor = 0x0018;
  const unsigned short TLV_ClientICQNumber = 0x0019;
  const unsigned short TLV_ClientBuildMajor = 0x001a;

  // Channel 0x0002
  const unsigned short TLV_UserClass = 0x0001;
  const unsigned short TLV_SignupDate = 0x0002;
  const unsigned short TLV_SignonDate = 0x0003;
  const unsigned short TLV_Port = 0x0004; // ??
  const unsigned short TLV_Encoded = 0x0005;
  const unsigned short TLV_Status = 0x0006;
  const unsigned short TLV_Unknown = 0x0008; // ??
  const unsigned short TLV_IPAddress = 0x000a;
  const unsigned short TLV_WebAddress = 0x000b;
  const unsigned short TLV_LANDetails = 0x000c;
  const unsigned short TLV_Unknown000d = 0x000d;
  const unsigned short TLV_TimeOnline = 0x000f;

  // Channel 0x0004
  // const unsigned short TLV_Screenname = 0x0001;
  const unsigned short TLV_ErrorURL = 0x0004;
  const unsigned short TLV_Redirect = 0x0005;
  // const unsigned short TLV_Cookie = 0x0006;
  const unsigned short TLV_ErrorCode = 0x0008;
  const unsigned short TLV_DualUserOnline = 0x0009; // ??
  const unsigned short TLV_Unknown3 = 0x000c;
  const unsigned short TLV_EmailAddress = 0x0011;
  const unsigned short TLV_RegStatus = 0x0013;

  // Message Block
  const unsigned short TLV_MessageData = 0x0002;
  const unsigned short TLV_ServerAckRequested = 0x0003;
  const unsigned short TLV_MessageIsAutoResponse = 0x0004;
  const unsigned short TLV_ICQData = 0x0005;

  // In Message Data
  const unsigned short TLV_Unknown0501 = 0x0501;
  const unsigned short TLV_MessageText = 0x0101;

static const unsigned char XORtable[] = { 0xf3, 0x26, 0x81, 0xc4,
                                            0x39, 0x86, 0xdb, 0x92,
                                            0x71, 0xa3, 0xb9, 0xe6,
                                            0x53, 0x7a, 0x95, 0x7c };

typedef struct tlvDef
{
	Q_UINT16 type;
	Q_UINT16 len;
	Q_UINT8 ch8;
	Q_UINT16 ch16;
	Q_UINT32 ch32;
	
	Q_UINT8 allowDirect;
	Q_UINT8 webAware;
	Q_UINT16 status;
	
	char *text;

};

/**TLVs for AIM protocol
  *@author Herwin Jan Steehouwer
  */

class kxTLV {
public: 
	kxTLV();
	~kxTLV();
  /** Screenname */
  int screenNameTLV(QDataStream *s, const QString &name);
  int passwordTLV(QDataStream *s, const QString &name);	
  int clientProfileTLV(QDataStream *s, const QString &name);	
	int clientTypeTLV(QDataStream *s, Q_UINT16);	
	int clientVersionMajorTLV(QDataStream *s, Q_UINT16);	
	int clientVersionMinorTLV(QDataStream *s, Q_UINT16);	
	int clientICQNumberTLV(QDataStream *s, Q_UINT16);	
	int clientBuildMajorTLV(QDataStream *s, Q_UINT16);	
	int clientBuildMinorTLV(QDataStream *s, Q_UINT32);	
	int languageTLV(QDataStream *s, const QString &name);	
	int countryCodeTLV(QDataStream *s, const QString &name);	
	int cookieTLV(QDataStream *s, const char *);
	
	QList<tlvDef> tlvList;
	
	int countTLVList();
	void clearTLVList();
	void parseTLVList( QDataStream *s, int num=0);
	bool isTLVinList(int type);
	tlvDef *getTLV(int type);
	
};

#endif
