/***************************************************************************
                          kxtlv.cpp  -  description
                             -------------------
    begin                : Sun Nov 4 2001
    copyright            : (C) 2001 by Herwin Jan Steehouwer
    email                : steehouwer@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kxtlv.h"

kxTLV::kxTLV(){
 	tlvList.setAutoDelete(TRUE);
}
kxTLV::~kxTLV(){
}
/** Screenname */
int kxTLV::screenNameTLV(QDataStream *s, const QString &name)
{
	*s << (Q_UINT16 ) TLV_Screenname;
	*s << (Q_UINT16 ) name.length();
	s->writeRawBytes(name.latin1(),name.length());
	return 4+name.length();
}
int kxTLV::passwordTLV(QDataStream *s, const QString &name)
{
	*s << (Q_UINT16 ) TLV_Password;
	*s << (Q_UINT16 ) name.length();

  for(Q_UINT8 i = 0; i < name.length(); i++)
      *s << (Q_UINT8)(name.at(i).latin1() ^ XORtable[i%16]);

	return 4+name.length();
}
int kxTLV::clientProfileTLV(QDataStream *s, const QString &name)
{
	*s << (Q_UINT16 ) TLV_ClientProfile;
	*s << (Q_UINT16 ) name.length();
	s->writeRawBytes(name.latin1(),name.length());
	return 4+name.length();
}
int kxTLV::clientTypeTLV(QDataStream *s, Q_UINT16 t )
{
	*s << (Q_UINT16 ) TLV_ClientType;
	*s << (Q_UINT16 ) 2;
	*s << (Q_UINT16 ) t;
	return 4+2;
}
int kxTLV::clientVersionMajorTLV(QDataStream *s, Q_UINT16 t)
{
	*s << (Q_UINT16 ) TLV_ClientVersionMajor;
	*s << (Q_UINT16 ) 2;
	*s << (Q_UINT16 ) t;
	return 4+2;
}
int kxTLV::clientVersionMinorTLV(QDataStream *s, Q_UINT16 t)
{
	*s << (Q_UINT16 ) TLV_ClientVersionMinor;
	*s << (Q_UINT16 ) 2;
	*s << (Q_UINT16 ) t;
	return 4+2;
}
int kxTLV::clientICQNumberTLV(QDataStream *s, Q_UINT16 t)
{
	*s << (Q_UINT16 ) TLV_ClientICQNumber;
	*s << (Q_UINT16 ) 2;
	*s << (Q_UINT16 ) t;
	return 4+2;
}
int kxTLV::clientBuildMajorTLV(QDataStream *s, Q_UINT16 t)
{
	*s << (Q_UINT16 ) TLV_ClientBuildMajor;
	*s << (Q_UINT16 ) 2;
	*s << (Q_UINT16 ) t;
	return 4+2;
}
int kxTLV::clientBuildMinorTLV(QDataStream *s, Q_UINT32 t)
{
	*s << (Q_UINT16 ) TLV_ClientBuildMinor;
	*s << (Q_UINT16 ) 4;
	*s << (Q_UINT32 ) t;
	return 4+4;
}
int kxTLV::languageTLV(QDataStream *s, const QString &name)
{
	*s << (Q_UINT16 ) TLV_Language;
	*s << (Q_UINT16 ) name.length();
	s->writeRawBytes(name.latin1(),name.length());
	return 4+name.length();
}
int kxTLV::countryCodeTLV(QDataStream *s, const QString &name)
{
	*s << (Q_UINT16 ) TLV_CountryCode;
	*s << (Q_UINT16 ) name.length();
	s->writeRawBytes(name.latin1(),name.length());
	return 4+name.length();
}

int kxTLV::cookieTLV(QDataStream *s, const char *name)
{
	*s << (Q_UINT16 ) TLV_Cookie;
	*s << (Q_UINT16 ) 256;
	s->writeRawBytes(name,256);
	return 4+256;
}

int kxTLV::countTLVList()
{
	return tlvList.count();
}
void kxTLV::clearTLVList()
{
	if (tlvList.count()>0)
		tlvList.clear();
}
void kxTLV::parseTLVList( QDataStream *s, int num=0)
{
	tlvList.clear();
	Q_UINT16 t=0;
//	s->device()->at(0);
	while(!s->atEnd())
	{
		Q_UINT16 type;
		Q_UINT16 l;
		Q_UINT8 ch8;
		Q_UINT16 ch16;
		Q_UINT32 ch32;

		tlvDef *TLV;
		TLV=new tlvDef;
		*s >> (Q_UINT16 &)type;
		TLV->type=type;
		*s >> (Q_UINT16 &)l;
		TLV->len=l;
		debug("New TVL found: %02X, len: %d",type,l);
		switch(l)
		{
			case 1:
				*s >> (Q_UINT8 &)ch8;
				TLV->ch8=ch8;
				break;
			case 2:
				*s >> (Q_UINT16 &)ch16;
				TLV->ch16=ch16;
				break;
			case 4:
			  switch (type)
			  {
			  	case TLV_Status:
			  		*s >> (Q_UINT8 &)TLV->allowDirect;
			  		*s >> (Q_UINT8 &)TLV->webAware;
			  		*s >> (Q_UINT16&)TLV->status;			  		
			  	break;
			  	default:
						*s >> (Q_UINT32 &)ch32;
						TLV->ch32=ch32;
				}
				break;
			default:
				
				char *tmpstr=new char[l+1];
				s->readRawBytes(tmpstr, l);
				tmpstr[l]=0;
				TLV->text=tmpstr;
		}
		tlvList.append(TLV);
		t++;				
		if (num>0) if (t>=num) return;
	}		
	debug("Total found TLV's: %d",t);
}

bool kxTLV::isTLVinList(int type)
{
	tlvDef *TLV;
	for (Q_UINT16 t=0; t<tlvList.count(); t++)
	{
		TLV=tlvList.at(t);
		if (TLV->type==type)
		{
			return TRUE;
		}
	}		
	return FALSE;
}
tlvDef *kxTLV::getTLV(int type)
{
	tlvDef *TLV;
	for (Q_UINT16 t=0; t<tlvList.count(); t++)
	{
		TLV=tlvList.at(t);
		if (TLV->type==type)
		{
			return TLV;
		}
	}
	return NULL;
}
