#include <sys/time.h>
#include "kxsend.h"
#include <kxengine.h>
#include <kxudp.h>
#include <kxtcp.h>
#include <kxaim.h>

kxSend::kxSend(int _type, int _sendSeq, UIN _uin, QString _msg, QString _url, bool _server, QColor _fg, QColor _bg, bool _useColor=FALSE) : QObject()
{
  message.type=_type;
  message.send=TRUE;
  message.uin=_uin;
  message.message=_msg;
  message.url=_url;
  message.useColor=_useColor;
  message.foreground=_fg;
	message.background=_bg;
	
	send=FALSE;

  sendSeq=_sendSeq;
  uin=_uin;
  type=_server ? 1 : 0;
  init();

}
kxSend::kxSend(int _sendSeq,UIN _uin, QList<kxAddContactStruct> *_cl, bool _server)
{
  message.type=CONTACTS_TYPE;
  message.send=TRUE;
  message.uin=_uin;
  uin=_uin;  
  type=_server ? 1 : 0;  
  sendSeq=_sendSeq;  
  contactList=_cl;
	send=FALSE;
  init();
}
void kxSend::init()
{  

  QDate tmpDate=QDate::currentDate();
  QTime tmpTime=QTime::currentTime();

  message.dateTime.setDate(tmpDate);
  message.dateTime.setTime(tmpTime);      
  message.online=TRUE;

  QObject::connect(&sendTimer, SIGNAL(timeout()), this, SLOT(SlotTimeout()));  
  QObject::connect(ENGINE->AIM, SIGNAL(receivedAck(Q_UINT16)), this, SLOT(SlotReceivedAck(Q_UINT16)));
  QObject::connect(ENGINE->AIM, SIGNAL(receivedErrorAck(Q_UINT16, Q_UINT16)), this, SLOT(SlotReceivedErrorAck(Q_UINT16, Q_UINT16)));
//  QObject::connect(ENGINE->TCP, SIGNAL(receivedAck(int)), this, SLOT(SlotReceivedAck(int)));
  
  if (type)
  {
    sendToServer();
  }
  else
  {
    sendToClient();
  }
}
   
void kxSend::sendToServer()
{
  if (message.type==MESSAGE_TYPE)
  {
  	type=1;
  	sendAck=ENGINE->AIM->sendMessage(uin, message.message);
  	SlotReceivedAck(sendAck);  	  	
  	send=TRUE;
  	return;
  }
  else
  {
    if (message.type==URL_TYPE)
    {
    	type=1;
      sendAck=ENGINE->AIM->sendUrl(uin, message.message, message.url);
     	SlotReceivedAck(sendAck);  	
     	send=TRUE;
     	return;
    }
    else
    {
      if (message.type==CONTACTS_TYPE)
      {
      	sendAck=ENGINE->AIM->sendContacts(uin, contactList);
	     	SlotReceivedAck(sendAck);  	
	     	send=TRUE;      	
      }
    }
  }
  type=1;
  sendTimer.start(30000);
}
void kxSend::sendToClient()
{
	SlotSendToClient(uin);
}
void kxSend::SlotSendToClient(UIN _ruin)
{
	if (_ruin==uin)
	{
    if (message.type==MESSAGE_TYPE)
    {
      sendAck=ENGINE->AIM->sendAdvanchedMessage(uin,  &message);
    }
    else
    {
      if (message.type==URL_TYPE)
      {
	      sendAck=ENGINE->AIM->sendAdvanchedMessage(uin,    &message);
      }
      else
      {
        if (message.type==CONTACTS_TYPE)
        {
        	sendAck=ENGINE->AIM->sendAdvanchedMessage(uin, &message, contactList);
        }
      }
    }
    type=0;
    sendTimer.start(30000);
  }
}
void kxSend::SlotTimeout()
{
  sendTimer.stop();
  if (type)
    emit SignalSendToServerError(sendSeq);
  else
    emit SignalSendToClientError(sendSeq);
}
void kxSend::cancelSend()
{                  
  delete this;
}
void kxSend::SlotReceivedErrorAck(Q_UINT16 _ack, Q_UINT16 error)
{
	if (_ack==sendAck)
  {
  	debug("Error Ack in kxSend..");
  	SlotTimeout();
  }  		
}
void kxSend::SlotReceivedAck(Q_UINT16 _ack)
{
  if (_ack==sendAck)
  {
    if (message.type==MESSAGE_TYPE)
      ENGINE->MESSAGE->newMessage(uin, message);
    else
      if (message.type==URL_TYPE) 
        ENGINE->MESSAGE->newUrl(uin, message);
    if (type)
      emit SignalSendToServerOk(sendSeq);
    else
      emit SignalSendToClientOk(sendSeq);      
  }
}
