/***************************************************************************
                          kxpacket.h  -  description                              
                             -------------------                                         
    begin                : Wed Jun 23 1999                                           
    copyright            : (C) 1999 by Herwin Jan Steehouwer                         
    email                : steehouwer@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KXPACKET_H
#define KXPACKET_H

#include <qdatastream.h>
#include <qstring.h>
#include <qiodevice.h>
#include <qwidget.h>
#include <qlist.h>
#include <ksock.h>

/** This struct hold the Packet and his length */
typedef struct packetDef
{
	QByteArray *packet;
	Q_UINT8 channel;
	Q_UINT8 command;	
	int length;
	KSocket *mySocket;
	Q_UINT32 uin;
};


/**
  Packet class for KXicq,

  This is the class that holds all the info for a ICQ packet.

  *@author Herwin Jan Steehouwer
  */

class kxPacket {

protected: // Protected methods
  /** a list with packets */
  QList <packetDef> packetList;

public:
/**
	Constructor call initPacket()
*/
/** We don't have strsep() on DEC OSF or SunOS (maybe not on any
    non-Linux system -- ? ).  So we'll take it from glibc-2.0.6.
 */
  char * kxicqStrSep(char **stringp, char *delim);

	kxPacket();
  /** Get the number of Packets waiting in the Packet list */
  int countList();
  /** Delete the first packet when it was send */
  void deleteFirstPacket();
  /** get First packet for sending */
  packetDef *getFirstPacket();
  /** Add Packet to the List */
  void addPacket2List();
  /** Add Packet to the List with info for TCP*/
  void addPacket2List(KSocket *, Q_UINT32 );
  void addPacket2ListAIM(KSocket *, Q_UINT8 );

/**
   return IP address in a format suitable to be transmitted to ICQ via
   packet class. ICQ uses big endian format, packet class return little
   endian ints, so we need a conversion from little to big endian.
   IP is represented in native format and converted to big-endian by
   htonl();
   "aa.bb.cc.dd" must be passed to packet class as 0xddccbbaa
   on entry, l is in native format:
   0xaabbccdd on Sparcs (big endian)
   0xddccbbaa on Intels (little endian)
   after htonl(), l is in big-endian (net format)
   0xaabbccdd
   to pass to ICQ, l is converted to little endian) */
	unsigned int ipToIcq( unsigned int l );
/**
   return IP address in a format suitable to be used by socket from a int
   returned by packet class. ICQ uses big endian format, packet class return
   little endian ints, so we need a conversion from little to big endian.
   IP is returned in native format by ntohl();
   "aa.bb.cc.dd" is received from packet class as 0xddccbbaa.
   0xddccbbaa is converted to net format (big endian) and than back to host
   via ntohl(). */
	unsigned int icqToIp( unsigned int l );


/**
	destructor, deletes the data !
*/
	~kxPacket();

/**
	inits the Packet Data stream, allocs the memory
*/
	void initPacket();
  /** count packets */
  int count();
  /** Delete this packet */
  void deletePacket(int );
  void deleteFirst();
  /** Get a packet */
  packetDef * getPacket(int);
  packetDef * getFirst();
	
		
protected:


/** packet where data is added to, that needs to put in the List
		for sending, if the packet is in the List, it will automaticly
		been send. */
	QByteArray *byteArray;
/** length of packet that is not yet in the list */
	unsigned int length;
/** max packets size */
	unsigned int PacketSize;			

};

#endif





