 /***************************************************************************
                          kxpacket.cpp  -  description                              
                             -------------------                                         
    begin                : Wed Jun 23 1999                                           
    copyright            : (C) 1999 by Herwin Jan Steehouwer                         
    email                : steehouwer@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "kxpacket.h"

#include <netinet/in.h>

kxPacket::kxPacket()
{
  length=0;
	PacketSize=3048;
  packetList.setAutoDelete(TRUE);
}

kxPacket::~kxPacket()
{
}

void kxPacket::initPacket()
{
	byteArray=new QByteArray(PacketSize);
	length=0;
}

/** Add Packet to the List */
void kxPacket::addPacket2List()
{
	packetDef *pd=new packetDef;
	pd->packet=byteArray;
	pd->length=length;
	pd->uin=0;
	pd->mySocket=NULL;
	packetList.append(pd);
	initPacket();
}
/** Add Packet to the List */
void kxPacket::addPacket2List(KSocket *_ks, Q_UINT32 _uin)
{
	packetDef *pd=new packetDef;
	pd->packet=byteArray;
	pd->length=length;
	pd->uin=_uin;
	pd->mySocket=_ks;
	packetList.append(pd);
	initPacket();
}
/** Add Packet to the List */
void kxPacket::addPacket2ListAIM(KSocket *_ks, Q_UINT8 chan)
{
	debug("Do Add");
	packetDef *pd=new packetDef;
	pd->packet=byteArray;
	pd->length=length;
	pd->command=0x2a;
	pd->channel=chan;	
	pd->uin=0;
	pd->mySocket=_ks;
	packetList.append(pd);
	debug("Done Add");
	initPacket();
	debug("reinit");
}

/** get First packet for sending */
packetDef* kxPacket::getFirstPacket()
{
	return packetList.first();
}

/** Delete the first packet when it was send */
void kxPacket::deleteFirstPacket()
{
    delete packetList.at(0)->packet;
	packetList.removeFirst();
}

/** Get the number of Packets waiting in the Packet list */
int kxPacket::countList()
{
	return packetList.count();
}

/**
   return IP address in a format suitable to be transmitted to ICQ via
   packet class. ICQ uses big endian format, packet class return little
   endian ints, so we need a conversion from little to big endian.
   IP is represented in native format and converted to big-endian by
   htonl();
   "aa.bb.cc.dd" must be passed to packet class as 0xddccbbaa
   on entry, l is in native format:
   0xaabbccdd on Sparcs (big endian)
   0xddccbbaa on Intels (little endian)
   after htonl(), l is in big-endian (net format)
   0xaabbccdd
   to pass to ICQ, l is converted to little endian) */
unsigned int kxPacket::ipToIcq( unsigned int l )
{
    l = htonl( l );
    return ( l << 24 ) | ( ( l & 0xff00 ) << 8 ) | ( ( l & 0xff0000 ) >> 8 ) | ( l >> 24 );
}

/**
   return IP address in a format suitable to be used by socket from a int
   returned by packet class. ICQ uses big endian format, packet class return
   little endian ints, so we need a conversion from little to big endian.
   IP is returned in native format by ntohl();
   "aa.bb.cc.dd" is received from packet class as 0xddccbbaa.
   0xddccbbaa is converted to net format (big endian) and than back to host
   via ntohl(). */
unsigned int kxPacket::icqToIp( unsigned int l )
{
    return ntohl( ( l << 24 ) | ( ( l & 0xff00 ) << 8 ) | ( ( l & 0xff0000 ) >> 8 ) | ( l >> 24 ) );
}

/**
		* We don't have strsep() on DEC OSF or SunOS (maybe not on any
		* non-Linux system -- ? ).  So we'll take it from glibc-2.0.6.
		*
		* tanx to David Sweet <dsweet@chaos.umd.edu> for the patch to KXicq
 */
char * kxPacket::kxicqStrSep(char **stringp, char *delim)
{
  char *begin, *end;

  begin = *stringp;
  if (! begin || *begin == '\0')
    return NULL;

  /* Find the end of the token.  */
  end = strpbrk (begin, delim);
  if (end)
    {
      /* Terminate the token and set *STRINGP past NUL character.  */
      *end++ = '\0';
      *stringp = end;
    }
  else
    /* No more delimiters; this is the last token.  */
    *stringp = 0;

  return begin;
}

/** Get a packet */
packetDef * kxPacket::getPacket(int _p){
	return packetList.at(_p);
}
packetDef * kxPacket::getFirst(){
	
	if (packetList.count()>0)
		return packetList.first();
	else
		return NULL;
}

void kxPacket::deleteFirst()
{
	if (packetList.count()>0)
		packetList.removeFirst();
}
/** Delete this packet */
void kxPacket::deletePacket(int _p)
{
	packetDef *p=getPacket(_p);
	delete p->packet;
	p->packet=NULL;
	packetList.remove(_p);
}

/** count packets */
int kxPacket::count()
{
	return packetList.count();
}
