#ifndef KXMESSAGE_H
#define KXMESSAGE_H

#include <qdatetime.h>
#include <qobject.h>
#include <qfile.h>
#include <qstring.h>
#include <qlist.h>
#include <v2_codes.h>
#include <qcolor.h>

#define MESSAGE_TYPE 1
#define URL_TYPE 2
#define ADDED_TYPE 3
#define REQUEST_TYPE 4
#define AUTH_TYPE 5
#define WEBPANEL_TYPE 6
#define EMAIL_TYPE 7
#define REJECT_TYPE 8
#define FILE_TYPE 9
#define CHAT_TYPE 10
#define CONTACTS_TYPE 11
#define SMS_TYPE 12


#define MESSAGE_RECEIVED 0
#define MESSAGE_SEND 1

typedef struct kxAddContactStruct
{
  UIN uin;
  QString nick;
};

typedef struct kxMessageInfoStruct
{
  bool read;
  int type;
  bool send;
  Q_UINT32 uin;
  Q_UINT32 pos;
  bool useColor;
  QColor foreground;
	QColor background;
} ;

typedef struct kxMessageStruct
{
  QString message;
  QString url;
  QString nick;
  QString firstName;
  QString lastName;
  QString email;
  QList<kxAddContactStruct> list;
  
  bool auth_request;
  bool authorization;
  bool didAuthorize;
  QDateTime dateTime;
  int type;
  bool send;
  bool online;
  Q_UINT32 uin;
  bool useColor;
  QColor foreground;
	QColor background;

} ;

class kxMessage : public QObject
{
  Q_OBJECT
public:
  kxMessage();
  
  void readMessages();
    
  QList<kxMessageInfoStruct> messageList;
  QFile file;
  
  void split(QString, QString *, QString *);
  QString makeMessageCount(int);
  kxMessageStruct getMessage(int, bool del=TRUE);
  kxMessageInfoStruct *getMessageInfo(int _pos);

  int getType(int);
  int giveFirstUnread(UIN);
  int giveFirstUnreadMessage(UIN);
  int giveLastUnread(UIN);
  int giveFirstAllUnread();
  int countAllUnread();
  int countUnreadMessages(UIN);
  bool isAnyMessage(UIN);
  bool isUnreadMessage(UIN);

  QString parseEnters(QString);  
  void setRead(int,bool);
  
public slots:
  void newMessage(UIN,  kxMessageStruct);
  void newUrl(UIN,  kxMessageStruct);
  void newAuthReq(UIN,  kxMessageStruct);
  void newAuthReply(UIN,  kxMessageStruct);
  void newAdded(UIN,  kxMessageStruct);
  void newContacts(UIN,  kxMessageStruct);
  void newSMSReply(UIN,kxMessageStruct sms);
  
signals:
  void SignalMessagePos(UIN, int);
  void SignalMessagePosSend(UIN, int);    
  
};  


#endif



