#ifndef KXENGINE_H
#define KXENGINE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qobject.h>
#include <kapp.h>
#include <qtextcodec.h>
#include <v2_codes.h>
#include <qtimer.h>
#include <kxmessage.h>

struct kxAddContactStruct;
class QString;
class QPixmap;
class kxMessage;
class kxContact;
class kxEngine;
//class kxConnection;
class kxMainWindow;
class kxTCP;
class kxUDP;
class kxAIM;
class kxSend;




#define ENGINE kxEngine::getPointer()

class kxEngine : public QObject
{
  Q_OBJECT
public:
  kxEngine();

  enum requestInfoType { ALL, AUTH, GSM };
  
  void init(); // init engine
  
  // variables
  static kxEngine *ptr;
  static kxEngine *getPointer() { return ptr; };

  int statusChangeAck,statusChangeTo;
  
  kxContact *CONTACT;
  kxMessage *MESSAGE;
  kxTCP *TCP;
  kxUDP *UDP;
  kxAIM *AIM;
  int connectRetry;
  int sendSeq;

  QString server;
  Q_UINT32 port;
  QString encoderLanguage;
  QTextCodec* codecLocal;
  
  QString awayMessage;
  QString naMessage;
  QString dndMessage;

  bool ignoreMessage, ignoreUrl, ignoreRest;

  QTimer connectTimer;
  bool tryLogin;
  int loginStatus;

  int connect();
  int disconnect();
  void closeConnection();
  void notLoggedOn();
  int getStatus() { return currentStatus; };
  void login(int);
  void changeStatus(int);
  void setCurrentStatus(int);
  void setIgnore(bool m, bool u, bool r) { ignoreMessage=m; ignoreUrl=u; ignoreRest=r; };
  void updateDock() { emit SignalUpdateDock(); };
  void setUserInfo(Q_UINT32 _uin, QString _passwd, QString _server, int _port, int _minPort, int _maxPort);
  void setServer(QString, int);
  bool loggedOn();
  void sendAuthorization(UIN);
  void rejectContact(UIN,QString);
  void addContact2List(UIN, bool auth, bool notify, QString, QString, QString, QString, QString, bool, bool _req=TRUE);
  void removeContactFromList(UIN);
  void notifyContact(UIN, QString, QString, QString, QString, bool auth=FALSE);
  void getStatusMessage(UIN, int);
  void setStatusMessages(QString, QString, QString);
  QString getStatusMessages(int);
  int sendRequestInfo(Q_UINT32);
  int sendRequestOwnInfo( Q_UINT32 _uin);
  void addToVisibleList(Q_UINT32);
  void removeFromVisibleList(Q_UINT32);
	void addToInvisibleList(Q_UINT32);
  void removeFromInvisibleList(Q_UINT32);
  void sendAuthRequest(Q_UINT32, const QString &);
  int sendRandomSearch(Q_UINT16);
  int sendSMS(const QString &, const QString &, const QString &);
  bool requestInfo( Q_UINT32, Q_UINT8 );
  void setEncoderLanguage(const QString &_l);
  QString Local2Unicode(const char* localString);
  QCString Unicode2Local(const QString& uniString);
	int sendMainHomeInfo( QString,QString,QString,QString,QString,QString,QString,QString,QString,QString,QString,Q_UINT16, Q_UINT8, Q_UINT8);
	int sendEmailList(const QStringList &lst);
	int sendWorkInfo(QString _n, QString _p,QString _d, QString _s,QString _z, QString _c,QString _st, QString _url, QString _ph, QString _f,Q_UINT16 _co, Q_UINT16 _oc);
	int sendMoreInfo(Q_UINT16, Q_UINT8, QString, Q_UINT16, Q_UINT8, Q_UINT8, Q_UINT8, Q_UINT8, Q_UINT8 );
	int sendAboutInfo(QString);

// search:
  int searchForUin(UIN);
  int searchForEmail(const char *_email);
  int searchForExtra(const char *_nick,const char *_first, const char *_last);           
  
// send messages
  kxSend *sendMessage(UIN, QString, bool, QColor _fg, QColor _bg, bool _useColor=FALSE);
  kxSend *sendUrl(UIN, QString, QString, bool, QColor _fg, QColor _bg, bool _useColor=FALSE);
  kxSend *sendContacts(UIN, QList<kxAddContactStruct> *, bool);
  /** Set Security settings:
webAware
HideIP
send=FALSE
*/
  void setSecuritySettings(bool, bool, bool _send=FALSE);

public slots:
  void SlotConnecting();
  void SlotConnected();
  void SlotDisconnected(int);
  void SlotConnectTimeout();
  void SlotInvalidPassword();
  void SlotErrorString(QString);
  void SlotContactStatusChange(UIN , Q_UINT16, Q_UINT16 );
  void SlotContactChange(UIN );
  void SlotNewMessage(UIN, kxMessageStruct);
  void SlotNewUrl(UIN, kxMessageStruct);
  void SlotNewAuthReq(UIN, kxMessageStruct);
  void SlotNewAuthReply(UIN, kxMessageStruct);
  void SlotNewAdded(UIN, kxMessageStruct);
  void SlotNewSMSReply(UIN,kxMessageStruct);
	void SlotSearchFound(Q_UINT16, UIN, QString, QString, QString, QString, Q_UINT8,Q_UINT8, bool);
	void SlotSearchFailed(Q_UINT16);
	void SlotContactAdd2List(UIN, QString);
	void SlotReceivedAck(Q_UINT16);
	void SlotStatusMessage(UIN uin, QString message);
	void SlotNewFile(UIN,int,QString,QString, int);
	void SlotReceivedMainHomeInfo(Q_UINT16, QString,QString,QString,QString,QString,QString,QString,QString,QString,QString,QString,Q_UINT16, Q_UINT8, Q_UINT8);
	void SlotMoreInfo(Q_UINT16, Q_UINT16, Q_UINT8, QString , Q_UINT16,Q_UINT8,Q_UINT8,Q_UINT8,Q_UINT8,Q_UINT8);
  void SlotReceivedEmailInfo(Q_UINT16, QStringList);
  void SlotReceivedWorkInfo(Q_UINT16, QString, QString, QString, QString,QString,QString,QString,QString,QString,QString,Q_UINT16,Q_UINT16);
  	
	void SlotSearchEnd(Q_UINT16);
	void SlotErrorAck(Q_UINT16, Q_UINT16);
	

public:  
// neededfor ICQ communication	
  int ourIntIP;
  int maxPort, minPort;
  int ourExtIP;
  int ourPort;
  Q_UINT32 ourUin;
  int currentStatus;
  int ourMode;
  int lastStatus;
  bool webStatus;
  bool hideIP;
  int serverPort;
  QString ourPassword;

signals:  
  void SignalConnectError(QString);
  void SignalInvalidPassword();
  void SignalConnected();
  void SignalConnecting();
  void SignalDisconnected(int);
  void SignalStatusUpdate(int);
  void SignalContactStatusChange(UIN , Q_UINT16, Q_UINT16 );
  void SignalContactChange(UIN );
  void SignalNewMessage(UIN, kxMessageStruct);
  void SignalNewUrl(UIN, kxMessageStruct);
  void SignalNewAuthReq(UIN, kxMessageStruct);
  void SignalNewAuthReply(UIN, kxMessageStruct);
  void SignalNewAdded(UIN, kxMessageStruct);
  void SignalNewSMSReply(UIN,kxMessageStruct sms);
  void SignalUpdateDock();  // for docking 
	void SignalSearchFound(Q_UINT16, UIN, QString, QString, QString, QString, Q_UINT8,Q_UINT8, bool);
	void SignalSearchFailed(Q_UINT16);
	void SignalContactAdded(UIN, QString);
  void SignalReceivedAck(Q_UINT16);
  void SignalStatusMessage(UIN uin, QString message);
  void SignalNewFile(UIN,int,QString,QString, int);
  void SignalReceivedMainHomeInfo(Q_UINT16, QString,QString,QString,QString,QString,QString,QString,QString,QString,QString,QString,Q_UINT16, Q_UINT8, Q_UINT8);
  void SignalReceivedMoreInfo(Q_UINT16, Q_UINT16, Q_UINT8, QString , Q_UINT16,Q_UINT8,Q_UINT8,Q_UINT8,Q_UINT8,Q_UINT8);
  void SignalReceivedEmailInfo(Q_UINT16, QStringList);
  void SignalReceivedWorkInfo(Q_UINT16, QString, QString, QString, QString,QString,QString,QString,QString,QString,QString,Q_UINT16,Q_UINT16);
  void SignalReceivedAboutInfo(Q_UINT16, QString);
  void SignalSearchEnd(Q_UINT16);
  void SignalErrorAck(Q_UINT16, Q_UINT16);
  void SignalRequestAdd2List(Q_UINT32);
  void SignalNotLoggedOn();
  void SignalReceivedSMSAck(Q_UINT16, QString, QString);
  void SignalRequestInfo(Q_UINT16, Q_UINT32, bool *);

};


#endif

