#include <kxsend.h>
#include <qapplication.h>
#include <kwin.h>
#include "kxengine.h"
#include <qlabel.h>
#include "kxcontact.h"
#include <kxudp.h>
#include <kxtcp.h>
#include <kxaim.h>


kxEngine *kxEngine::ptr=0L;

kxEngine::kxEngine() : QObject()
{
  ptr=this;
  statusChangeAck=-1;
  sendSeq=0;
  codecLocal=NULL;
  tryLogin=FALSE;
  currentStatus=STATUS_OFFLINE;
}  

void kxEngine::init()
{
  CONTACT=new kxContact();
  CONTACT->init();
  MESSAGE=new kxMessage();
  QObject::connect(&connectTimer, SIGNAL(timeout()), this, SLOT(SlotConnectTimeout()));
}

void kxEngine::setUserInfo(Q_UINT32 _uin, QString _passwd, QString _server, int _port, int _minPort, int _maxPort)
{
  ourUin=_uin;
  ourPassword=_passwd;
  server=_server;
  serverPort=_port;
  maxPort=_maxPort;
  minPort=_minPort;  

  TCP=new kxTCP(minPort,maxPort);
  debug("TCP engine started");
  AIM=new kxAIM(TCP->getPort(), TCP->getIntAddr());
  debug("AIM engine started");
  AIM->setFirstData(_uin,_passwd);
  AIM->setServer(_server, _port);

  QObject::connect(AIM, SIGNAL(receivedMessage(UIN, kxMessageStruct)), MESSAGE, SLOT(newMessage(UIN, kxMessageStruct)));
  QObject::connect(AIM, SIGNAL(receivedUrl(UIN, kxMessageStruct)), MESSAGE, SLOT(newUrl(UIN, kxMessageStruct)));
  QObject::connect(AIM, SIGNAL(receivedAuth(UIN, kxMessageStruct)), MESSAGE, SLOT(newAuthReq(UIN, kxMessageStruct)));
  QObject::connect(AIM, SIGNAL(receivedAuthReply(UIN, kxMessageStruct)), MESSAGE, SLOT(newAuthReply(UIN, kxMessageStruct)));
  QObject::connect(AIM, SIGNAL(receivedAdded(UIN, kxMessageStruct)), MESSAGE, SLOT(newAdded(UIN, kxMessageStruct)));
  QObject::connect(AIM, SIGNAL(receivedSMSReply(UIN, kxMessageStruct)), MESSAGE, SLOT(newSMSReply(UIN, kxMessageStruct)));
  QObject::connect(AIM, SIGNAL(receivedContacts(UIN, kxMessageStruct)), MESSAGE, SLOT(newContacts(UIN, kxMessageStruct)));

  QObject::connect(AIM, SIGNAL(connected()), this, SLOT(SlotConnected()));
  QObject::connect(AIM, SIGNAL(connecting()), this, SLOT(SlotConnecting()));
  QObject::connect(AIM, SIGNAL(disconnected(int)), this, SLOT(SlotDisconnected(int)));
  QObject::connect(AIM, SIGNAL(signalContactStatusChange(UIN, Q_UINT16, Q_UINT16 )), this, SLOT(SlotContactStatusChange(UIN, Q_UINT16, Q_UINT16 )));
  QObject::connect(AIM, SIGNAL(receivedMessage(UIN,kxMessageStruct)), this, SLOT(SlotNewMessage(UIN, kxMessageStruct)));
	QObject::connect(AIM, SIGNAL(receivedUrl(UIN,kxMessageStruct)), this, SLOT(SlotNewUrl(UIN, kxMessageStruct)));

  QObject::connect(AIM, SIGNAL(receivedAck(Q_UINT16)), this, SLOT(SlotReceivedAck(Q_UINT16)));
  QObject::connect(AIM, SIGNAL(receivedErrorAck(Q_UINT16, Q_UINT16 )), this, SLOT(SlotErrorAck(Q_UINT16, Q_UINT16)));
//  QObject::connect(UDP, SIGNAL(errorString(QString)), this, SLOT(SlotErrorString(QString)));
//  QObject::connect(UDP, SIGNAL(invalidPassword()), this, SLOT(SlotInvalidPassword()));

  QObject::connect(TCP, SIGNAL(receivedMessage(UIN,kxMessageStruct)), this, SLOT(SlotNewMessage(UIN, kxMessageStruct)));
  QObject::connect(TCP, SIGNAL(receivedUrl(UIN,kxMessageStruct)), this, SLOT(SlotNewUrl(UIN, kxMessageStruct)));
  QObject::connect(AIM, SIGNAL(receivedAuth(UIN,kxMessageStruct)), this, SLOT(SlotNewAuthReq(UIN, kxMessageStruct)));
  QObject::connect(AIM, SIGNAL(receivedAuthReply(UIN,kxMessageStruct)), this, SLOT(SlotNewAuthReply(UIN, kxMessageStruct)));
  QObject::connect(AIM, SIGNAL(receivedAdded(UIN,kxMessageStruct)), this, SLOT(SlotNewAdded(UIN, kxMessageStruct)));
	QObject::connect(AIM, SIGNAL(receivedSMSReply(UIN,kxMessageStruct)), this, SLOT(SlotNewSMSReply(UIN, kxMessageStruct)));
  QObject::connect(AIM, SIGNAL(receivedStatusMessage(UIN, QString)), this, SLOT(SlotStatusMessage(UIN, QString)));
  QObject::connect(TCP, SIGNAL(receivedStatusMessage(UIN, QString)), this, SLOT(SlotStatusMessage(UIN, QString)));
  QObject::connect(TCP, SIGNAL(SignalNewFile(UIN,int,QString, QString, int)), this, SLOT(SlotNewFile(UIN, int, QString,QString, int)));
  QObject::connect(AIM, SIGNAL(receivedMetaSearch(Q_UINT16, UIN, QString, QString, QString, QString, Q_UINT8,Q_UINT8, bool)),
                   this, SLOT(SlotSearchFound(Q_UINT16, UIN, QString,QString,QString,QString, Q_UINT8,Q_UINT8, bool)));
  QObject::connect(AIM, SIGNAL(receivedMetaSearchFailed(Q_UINT16)), this, SLOT(SlotSearchFailed(Q_UINT16)));
  QObject::connect(AIM,SIGNAL(receivedMoreInfo(Q_UINT16, Q_UINT16, Q_UINT8, QString, Q_UINT16,Q_UINT8,Q_UINT8,Q_UINT8,Q_UINT8,Q_UINT8)),
                    this,SLOT(SlotMoreInfo(Q_UINT16, Q_UINT16, Q_UINT8, QString, Q_UINT16,Q_UINT8,Q_UINT8,Q_UINT8,Q_UINT8,Q_UINT8)));
	QObject::connect(AIM, SIGNAL(receivedEmailInfo(Q_UINT16, QStringList)), this, SLOT(SlotReceivedEmailInfo(Q_UINT16, QStringList)));
  QObject::connect(AIM, SIGNAL(receivedWorkInfo(Q_UINT16, QString, QString,QString,QString,QString,QString,QString,QString,QString,QString,Q_UINT16,Q_UINT16)),
  									this, SLOT(SlotReceivedWorkInfo(Q_UINT16, QString, QString,QString,QString,QString,QString,QString,QString,QString,QString,Q_UINT16,Q_UINT16)));
	QObject::connect(AIM, SIGNAL(receivedAboutInfo(Q_UINT16, QString)), SIGNAL(SignalReceivedAboutInfo(Q_UINT16, QString)));	
  QObject::connect(AIM, SIGNAL(receivedMainHomeInfo(Q_UINT16, QString,QString,QString,QString,QString,QString,QString,QString,QString,QString,QString,Q_UINT16, Q_UINT8, Q_UINT8)), this, SLOT(SlotReceivedMainHomeInfo(Q_UINT16, QString,QString,QString,QString,QString,QString,QString,QString,QString,QString,QString,Q_UINT16, Q_UINT8, Q_UINT8)));
  QObject::connect(AIM, SIGNAL(searchEnd(Q_UINT16)), this, SLOT(SlotSearchEnd(Q_UINT16)));
  QObject::connect(AIM, SIGNAL(receivedSMSAck(Q_UINT16, QString, QString)),this, SIGNAL(SignalReceivedSMSAck(Q_UINT16, QString, QString)));


}
void kxEngine::setServer(QString _s, int _p)
{
	server=_s;
	serverPort=_p;
	AIM->setServer(_s, _p);
}

bool kxEngine::loggedOn()
{ 
	return AIM->loggedOn();
}

int kxEngine::connect()
{
	return AIM->connect();
}

void kxEngine::login(int _status)
{
  connectRetry=0;
//  connectTimer.start(20000);
  if (AIM->connect(_status)<0)
  {
	  tryLogin=FALSE;
	  loginStatus=STATUS_OFFLINE;
	  currentStatus=STATUS_OFFLINE;
  	emit SignalDisconnected(kxAIM::NoServer);
  	return;
  }
  tryLogin=TRUE;
  loginStatus=_status;
  currentStatus=_status;
}
void kxEngine::changeStatus(int _status)
{
	if (!loggedOn()) { notLoggedOn(); return ; }
  AIM->sendStatus(_status);
  statusChangeAck=0xFF98; //random ;-)
  statusChangeTo=_status;
  SlotReceivedAck(0xFF98);
}
void kxEngine::SlotReceivedAck(Q_UINT16 _ack)
{
  if (statusChangeAck==_ack)
  {
    currentStatus=statusChangeTo;
    emit SignalStatusUpdate(statusChangeTo);
    emit SignalUpdateDock();
  }
  else  emit SignalReceivedAck(_ack);
}
void kxEngine::closeConnection()
{
//	if (!loggedOn()) { notLoggedOn(); return ; }
	AIM->disconnect(kxAIM::Manual);
}
void kxEngine::SlotConnected()
{
  debug("connected!!");
  tryLogin=FALSE;
  connectTimer.stop();
  emit SignalConnected();
  emit SignalUpdateDock();
}
void kxEngine::SlotDisconnected(int _t)
{
  debug("disconnected..");
	for (int t=0; t<CONTACT->count(); t++)
	{
	  debug("Go Offline: %d, %d",CONTACT->getContact(t).uin, CONTACT->getContact(t).status);
		if (ENGINE->CONTACT->getContact(t).status!=STATUS_OFFLINE)
		{
		  CONTACT->updateStatus(t,STATUS_OFFLINE);
		  emit SignalContactStatusChange(CONTACT->getContact(t).uin,STATUS_OFFLINE, 1);
		}
  }
  currentStatus=STATUS_OFFLINE;
  emit SignalDisconnected(_t);
  emit SignalUpdateDock();
}
void kxEngine::SlotConnectTimeout()
{
  currentStatus=STATUS_OFFLINE;
  debug("Connect timeout");
  if (connectRetry++>2)
  {
    debug("Retry...");
//    connectTimer.start(20000);
    AIM->connect(loginStatus);
  }
  else
  {
    connectTimer.stop();
    QString tmp="Connection timeout";
    emit SignalConnectError(tmp);
    emit SignalDisconnected(kxUDP::TimeOut);
    emit SignalUpdateDock();
    tryLogin=FALSE;
  }
}
void kxEngine::SlotInvalidPassword()
{
  emit SignalInvalidPassword();
  currentStatus=STATUS_OFFLINE;
}
void kxEngine::SlotConnecting()
{
	currentStatus=STATUS_OFFLINE;
  emit SignalConnecting();
}
void kxEngine::SlotErrorString(QString _str)
{
  currentStatus=STATUS_OFFLINE;
  emit SignalConnectError(_str);
}
int kxEngine::disconnect()
{
  if (tryLogin==TRUE)
    connectTimer.stop();

  AIM->disconnect(kxAIM::Manual);
  emit SignalUpdateDock();
  return 1;
}

void kxEngine::setCurrentStatus(int _status)
{
  currentStatus=_status;
  emit SignalStatusUpdate(_status);
}
void kxEngine::SlotContactStatusChange(UIN _uin, Q_UINT16 _status, Q_UINT16 _type )
{
  emit SignalContactStatusChange(_uin,_status, _type);
}
void kxEngine::SlotContactChange(UIN _uin)
{
  emit SignalContactChange(_uin);
}

void kxEngine::SlotContactAdd2List(UIN _uin, QString)
{
	if (!loggedOn()) { notLoggedOn(); return ; }
  AIM->sendAddUser2List(_uin);
}

void kxEngine::SlotNewMessage(UIN _uin, kxMessageStruct _msg)
{
  emit SignalNewMessage(_uin, _msg);
  emit SignalUpdateDock();
}
void kxEngine::SlotNewUrl(UIN _uin, kxMessageStruct _msg)
{
  emit SignalNewUrl(_uin, _msg);
  emit SignalUpdateDock();
}
void kxEngine::SlotNewAuthReq(UIN _uin, kxMessageStruct _msg)
{
  emit SignalNewAuthReq(_uin, _msg);
  emit SignalUpdateDock();
}
void kxEngine::SlotNewAuthReply(UIN _uin, kxMessageStruct _msg)
{
  emit SignalNewAuthReply(_uin, _msg);
  emit SignalUpdateDock();
}
void kxEngine::SlotNewAdded(UIN _uin, kxMessageStruct _msg)
{
  emit SignalNewAdded(_uin, _msg);
  emit SignalUpdateDock();
}
void kxEngine::SlotNewSMSReply(UIN _uin, kxMessageStruct _msg)
{
  emit SignalNewSMSReply(_uin, _msg);
  emit SignalUpdateDock();
}

int kxEngine::searchForUin(UIN _uin)
{
	if (!loggedOn()) { notLoggedOn(); return 0; }
	return AIM->sendRequestInfoOnUin(_uin);
}
int kxEngine::searchForEmail(const char *_email)
{
	if (!loggedOn()) { notLoggedOn(); return 0; }
	return AIM->sendMetaSearchEmail(_email);
}
int kxEngine::searchForExtra(const char *_nick,const char *_first, const char *_last)
{
	if (!loggedOn()) { notLoggedOn(); return 0; }
  return AIM->sendMetaSearchNick(_nick,_first, _last);
}
void kxEngine::SlotSearchFound(Q_UINT16 _s, UIN _u, QString _n, QString _f, QString _l, QString _e, Q_UINT8 _a,Q_UINT8 _st, bool _last)
{
  debug("search Found");
  emit SignalSearchFound(_s, _u, _n, _f, _l, _e, _a, _st, _last);
}
void kxEngine::SlotSearchFailed(Q_UINT16 _s)
{
  debug("search Failed");
	emit SignalSearchFailed(_s);
}
kxSend *kxEngine::sendMessage(UIN _uin, QString _msg, bool _server, QColor _fg, QColor _bg, bool _useColor=FALSE)
{
	if (!loggedOn()) { notLoggedOn(); return NULL; }
  sendSeq++;
  kxSend *send;
  send=new kxSend(MESSAGE_TYPE, sendSeq, _uin, _msg,"",_server, _fg, _bg, _useColor);
  return send;
}
kxSend *kxEngine::sendUrl(UIN _uin, QString _msg, QString _url, bool _server, QColor _fg, QColor _bg, bool _useColor=FALSE)
{
	if (!loggedOn()) { notLoggedOn(); return NULL; }
  sendSeq++;
  kxSend *send;
  send=new kxSend(URL_TYPE, sendSeq, _uin,_msg,_url, _server, _fg, _bg, _useColor);
  return send;
}
kxSend *kxEngine::sendContacts(UIN _uin, QList<kxAddContactStruct> *_list, bool _server)
{
	if (!loggedOn()) { notLoggedOn(); return NULL; }
  sendSeq++;
  kxSend *send;
  send=new kxSend(sendSeq, _uin,_list, _server);
  return send;
}
void kxEngine::sendAuthorization(UIN _uin)
{
	if (!loggedOn()) { notLoggedOn(); return ; }
	AIM->sendAuthRequest(_uin,TRUE,QString(""));
}
void kxEngine::rejectContact(UIN _uin,QString _str)
{
	if (!loggedOn()) { notLoggedOn(); return ; }
	AIM->sendAuthRequest(_uin,FALSE,_str);
}
void kxEngine::addContact2List(UIN _uin, bool auth, bool notify, QString _nick, QString _n, QString _f, QString _l, QString _e, bool _a, bool _req=TRUE)
{
	if (notify)
	{
		if (_req)
		{
			if (requestInfo(_uin,AUTH))
			{
				auth=CONTACT->getContact(_uin).needAuth;
			}
			else return;
		}
		if (auth)
			emit SignalRequestAdd2List(_uin);
		else
		{
			notifyContact(_uin, _n, _f, _l, _e, auth);			
		}
	}
	ENGINE->CONTACT->add(_nick,_uin, notify==TRUE?auth:FALSE);	
	if (!loggedOn()) { return ; }	
	AIM->sendAddUser2List(_uin);
}
void kxEngine::sendAuthRequest(Q_UINT32 _uin, const QString &_msg)
{
	if (!loggedOn()) { notLoggedOn(); return ; }
	AIM->sendAuthRequest(_uin, _msg);
}
void kxEngine::removeContactFromList(UIN _uin)
{
	if (!loggedOn()) { return ; }
  AIM->sendRemoveUser2List(_uin);
}
void kxEngine::notifyContact(UIN _uin, QString _n, QString _fn, QString _ln, QString _e, bool auth=FALSE)
{
	if (!loggedOn()) { notLoggedOn(); return ; }
	AIM->sendAddUser(_uin, _n, _fn, _ln, _e, auth);
}
void kxEngine::SlotStatusMessage(UIN uin, QString message)
{
  emit SignalStatusMessage(uin, message);
  debug("Status Message: %s",message.latin1());
}
void kxEngine::getStatusMessage(UIN _uin, int _status)
{
	if (!loggedOn()) { notLoggedOn(); return ; }
	AIM->sendReuqestMessage(_uin,_status);
}
void kxEngine::setStatusMessages(QString away, QString na, QString dnd)
{
  awayMessage=away;
  naMessage=na;
  dndMessage=dnd;
}
QString kxEngine::getStatusMessages(int status)
{
	switch(status)
 	{
 		case STATUS_ONLINE:
 		case STATUS_OFFLINE:
 			break;
 		case STATUS_AWAY:								
			return awayMessage;
			break;
 		case STATUS_NA:
			return naMessage;
 			break;					
 		case STATUS_DND:								
			return dndMessage;
 			break;								
 		case STATUS_OCCUPIED:			
 			break;
 		case STATUS_FFC:											
 			break;
 	}
 	return QString("");
}
void kxEngine::SlotNewFile(UIN _u,int _s,QString _m,QString _f, int _si)
{
  emit SignalNewFile(_u,_s,_m, _f, _si);
}
int kxEngine::sendRequestInfo(Q_UINT32 _uin)
{
	if (!loggedOn()) { notLoggedOn(); return 0; }
	return AIM->sendRequestInfo(_uin);
}
void kxEngine::SlotReceivedMainHomeInfo(Q_UINT16 s, QString _n,QString _f,QString _l,QString _e,
						QString _c,QString _s,QString _p,QString _fa,
						QString _st,QString _ce,QString _z,Q_UINT16 _co, Q_UINT8 _gmt, Q_UINT8 _pe)
{
	emit SignalReceivedMainHomeInfo(s, _n, _f, _l, _e, _c, _s, _p, _fa, _st, _ce, _z, _co, _gmt, _pe);
}
void kxEngine::SlotErrorAck(Q_UINT16 _t, Q_UINT16 _e)
{
	emit SignalErrorAck(_t, _e);
}
void kxEngine::SlotSearchEnd(Q_UINT16 _t)
{
	emit SignalSearchEnd(_t);
}
void kxEngine::SlotMoreInfo(Q_UINT16 s,Q_UINT16 _age, Q_UINT8 _sex, QString _homepage, Q_UINT16 j,Q_UINT8 d,Q_UINT8 m,Q_UINT8 l1,Q_UINT8 l2,Q_UINT8 l3)
{
	emit SignalReceivedMoreInfo(s, _age, _sex, _homepage, j, d, m, l1, l2, l3);
}
/** Set Security settings:
webAware
HideIP */
void kxEngine::setSecuritySettings(bool _wa, bool _hi, bool _send=FALSE)
{
	webStatus=_wa;
	hideIP=_hi;
	if (_send && loggedOn()) ENGINE->AIM->sendStatus(currentStatus);	
}
void kxEngine::addToVisibleList(Q_UINT32 _uin)
{
	if (!loggedOn()) { notLoggedOn(); return ; }
	if (currentStatus==STATUS_INVISIBLE)
		AIM->addToVisibleList(_uin);
}
void kxEngine::removeFromVisibleList(Q_UINT32 _uin)
{
	if (!loggedOn()) { notLoggedOn(); return ; }
	if (currentStatus==STATUS_INVISIBLE)
		AIM->removeFromVisibleList(_uin);
}
void kxEngine::addToInvisibleList(Q_UINT32 _uin)
{
	if (!loggedOn()) { notLoggedOn(); return ; }
	if (currentStatus!=STATUS_INVISIBLE)
		AIM->addToInvisibleList(_uin);
}
void kxEngine::removeFromInvisibleList(Q_UINT32 _uin)
{
	if (!loggedOn()) { notLoggedOn(); return ; }
	if (currentStatus!=STATUS_INVISIBLE)
		AIM->removeFromInvisibleList(_uin);
}
void kxEngine::notLoggedOn()
{
	emit SignalNotLoggedOn();
}
void kxEngine::SlotReceivedEmailInfo(Q_UINT16 s, QStringList lst)
{
	emit SignalReceivedEmailInfo(s, lst);
}
void kxEngine::SlotReceivedWorkInfo(Q_UINT16 s, QString s1, QString s2,QString s3,QString s4,QString s5,QString s6,QString s7 ,QString s8,QString s9, QString s10, Q_UINT16 c, Q_UINT16 c1)
{
	emit SignalReceivedWorkInfo(s, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, c, c1);
}
int kxEngine::sendRandomSearch(Q_UINT16 type)
{
	if (!loggedOn()) { notLoggedOn(); return 0; }
	return AIM->sendRandomSearch(type);
}
int kxEngine::sendSMS(const QString &t, const QString &m, const QString &n)
{
	return AIM->sendSMS(t,m, n);
}
bool kxEngine::requestInfo( Q_UINT32 _u, Q_UINT8 _type)
{
	if (!loggedOn()) { notLoggedOn(); return FALSE; }
	Q_UINT16 seq=0;
	switch(_type)
	{
		case ALL:	
		{
			seq=sendRequestInfo(_u);
		}
		break;
		case AUTH:
		{
			seq=searchForUin(_u);
		}
		break;
		case GSM:
		{
			seq=sendRequestInfo(_u);
		}
	}
	bool status=FALSE;
	emit SignalRequestInfo(seq, _u, &status);
	debug("Did emit with %d, %d",seq, _u);
	return status;
}

#include <kglobal.h>
#include <kcharsets.h>

void kxEngine::setEncoderLanguage(const QString &_l)
{
	encoderLanguage=_l;
	if (encoderLanguage.length()>0 && encoderLanguage!="KDE Default")
		codecLocal = QTextCodec::codecForName(KGlobal::charsets()->encodingForName(_l));
	else codecLocal=NULL;
};

QString kxEngine::Local2Unicode(const char* localString)
{
	if (encoderLanguage.length()>0 && encoderLanguage!="KDE Default" && codecLocal)
	  return codecLocal->toUnicode(localString);
 	return QString::fromLocal8Bit(localString);
}

QCString kxEngine::Unicode2Local(const QString& uniString)
{
	if (encoderLanguage.length()>0 && encoderLanguage!="KDE Default" && codecLocal)
	  return (const char*)codecLocal->fromUnicode(uniString);
 	return uniString.local8Bit();
}
int kxEngine::sendMainHomeInfo( QString _n,QString _f,QString _l,QString _e,QString _c,QString _st,QString _p,QString _fa,QString _ste,QString _ce,QString _zip,Q_UINT16 _con, Q_UINT8 _gmt, Q_UINT8 _pubEmail)
{
	return AIM->sendMainHomeInfo( _n, _f, _l, _e, _c, _st, _p, _fa, _ste, _ce,_zip, _con, _gmt, _pubEmail);
}
int kxEngine::sendEmailList(const QStringList &lst)
{
	return AIM->sendEmailList(lst);
}
int kxEngine::sendWorkInfo(QString _n, QString _p,QString _d, QString _s,QString _z, QString _c,QString _st, QString _url, QString _ph, QString _f,Q_UINT16 _co, Q_UINT16 _oc)
{
	return AIM->sendWorkInfo(_n,_p, _d, _s, _z, _c, _st, _url, _ph, _f, _co, _oc );
}
int kxEngine::sendAboutInfo(QString _a)
{
	return AIM->sendAboutInfo(_a);
}
int kxEngine::sendMoreInfo(Q_UINT16 _a, Q_UINT8 _s, QString _u, Q_UINT16 _y, Q_UINT8 _d, Q_UINT8 _m, Q_UINT8 _l1, Q_UINT8 _l2, Q_UINT8 _l3)
{
	return AIM->sendMoreInfo(_a, _s, _u, _y, _d, _m, _l1, _l2, _l3);
}
int kxEngine::sendRequestOwnInfo( Q_UINT32 _uin)
{
	if (!loggedOn()) { notLoggedOn(); return 0; }
	return AIM->sendRequestOwnInfo(_uin);
}
