#ifndef KXCONNECTION_H
#define KXCONNECTION_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <qobject.h>
#include <qtimer.h>
#include <v2_codes.h>
#include <kxmessage.h>

class kxTCP;
class kxUDP;

class kxConnection : public QObject
{
  Q_OBJECT
public:

  kxConnection();
  ~kxConnection();  
  QString server;
  int serverPort;

  void init();
  int connect();
  void login();
  void setupConnection(QString _server, int _port, Q_UINT32 _uin, QString _password);
  int setCurrentStatus(int);
  int closeConnection();
 

// search  
  int searchForUin(UIN);
  int searchForEmail(const char *_email);
  int searchForExtra(const char *_nick,const char *_first, const char *_last);
  
    
  bool loggedOn(); 

  kxTCP *TCP;
  kxUDP *UDP;
  
public slots:
  void SlotConnecting();
  void SlotConnected();
  void SlotDisconnected(int);
  void SlotConnectTimeout();
  void SlotInvalidPassword();
  void SlotErrorString(QString);
  void SlotContactStatusChange(UIN , Q_UINT16, Q_UINT16 );
  void SlotNewMessage(UIN, kxMessageStruct);
  void SlotNewUrl(UIN, kxMessageStruct);
	void SlotSearchFound(Q_UINT16, UIN, const char *, const char *, const char *, const char *, Q_UINT8,Q_UINT16, bool);
	void SlotSearchFailed(Q_UINT16);
	void SlotContactAdded(UIN, QString);

  
signals:
  
  void errorString(QString);
  void invalidPassword();
  void connected();
  void connecting();
  void disconnected(int);
  void contactStatusChange(UIN , Q_UINT16, Q_UINT16 );
  void newMessage(UIN, kxMessageStruct);
  void newUrl(UIN, kxMessageStruct);
  void updateDock();  // for docking 

	void searchFound(Q_UINT16, UIN, const char *, const char *, const char *, const char *, Q_UINT8,Q_UINT16, bool);
	void searchFailed(Q_UINT16);
	void contactAdded(UIN, QString);
  
    
private:

};

#endif
