#include "kxconnection.h"
#include "kxtcp.h"
#include "kxudp.h"
#include "kxengine.h"
#include "kxcontact.h"
#include "v2_codes.h"

kxConnection::kxConnection() : QObject(this)
{
}

kxConnection::~kxConnection()
{
}

void kxConnection::init()
{
  tryLogin=FALSE;
  QObject::connect(&connectTimer, SIGNAL(timeout()), this, SLOT(SlotConnectTimeout()));

  TCP=new kxTCP(ENGINE->kxConfig.minPort,ENGINE->kxConfig.maxPort);
  debug("TCP engine started");
  UDP=new kxUDP(TCP->getPort(), TCP->getAddr());
  debug("UDP engine started");

  QObject::connect(UDP, SIGNAL(connected()), this, SLOT(SlotConnected()));
  QObject::connect(UDP, SIGNAL(connecting()), this, SLOT(SlotConnecting()));
  QObject::connect(UDP, SIGNAL(disconnected(int)), this, SLOT(SlotDisconnected(int)));
  QObject::connect(UDP, SIGNAL(errorString(QString)), this, SLOT(SlotErrorString(QString)));
  QObject::connect(UDP, SIGNAL(invalidPassword()), this, SLOT(SlotInvalidPassword()));
  QObject::connect(UDP, SIGNAL(signalContactStatusChange(UIN, Q_UINT16, Q_UINT16 )), this, SLOT(SlotContactStatusChange(UIN, Q_UINT16, Q_UINT16 )));

  QObject::connect(UDP, SIGNAL(receivedMessage(UIN,kxMessageStruct)), this, SLOT(SlotNewMessage(UIN, kxMessageStruct)));
  QObject::connect(TCP, SIGNAL(receivedMessage(UIN,kxMessageStruct)), this, SLOT(SlotNewMessage(UIN, kxMessageStruct)));
  QObject::connect(UDP, SIGNAL(receivedUrl(UIN,kxMessageStruct)), this, SLOT(SlotNewUrl(UIN, kxMessageStruct)));
	
  QObject::connect(UDP, SIGNAL(receivedMetaSearch(Q_UINT16, UIN, const char *, const char *, const char *, const char *, Q_UINT8,Q_UINT16, bool)),
                   this, SLOT(SlotSearchFound(Q_UINT16, UIN, const char *, const char *, const char *, const char *, Q_UINT8,Q_UINT16, bool)));
  QObject::connect(UDP, SIGNAL(receivedMetaSearchFailed(Q_UINT16)), this, SLOT(SlotSearchFailed(Q_UINT16)));
  
  QObject::connect(ENGINE->CONTACT, SIGNAL(contactAdded(UIN, QString)), this, SLOT(SlotContactAdded(UIN, QString)));
}

void kxConnection::setupConnection(QString _server, int _port, Q_UINT32 _uin, QString _password)
{
  UDP->setFirstData(_uin,_password.latin1());
  server=_server;
  serverPort=_port;
};

bool kxConnection::loggedOn()
{ 
  return UDP->loggedOn(); 
}

int kxConnection::connect()
{
  return UDP->connect(server.latin1(), serverPort);
}

void kxConnection::login()
{
  connectRetry=0;
  connectTimer.start(20000);
  UDP->login();
  tryLogin=TRUE;
}
int kxConnection::setCurrentStatus(int _status)
{
  UDP->sendStatusChange(_status);
  return _status;  
}

void kxConnection::SlotConnected()
{
  debug("connected!!");
  tryLogin=FALSE;
  connectTimer.stop();  
  emit connected();
  emit updateDock();  
}
void kxConnection::SlotDisconnected(int _t)
{
  debug("disconnected..");
	for (int t=0; t<ENGINE->CONTACT->count(); t++)
	{
	  debug("Go Offline: %d, %d",ENGINE->CONTACT->getContact(t).uin, ENGINE->CONTACT->getContact(t).status);
		if (ENGINE->CONTACT->getContact(t).status!=STATUS_OFFLINE)
		{
		  debug("Ok, go..");
		  ENGINE->CONTACT->updateStatus(t,STATUS_OFFLINE);
		  emit contactStatusChange(ENGINE->CONTACT->getContact(t).uin,STATUS_OFFLINE, 1);
		}
  }  
  emit disconnected(_t);
  emit updateDock();
}
void kxConnection::SlotConnectTimeout()
{
  debug("Connect timeout");
  if (connectRetry++>2)
  {
    debug("Retry...");
    connectTimer.start(20000);
    UDP->login();
  }
  else
  {
    connectTimer.stop();  
    QString tmp="Connection timeout";
    emit errorString(tmp);
    emit disconnected(kxUDP::TimeOut);
    emit updateDock();
    tryLogin=FALSE;
  }
}
void kxConnection::SlotInvalidPassword()
{
  emit invalidPassword();
}
void kxConnection::SlotConnecting()
{
  emit connecting();
}
void kxConnection::SlotErrorString(QString _str)
{
  emit errorString(_str);
}
int kxConnection::closeConnection()
{
  if (tryLogin==TRUE)
    connectTimer.stop();  
   
  UDP->closeConnection(); 
  emit updateDock();  
  return 1;
}

void kxConnection::SlotContactStatusChange(UIN _uin, Q_UINT16 _status, Q_UINT16 _type )
{
  emit contactStatusChange(_uin,_status, _type);
}
void kxConnection::SlotNewMessage(UIN _uin, kxMessageStruct _msg)
{
  emit newMessage(_uin, _msg);
  emit updateDock();
}
void kxConnection::SlotNewUrl(UIN _uin, kxMessageStruct _msg)
{
  emit newUrl(_uin, _msg);
  emit updateDock();
}
int kxConnection::searchForUin(UIN _uin)
{
  return UDP->sendMetaSearchUin(_uin);
}
int kxConnection::searchForEmail(const char *_email)
{ 
  return UDP->sendMetaSearchEmail(_email);
}
int kxConnection::searchForExtra(const char *_nick,const char *_first, const char *_last)
{
  return UDP->sendMetaSearchNick(_nick,_first, _last);
}
void kxConnection::SlotSearchFound(Q_UINT16 _s, UIN _u, const char *_n, const char *_f, const char *_l, const char *_e, Q_UINT8 _a,Q_UINT16 _un, bool _last)
{
  debug("search Found");
  emit searchFound(_s, _u, _n, _f, _l, _e, _a, _un, _last);
}
void kxConnection::SlotSearchFailed(Q_UINT16 _s)
{
  debug("search Failed");
	emit searchFailed(_s);
}
void kxConnection::SlotContactAdded(UIN _uin, QString)
{
  UDP->sendAddUser2List(_uin);
}

/*
  QObject::connect(ENGINE->UDP, SIGNAL(receivedEmail(UIN,MESSAGE)), this, SLOT(SlotReceivedEmail(UIN,MESSAGE)));
  QObject::connect(ENGINE->UDP, SIGNAL(receivedWebPanel(UIN,MESSAGE)), this, SLOT(SlotReceivedWebPanel(UIN,MESSAGE)));
  QObject::connect(ENGINE->UDP, SIGNAL(receivedMessage(UIN,MESSAGE)), this, SLOT(SlotReceivedMessage(UIN,MESSAGE)));
  QObject::connect(ENGINE->UDP, SIGNAL(receivedUrl(UIN,URL)), this, SLOT(SlotReceivedUrl(UIN,URL)));
  QObject::connect(ENGINE->UDP, SIGNAL(receivedAdded(UIN,ADDED)), this, SLOT(SlotReceivedAdded(UIN,ADDED)));
  QObject::connect(ENGINE->UDP, SIGNAL(receivedAuth(UIN,ADDED)), this, SLOT(SlotReceivedAuth(UIN,ADDED)));
  QObject::connect(ENGINE->UDP, SIGNAL(receivedAuthReply(UIN,int, MESSAGE)), this, SLOT(SlotReceivedAuthReply(UIN,int, MESSAGE)));
  QObject::connect(ENGINE->UDP, SIGNAL(kxContactUpdate(UIN, Q_UINT32, Q_UINT16)), this, SLOT(contactUpdate(UIN, Q_UINT32, Q_UINT16)));
  QObject::connect(ENGINE->TCP, SIGNAL(receivedStatusMessage(UIN,char *)), this, SLOT(SlotStatusMessage(UIN,char *)));
  QObject::connect(ENGINE->TCP, SIGNAL(receivedMessage(UIN,MESSAGE)), this, SLOT(SlotReceivedMessage(UIN,MESSAGE)));
  QObject::connect(ENGINE->TCP, SIGNAL(receivedUrl(UIN,URL)), this, SLOT(SlotReceivedUrl(UIN,URL)));
  QObject::connect(ENGINE->UDP, SIGNAL(giveUserInfo()), this, SLOT(SlotGiveUserInfo()));
  QObject::connect(ENGINE->UDP, SIGNAL(receivedAskAddContact(UIN,QList<kxAddContactStruct> *)), this, SLOT(SlotAddContact(UIN,QList<kxAddContactStruct> *)));
  QObject::connect(ENGINE->TCP, SIGNAL(receivedAskAddContact(UIN,QList<kxAddContactStruct> *)), this, SLOT(SlotAddContact(UIN,QList<kxAddContactStruct> *)));    
  */



