/***************************************************************************
                          kxaim.cpp  -  description
                             -------------------
    begin                : Sun Nov 4 2001
    copyright            : (C) 2001 by Herwin Jan Steehouwer
    email                : steehouwer@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <config.h>
#include <qtextcodec.h>
#include "kxaim.h"
#include <ksock.h>
#include <qobject.h>
#include <stdlib.h>
#include <kxengine.h>
#include <kxcontact.h>
#include <qdom.h>


kxAIM::kxAIM(Q_UINT16 _port, Q_UINT32 _lanIP) :  QObject(), kxPacket() , kxTLV(), kxSNAC()
{
 	initPacket();	
 	requestID=0;
 	packetList.setAutoDelete(TRUE);
	aimSock=NULL;
	myLoggedOn=FALSE; 	
	seq = 5452;
	messageSeq=1;
	searchSequence=1;
	connectStatus=0xFFFF;
	lanIP=_lanIP;
	serverPort=_port;
	wanIP=0x00000000;	
	continueSendLogin=FALSE;
	ourStatus=0xFFFF;
	incommingPacket=NULL;
}
kxAIM::~kxAIM()
{
}
void kxAIM::setFirstData(Q_UINT32 _uin, const QString &_passwd)
{
	uin=_uin;
	passwd=_passwd;	
}
bool kxAIM::loggedOn()
{
	return myLoggedOn;
}


void kxAIM::SlotReadEvent(KSocket *_ks)
{
	int sock=_ks->socket();
	Q_UINT16 len;
	if (!incommingPacket)
	{
    incommingPacket=new kxAIMIncommingPacket;
    incommingPacket->length=0;
    incommingPacket->totalRead=0;
    incommingPacket->mySocket=_ks;	
    char *buf2=new char[7];
    char * oBuf=buf2;
    len=recv(sock, buf2, 6,0 );
    QByteArray  a; //=new QByteArray(2049);
    a.setRawData( buf2, len );
    QDataStream s( a, IO_ReadOnly );            // open on a's data
    s.setByteOrder(QDataStream::BigEndian);
    Q_UINT8 command;
    Q_UINT8 channel;
    Q_UINT16 seq;
    Q_UINT16 packetLen;
    s >> (Q_UINT8  &)command;
    s >> (Q_UINT8  &)channel;
    s >> (Q_UINT16 &)seq;
    s >> (Q_UINT16 &)packetLen;
    incommingPacket->length=packetLen;
    incommingPacket->seq=seq;
    incommingPacket->command=command;
    incommingPacket->channel=channel;
    incommingPacket->totalRead=0;
    a.resetRawData(buf2, len);
   	if (oBuf==buf2)
   		delete oBuf;
   	else
   		debug("Error deleting when receiving new packet");
	}
	
 	QDataStream s(incommingPacket->packet, IO_ReadWrite);
  s.setByteOrder(QDataStream::BigEndian);
   			
  char *buf=new char[incommingPacket->length-incommingPacket->totalRead+1];	
  char *oBuf=buf;
  len=recv(sock, buf, incommingPacket->length-incommingPacket->totalRead,0 );
  if (len>0)
  {	
  	s.device()->at(incommingPacket->totalRead);
  	s.writeRawBytes(buf,len);	
  	incommingPacket->totalRead+=len;
  	debug("packet: len: %d, %d",len, incommingPacket->totalRead);
  }
 	if (oBuf==buf)
 		delete oBuf;
 	else
 		debug("Error deleting oBuf in receiving packet");

  debug("Ok, total: %d >= %d",incommingPacket->totalRead,incommingPacket->length);
  if (incommingPacket->totalRead>=incommingPacket->length)
  {
  	parseData(&incommingPacket->packet, incommingPacket->totalRead, incommingPacket->command, incommingPacket->channel, incommingPacket->seq);
  	delete incommingPacket;
  	incommingPacket=NULL;
  }
}
 void kxAIM::SlotCloseEvent(KSocket *_ks)
 {
	debug("delete _ks ! Connection closed by AIM Server ???");
	if (_ks!=aimSock) {
		debug("AIM Socket not the same we know .. so keep online ????????????????? ");
		delete _ks;
		_ks=NULL;
		return;
	}
	if (aimSock)
	  delete aimSock;
	
	aimSock=NULL;
	debug("Close AIM Socket now");
	myLoggedOn=FALSE;
	emit disconnected(kxAIM::ByServer);
}

/**  */
void kxAIM::SlotWriteEvent(KSocket *_ks)
{
	if (!aimSock) { debug("can not send to AIM socket"); return; }
	packetDef *p;
	bool stop;
	
 	
	p=getFirst();		
	QByteArray *b=p->packet;
	QByteArray a;
	QDataStream s(a, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);
	s << (Q_UINT8) p->command;
	s << (Q_UINT8) p->channel;
	s << (Q_UINT16) seq++;
	s << (Q_UINT16) p->length;
	int ret;
 	ret=::send(_ks->socket(), a.data(), 6, 0);
 	if (ret <= 0)
 		return;
 	debug("send AIM packet: %d",p->length);
 	if (p->length>0)
 	{
 	  QString str, tmps;
 	  char *data=b->data();
 	  debug("[AIM]=========================[ send  ]=======================");
 	  for (Q_UINT16 t1=0; t1<p->length; t1++)
 	  {
   		Q_UINT8 c=data[t1];
      str.append(QString("[%1] ").arg(c,2,16));
      if (str.length()>80) { debug(str.latin1()); str.remove(0,str.length()); }   		
   	}
   	debug(str.latin1());
   	debug("[AIM]=========================[ send  ]=======================");
 		  		
    ret=::send(_ks->socket(), b->data(), p->length, 0);
    debug("Send return: %d, %d",ret, p->length);
    if (ret > 0 )
    {
  		  stop=TRUE;
  		  debug("Send File AIM ok !(%d, %d, %d)", ret, p->length, _ks->socket() );
  		  deleteFirst();
  		  debug("Deleted first packet");
  		  if (countList()<=0) _ks->enableWrite(FALSE);
  		  debug("return..");
  		  return;				
  	}	
	}
	else
	{
		debug("Empty Packet Send..");
 	  deleteFirst();
 	  if (countList()<=0) _ks->enableWrite(FALSE);
 	  return;				
 	}
}

void kxAIM::parseData(const QByteArray *a, int len, Q_UINT8 command, Q_UINT8 channel, Q_UINT16 seq)
{
    QDataStream s( *a, IO_ReadOnly );            // open on a's data
		s.setByteOrder(QDataStream::BigEndian);	
		QString str;
		
    debug("[AIM]=========================[receive]=======================");
    debug("packet: len: %d",len);
    Q_UINT8 ttmp;
    char c=0;
    for (int t=0; t<len; t++)
    {
      s >> (Q_UINT8 &)ttmp;
      str.append(QString("[%1|").arg(ttmp,2,16));
      c=(ttmp>31)?ttmp:'_';
      str.append(QString("%1] ").arg(c));
      if (str.length()>60) { debug(str.latin1()); str.remove(0,str.length()); }
    }
    debug("%s", str.latin1());
    debug("[AIM]=========================[end receive]=======================");
	
		s.device()->at(0);
		
		debug("FLAP: start: %02X, channel: %d, seq: %d (%04X), len: %d - state: %d",command, channel, seq,seq, len, state);
		switch(channel)
		{
			case 1:
				debug("Parse Channel 1 ");
				if (len==4 && state==BOS_WAITING_CONN_ACK)
				{
					debug("Got BOS ack");
					state=BOS_WAITING_LOGIN_REPLAY;					
					sendAuthRequest();
				}
				else
					if (len==4 && state==AUTH_WAITING_CONN_ACK)				
					{
						debug("Got AUTH Ack");
						state=0;
						sendCookie();
					}
				break;
			case 2:
				parseSNAC(&s, len);
				break;
			case 4:
				while(s.device()->at()<len)
				{
					parseTLVList(&s);
					if (isTLVinList(TLV_Redirect) && isTLVinList(TLV_Cookie))
					{
						tlvDef *TLV=getTLV(TLV_Redirect);
						debug("Go to: %s",TLV->text);
						state=AUTH_WAITING_CONN_ACK;
						cookie=getTLV(TLV_Cookie)->text;
						reconnect(TLV->text);						
					}
					else
					{
						debug("Error, no Cookie !!");
						myLoggedOn=FALSE;
						QObject::disconnect(aimSock,SIGNAL(closeEvent(KSocket *)), this, SLOT(SlotCloseEvent(KSocket *)));
						delete aimSock;
						aimSock=NULL;
						Q_UINT16 er=0x10;
						if (getTLV(TLV_ErrorCode))
							er=(getTLV(TLV_ErrorCode)->ch16+0x10);
						if (getTLV(TLV_DualUserOnline))
							er=0x4D;
						emit disconnected(er);
					}
				}					
		}				
}

/** Connect to the ICQ server the first time */
int kxAIM::connect(Q_UINT16 status=0x0000)
{
	connectStatus=status;
	if (aimSock)
	{
		debug("Login already busy..");
		return 1;
	}
	KSocket *_ks;
	debug("Connect to: %s:%d",server.latin1(), serverPort);
  _ks=new KSocket(server,serverPort);
  state=BOS_WAITING_CONN_ACK;
  debug("new AIM KSocket for first Login");
  if (_ks->socket()!=-1)
  {
      _ks->enableRead(TRUE);
      QObject::connect(_ks,SIGNAL(readEvent(KSocket *)), this, SLOT(SlotReadEvent(KSocket *)));
      QObject::connect(_ks,SIGNAL(closeEvent(KSocket *)), this, SLOT(SlotCloseEvent(KSocket *)));
      QObject::connect(_ks,SIGNAL(writeEvent(KSocket *)), this, SLOT(SlotWriteEvent(KSocket *)));
  }
  else
  {
  	return 0;
  }

  aimSock=_ks;
  debug("AIM COnnected..");
	ourStatus=0xFFFF;
  emit connecting();
  myLoggedOn=FALSE;

  return 1;
}
void kxAIM::reconnect(QString srv)
{
	delete aimSock;
  QObject::disconnect(aimSock,SIGNAL(readEvent(KSocket *)), this, SLOT(SlotReadEvent(KSocket *)));
  QObject::disconnect(aimSock,SIGNAL(closeEvent(KSocket *)), this, SLOT(SlotCloseEvent(KSocket *)));
  QObject::disconnect(aimSock,SIGNAL(writeEvent(KSocket *)), this, SLOT(SlotWriteEvent(KSocket *)));

	KSocket *_ks;
	
	QString server;
	int port;
	
  int pos=srv.find(':');
	server=srv.left(pos);
	port=srv.mid(pos+1).toInt();
	
	debug("AIM reConnect to %s:%d",server.latin1(), port);

	//server
  _ks=new KSocket(server,port);
  debug("new AIM reKSocket");
  if (_ks->socket()!=-1)
  {
      _ks->enableRead(TRUE);
      QObject::connect(_ks,SIGNAL(readEvent(KSocket *)), this, SLOT(SlotReadEvent(KSocket *)));
      QObject::connect(_ks,SIGNAL(closeEvent(KSocket *)), this, SLOT(SlotCloseEvent(KSocket *)));
      QObject::connect(_ks,SIGNAL(writeEvent(KSocket *)), this, SLOT(SlotWriteEvent(KSocket *)));
  }
  aimSock=_ks;
  debug("AIM reCOnnected..");
}

/** No descriptions */
void kxAIM::sendAuthRequest()
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	

	Q_UINT32 init=1;
	
	s << (Q_UINT32)init;
	length+=4;	
	QString tmp;
	tmp.sprintf("%d",uin);
	length+=screenNameTLV(&s, tmp.latin1());	
  length+=passwordTLV(&s, passwd.latin1());

  debug("Login: %s, %s",tmp.latin1(), passwd.latin1());

  length+=clientProfileTLV(&s, "ICQ Inc. - Product of ICQ (TM).2000b.4.65.1.3281.85");
  length+=clientTypeTLV(&s, 266);
  length+=clientVersionMajorTLV(&s, 4);
  length+=clientVersionMinorTLV(&s, 65);
  length+=clientICQNumberTLV(&s, 1);
  length+=clientBuildMajorTLV(&s, 3281);
  length+=clientBuildMinorTLV(&s, 85);
  length+=languageTLV(&s, "en");
	length+=countryCodeTLV(&s, "us");
	
   addPacket2ListAIM(aimSock, 0x01);
   if (aimSock)   aimSock->enableWrite(TRUE);
}
void kxAIM::sendCookie()
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send Cookie");

	Q_UINT32 init=1;
	
	s << (Q_UINT32)init;
	length+=4;	
	length+=cookieTLV(&s, cookie);
	
   addPacket2ListAIM(aimSock,0x01);
   if (aimSock)   aimSock->enableWrite(TRUE);
}
void kxAIM::disconnect(Q_UINT16 _s)
{
  QObject::disconnect(aimSock,SIGNAL(readEvent(KSocket *)), this, SLOT(SlotReadEvent(KSocket *)));
  QObject::disconnect(aimSock,SIGNAL(closeEvent(KSocket *)), this, SLOT(SlotCloseEvent(KSocket *)));
  QObject::disconnect(aimSock,SIGNAL(writeEvent(KSocket *)), this, SLOT(SlotWriteEvent(KSocket *)));
  debug("close Connection");
  delete aimSock;
  aimSock=NULL;
  myLoggedOn=FALSE;
  emit disconnected(_s);		
}
void kxAIM::parseSNAC( QDataStream *s, int len)
{
	Q_UINT16 family, subType;
	Q_UINT8 flag0, flag1;
	
	*s >> (Q_UINT16 &) family;
	*s >> (Q_UINT16 &) subType;
	*s >> (Q_UINT8 &) flag0;
	*s >> (Q_UINT8 &) flag1;
	*s >> (Q_UINT32 &) requestID;
	
	debug("SNAC: family: %02X(%d), subType: %02X(%d), flag0: %02X, flag1: %02X, request ID: %02X",	
		family, family, subType, subType, flag0, flag1, requestID );
		
	switch(family) // Family
	{
		case 1:  // Generic
			switch(subType)
			{
				case 0x03:	// Server ready;
					sendImICQ();
					break;
				case 0x18: // Capabilities ack
					sendRateRequest();
					break;
				case 0x07: // messages capabilities ack
					sendRateRequestAck();
					requestRightInfoLocationService();
					requestPersonalInfo();

					
					continueSendLogin=TRUE;

					break;
				case 0x0F: // reply to 0x01, 0x0E
					Q_UINT16 warningLevel, userClass;					
					Q_UINT8 l;
					QString uin;
					*s >> (Q_UINT8 &)l;					
					char *tmpstr=new char[l+1];
					s->readRawBytes(tmpstr, l);
					tmpstr[l]=0;
					uin=tmpstr;			
					delete tmpstr;		

					*s >> (Q_UINT16 &)warningLevel;
					*s >> (Q_UINT16 &)userClass;
					debug("Got: uin: %s, warining: %d, class: %d",uin.latin1(),warningLevel, userClass);
					parseTLVList(s);
					tlvDef *TLV=getTLV(TLV_Status);
					if (TLV)
					{
						debug("Our status: %d, %d",TLV->status, TLV->webAware);
						emit changeOurStatus(TLV->status);
					}				
					TLV=getTLV(TLV_IPAddress);
					if (TLV)
					{          	
          	Q_UINT32 l=TLV->ch32;
          	wanIP=( l << 24 ) | ( ( l & 0xff00 ) << 8 ) | ( ( l & 0xff0000 ) >> 8 ) | ( l >> 24 );
          	Q_UINT32 c=wanIP;
      	    Q_UINT8 p1, p2, p3, p4;
          	p1=c;
          	c>>= 8;
          	p2=c;
          	c>>=8;
          	p3=c;
          	c>>=8;
          	p4=c;
            QString Strip;
            Strip.sprintf("%d.%d.%d.%d",p1,p2,p3,p4);
            debug("Found Our IP: %s",Strip.latin1());
          }
	
          if (continueSendLogin)
          {
	 					requestBOS();
  					requestICBM();
  					requestRightInfoBubbyList();
  					sendICQMode();
  					sendUserInfo();
  					sendContactList();
  					
  					if (connectStatus==STATUS_INVISIBLE)
  						sendVisibleList();  					
  						
  					if (connectStatus!=0xFFFF)
  					{
  						sendStatusFull(connectStatus);
	  					if (connectStatus!=STATUS_INVISIBLE)
		  					sendInvisibleList();  						
  						connectStatus=0xFFFF;
  					}
	  					
  					sendClientReady();
  					
  					parseTLVList(s);
  					
  					myLoggedOn=TRUE;					
  					emit connected();

  					sendRequestOfflineMessages();					
          	continueSendLogin=FALSE;
          }
					debug("-=-=-==-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-");
					
				break;					
			}
			break;
		case 3: // contacts
			switch(subType)
			{
				case 0x0B: // user Online
				{
					Q_UINT16 warningLevel, noTLV;					
					Q_UINT8 l;
					QString uin;
					*s >> (Q_UINT8 &)l;					
					char *tmpstr=new char[l+1];
					s->readRawBytes(tmpstr, l);
					tmpstr[l]=0;
					uin=tmpstr;			
					delete tmpstr;		

					*s >> (Q_UINT16 &)warningLevel;
					*s >> (Q_UINT16 &)noTLV;
					debug("Got: uin: %s, warining: %d, noTLV: %d",uin.latin1(),warningLevel, noTLV);
					parseTLVList(s);
					Q_UINT32 status=0xFFFF;
					
					tlvDef *TLV=getTLV(TLV_Status);
					if (TLV)
					{
						debug("Status: %d, %d, %d",TLV->allowDirect, TLV->webAware, TLV->status);
						status=TLV->status;
						emit signalContactStatusChange(uin.toULong(),TLV->status,TLV->allowDirect);
					}	
					Q_UINT32 ip=0x0000;
					TLV=getTLV(TLV_IPAddress);
					if (TLV)
					{          	
          	Q_UINT32 l=TLV->ch32;
          	ip=( l << 24 ) | ( ( l & 0xff00 ) << 8 ) | ( ( l & 0xff0000 ) >> 8 ) | ( l >> 24 );
          	Q_UINT32 c=ip;
      	    Q_UINT8 p1, p2, p3, p4;
          	p1=c;
          	c>>= 8;
          	p2=c;
          	c>>=8;
          	p3=c;
          	c>>=8;
          	p4=c;
            QString Strip;
            Strip.sprintf("%d.%d.%d.%d",p1,p2,p3,p4);
            debug("Found IP: %s",Strip.latin1());
          }
  		    Q_UINT32 lanip=0;
			    Q_UINT32 port=0;
			    Q_UINT16 version=0x00;
			    Q_UINT8 mode=0x00;

					TLV=getTLV(TLV_LANDetails);
					if (TLV)
          {
	          QByteArray  a;
				    a.setRawData( TLV->text, TLV->len);
				    QDataStream st( a, IO_ReadOnly );            // open on a's data				
										
				    st >> (Q_UINT32 &)lanip;				
				    st >> (Q_UINT32 &)port;
				    st >> (Q_UINT8  &)mode;
				    st >> (Q_UINT16 &)version;
				    Q_UINT32 l=lanip;
          	Q_UINT32 c=( l << 24 ) | ( ( l & 0xff00 ) << 8 ) | ( ( l & 0xff0000 ) >> 8 ) | ( l >> 24 );
          	lanip=c;
      	    Q_UINT8 p1, p2, p3, p4;
          	p1=c;
          	c>>= 8;
          	p2=c;
          	c>>=8;
          	p3=c;
          	c>>=8;
          	p4=c;
            QString Strip;
            Strip.sprintf("%d.%d.%d.%d",p1,p2,p3,p4);
            debug("Lan IP: %s",Strip.latin1());				
				    debug("Lan details: IP: %X, port: %d, mode: %d, version: %X",lanip, port, mode, version);
				
				  }
          contacts->updateContact(uin.toULong(),status, ip, port, mode, lanip, version);																			
				}
				break;
				case 0x0C: // user Offline
				{
					Q_UINT8 l;
					QString uin;
					*s >> (Q_UINT8 &)l;					
					char *tmpstr=new char[l+1];
					s->readRawBytes(tmpstr, l);
					tmpstr[l]=0;
					uin=tmpstr;			
					delete tmpstr;		
					emit signalContactStatusChange(uin.toULong(),0xFFFF,0);					
				}
				break;
			}
		break;
		case 0x04: //Messages
			switch(subType)
			{
				case 0x01: // error
					debug("Error Ack %d",requestID);
					emit receivedErrorAck(requestID, 0);
					break;
				case 0x07: // Incomming Message
				{
					debug("Got new Messages !!!!");
					Q_UINT32 msgid1, msgid2;
					*s >> (Q_UINT32 &) msgid1;
					*s >> (Q_UINT32 &) msgid2;
					Q_UINT16 format;
					Q_UINT8 len;
					char *_uinStr;
					*s >> (Q_UINT16 &) format;
					*s >> (Q_UINT8  &) len;
					_uinStr=new char[len+1];
					s->readRawBytes(_uinStr, len);
					_uinStr[len]=0;
					QString uinStr=_uinStr;
					delete _uinStr;
				
					Q_UINT16 num, warning;
					
					*s >> (Q_UINT16 &) warning;
					*s >> (Q_UINT16 &) num;
					
					debug("Message: num TLV: %d, warning: %d",num,warning);
					
					if (num>0) parseTLVList(s,num);			
						
					debug("Message type %d(%X), UIN: %s",format, format, uinStr.latin1());
					
					switch(format)
					{
						case 0x01: // message	
						{
    					Q_UINT16 TLVtype, TLVlen;
    					
    					*s >> (Q_UINT16 &) TLVtype; // fake, this is way easier
    					*s >> (Q_UINT16 &) TLVlen; // fake, this is way easier										
    					
    					Q_UINT32 u1;
    					Q_UINT8  u2;
    					
    					*s >> (Q_UINT8 &) u2;    // 05
    					*s >> (Q_UINT32 &) u1;   // 01010101
    					
    					Q_UINT16 msgLen;
    					char *msg;
    					
    					*s >> (Q_UINT32 &) msgLen;
    					msgLen-=4;
    					*s >> (Q_UINT32 &) u1;
    					
    					msg=new char[msgLen+25];
    					s->readRawBytes(msg, msgLen);
    					msg[msgLen]=0;		
    					
    					debug("Message [%s]",msg);
    					
    				  kxMessageStruct message;
						  message.uin = QString(uinStr).toULong();
						  message.type=MESSAGE_TYPE;
						  message.send=FALSE;
						  message.useColor=FALSE;
			        message.online = TRUE;
			        message.message=ENGINE->Local2Unicode(msg);
			        delete msg;
			
				      QDate tmpDate(QDate::currentDate());
	    			  QTime tmpTime(QTime::currentTime());

  				    message.dateTime.setDate(tmpDate);
				      message.dateTime.setTime(tmpTime);
						
							emit receivedMessage((UIN)uinStr.toULong(), message);						
    				}	
    				break;
    				case 0x02: // advanched message
    				{
    					debug("Advanched message !!");
    					Q_UINT16 st;
    					Q_UINT32 u32, _msgid1, _msgid2;
    					*s >> (Q_UINT16 &) st;
    					*s >> (Q_UINT32 &) _msgid1;
    					*s >> (Q_UINT32 &) _msgid2;
    					
    					*s >> (Q_UINT32 &) u32; *s >> (Q_UINT32 &) u32; *s >> (Q_UINT32 &) u32; *s >> (Q_UINT32 &) u32;
    					
    					parseTLVList(s);
    					
    					debug("??A: %d, MSGid %X%X = %X%X ",st, msgid1, msgid2, _msgid1, _msgid2);
    					
    					tlvDef *TLV=getTLV(0x2711);
    					if (TLV)
              {
    	          QByteArray  a;
    				    a.setRawData( TLV->text, TLV->len);
    				    debug("Open Stream with :%d",TLV->len);
    				    QDataStream st( a, IO_ReadOnly );            // open on a's data
    				
    				    char *tlvstart=TLV->text;
    				
    				    sendMessage2Ack((UIN)uinStr.toULong(), msgid1, msgid2, format, tlvstart);
    				
    				    Q_UINT16 u16;
    				    Q_UINT32 u32;
    				    Q_UINT8  u8;
    				
    				    st >> (Q_UINT16 &) u16;
    				    st >> (Q_UINT8  &) u8;
    				
    				    st >> (Q_UINT32 &) u32; st >> (Q_UINT32 &) u32; st >> (Q_UINT32 &) u32; st >> (Q_UINT32 &) u32;
    				    st >> (Q_UINT16 &) u16; st >> (Q_UINT8  &) u8;
    				
								st >> (Q_UINT32 &) u32;
								
								Q_UINT8  unkStatus;
								
								st >> (Q_UINT8  &) unkStatus;
								st >> (Q_UINT16 &) u16; // downcounter
								st >> (Q_UINT16 &) u16;	// 0E00							
								st >> (Q_UINT16 &) u16;	// downcounter				
								
								st >> (Q_UINT32 &) u32; st >> (Q_UINT32 &) u32; st >> (Q_UINT32 &) u32;
								
								Q_UINT8 msgType, msgFlags;
								st >> (Q_UINT8  &) msgType;
								st >> (Q_UINT8  &) msgFlags;							
								st >> (Q_UINT16 &) u16; // status
								st >> (Q_UINT16 &) u16; // priority
								
								Q_UINT16 msgLen;
      					char *msg;
      					
								st.setByteOrder(QDataStream::LittleEndian);      					
      					st >> (Q_UINT16 &) msgLen;
      					
       					msg=new char[msgLen+1];
  	  					st.readRawBytes(msg, msgLen);
      					msg[msgLen]=0;
      					
      					parseMessages(uinStr, msgType, msg, &st, 0x02); //advanched message
      					
    				  }				
    				}
    				break;
						case 0x04: // URL etc or advanched message
						{
							
						
    					Q_UINT16 TLVtype, TLVlen;
    					
    					*s >> (Q_UINT16 &) TLVtype; // fake, this is way easier
    					debug("TVL in advanched message (must be 5): %d",TLVtype);
    					*s >> (Q_UINT16 &) TLVlen; // fake, this is way easier										
    					
    					Q_UINT32 uin;
    					Q_UINT8  msgType;
    					Q_UINT8  flag;
    					
    					*s >> (Q_UINT32 &) uin;
    					debug("UIN: %d, %X",uin, uin);
    					*s >> (Q_UINT8 &) msgType;
    					*s >> (Q_UINT8 &) flag;
    					
    					Q_UINT16 msgLen=0;
    					char *msg;
    					s->setByteOrder(QDataStream::LittleEndian);
    					*s >> (Q_UINT16 &) msgLen;
    					debug("Len?: %d (%X)",msgLen, msgLen);
     					msg=new char[msgLen+25];
	  					s->readRawBytes(msg, msgLen);
    					msg[msgLen]=0;		
    					
    					if (msgType==0x1a)
    					{
    					   	s->setByteOrder(QDataStream::BigEndian);
   	Q_UINT32 u32;
   	Q_UINT16 u16;
   	
   	*s >> (Q_UINT32 &)u32;
   	debug("%X",u32);
   	*s >> (Q_UINT32 &)u32; *s >> (Q_UINT32 &)u32; *s >> (Q_UINT32 &)u32; *s >> (Q_UINT32 &)u32;
   	*s >> (Q_UINT32 &)u32; *s >> (Q_UINT32 &)u32; *s >> (Q_UINT32 &)u32; *s >> (Q_UINT32 &)u32;
   	*s >> (Q_UINT16 &)u16;
   	debug("%X",u32);
		Q_UINT32 len;
		s->setByteOrder(QDataStream::LittleEndian);
		* s >> (Q_UINT32 &)len;
		char str[len+2];
		s->readRawBytes(str, len);	
		str[len]=0;
		QString msg1=str;
		debug("SMS reply: %s",msg1.latin1());
		kxMessageStruct message;
    message.uin = QString(uinStr).toULong();
    message.send=FALSE; 						
    message.online = TRUE;
    message.useColor=FALSE;
      			
    QDate tmpDate(QDate::currentDate());
    QTime tmpTime(QTime::currentTime());

    message.dateTime.setDate(tmpDate);
    message.dateTime.setTime(tmpTime);
    message.type=SMS_TYPE;
    message.message=QString::fromLocal8Bit(msg1);

    QString uinStr;
		QDomDocument d;
		d.setContent(msg1);
		QDomNode n = d.firstChild();
		while( !n.isNull() )
		{
			QDomNodeList l=n.childNodes();
			for (Q_UINT16 t=0; t<=l.length(); t++)
			{
/*				if (l.item(t).toElement().tagName()=="message_id")
				{
					uinStr=l.item(t).toElement().text();
			 	  QStringList urllist;
			 	  urllist=QStringList::split('-', uinStr, TRUE);
			    message.uin=(*urllist.at(0)).toULong();					
				}*/
				if (l.item(t).toElement().tagName()=="destination_UIN")
				{
					uinStr=l.item(t).toElement().text();
					message.uin=uinStr.toULong();
				}
				if (l.item(t).toElement().tagName()=="destination")
				{
					uinStr=l.item(t).toElement().text();
					for (Q_UINT16 y=0; y<ENGINE->CONTACT->count(); y++)
					{
        		QStringList gsm=QStringList::split(' ',ENGINE->CONTACT->getContact(y).gsm);
//            debug("%s - %s - %s - %s", (*gsm.at(0)).latin1(), (*gsm.at(1)).latin1(),(*gsm.at(2)).latin1(),(*gsm.at(3)).latin1());
       	    QString country=(*gsm.at(0));
       			QString prefix=(*gsm.at(1));
       			QString number=(*gsm.at(2));
       	    country.replace(QRegExp("[()+]"),"");
       	    prefix.replace(QRegExp("[()+]"),"");
       	    number.replace(QRegExp("[()+]"),"");
       	    QString g;
       	    g.sprintf("%s%s%s",country.latin1(), prefix.latin1(), number.latin1());
       	    debug("Try: %s = %s",g.latin1(), uinStr.latin1());
       	    if (g==uinStr)
       	    {
       	    	message.uin=ENGINE->CONTACT->getContact(y).uin;       	
       	    	y=ENGINE->CONTACT->count()+1;
       	    }
       	  }
				}				
			}		
			n=n.nextSibling();
		}			
 		
		debug("Message ID %d",message.uin);
        		
		receivedSMSReply(message.uin,message);
						}
						else
    					
    					
    					parseMessages(uinStr, msgType, msg, s, 0x02); // advanched message
							
    				}	
    				break;    				
    			}
    		}
				break;
				case 0x0B: // auto-msg
				{
					debug("Ack to type-2 message ?");
					
					char *msg;
					Q_UINT16 unk16, seq;
					Q_UINT8  unk8;
					Q_UINT32 unk32;					

					*s >> (Q_UINT32 &) unk32; *s >> (Q_UINT32 &) unk32;
					*s >> (Q_UINT16 &) unk16;
    					
					Q_UINT8 uinLen;
//					s->setByteOrder(QDataStream::LittleEndian);		
					*s >> (Q_UINT8  &) uinLen;
					debug("Len: %d",uinLen);
					msg=new char[uinLen+1];
					s->readRawBytes(msg, uinLen);
					msg[uinLen]=0;
					QString uinStr=msg;
					delete msg;					
					
//					s->setByteOrder(QDataStream::BigEndian);

					// skip 26
					*s >> (Q_UINT32 &) unk32; *s >> (Q_UINT32 &) unk32; *s >> (Q_UINT32 &) unk32;
					*s >> (Q_UINT32 &) unk32; *s >> (Q_UINT32 &) unk32; *s >> (Q_UINT32 &) unk32;
					*s >> (Q_UINT32 &) unk32;					
					
					*s >> (Q_UINT8  &) unk8;
					*s >> (Q_UINT16 &) seq;
//					debug("UIN: %u, Seq: %d, %X",uinStr.toULong(),seq, seq);
					
					//skip 16
					*s >> (Q_UINT32 &) unk32; *s >> (Q_UINT32 &) unk32; *s >> (Q_UINT32 &) unk32;
					*s >> (Q_UINT32 &) unk32;
					
					Q_UINT8 status;
					*s >> (Q_UINT8  &) status;
					*s >> (Q_UINT8  &) unk8;
					*s >> (Q_UINT32 &) unk32;
					
					s->setByteOrder(QDataStream::LittleEndian);
					Q_UINT16 len;
					*s >> (Q_UINT16  &) len;
					debug("Len: %d",len);
					msg=new char[len+25];
					s->readRawBytes(msg, len);
					msg[len]=0;
					QString msgStr=msg;
					delete msg;					
					
					debug("Status: %d, %s",status, msgStr.latin1());
					if (msgStr.length()>0 && status!=4)
					{
						debug("Ok got Message.. emit");
						emit receivedStatusMessage(uinStr.toULong(), msgStr);
					}
					emit receivedAck(seq);
				}
				break;
				case 0x0C: // ack
				{
					debug("Ack to message ?");
				}
				break;
			}
		break;		
		case 0x15: //Server messages
			switch(subType)
			{
				case 0x03: // Many things
				{
					debug("Got SNAC 15,3 !!");
					Q_UINT16 u16;
					Q_UINT32 u32;
					
					
					*s >> (Q_UINT16 &) u16; // tlv 1
					*s >> (Q_UINT16 &) u16; // tlv len
					
					s->setByteOrder(QDataStream::LittleEndian);
					
					*s >> (Q_UINT16 &) u16; // len again ?
					*s >> (Q_UINT32 &) u32; // our uin
					
					Q_UINT16 type;
					Q_UINT16 reqSeq;
					
					*s >> (Q_UINT16 &) type; // type
					*s >> (Q_UINT16 &) reqSeq; // request Seq
					
					debug("SNAC 15,3 type: %X (%d) ",type, type);
					
					switch(type)
					{
						case 0x0041: // offline message
						{
							debug("Offline message !");
							
							Q_UINT32 hisUin;							
							Q_UINT16 year;
							Q_UINT8 month, day, hour, min, type, flag;
							Q_UINT16 len;
							
							kxMessageStruct message;
							
							*s >> (Q_UINT32 &) hisUin;
							*s >> (Q_UINT16 &) year;
							*s >> (Q_UINT8  &) month;
							*s >> (Q_UINT8  &) day;
							*s >> (Q_UINT8  &) hour;
							*s >> (Q_UINT8  &) min;
							*s >> (Q_UINT8  &) type;
							*s >> (Q_UINT8  &) flag;
							*s >> (Q_UINT16 &) len;
							
							debug("UIN for offline message: %d, type: %d",hisUin, type);
							
				      QDate tmpDate(year,month,day);
				      QTime tmpTime(hour,min);

				      message.dateTime.setDate(tmpDate);
				      message.dateTime.setTime(tmpTime);
				
				      message.uin = hisUin;						
						  message.send=FALSE;
						  message.useColor=FALSE;
						
							char *tmp;
				      tmp=new char[len+1];
				      s->readRawBytes(tmp, len);
				      tmp[len]=0;
				
				      QString uinStr;
				      uinStr.sprintf("%d",hisUin);
				
				      parseMessages(uinStr, type, tmp, s, 0x41);  //offline message
									
						}
							break;
						case 0x0042: // end Offline messages
							debug("End of offline messages !");
							sendAckRequestOfflineMessages();

							break;
						case 0x07DA: // search etc..
						{
							Q_UINT16 subType;
							Q_UINT8  result;
							
							*s >> (Q_UINT16 &) subType; // subType
							*s >> (Q_UINT8  &) result; // result
							
							debug("Search type: %X result: %X",subType, result);
							
							if (result==0x32 || result==0x14 || result==0x1E)
							{
								debug("Error found in search...");
								emit receivedMetaSearchFailed(reqSeq);
							}
							else
							{
								if (flag1==0x00)
								{
									debug("Search End");
									emit searchEnd(reqSeq);
								}
								switch(subType)
								{
									case 0xDC: // homepage-more-info
									{
										Q_UINT8 age, sex, u8, birthMonth, birthDay, lan1, lan2, lan3;
										Q_UINT16 birthYear;
										QString homepage;
										*s >> (Q_UINT8 &) age;
										*s >> (Q_UINT8 &) u8;
										*s >> (Q_UINT8 &) sex;
										
										char *tmpstr;										
										Q_UINT16 l;
										
										*s >> (Q_UINT16 &) l;										
										tmpstr=new char[l+1];
            				s->readRawBytes(tmpstr, l);
            				tmpstr[l]=0;            				
            				homepage=ENGINE->Local2Unicode(tmpstr);
            				delete tmpstr;
   									s->setByteOrder(QDataStream::LittleEndian);

										*s >> (Q_UINT16 &) birthYear;
										*s >> (Q_UINT8 &) birthMonth;
										*s >> (Q_UINT8 &) birthDay;
										*s >> (Q_UINT8 &) lan1;
										*s >> (Q_UINT8 &) lan2;
										*s >> (Q_UINT8 &) lan3;
										
										emit receivedMoreInfo(reqSeq, (Q_UINT8 ) age, sex, homepage, birthYear, birthDay, birthMonth,lan1, lan2, lan3);
            														
									}
										break;
									case 0xC8: // home-info
									{
										
										QString nick, first, last, email, city, state, phone, fax, street, cellular, zip;
										Q_UINT16 country;
										Q_UINT8 gmt, pubEmail;
										
										char *tmpstr;										
										Q_UINT16 l;
										
										*s >> (Q_UINT16 &) l;										
										tmpstr=new char[l+1];
            				s->readRawBytes(tmpstr, l);
            				tmpstr[l]=0;            				
            				nick=ENGINE->Local2Unicode(tmpstr);
            				delete tmpstr;
            				
										*s >> (Q_UINT16 &) l;										
										tmpstr=new char[l+1];
            				s->readRawBytes(tmpstr, l);
            				tmpstr[l]=0;            				
            				first=ENGINE->Local2Unicode(tmpstr);
            				delete tmpstr;
            				
										*s >> (Q_UINT16 &) l;										
										tmpstr=new char[l+1];
            				s->readRawBytes(tmpstr, l);
            				tmpstr[l]=0;            				
            				last=ENGINE->Local2Unicode(tmpstr);
            				delete tmpstr;

										*s >> (Q_UINT16 &) l;										
										tmpstr=new char[l+1];
            				s->readRawBytes(tmpstr, l);
            				tmpstr[l]=0;            				
            				email=ENGINE->Local2Unicode(tmpstr);
            				delete tmpstr;
            				
										*s >> (Q_UINT16 &) l;										
										tmpstr=new char[l+1];
            				s->readRawBytes(tmpstr, l);
            				tmpstr[l]=0;            				
            				city=ENGINE->Local2Unicode(tmpstr);
            				delete tmpstr;
            				
										*s >> (Q_UINT16 &) l;										
										tmpstr=new char[l+1];
            				s->readRawBytes(tmpstr, l);
            				tmpstr[l]=0;            				
            				state=ENGINE->Local2Unicode(tmpstr);
            				delete tmpstr;
            				
										*s >> (Q_UINT16 &) l;										
										tmpstr=new char[l+1];
            				s->readRawBytes(tmpstr, l);
            				tmpstr[l]=0;            				
            				phone=ENGINE->Local2Unicode(tmpstr);
            				delete tmpstr;

										*s >> (Q_UINT16 &) l;										
										tmpstr=new char[l+1];
            				s->readRawBytes(tmpstr, l);
            				tmpstr[l]=0;            				
            				fax=ENGINE->Local2Unicode(tmpstr);
            				delete tmpstr;
            				
										*s >> (Q_UINT16 &) l;										
										tmpstr=new char[l+1];
            				s->readRawBytes(tmpstr, l);
            				tmpstr[l]=0;            				
            				street=ENGINE->Local2Unicode(tmpstr);
            				delete tmpstr;
            				
										*s >> (Q_UINT16 &) l;										
										tmpstr=new char[l+1];
            				s->readRawBytes(tmpstr, l);
            				tmpstr[l]=0;            				
            				cellular=ENGINE->Local2Unicode(tmpstr);
            				delete tmpstr;
            				//ENGING->CONTACT->setGSM(uin, cellular);
            				
										*s >> (Q_UINT16 &) l;										
										tmpstr=new char[l+1];
            				s->readRawBytes(tmpstr, l);
            				tmpstr[l]=0;            				
            				zip=ENGINE->Local2Unicode(tmpstr);
            				delete tmpstr;
            				

            				*s >> (Q_UINT16 &) country;
            				*s >> (Q_UINT8  &) gmt;            				
            				debug("Country AIM %d",country);            				
            				Q_UINT8 u1, u2;
            				*s >> (Q_UINT8  &) u1;
            				*s >> (Q_UINT8  &) u2;            				
            				*s >> (Q_UINT8 &) pubEmail;

            				debug("Found home-info: nick: %s - %s %d",nick.latin1(), email.latin1(), pubEmail);
										emit receivedMainHomeInfo(reqSeq, nick, first, last, email, city, state, phone, fax, street, cellular, zip, country, gmt, !pubEmail);										
									}
									break;
									case 0x019A: // reply to show info or search by UIN
									case 0x0190: // reply to seach by UIN
									{
										QString first, last, nick, email;
										Q_UINT8 auth;
										Q_UINT8 u81;
										Q_UINT8 status;
										Q_UINT16 u16;
										Q_UINT32 _uin;
										
										
										*s >> (Q_UINT16 &) u16;
										*s >> (Q_UINT32 &) _uin;

										char *tmpstr;										
										Q_UINT16 l;
										
										*s >> (Q_UINT16 &) l;										
										tmpstr=new char[l+1];
            				s->readRawBytes(tmpstr, l);
            				tmpstr[l]=0;
            				
            				nick=ENGINE->Local2Unicode(tmpstr);
            				delete tmpstr;																				
										
										*s >> (Q_UINT16 &) l;										
										tmpstr=new char[l+1];
            				s->readRawBytes(tmpstr, l);
            				tmpstr[l]=0;
            				
            				first=ENGINE->Local2Unicode(tmpstr);
            				delete tmpstr;
            				
										*s >> (Q_UINT16 &) l;										
										tmpstr=new char[l+1];
            				s->readRawBytes(tmpstr, l);
            				tmpstr[l]=0;
            				
            				last=ENGINE->Local2Unicode(tmpstr);
            				delete tmpstr;
            				
										*s >> (Q_UINT16 &) l;										
										tmpstr=new char[l+1];
            				s->readRawBytes(tmpstr, l);
            				tmpstr[l]=0;
            				
            				email=ENGINE->Local2Unicode(tmpstr);
            				delete tmpstr;
            				
            				Q_UINT32 togo;
            				
            				*s >> (Q_UINT8 &) auth;
            				*s >> (Q_UINT8 &) status;
										*s >> (Q_UINT8 &) u81;            				
            				*s >> (Q_UINT32 &) togo;             				
            				
            				debug("Found UIN: %s, %s %s, %s.. Auth: %d, status %X, todo: %d -- %X,%X ",
            					nick.latin1(), first.latin1(), last.latin1(), email.latin1(),auth, status,togo,
            					u16, u81);
            					
            				bool isLast=flag1==0x01?FALSE:TRUE;
            				emit receivedMetaSearch(reqSeq, _uin, nick, first, last,email, auth,status, isLast);	
            				
									}
									break;
									case 0xEB: //email info
									{
										debug("Email List receive");
										Q_UINT8 len;
										s->setByteOrder(QDataStream::LittleEndian);
										*s >> (Q_UINT8 &)len;
										QStringList list;
										for (Q_UINT8 t=0; t<len; t++)
										{
											Q_UINT8 publish;
											Q_UINT16 l;
											*s >> (Q_UINT8 &)publish;
											*s >> (Q_UINT16 &)l;
											char email[l+1];
											s->readRawBytes(email,l);
											list << email;
											list << (publish==0?"Y":"N");
										}								
										emit receivedEmailInfo(reqSeq, list);	
									}
									break;
									case 0xD2: // work info
									{
										debug("received WORK info..");
										s->setByteOrder(QDataStream::LittleEndian);
										QString city, state, street, zip, compName, compDept, compPos, compWeb,phone, fax;
										Q_UINT16 country;
										Q_UINT16 len, u16;
										char *str;
										
										*s >> (Q_UINT16 &)len;
										str= new char[len+1];
										s->readRawBytes(str, len);
							city=ENGINE->Local2Unicode(str);
										delete str;
										*s >> (Q_UINT16 &)len;
										str= new char[len+1];
										s->readRawBytes(str, len);
							state=ENGINE->Local2Unicode(str);
										delete str;
										*s >> (Q_UINT16 &)len;
										str= new char[len+1];
										s->readRawBytes(str, len);
							phone=ENGINE->Local2Unicode(str);
										delete str;
										*s >> (Q_UINT16 &)len;
										str= new char[len+1];
										s->readRawBytes(str, len);
							fax=ENGINE->Local2Unicode(str);
										delete str;
										*s >> (Q_UINT16 &)len;
										str= new char[len+1];
										s->readRawBytes(str, len);
							street=ENGINE->Local2Unicode(str);
										delete str;
										*s >> (Q_UINT16 &)len;
										str= new char[len+1];
										s->readRawBytes(str, len);
							zip=ENGINE->Local2Unicode(str);
										delete str;
										*s >> (Q_UINT16 &)country;
										*s >> (Q_UINT16 &)len;
										str= new char[len+1];
										s->readRawBytes(str, len);
							compName=ENGINE->Local2Unicode(str);
										delete str;
										*s >> (Q_UINT16 &)len;
										str= new char[len+1];
										s->readRawBytes(str, len);
							compDept=ENGINE->Local2Unicode(str);
										delete str;
										*s >> (Q_UINT16 &)len;
										str= new char[len+1];
										s->readRawBytes(str, len);
							compPos=ENGINE->Local2Unicode(str);
										delete str;
										*s >> (Q_UINT16 &)u16;
										*s >> (Q_UINT16 &)len;
										str= new char[len+1];
										s->readRawBytes(str, len);
							compWeb=ENGINE->Local2Unicode(str);
										delete str;
										
										emit receivedWorkInfo(reqSeq, city, state, phone, fax,street, zip, compName,compDept, compPos, compWeb, country, u16);
										
									}
									break;
									case 0xE6:
									{
										debug("received About info..");
										s->setByteOrder(QDataStream::LittleEndian);
										QString about;
										char *str;
										
										*s >> (Q_UINT16 &)len;
										str= new char[len+1];
										s->readRawBytes(str, len);
							about=ENGINE->Local2Unicode(str);
										delete str;
										
										emit receivedAboutInfo(reqSeq, about);
										
									}
									break;
									case 0x96: // SMS reply
									{
										Q_UINT16 u161, u162, u163, len;
										Q_UINT16 uinLen;
										QString smsMsg, rUin;
										s->setByteOrder(QDataStream::BigEndian);
										*s >> (Q_UINT16 &)u161;
										*s >> (Q_UINT16 &)u162;
										*s >> (Q_UINT16 &)u163;
										
										*s >> (Q_UINT16 &)uinLen;
										debug("Len: %d",uinLen);
										char recUin[uinLen+1];
										s->readRawBytes(recUin, uinLen);
										recUin[uinLen+1]=0;
										rUin=recUin;
										
										*s >> (Q_UINT16 &)len;
										debug("Len: %d",len);
										char msg[len+1];
										s->readRawBytes(msg, len);
										msg[len]=0;
										smsMsg=msg;
										
										debug("Reveived SMS reply, uin: %s, %X,%X,%X, msg: %s",recUin, u161, u162, u163, msg);
										emit receivedSMSAck(reqSeq, rUin, smsMsg);
									}
								}
							}
						}
						break;
					}
				}
				break;
			}
		break;	
	}
	debug("clear TLV List");
	clearTLVList();
}
void kxAIM::parseMessages(const QString &uinStr, Q_UINT16 msgType, char *msg, QDataStream *st, Q_UINT16 subType)
{
  kxMessageStruct message;
  debug("Message [%s]  MsgType: %d (%X)",msg, msgType, msgType);
     					    				
  message.uin = QString(uinStr).toULong();
  message.send=FALSE; 						
  message.online = TRUE;
  message.useColor=FALSE;
    			
  QDate tmpDate(QDate::currentDate());
  QTime tmpTime(QTime::currentTime());

  message.dateTime.setDate(tmpDate);
  message.dateTime.setTime(tmpTime);			              													
  switch(msgType)
  {
   case 0x0001:
   {
   	Q_UINT32 foreColor=0;
   	Q_UINT32 backColor=0;    									
    *st >> (Q_UINT32 &) foreColor;        	
   	*st >> (Q_UINT32 &) backColor;
    debug("Color: %X, %X",foreColor, backColor);
   	message.type=MESSAGE_TYPE;
   	message.message=ENGINE->Local2Unicode(msg);
   	delete msg;
    			
   	if (subType==0x02) //advanched message
   	{    	
    	message.useColor=TRUE;
    	Q_UINT32 c=foreColor;
      Q_UINT8 p1, p2, p3, p4;
    	p1=c;
    	c>>= 8;
    	p2=c;
    	c>>=8;
    	p3=c;
    	c>>=8;
    	p4=c;
      message.foreground.setRgb(p1,p2,p3);
      c=backColor;
    	p1=c;
    	c>>= 8;
    	p2=c;
    	c>>=8;
    	p3=c;
    	c>>=8;
    	p4=c;
      message.background.setRgb(p1,p2,p3);
    }
    if (message.message.length()>0)						  		
       emit receivedMessage((UIN)QString(uinStr).toULong(), message);
    else
     	debug("Message Empty, reject ??????????");	                  	
   }
   	break;
   case 0x0004:
   {
   	 message.type=URL_TYPE;
   	
   	 QStringList urllist;
   	 urllist=QStringList::split(0xFE, msg, TRUE);
   	 debug("Count: %d",urllist.count());
   	 delete msg;
   	
//   	 QStringList::Iterator it=
		message.message=(ENGINE->Local2Unicode(*urllist.at(0)));	
		message.url=(ENGINE->Local2Unicode(*urllist.at(1)));

     emit receivedUrl((UIN)uinStr.toULong(), message);						
   }
   	break;						  		
   case 0x0006:
   {
   	message.type=REQUEST_TYPE;
   	
   	QStringList reqlist;
   	reqlist=QStringList::split(0xFE, msg, TRUE);
   	debug("Count: %d",reqlist.count());
   	delete msg;
   							  		
		message.nick=ENGINE->Local2Unicode(*reqlist.at(0));		
		message.firstName=ENGINE->Local2Unicode(*reqlist.at(1));	
		message.lastName=ENGINE->Local2Unicode(*reqlist.at(2));	
    message.email=(*reqlist.at(3));
    message.auth_request=(*reqlist.at(4))=="1"?TRUE:FALSE;
		message.message=ENGINE->Local2Unicode(*reqlist.at(5));		

   	emit receivedAuth((UIN)uinStr.toULong(), message);
   }
   	break;	
   case 0x0007: //rejected auth
   {
   	message.type=REJECT_TYPE;
   	message.message=ENGINE->Local2Unicode(msg);
   	delete msg;
   	emit receivedAuthReply((UIN)uinStr.toULong(), message);
   }
    break;
   case 0x0008: //granted auth
   {
   	message.type=AUTH_TYPE;
   	delete msg;
   	emit receivedAuthReply((UIN)uinStr.toULong(), message);
   }
    break;    					  	
   case 0x001a:
   {
//   	message.type=SMS_TYPE;
   	delete msg;
   	debug("Got Allround");
   	Q_UINT16 type;
   	Q_UINT32 u32;
   	Q_UINT16 u16;
   	Q_UINT8 u8;
   	Q_UINT32 len;
   	QString Msg, Mtype;
   	st->setByteOrder(QDataStream::LittleEndian);
   	*st >> (Q_UINT16 &) type;
   	debug("Type: %d",type);
   	*st >> (Q_UINT32 &) u32; *st >> (Q_UINT32 &) u32; *st >> (Q_UINT32 &) u32; *st >> (Q_UINT32 &) u32;
		*st >> (Q_UINT16 &) u16;
		
		*st >> (Q_UINT32 &) len;
		debug("Len: %d(%X)",len,len);
		char ty[len+2];
		st->readRawBytes(ty, len);
		ty[len]=0;
		Mtype=ty;
		debug("Type: %s",Mtype.latin1());
//		*st >> (Q_UINT32 &) u32;
		*st >> (Q_UINT32 &) u32;
		*st >> (Q_UINT16 &) u16;
		*st >> (Q_UINT8 &) u8;   	  	
		*st >> (Q_UINT32 &) len;
		debug("Len: %d",len);
		char ms[len+2];
		st->readRawBytes(ms, len);
		ms[len]=0;
		Msg=ms;
		debug("Msg: %s",Msg.latin1());
		switch(type)
		{
			case 0x3B:
			{
       	 message.type=URL_TYPE;
       	
       	 QStringList urllist;
       	 urllist=QStringList::split(0xFE, Msg, TRUE);
       	 debug("Count: %d",urllist.count());

         message.message=(*urllist.at(0));
         message.url=(*urllist.at(1));
         debug("debug: %s",(*urllist.at(1)).latin1());
         debug("debug: %s",message.url.latin1());

         emit receivedUrl((UIN)uinStr.toULong(), message);					
       }
     }	
   }	
   	break;
   case 0x000C: // added by User
   {
    	message.type=ADDED_TYPE;
     	QStringList reqlist;
     	reqlist=QStringList::split(0xFE, msg, TRUE);
     	debug("Count: %d",reqlist.count());
     	delete msg;
     							  		
		message.nick=ENGINE->Local2Unicode(*reqlist.at(0));	
		message.firstName=ENGINE->Local2Unicode(*reqlist.at(1));	
		message.lastName=ENGINE->Local2Unicode(*reqlist.at(2));	
      message.email=(*reqlist.at(3));           	
      message.auth_request=(*reqlist.at(4))=="1"?TRUE:FALSE;
    	message.message=ENGINE->Local2Unicode(*reqlist.at(5));	

    	emit receivedAdded((UIN)uinStr.toULong(), message);
   }
   	break;
   case 0x0013:  // received contacts
   {
   			message.type=CONTACTS_TYPE;
   			char *tmp=msg;
   		  char tmpdelim[ 2 ];
        tmpdelim[ 0 ] = 0xFE;
        tmpdelim[ 1 ] = '\0';
        message.list.setAutoDelete(TRUE);
        kxAddContactStruct *c;
        char *p1,*p = kxicqStrSep( &msg, tmpdelim );
        do
        {
              p  = kxicqStrSep( &msg, tmpdelim );
              p1 = kxicqStrSep( &msg, tmpdelim );
              if (p)
              {
                      debug("Ask to add: %s (%s)",p, p1);
                      c=new kxAddContactStruct;
				c->nick=ENGINE->Local2Unicode(p1);	
                      c->uin=atoi(p);
                      message.list.append(c);
              }
        }
        while(p);
        delete tmp;

        emit receivedContacts((UIN)uinStr.toULong(),message);				
   }
   break;
   case 0x00e8:
   	debug("Status Message request");
   	break;

  }
}


/** No descriptions */
void kxAIM::sendImICQ()
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send I'm ICQ");

	length+=addSNACHeader(&s, 0x01, 0x17);
	
	Q_UINT16 v3=0x03, v1=0x01;

  s << (Q_UINT16) SNAC_FAM_GEN << (Q_UINT16) v3;
  s << (Q_UINT16) SNAC_FAM_LOC << (Q_UINT16) v1;
  s << (Q_UINT16) SNAC_FAM_BUD << (Q_UINT16) v1;
  s << (Q_UINT16) SNAC_FAM_SRV << (Q_UINT16) v1;
  s << (Q_UINT16) SNAC_FAM_MSG << (Q_UINT16) v1;
  s << (Q_UINT16) SNAC_FAM_INV << (Q_UINT16) v1;
  s << (Q_UINT16) SNAC_FAM_BOS << (Q_UINT16) v1;
  s << (Q_UINT16) SNAC_FAM_LUP << (Q_UINT16) v1;

  length+=32;
	
  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);
}
/** No descriptions */
void kxAIM::sendRateRequest()
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send Rate Request");

	length+=addSNACHeader(&s, 0x01, 0x06);	
	
  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);
}
void kxAIM::sendRateRequestAck()
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send Rate Request Ack");

	length+=addSNACHeader(&s, 0x01, 0x08);	
	
	Q_UINT16 l;
	l=0x01;
	s << (Q_UINT16 ) l;
	l=0x02;
	s << (Q_UINT16 ) l;
	l=0x03;
	s << (Q_UINT16 ) l;
	l=0x04;
	s << (Q_UINT16 ) l;
	l=0x05;
	s << (Q_UINT16 ) l;
	
	length+=10;
	
  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);
}
/** No descriptions */
void kxAIM::requestPersonalInfo()
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send Request Personal Info");

	length+=addSNACHeader(&s, 0x01, 0x0E);	
	
  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);
}
/** No descriptions */
void kxAIM::requestRightInfoLocationService()
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send Request Info Location Serice");

	length+=addSNACHeader(&s, 0x02, 0x02);	
	
  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);
}
/** No descriptions */
void kxAIM::requestRightInfoBubbyList()
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send Request Info Buddy List");

	length+=addSNACHeader(&s, 0x03, 0x02);	
	
  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);
}
/** No descriptions */
void kxAIM::requestICBM()
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send Request ICBM");

	length+=addSNACHeader(&s, 0x04, 0x04);	
	
  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);
}
/** No descriptions */
void kxAIM::requestBOS()
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send Request BOS");

	length+=addSNACHeader(&s, 0x09, 0x02);	
	
  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);
}
void kxAIM::sendICQMode()
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send ICQ Mode");

	length+=addSNACHeader(&s, 0x04, 0x02);	
	
	s << (Q_UINT32 ) 0x00000000;
	s << (Q_UINT32 ) 0x00031F40;
	s << (Q_UINT32 ) 0x03E703E7;
	s << (Q_UINT32 ) 0x00000000;
	
	length+=16;	
	
  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);
}
void kxAIM::sendUserInfo()
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send ICQ Mode");

	length+=addSNACHeader(&s, 0x02, 0x04);	
	
	s << (Q_UINT16 ) 0x05;
	s << (Q_UINT16 ) 0x20;
	s << (Q_UINT32 ) 0x09461349;
	s << (Q_UINT32 ) 0x4c7f11d1;
	s << (Q_UINT32 ) 0x82224445;
	s << (Q_UINT32 ) 0x53540000;
	s << (Q_UINT32 ) 0x09491344;
	s << (Q_UINT32 ) 0x4c7f11d1;
	s << (Q_UINT32 ) 0x82224445;
	s << (Q_UINT32 ) 0x53540000;
	
	length+=36;	
	
  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);

}

void kxAIM::sendClientReady()
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send Client Ready");

	length+=addSNACHeader(&s, 0x01, 0x02);	
  	s << (Q_UINT32) 0x00010003
      << (Q_UINT32) 0x0110028a
      << (Q_UINT32) 0x00020001
      << (Q_UINT32) 0x0101028a
      << (Q_UINT32) 0x00030001
      << (Q_UINT32) 0x0110028a
      << (Q_UINT32) 0x00150001
      << (Q_UINT32) 0x0110028a
      << (Q_UINT32) 0x00040001
      << (Q_UINT32) 0x0110028a
      << (Q_UINT32) 0x00060001
      << (Q_UINT32) 0x0110028a
      << (Q_UINT32) 0x00090001
      << (Q_UINT32) 0x0110028a
      << (Q_UINT32) 0x000a0001
      << (Q_UINT32) 0x0110028a;

  length+=64;	
	
  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);	
}
void kxAIM::sendInvisibleList()
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send Invisible List");

	length+=addSNACHeader(&s, 0x09, 0x07);	
	
	QString uin;
	
	for (Q_UINT16 t=0; t<ENGINE->CONTACT->count(); t++)
	{
		if (ENGINE->CONTACT->getContact(t).invisible)
		{
			uin.sprintf("%d",ENGINE->CONTACT->getContact(t).uin);
			s << (Q_UINT8 ) uin.length();
			s.writeRawBytes(uin.latin1(),uin.length());
			length+=1+uin.length();
		}
	}	
	
  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);
}
void kxAIM::sendVisibleList()
{	
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send Visible List");

	length+=addSNACHeader(&s, 0x09, 0x05);	
	
	QString uin;
	
	for (Q_UINT16 t=0; t<ENGINE->CONTACT->count(); t++)
	{
		if (ENGINE->CONTACT->getContact(t).visible)
		{
			uin.sprintf("%d",ENGINE->CONTACT->getContact(t).uin);
			debug("Send UIN: %s",uin.latin1());
			s << (Q_UINT8 ) uin.length();
			s.writeRawBytes(uin.latin1(),uin.length());
			length+=1+uin.length();
		}
	}	
	
  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);
}

void kxAIM::sendContactList()
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send Contact List");

	length+=addSNACHeader(&s, 0x03, 0x04);	
	
	QString uin;
	
	for (Q_UINT16 t=0; t<ENGINE->CONTACT->count(); t++)
	{
		uin.sprintf("%d",ENGINE->CONTACT->getContact(t).uin);
		s << (Q_UINT8 ) uin.length();
		s.writeRawBytes(uin.latin1(),uin.length());
		length+=1+uin.length();
	}	
	
  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);
}

void kxAIM::addToVisibleList(Q_UINT32 _uin)
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send add To Visible List");

	length+=addSNACHeader(&s, 0x09, 0x05);	
	
	QString uin;
	uin.sprintf("%d",_uin);
	s << (Q_UINT8 ) uin.length();
	s.writeRawBytes(uin.latin1(),uin.length());
	length+=1+uin.length();
	
  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);	
}
void kxAIM::removeFromVisibleList(Q_UINT32 _uin)
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send remove From Visible List");

	length+=addSNACHeader(&s, 0x09, 0x06);	
	
	QString uin;
	uin.sprintf("%d",_uin);
	s << (Q_UINT8 ) uin.length();
	s.writeRawBytes(uin.latin1(),uin.length());
	length+=1+uin.length();
	
  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);	
}
void kxAIM::addToInvisibleList(Q_UINT32 _uin)
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send add To InVisible List");

	length+=addSNACHeader(&s, 0x09, 0x07);	
	
	QString uin;
	uin.sprintf("%d",_uin);
	s << (Q_UINT8 ) uin.length();
	s.writeRawBytes(uin.latin1(),uin.length());
	length+=1+uin.length();
	
  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);	
}
void kxAIM::removeFromInvisibleList(Q_UINT32 _uin)
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send remove From InVisible List");

	length+=addSNACHeader(&s, 0x09, 0x08);	
	
	QString uin;
	uin.sprintf("%d",_uin);
	s << (Q_UINT8 ) uin.length();
	s.writeRawBytes(uin.latin1(),uin.length());
	length+=1+uin.length();
	
  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);	
}

void kxAIM::sendRequestOfflineMessages()
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send Request for Offline messages");

	length+=addSNACHeader(&s, 0x15, 0x02, ++messageSeq);
	
	//TLV header
	s << (Q_UINT16) 0x0001;
	s << (Q_UINT16) 0x000a; // length
	
	s.setByteOrder(QDataStream::LittleEndian);		
	s << (Q_UINT16) 0x0008;
	s << (Q_UINT32) uin;
	s << (Q_UINT16) 0x003C; // ask for offline messages
	s << (Q_UINT16) searchSequence++;
	
	length+=14;
	
	
  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);
}
void kxAIM::sendAckRequestOfflineMessages()
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send Ack Request for Offline messages");

	length+=addSNACHeader(&s, 0x15, 0x02, ++messageSeq);

	//TLV header
	s << (Q_UINT16) 0x0001;
	s << (Q_UINT16) 0x000a; // length
	
	s.setByteOrder(QDataStream::LittleEndian);		
	s << (Q_UINT16) 0x0008;
	s << (Q_UINT32) uin;
	s << (Q_UINT16) 0x003E; // ask for offline messages
	s << (Q_UINT16) searchSequence++;
	
	length+=14;
	
  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);
}
int kxAIM::sendMessage( Q_UINT32 _uin, QString msg)
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send Message");
	QCString msgLocalCode = ENGINE->Unicode2Local(msg);					
	
	messageSeq++;
	length+=addSNACHeader(&s, 0x04, 0x06, messageSeq);
	
	//Seq 8 bytes ?
	s << (Q_UINT32) 0x0000;
	s << (Q_UINT32) 0x0000;
	s << (Q_UINT16) 0x0001;		
	
	length+=10;
	
	// UIN
	QString uin;
	uin.sprintf("%d",_uin);
	s << (Q_UINT8 ) uin.length();
	s.writeRawBytes(uin.latin1(),uin.length());
	length+=1+uin.length();

	// TLV 2
  s << (Q_UINT16 ) 0x0002;
  Q_UINT16 ln=13+msgLocalCode.length();	
  s << (Q_UINT16 ) ln;

  // TLV 0501 ???

  s << (Q_UINT16 ) 0x0501;
  s << (Q_UINT16 ) 0x0001;
  s << (Q_UINT8 ) 0x01;

  // TLV 0x0101 Message
  s << (Q_UINT16 ) 0x0101;	
		
	// Len of messages + 4 ?
	Q_UINT16 len=msgLocalCode.length()+4;
	
	s << (Q_UINT16 ) len;
	s << (Q_UINT32 ) 0x0000;
	
	length+=17;
			
	s.writeRawBytes(msgLocalCode,msgLocalCode.length());
	length+=msgLocalCode.length();
	
	// TLV 6 ??? unknown why
	s << (Q_UINT16 ) 0x0006;
	s << (Q_UINT16 ) 0x0000;
	
	length+=4;

  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);

  return messageSeq;
}
int kxAIM::sendUrl( Q_UINT32 _uin, QString msg, QString url)
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send URL");
	
	length+=addSNACHeader(&s, 0x04, 0x06);

	messageSeq++;
	
	//Seq 8 bytes ?
	s << (Q_UINT32) 0x0000;
	s << (Q_UINT32) 0x0001;
	s << (Q_UINT16) 0x0004;
	length+=10;
	
	// UIN
	QString uinStr;
	uinStr.sprintf("%d",_uin);
	s << (Q_UINT8 ) uinStr.length();
	s.writeRawBytes(uinStr.latin1(),uinStr.length());
	length+=1+uinStr.length();

	QCString msgLocalCode = ENGINE->Unicode2Local(msg);	
	QCString urlLocalCode = ENGINE->Unicode2Local(url);	
	Q_UINT16 totalLen=msgLocalCode.length()+urlLocalCode.length()+2;	
	
	// TLV 5
  s << (Q_UINT16 ) 0x0005;
  Q_UINT16 ln=8+totalLen;
  s << (Q_UINT16 ) ln;

  s.setByteOrder(QDataStream::LittleEndian);	
  s << (Q_UINT32 ) uin;
  s << (Q_UINT16 ) 0x0004; // URL type
  s << (Q_UINT16 ) totalLen;
  length+=12;
	
	s.writeRawBytes(msgLocalCode,msgLocalCode.length());
	s << (Q_UINT8 ) 0xfe;

	s.writeRawBytes(urlLocalCode,urlLocalCode.length());
	s << (Q_UINT8 ) 0x00;		
	length+=totalLen;	

  s.setByteOrder(QDataStream::BigEndian);		
	// TLV 6 ??? unknown why
	s << (Q_UINT16 ) 0x0006;
	s << (Q_UINT16 ) 0x0000;	
	length+=4;

  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);

  return messageSeq;
}

int kxAIM::sendRequestInfoOnUin( Q_UINT32 _uin)
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send UIN search");
	
	length+=addSNACHeader(&s, 0x15, 0x02);

	searchSequence++;
	
	s << (Q_UINT16) 0x0001;
	s << (Q_UINT16) 0x0010; // length
	
	s.setByteOrder(QDataStream::LittleEndian);		
	s << (Q_UINT16) 0x000e; //length again ?
	s << (Q_UINT32) uin;
	s << (Q_UINT16) 2000;
	s << (Q_UINT16) searchSequence;
	
	s << (Q_UINT16) 1311;
	s << (Q_UINT32) _uin;	
	length+=20;	

  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);

  return searchSequence;
}
int kxAIM::sendRequestOwnInfo( Q_UINT32 _uin)
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send UIN search");
	
	length+=addSNACHeader(&s, 0x15, 0x02);

	searchSequence++;
	
	s << (Q_UINT16) 0x0001;
	s << (Q_UINT16) 0x0010; // length
	
	s.setByteOrder(QDataStream::LittleEndian);		
	s << (Q_UINT16) 0x000e; //length again ?
	s << (Q_UINT32) uin;
	s << (Q_UINT16) 2000;
	s << (Q_UINT16) searchSequence;
	
	s << (Q_UINT16) 0x04D0;
	s << (Q_UINT32) _uin;	
	length+=20;	

  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);

  return searchSequence;
}
int kxAIM::sendMetaSearchNick(QString _nick,QString _first, QString _last)
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send Nick/First/Last search");
	
	length+=addSNACHeader(&s, 0x15, 0x02);

	searchSequence++;

	QCString _nickLocalCode = ENGINE->Unicode2Local(_nick);	
	QCString _firstLocalCode = ENGINE->Unicode2Local(_first);	
	QCString _lastLocalCode = ENGINE->Unicode2Local(_last);	

	Q_UINT16 len=12+3+_nickLocalCode.length()+3+_firstLocalCode.length()+3+_lastLocalCode.length();	
	
	s << (Q_UINT16 ) 0x0001;
	s << (Q_UINT16 ) len;
	s.setByteOrder(QDataStream::LittleEndian);	
	s << (Q_UINT16 ) (len-2);
	s << (Q_UINT32 ) uin;
	s << (Q_UINT16 ) 0x07D0;
	s << (Q_UINT16 ) searchSequence;
	s << (Q_UINT16 ) 0x0515;
	length+=16;	
		
	s << (Q_UINT16 ) (_firstLocalCode.length()+1);	
	s.writeRawBytes((const char*)_firstLocalCode,_firstLocalCode.length());	
	s << (Q_UINT8  ) 0x00;	
	length+=3+_firstLocalCode.length();	
	
	s << (Q_UINT16 ) (_lastLocalCode.length()+1);	
	s.writeRawBytes((const char*)_lastLocalCode,_lastLocalCode.length());	
	s << (Q_UINT8  ) 0x00;	
	length+=3+_lastLocalCode.length();	

	s << (Q_UINT16 ) (_nickLocalCode.length()+1);	
	s.writeRawBytes((const char*)_nickLocalCode,_nickLocalCode.length());	
	s << (Q_UINT8  ) 0x00;
	length+=3+_nickLocalCode.length();	

  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);

  return searchSequence;
	
}
int kxAIM::sendMetaSearchEmail(QString _email)
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send EMail search");
	
	length+=addSNACHeader(&s, 0x15, 0x02);

	searchSequence++;

	Q_UINT16 len=12+3+_email.length();
	
	s << (Q_UINT16 ) 0x0001;
	s << (Q_UINT16 ) len;
	s.setByteOrder(QDataStream::LittleEndian);	
	s << (Q_UINT16 ) (len-2);
	s << (Q_UINT32 ) uin;
	s << (Q_UINT16 ) 0x07D0;
	s << (Q_UINT16 ) searchSequence;
	s << (Q_UINT16 ) 0x0529;
	length+=16;	
		
	s << (Q_UINT16 ) (_email.length()+1);
	s.writeRawBytes(_email.latin1(),_email.length());
	s << (Q_UINT8  ) 0x00;	
	length+=3+_email.length();
	
  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);

  return searchSequence;	
}

int kxAIM::sendAuthRequest( Q_UINT32 _uin, bool _given, QString _reason)
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send URL");
	
	length+=addSNACHeader(&s, 0x04, 0x06);

	messageSeq++;
	
	//Seq 8 bytes ?
	s << (Q_UINT32) 0x0000;
	s << (Q_UINT32) 0x0001;
	s << (Q_UINT16) 0x0004;
	length+=10;
	
	// UIN
	QString uinStr;
	uinStr.sprintf("%d",_uin);
	s << (Q_UINT8 ) uinStr.length();
	s.writeRawBytes(uinStr.latin1(),uinStr.length());
	length+=1+uinStr.length();

	Q_UINT16 totalLen=1;
	QCString _reasonLocalCode = ENGINE->Unicode2Local(_reason);		
	if (!_given)
	  totalLen=_reasonLocalCode.length()+1;		
	
	// TLV 5
  s << (Q_UINT16 ) 0x0005;
  Q_UINT16 ln=8+totalLen;
  s << (Q_UINT16 ) ln;
  length+=4;

  s.setByteOrder(QDataStream::LittleEndian);	
  s << (Q_UINT32 ) uin;
  if (_given)
	  s << (Q_UINT16 ) 0x0008; // Given
	else
		s << (Q_UINT16 ) 0x0007; // Denied
  length+=6;

  if (_given)
  {
		s << (Q_UINT16 ) 0x0001;  	// len
		s << (Q_UINT8  ) 0x00;		  // empty
		length+=3;			
  }
  else
  {
		s << (Q_UINT16 ) totalLen;
		s.writeRawBytes((const char*)_reasonLocalCode,_reasonLocalCode.length());		
		s << (Q_UINT8 ) 0x00;		
		length+=totalLen+2;	
	}

  s.setByteOrder(QDataStream::BigEndian);		
	// TLV 6 ??? unknown why
	s << (Q_UINT16 ) 0x0006;
	s << (Q_UINT16 ) 0x0000;	
	length+=4;

  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);

  return messageSeq;
}
int kxAIM::sendStatus( int _status)
{
	if (_status==STATUS_INVISIBLE)
		sendVisibleList();

	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send Status");
	
	length+=addSNACHeader(&s, 0x01, 0x1E);

	s << (Q_UINT16 ) 0x0006;
	s << (Q_UINT16 ) 0x0004;	
	length+=4;
	
	Q_UINT16 status=0;
	switch(_status)
	{
		case STATUS_ONLINE:
			status=0x0000;
			break;
		case STATUS_AWAY:
			status=0x0001;
			break;
		case STATUS_DND:
			status=0x0013;
			break;
		case STATUS_NA:
			status=0x0004;
			break;			
		case STATUS_FFC:
			status=0x0020;
			break;
		case STATUS_INVISIBLE:
			status=0x0100;
			break;
		case STATUS_OCCUPIED:
			status=0x0010;
			break;
	}		
	Q_UINT16 flag=0;
	if (ENGINE->hideIP) flag^=0x0002;
	if (ENGINE->webStatus) flag^=0x0001;	
//	flag^=0x2000;
	
	s << (Q_UINT16 ) flag;
	s << (Q_UINT16 ) status;
	length+=4;
	
  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);

	if (_status!=STATUS_INVISIBLE)
		sendInvisibleList();

  ourStatus=status;
  return _status;
}
int kxAIM::sendStatusFull( int _status)
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send Status FULL %d", _status);
	
	debug("lanIP: %X:%d",lanIP,port);
	
	length+=addSNACHeader(&s, 0x01, 0x1E);

	s << (Q_UINT16 ) 0x0006;
	s << (Q_UINT16 ) 0x0004;	
	length+=4;
	
	Q_UINT16 status=0;
	switch(_status)
	{
		case STATUS_ONLINE:
			status=0x0000;
			break;
		case STATUS_AWAY:
			status=0x0001;
			break;
		case STATUS_DND:
			status=0x0013;
			break;
		case STATUS_NA:
			status=0x0004;
			break;			
		case STATUS_FFC:
			status=0x0020;
			break;
		case STATUS_INVISIBLE:
			status=0x0100;
			break;
		case STATUS_OCCUPIED:
			status=0x0010;
			break;
	}		
	Q_UINT16 flag=0;
	if (ENGINE->hideIP)
		flag^=0x0002;
	if (ENGINE->webStatus)
		flag^=0x0001;
	
//	flag^=0x2000;
	
	s << (Q_UINT16 ) flag;
	s << (Q_UINT16 ) status;
	length+=4;

	s << (Q_UINT16 ) 0x0008; // error code
	s << (Q_UINT16 ) 0x0002; // len
	s << (Q_UINT16 ) 0x0000; // error code
	length+=6;
	
		
	s << (Q_UINT16 ) 0x000C; // direct info
	s << (Q_UINT16 ) 37; // len
	length+=4;
	
	s.setByteOrder(QDataStream::BigEndian);
	s << (Q_UINT32 ) lanIP;
//	s.setByteOrder(QDataStream::BigEndian);
	s << (Q_UINT32 ) port;
	s << (Q_UINT8  ) 0x04; // mode ?
	s << (Q_UINT16 ) 0x0007; // version !!
	s << (Q_UINT32 ) 0x0000000;
	s << (Q_UINT32 ) 0x50;
	s << (Q_UINT32 ) 0x03;
	
	s << (Q_UINT32 ) 0x3B4C4C0C;
	s << (Q_UINT32 ) 0x00000000;
	s << (Q_UINT32 ) 0x3B7248ed;
	s << (Q_UINT16 ) 0x0000;
	
	length+=37;
	
  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);

  ourStatus=status;
  return _status;
}

void kxAIM::sendRequestStatusMessage(Q_UINT32)
{
}
void kxAIM::sendAddUser2List(Q_UINT32 _uin)
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send UIN to List");
	
	length+=addSNACHeader(&s, 0x03, 0x04);
	
	QString uin;
	uin.sprintf("%d",_uin);
	s << (Q_UINT8 ) uin.length();
	s.writeRawBytes(uin.latin1(),uin.length());
	length+=1+uin.length();	

  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);
}
void kxAIM::sendRemoveUser2List(Q_UINT32 _uin)
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send Remove UIN to List");
	
	length+=addSNACHeader(&s, 0x03, 0x05);
	
	QString uin;
	uin.sprintf("%d",_uin);
	s << (Q_UINT8 ) uin.length();
	s.writeRawBytes(uin.latin1(),uin.length());
	length+=1+uin.length();		

  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);
}
void kxAIM::sendReuqestMessage(Q_UINT32 _uin, Q_UINT8 _status)
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send request status message");
	
	length+=addSNACHeader(&s, 0x04, 0x06);
	
		//Seq 8 bytes ?
	s << (Q_UINT32) 0x0000;
	s << (Q_UINT32) 0x0000;
	s << (Q_UINT16) 0x0002;		
	
	length+=10;
	
	// UIN
	QString uin;
	uin.sprintf("%u",_uin);
	s << (Q_UINT8 ) uin.length();
	s.writeRawBytes(uin.latin1(),uin.length());
	length+=1+uin.length();

	// TLV 5
  s << (Q_UINT16 ) 0x0005;
  Q_UINT16 ln=94;
  s << (Q_UINT16 ) ln;
  length+=4;

  s << (Q_UINT16 ) 0x0000; // type
	s << (Q_UINT32 ) 0x0000; // msg ID 1
	s << (Q_UINT32 ) 0x0000; // msg ID 2
	length+=10;
	
	s << (Q_UINT32 ) 0x09461349;
	s << (Q_UINT32 ) 0x4C7F11D1;
	s << (Q_UINT32 ) 0x82224445;
	s << (Q_UINT32 ) 0x53540000;
	length+=16;
	
	// TLV 0x000A
	s << (Q_UINT16 ) 0x000A;	
	s << (Q_UINT16 ) 0x0002;
	s << (Q_UINT16 ) 0x0001;
	length+=6;
	
	// TLV 0x000F
  s << (Q_UINT16 ) 0x000F;	
	s << (Q_UINT16 ) 0x0000;
	length+=4;

	
	// TLV 0x2711
	s << (Q_UINT16 ) 0x2711;	
	s << (Q_UINT16 ) 0x36; // len ?
	length+=4;
	
	s << (Q_UINT16 ) 0x1B00;
	s << (Q_UINT8  ) 0x07;
	length+=3;
	
	// all 19x0
	s << (Q_UINT32 ) 0x0000;
	s << (Q_UINT32 ) 0x0000;
	s << (Q_UINT32 ) 0x0000;
	s << (Q_UINT32 ) 0x0000;
	s << (Q_UINT16 ) 0x0000;
	s << (Q_UINT8  ) 0x00;
	length+=19;
	
	s << (Q_UINT32 ) 0x03000000;
	s << (Q_UINT8  ) 0x00;
	length+=5;
	
	messageSeq++;
	
	s << (Q_UINT16 ) messageSeq;
	s << (Q_UINT16 ) 0x0E00;
	s << (Q_UINT16 ) messageSeq;
	length+=6;
	
	// all 12x0
	s << (Q_UINT32 ) 0x0000;
	s << (Q_UINT32 ) 0x0000;
	s << (Q_UINT32 ) 0x0000;
	length+=12;
	
	Q_UINT8 status=0xE0;
	switch(_status)
	{
		case STATUS_AWAY:
			status=0xE8;
			break;
		case STATUS_DND:
			status=0xEB;
			break;
		case STATUS_OCCUPIED:
			status=0xE9;
			break;
		case STATUS_NA:
			status=0xEA;
			break;
		case STATUS_FFC:
			status=0xEC;
			break;
	}		
	s << (Q_UINT8  ) status;
	s << (Q_UINT8  ) 0x03;  // flag
	length+=2;
	
	s.setByteOrder(QDataStream::LittleEndian);
	s << (Q_UINT8 ) ourStatus; // status, todo
	s.setByteOrder(QDataStream::BigEndian);
	s << (Q_UINT16 ) 0x0001; // priority
	length+=3;
	
	s << (Q_UINT16 ) 0x0001;
	s << (Q_UINT16  ) 0x00;
	length+=4;
	
	s << (Q_UINT16 ) 0x0003;
	s << (Q_UINT16 ) 0x0000;
	length+=4;
	
	
  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);
}
void kxAIM::sendMessage2Ack(Q_UINT32 _uin, Q_UINT32 _msgid1, Q_UINT32 _msgid2, Q_UINT16 _type, char *tlv)
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send Message v2 Ack");
	
	length+=addSNACHeader(&s, 0x04, 0x0B);
	
	s << (Q_UINT32 ) _msgid1;
	s << (Q_UINT32 ) _msgid2;
	s << (Q_UINT16 ) _type;
	length+=10;
	
	// UIN
	QString uin;
	uin.sprintf("%d",_uin);
	s << (Q_UINT8 ) uin.length();
	s.writeRawBytes(uin.latin1(),uin.length());
	length+=1+uin.length();	
	
	s <<(Q_UINT16 ) 0x0003;
	length+=2;
	
	s.writeRawBytes(tlv,26);
	length+=26;	
	s << (Q_UINT8 ) 0x00;
	s.writeRawBytes(tlv+27,20);
	length+=21;	
	
	s << (Q_UINT8 ) 0x00; // accept status
	s << (Q_UINT8 ) 0x00;
	s << (Q_UINT8 ) 0x00;
	s << (Q_UINT8 ) 0x00;	
	length+=4;
	
	QCString msgLocalCode=ENGINE->Unicode2Local(ENGINE->getStatusMessages(ENGINE->currentStatus));
	
	s.setByteOrder(QDataStream::LittleEndian);
	s << (Q_UINT16 ) (msgLocalCode.length()+1);
	s.writeRawBytes(msgLocalCode,msgLocalCode.length());
	s << (Q_UINT8 ) 0x00;	
	length+=3+msgLocalCode.length();
	s.setByteOrder(QDataStream::BigEndian);
	
	s << (Q_UINT32 ) 0x0000;
	s << (Q_UINT16 ) 0xFFFF;
	s << (Q_UINT16 ) 0xFFFF;	
	length+=8;

  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);	
}
int kxAIM::sendRequestInfo(Q_UINT32 _uin)
{
  QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send Request Info");
	
	searchSequence++;	
	
	length+=addSNACHeader(&s, 0x15, 0x02, searchSequence);	

	Q_UINT16 len=16;
	s << (Q_UINT16 ) 0x0001;
	s << (Q_UINT16 ) len;
	s.setByteOrder(QDataStream::LittleEndian);	
	s << (Q_UINT16 ) (len-2);
	s << (Q_UINT32 ) uin;
	s << (Q_UINT16 ) 0x07D0;
	s << (Q_UINT16 ) searchSequence;
	s << (Q_UINT16 ) 0x04B2;
	s << (Q_UINT32 ) _uin;
	length+=20;			

  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);	

  return searchSequence;	
}
void kxAIM::sendAddUser(Q_UINT32 _uin,QString _n, QString _f, QString _l, QString _e, bool auth=FALSE)
{
  QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send Add User 2 List");
	
	messageSeq++;
	
	length+=addSNACHeader(&s, 0x04, 0x06, messageSeq);		
	
	//Seq 8 bytes ?
	s << (Q_UINT32) 0x0000;
	s << (Q_UINT32) 0x0001;
	s << (Q_UINT16) 0x0004;
	length+=10;
	
	// UIN
	QString uinStr;
	uinStr.sprintf("%d",_uin);
	s << (Q_UINT8 ) uinStr.length();
	s.writeRawBytes(uinStr.latin1(),uinStr.length());
	length+=1+uinStr.length();

	//	QString info;
	QCString infoLocalCode;		
	infoLocalCode.sprintf("%s%c%s%c%s%c%s%c%01d%c", (const char*)ENGINE->Unicode2Local(_n),0xFE, (const char*)ENGINE->Unicode2Local(_f),0xFE, (const char*)ENGINE->Unicode2Local(_l),0xFE, (const char*)ENGINE->Unicode2Local(_e),0xFE,auth=TRUE?1:0, 0xFE);	

	Q_UINT16 totalLen=infoLocalCode.length()+1;	
	
	// TLV 5
  s << (Q_UINT16 ) 0x0005;
  Q_UINT16 ln=8+totalLen;
  s << (Q_UINT16 ) ln;
  length+=4;

  s.setByteOrder(QDataStream::LittleEndian);	
  s << (Q_UINT32 ) uin;
	s << (Q_UINT16 ) 0x000c; // added to contact list
  length+=6;

	s << (Q_UINT16 ) totalLen;
	s.writeRawBytes((const char*)infoLocalCode,infoLocalCode.length());	
	s << (Q_UINT8 ) 0x00;		
	length+=totalLen+2;	
	
  s.setByteOrder(QDataStream::BigEndian);		
	// TLV 6 ??? unknown why
	s << (Q_UINT16 ) 0x0006;
	s << (Q_UINT16 ) 0x0000;	
	length+=4;
	

  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);	
	
}
int kxAIM::sendContacts(UIN _uin,QList<kxAddContactStruct> *lst)
{
  QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send Contacts");

	messageSeq++;
	
	length+=addSNACHeader(&s, 0x04, 0x06, messageSeq);		
	
	//Seq 8 bytes ?
	s << (Q_UINT32) 0x0000;
	s << (Q_UINT32) 0x0001;
	s << (Q_UINT16) 0x0004;
	length+=10;
	
	// UIN
	QString uinStr;
	uinStr.sprintf("%d",_uin);
	s << (Q_UINT8 ) uinStr.length();
	s.writeRawBytes(uinStr.latin1(),uinStr.length());
	length+=1+uinStr.length();

  QCString contLocalCode;

  QCString tmpLocalCode;
  tmpLocalCode.sprintf("%01d%c",lst->count(), 0xFE);

  contLocalCode+=tmpLocalCode;

  kxAddContactStruct *li;
  for (int t1=0; t1<(int)lst->count(); t1++)
  {
    li=lst->at(t1);

    tmpLocalCode.sprintf("%d%c%s%c",li->uin, 0xFE, (const char*)ENGINE->Unicode2Local(li->nick), 0xFE);	
    contLocalCode+=tmpLocalCode;
  }

  //  QCString contLocalCode = ENGINE->Unicode2Local(cont);	
  Q_UINT16 totalLen=contLocalCode.length()+1;	
	
	// TLV 5
  s << (Q_UINT16 ) 0x0005;
  Q_UINT16 ln=8+totalLen;
  s << (Q_UINT16 ) ln;
  length+=4;

  s.setByteOrder(QDataStream::LittleEndian);	
  s << (Q_UINT32 ) uin;
	s << (Q_UINT16 ) 0x0013; // send contacts
  length+=6;

	s << (Q_UINT16 ) totalLen;
	s.writeRawBytes((const char*)contLocalCode,contLocalCode.length());	
	s << (Q_UINT8 ) 0x00;		
	length+=totalLen+2;	
	
  s.setByteOrder(QDataStream::BigEndian);		
	// TLV 6 ??? unknown why
	s << (Q_UINT16 ) 0x0006;
	s << (Q_UINT16 ) 0x0000;	
	length+=4;
		
  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);

  return messageSeq;		
}
int kxAIM::sendAdvanchedMessage(Q_UINT32 _uin, kxMessageStruct *message, QList<kxAddContactStruct> *lst=NULL)
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send Advanched Message");
	
	messageSeq++;
	
	length+=addSNACHeader(&s, 0x04, 0x06, messageSeq);
	
	Q_UINT8 type=0x01;
	Q_UINT16 extraLen=0;
  QCString msgLocalCode;
	switch(message->type)
	{
		case MESSAGE_TYPE:
			type=0x01;
			extraLen=8;
	  msgLocalCode=ENGINE->Unicode2Local(message->message);
			break;
		case URL_TYPE:
			type=0x04;
	  msgLocalCode.sprintf("%s%c%s",(const char*)ENGINE->Unicode2Local(message->message), 0xFE, (const char*)ENGINE->Unicode2Local(message->url));	
			break;
		case CONTACTS_TYPE:
			type=0x13;
	  QCString tmpLocalCode;
	  tmpLocalCode.sprintf("%01d%c",lst->count(), 0xFE);

	  msgLocalCode+=tmpLocalCode;

      kxAddContactStruct *li;
      for (int t1=0; t1<(int)lst->count(); t1++)
      {
        li=lst->at(t1);

		  tmpLocalCode.sprintf("%d%c%s%c",li->uin, 0xFE, (const char*)ENGINE->Unicode2Local(li->nick), 0xFE);	
		  msgLocalCode+=tmpLocalCode;
      }

      break;
	}						
	
		//Seq 8 bytes ?
	s << (Q_UINT32) 0x0000;
	s << (Q_UINT32) messageSeq;
	s << (Q_UINT16) 0x0002;		
	
	length+=10;
	
	// UIN
	QString uin;
	uin.sprintf("%d",_uin);
	s << (Q_UINT8 ) uin.length();
	s.writeRawBytes(uin.latin1(),uin.length());
	length+=1+uin.length();

	// TLV 5
  s << (Q_UINT16 ) 0x0005;
  Q_UINT16 ln=94+msgLocalCode.length()+extraLen;	
  s << (Q_UINT16 ) ln;
  length+=4;

  s << (Q_UINT16 ) 0x0000; // type
	s << (Q_UINT32 ) 0x0000; // msg ID 1
	s << (Q_UINT32 ) messageSeq; // msg ID 2
	length+=10;
	
	s << (Q_UINT32 ) 0x09461349;
	s << (Q_UINT32 ) 0x4C7F11D1;
	s << (Q_UINT32 ) 0x82224445;
	s << (Q_UINT32 ) 0x53540000;
	length+=16;
	
	// TLV 0x000A
	s << (Q_UINT16 ) 0x000A;	
	s << (Q_UINT16 ) 0x0002;
	s << (Q_UINT16 ) 0x0001;
	length+=6;
	
	// TLV 0x000F
  s << (Q_UINT16 ) 0x000F;	
	s << (Q_UINT16 ) 0x0000;
	length+=4;

	
	// TLV 0x2711
	s << (Q_UINT16 ) 0x2711;	
  s << (Q_UINT16 ) (54+extraLen+msgLocalCode.length()); // len ?		
	length+=4;
	
	s << (Q_UINT16 ) 0x1B00;
	s << (Q_UINT8  ) 0x07;
	length+=3;
	
	// all 19x0
	s << (Q_UINT32 ) 0x0000;
	s << (Q_UINT32 ) 0x0000;
	s << (Q_UINT32 ) 0x0000;
	s << (Q_UINT32 ) 0x0000;
	s << (Q_UINT16 ) 0x0000;
	s << (Q_UINT8  ) 0x00;
	length+=19;
	
	s << (Q_UINT32 ) 0x03000000;
	s << (Q_UINT8  ) 0x00;
	length+=5;
	
	s << (Q_UINT16 ) messageSeq;
	s << (Q_UINT16 ) 0x0E00;
	s << (Q_UINT16 ) messageSeq;
	length+=6;
	
	// all 12x0
	s << (Q_UINT32 ) 0x0000;
	s << (Q_UINT32 ) 0x0000;
	s << (Q_UINT32 ) 0x0000;
	length+=12;
	
			
	s << (Q_UINT8  ) type;  // message type
	s << (Q_UINT8  ) 0x00;  // flag
	length+=2;
	
	s.setByteOrder(QDataStream::LittleEndian);
	s << (Q_UINT16 ) ourStatus; // status, todo
	s << (Q_UINT16 ) 0x0001; // priority
	length+=4;	
	
	
	// message
	s << (Q_UINT16 ) (msgLocalCode.length()+1);
	s.writeRawBytes(msgLocalCode,msgLocalCode.length());
	s << (Q_UINT8  ) 0x00;	
	length+=2+msgLocalCode.length()+1;
	
	if (message->type==MESSAGE_TYPE)
	{
    int r,g,b, z=0;
    message->foreground.rgb(&r, &g, &b);
    s << ( Q_UINT8  ) r;
    s << ( Q_UINT8  ) g;
    s << ( Q_UINT8  ) b;
    s << ( Q_UINT8  ) z;	
    message->background.rgb(&r, &g, &b);
    s << ( Q_UINT8  ) r;
    s << ( Q_UINT8  ) g;
    s << ( Q_UINT8  ) b;
    s << ( Q_UINT8  ) z;	
  	length+=8;	
  }
	
	s << (Q_UINT32 ) 0x00000300;
	length+=4;
	
  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);

  return messageSeq;
}
void kxAIM::sendAuthRequest(Q_UINT32 _uin, const QString &_msg)
{
  QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send Auth Request");

	length+=addSNACHeader(&s, 0x13, 0x18);		
	
	// UIN
	QString uinStr;
	uinStr.sprintf("%d",_uin);
	s << (Q_UINT8 ) uinStr.length();
	s.writeRawBytes(uinStr.latin1(),uinStr.length());
	length+=1+uinStr.length();
	
	QCString _msgLocalCode = ENGINE->Unicode2Local(_msg);
	s << (Q_UINT16 ) (_msgLocalCode.length()+1);
	s.writeRawBytes(_msgLocalCode,_msgLocalCode.length());
	s << (Q_UINT8  ) 0x00;
	
	s << (Q_UINT8  ) 0x00;	
	s << (Q_UINT8  ) 0x00;
	
	length+=2+_msgLocalCode.length()+1+2;
	
  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);
}
int kxAIM::sendRandomSearch(Q_UINT16 type)
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send Random search");
	
	length+=addSNACHeader(&s, 0x15, 0x02);

	searchSequence++;

	Q_UINT16 len=14;
	
	s << (Q_UINT16 ) 0x0001;
	s << (Q_UINT16 ) len;
	s.setByteOrder(QDataStream::LittleEndian);	
	s << (Q_UINT16 ) (len-2);
	s << (Q_UINT32 ) uin;
	s << (Q_UINT16 ) 0x07D0;
	s << (Q_UINT16 ) searchSequence;
	s << (Q_UINT16 ) 0x074E;
	length+=16;	
		
	s << (Q_UINT16 ) type;
  length+=2;
		
  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);

  return searchSequence;	
}
int kxAIM::sendSMS(const QString &num, const QString &msg, const QString &nick)
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send Random search");
	
	length+=addSNACHeader(&s, 0x15, 0x02);

	searchSequence++;
	
	QString sms;
	sms.sprintf("<icq_sms_message><destination>%s</destination><text>%s</text><codepage>1252</codepage><senders_UIN>%d</senders_UIN><senders_name>%s</senders_name><delivery_receipt>%s</delivery_receipt><time>%s</time></icq_sms_message>",
			num.latin1(), msg.latin1(),uin, nick.latin1(), "Yes", "Mon, 10 Dec 2001 21:14:38 GMT");
  debug("SMS: %s",sms.latin1());
	Q_UINT16 len=12 + sms.length() + 3 + 22;
	
	s << (Q_UINT16 ) 0x0001;
	s << (Q_UINT16 ) len;
	s.setByteOrder(QDataStream::LittleEndian);	
	s << (Q_UINT16 ) (len-2);
	s << (Q_UINT32 ) uin;
	s << (Q_UINT16 ) 0x07D0;
	s << (Q_UINT16 ) searchSequence;
	s << (Q_UINT16 ) 0x1482;
	length+=16;	
	
	s.setByteOrder(QDataStream::BigEndian);		
	s << (Q_UINT16 ) 0x01;
	s << (Q_UINT16 ) 0x16;
	length+=4;
	s << (Q_UINT32 ) 0x00; s << (Q_UINT32 ) 0x00; s << (Q_UINT32 ) 0x00; s << (Q_UINT32 ) 0x00;
	s << (Q_UINT16 ) 0x00;
	length+=18;	
		
	s << (Q_UINT16 ) (sms.length()+1);
	s.writeRawBytes(sms.latin1(), sms.length());
	s << (Q_UINT8 ) 0x00;
	length+=sms.length()+2+1;	
					
  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);

  return searchSequence;	
}
int kxAIM::sendMainHomeInfo(QString _n,QString _f,QString _l,QString _e,QString _c,QString _st,QString _p,QString _fa,QString _ste,QString _ce,QString _zip,Q_UINT16 _con, Q_UINT8 _gmt, Q_UINT8 _pubEmail)
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send Update Home Main Info");
	
	length+=addSNACHeader(&s, 0x15, 0x02);

	searchSequence++;
	
	QCString _nLocal = ENGINE->Unicode2Local(_n);	//nick
	QCString _fLocal = ENGINE->Unicode2Local(_f);	//first
	QCString _lLocal = ENGINE->Unicode2Local(_l);	//last
	QCString _eLocal = ENGINE->Unicode2Local(_e);	//primEmail
	QCString _cLocal = ENGINE->Unicode2Local(_c);	//city
	QCString _stLocal = ENGINE->Unicode2Local(_st);	//state
	QCString _pLocal = ENGINE->Unicode2Local(_p);	//phone
	QCString _faLocal = ENGINE->Unicode2Local(_fa);	//fax
	QCString _steLocal = ENGINE->Unicode2Local(_ste);	//street
	QCString _ceLocal = ENGINE->Unicode2Local(_ce);	//gsm
	QCString _zipLocal = ENGINE->Unicode2Local(_zip);	//zip

	Q_UINT16 len=12+_nLocal.length()+3+_fLocal.length()+3+_lLocal.length()+3+_eLocal.length()+3+_cLocal.length()+3+_stLocal.length()+3+_pLocal.length()+3+_faLocal.length()+3;
	len+=3+_steLocal.length()+3+_ceLocal.length()+_zipLocal.length()+3+4;
	
	s << (Q_UINT16) 0x0001;
	s << (Q_UINT16) len; // length
	
	s.setByteOrder(QDataStream::LittleEndian);		
	s << (Q_UINT16) (len-2); //length again ?
	s << (Q_UINT32) uin;
	s << (Q_UINT16) 0x07D0;
	s << (Q_UINT16) searchSequence;	
	s << (Q_UINT16) 0x03EA;
	length+=16;	
	
	s << (Q_UINT16 ) (_nLocal.length()+1);
	s.writeRawBytes((const char*)_nLocal, _nLocal.length());
	s << (Q_UINT8 ) 0x00;
	length+=_nLocal.length()+3;	
	s << (Q_UINT16 ) (_fLocal.length()+1);
	s.writeRawBytes((const char*)_fLocal, _fLocal.length());
	s << (Q_UINT8 ) 0x00;
	length+=_fLocal.length()+3;	
	s << (Q_UINT16 ) (_lLocal.length()+1);
	s.writeRawBytes((const char*)_lLocal, _lLocal.length());
	s << (Q_UINT8 ) 0x00;
	length+=_lLocal.length()+3;	
	
	s << (Q_UINT16 ) (_eLocal.length()+1);
	s.writeRawBytes((const char*)_eLocal, _eLocal.length());
	s << (Q_UINT8 ) 0x00;
	length+=_eLocal.length()+3;	
	
	s << (Q_UINT16 ) (_cLocal.length()+1);
	s.writeRawBytes((const char*)_cLocal, _cLocal.length());
	s << (Q_UINT8 ) 0x00;
	length+=_cLocal.length()+3;
	
	s << (Q_UINT16 ) (_stLocal.length()+1);
	s.writeRawBytes((const char*)_stLocal, _stLocal.length());
	s << (Q_UINT8 ) 0x00;
	length+=_stLocal.length()+3;
	
	s << (Q_UINT16 ) (_pLocal.length()+1);
	s.writeRawBytes((const char*)_pLocal, _pLocal.length());
	s << (Q_UINT8 ) 0x00;
	length+=_pLocal.length()+3;

	s << (Q_UINT16 ) (_faLocal.length()+1);
	s.writeRawBytes((const char*)_faLocal, _faLocal.length());
	s << (Q_UINT8 ) 0x00;
	length+=_faLocal.length()+3;
	
	s << (Q_UINT16 ) (_steLocal.length()+1);
	s.writeRawBytes((const char*)_steLocal, _steLocal.length());
	s << (Q_UINT8 ) 0x00;
	length+=_steLocal.length()+3;
	
	s << (Q_UINT16 ) (_ceLocal.length()+1);
	s.writeRawBytes((const char*)_ceLocal, _ceLocal.length());
	s << (Q_UINT8 ) 0x00;
	length+=_ceLocal.length()+3;	

	s << (Q_UINT16 ) (_zipLocal.length()+1);
	s.writeRawBytes((const char*)_zipLocal, _zipLocal.length());
	s << (Q_UINT8 ) 0x00;
	length+=_zipLocal.length()+3;	
	
	if (_con==0) _con=0xFFFF;
	s << (Q_UINT16 ) _con;	
	s << (Q_UINT8  ) _gmt;	
	s << (Q_UINT8  ) (!_pubEmail);
	
	length+=4;
	
  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);

  return searchSequence;

}
int kxAIM::sendEmailList(const QStringList &lst)
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send Email List Info");
	
	length+=addSNACHeader(&s, 0x15, 0x02);

	searchSequence++;
	
	Q_UINT16 len=13;

 	for (Q_UINT16 t=0; t<lst.count(); t+=2)
 	{	 		
		len+=(ENGINE->Unicode2Local(lst[t])).length()+4;
	}	
	debug("Length: %d",len);
		
	s << (Q_UINT16) 0x0001;
	s << (Q_UINT16) len; // length
	
	s.setByteOrder(QDataStream::LittleEndian);		
	s << (Q_UINT16) (len-2); //length again ?
	s << (Q_UINT32) uin;
	s << (Q_UINT16) 0x07D0;
	s << (Q_UINT16) searchSequence;	
	s << (Q_UINT16) 0x040B;	
	s << (Q_UINT8 ) (lst.count()/2);
	length+=17;	
	
	Q_UINT16 l=0;
	QCString emailLocal;
 	for (Q_UINT16 t=0; t<lst.count(); t+=2)
 	{	 		
 		s <<(Q_UINT8 ) (lst[t+1]=="Y"?0:1);
 		debug("Add: %s, %s", QString(lst[t+1]).latin1(), lst[t].latin1());
 		emailLocal = lst[t];
		s << (Q_UINT16 ) (emailLocal.length()+1);
		s.writeRawBytes((const char*)emailLocal, emailLocal.length());
		s << (Q_UINT8 ) 0x00;
		length+=emailLocal.length()+4;	
		l+=emailLocal.length()+4;	
	}
	debug("Length: %d - %d   (%d) %d",length, len, lst.count(), l);
	
  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);

  return searchSequence;

}	
int kxAIM::sendWorkInfo(QString _n, QString _p,QString _d, QString _s,QString _z, QString _c,QString _st, QString _url, QString _ph, QString _f,Q_UINT16 _co, Q_UINT16 _oc)
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send Update Work Info");
	
	length+=addSNACHeader(&s, 0x15, 0x02);

	searchSequence++;
	
	QCString _nLocal = ENGINE->Unicode2Local(_n);	//wName
	QCString _pLocal = ENGINE->Unicode2Local(_p);	//wPos
	QCString _dLocal = ENGINE->Unicode2Local(_d);	//wDiv
	QCString _sLocal = ENGINE->Unicode2Local(_s);	//wStreet
	QCString _zLocal = ENGINE->Unicode2Local(_z);	//wZip
	QCString _cLocal = ENGINE->Unicode2Local(_c);	//wCity
	QCString _stLocal = ENGINE->Unicode2Local(_st);	//wState
	QCString _urlLocal = ENGINE->Unicode2Local(_url);	//wUrl
	QCString _phLocal = ENGINE->Unicode2Local(_ph);	//wPhone
	QCString _fLocal = ENGINE->Unicode2Local(_f);	//wFax
	
	Q_UINT16 len=12+_nLocal.length()+3+_pLocal.length()+3+_dLocal.length()+3+_sLocal.length()+3+_zLocal.length()+3+_cLocal.length()+3+_stLocal.length()+3+_urlLocal.length()+3;
	len+=3+_phLocal.length()+3+_fLocal.length()+4;
	
	s << (Q_UINT16) 0x0001;
	s << (Q_UINT16) len; // length
	
	s.setByteOrder(QDataStream::LittleEndian);		
	s << (Q_UINT16) (len-2); //length again ?
	s << (Q_UINT32) uin;
	s << (Q_UINT16) 0x07D0;
	s << (Q_UINT16) searchSequence;	
	s << (Q_UINT16) 0x03F3;
	length+=16;	
	
	s << (Q_UINT16 ) (_cLocal.length()+1);
	s.writeRawBytes((const char*)_cLocal, _cLocal.length());
	s << (Q_UINT8 ) 0x00;
	length+=_cLocal.length()+3;	

	s << (Q_UINT16 ) (_stLocal.length()+1);
	s.writeRawBytes((const char*)_stLocal, _stLocal.length());
	s << (Q_UINT8 ) 0x00;
	length+=_stLocal.length()+3;	

	s << (Q_UINT16 ) (_phLocal.length()+1);
	s.writeRawBytes((const char*)_phLocal, _phLocal.length());
	s << (Q_UINT8 ) 0x00;
	length+=_phLocal.length()+3;	
		
	s << (Q_UINT16 ) (_fLocal.length()+1);
	s.writeRawBytes((const char*)_fLocal, _fLocal.length());
	s << (Q_UINT8 ) 0x00;
	length+=_fLocal.length()+3;
	
	s << (Q_UINT16 ) (_sLocal.length()+1);
	s.writeRawBytes((const char*)_sLocal, _sLocal.length());
	s << (Q_UINT8 ) 0x00;
	length+=_sLocal.length()+3;		
	
	s << (Q_UINT16 ) (_zLocal.length()+1);
	s.writeRawBytes((const char*)_zLocal, _zLocal.length());
	s << (Q_UINT8 ) 0x00;
	length+=_zLocal.length()+3;
	
	s << (Q_UINT16 ) _co;
	length+=2;

	s << (Q_UINT16 ) (_nLocal.length()+1);
	s.writeRawBytes((const char*)_nLocal, _nLocal.length());
	s << (Q_UINT8 ) 0x00;
	length+=_nLocal.length()+3;	
	s << (Q_UINT16 ) (_dLocal.length()+1);
	s.writeRawBytes((const char*)_dLocal, _dLocal.length());
	s << (Q_UINT8 ) 0x00;
	length+=_dLocal.length()+3;	
	s << (Q_UINT16 ) (_pLocal.length()+1);
	s.writeRawBytes(_pLocal, _pLocal.length());
	s << (Q_UINT8 ) 0x00;
	length+=_pLocal.length()+3;				

	s << (Q_UINT16 ) _oc;
	length+=2;
			
	s << (Q_UINT16 ) (_urlLocal.length()+1);
	s.writeRawBytes(_urlLocal, _urlLocal.length());
	s << (Q_UINT8 ) 0x00;
	length+=_urlLocal.length()+3;	

  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);

  return searchSequence;

}
int kxAIM::sendAboutInfo(QString _about)
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send About Info");
	
	length+=addSNACHeader(&s, 0x15, 0x02);

	searchSequence++;
	
	QCString _aboutLocal = ENGINE->Unicode2Local(_about);	//about
		
	Q_UINT16 len=12+3+_aboutLocal.length();
		
	s << (Q_UINT16) 0x0001;
	s << (Q_UINT16) len; // length
	
	s.setByteOrder(QDataStream::LittleEndian);		
	s << (Q_UINT16) (len-2); //length again ?
	s << (Q_UINT32) uin;
	s << (Q_UINT16) 0x07D0;
	s << (Q_UINT16) searchSequence;	
	s << (Q_UINT16) 0x0406;	
	length+=16;	
	
	s << (Q_UINT16 ) (_aboutLocal.length()+1);
	s.writeRawBytes((const char*)_aboutLocal, _aboutLocal.length());
	s << (Q_UINT8 ) 0x00;
	length+=_aboutLocal.length()+3;	
	
  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);

  return searchSequence;
}
int kxAIM::sendMoreInfo(Q_UINT16 _a, Q_UINT8 _s, QString _u, Q_UINT16 _j, Q_UINT8 _d, Q_UINT8 _m, Q_UINT8 _l1, Q_UINT8 _l2, Q_UINT8 _l3 )
{
	QDataStream s(*byteArray, IO_ReadWrite);
	s.setByteOrder(QDataStream::BigEndian);	
	debug("Send About Info");
	
	length+=addSNACHeader(&s, 0x15, 0x02);

	searchSequence++;
	
	QCString _uLocal = ENGINE->Unicode2Local(_u);	//homepage
	
	Q_UINT16 len=12+3+_uLocal.length() + 10;
		
	s << (Q_UINT16) 0x0001;
	s << (Q_UINT16) len; // length
	
	s.setByteOrder(QDataStream::LittleEndian);		
	s << (Q_UINT16) (len-2); //length again ?
	s << (Q_UINT32) uin;
	s << (Q_UINT16) 0x07D0;
	s << (Q_UINT16) searchSequence;	
	s << (Q_UINT16) 0x03FD;	
	length+=16;	
	
	s << (Q_UINT8 ) _a;
	s << (Q_UINT8 ) 0;
	s << (Q_UINT8 ) _s;
	length+=3;
	
	s << (Q_UINT16 ) (_u.length()+1);
	s.writeRawBytes((const char*)_uLocal, _uLocal.length());
	s << (Q_UINT8 ) 0x00;
	length+=_uLocal.length()+3;	
	
	s << (Q_UINT16 ) _j;
	s << (Q_UINT8  ) _m;
	s << (Q_UINT8  ) _d;
	s << (Q_UINT8  ) _l1;
	s << (Q_UINT8  ) _l2;
	s << (Q_UINT8  ) _l3;
	length+=7;
	
  addPacket2ListAIM(aimSock, 0x02);
  if (aimSock)   aimSock->enableWrite(TRUE);

  return searchSequence;
}

