//
//   File : libkvistr.cpp
//   Creation date : Thu Dec 27 2001 17:13:12 GMT by Szymon Stefanek
//
//   This str is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

//#warning: FIXME: Incomplete documentation ('seealso', 'example', etc)

#include "kvi_module.h"
#include "kvi_uparser.h"
#include "kvi_locale.h"
#include "kvi_string.h"
#include "kvi_debug.h"
/*
#include "kvi_strutils.h"
#include "kvi_locale.h"
#include "kvi_command.h"
#include "kvi_malloc.h"
#include "kvi_app.h"


#include <qstrinfo.h>
#include <qstr.h>

*/

/*
    @doc: str.len
    @type:
        function
    @title:
        $str.len
    @short:
        Returns the lenght of the given string
    @syntax:
        $str.len(string)
    @description:
		Returns the lenght (that is, number of characters) of the given string.
*/

static bool str_module_fnc_len(KviModule *m,KviCommand *c,KviParameterList * parms,KviStr &buffer)
{
	buffer.append(KviStr::Format,"%d",(*(parms->safeFirst())).len());
	return true;
}

/*
    @doc: str.lowcase
    @type:
        function
    @title:
        $str.lowcase
    @short:
        Returns the given string with all characters turned to lower case
    @syntax:
        $str.lowcase(string)
    @description:
		Returns the given string with all characters turned to lower case.
*/

static bool str_module_fnc_lowcase(KviModule *m,KviCommand *c,KviParameterList * parms,KviStr &buffer)
{
	buffer.append((*(parms->safeFirst())).lower());
	return true;
}

/*
    @doc: str.upcase
    @type:
        function
    @title:
        $str.upcase
    @short:
        Returns the given string with all characters turned to upper case
    @syntax:
        $str.lowcase(string)
    @description:
        Returns the given string with all characters turned to lower case.
*/

static bool str_module_fnc_upcase(KviModule *m,KviCommand *c,KviParameterList * parms,KviStr &buffer)
{
	buffer.append((*(parms->safeFirst())).upper());
	return true;
}

/*
    @doc: str.isnumber
    @type:
        function
    @title:
        $str.isnumber
    @short:
        Returns 1 if the given string represents a number
    @syntax:
        $str.isnumber(string)
    @description:
		Returns 1 if the given string represents a number, 0 if not.
*/

static bool str_module_fnc_isnumber(KviModule *m,KviCommand *c,KviParameterList * parms,KviStr &buffer)
{
	bool isNum;
	parms->getInt(&isNum);
	buffer.append(isNum ? '1' : '0');
	return true;
}

/*
    @doc: str.isunsignednumber
    @type:
        function
    @title:
        $str.isunsignednumber
    @short:
        Returns 1 if the given string represents an unsigned number
    @syntax:
        $str.isunsignednumber(string)
    @description:
		Returns 1 if the given string represents an unsigned number, 0 if not.
*/

static bool str_module_fnc_isunsignednumber(KviModule *m,KviCommand *c,KviParameterList *parms,KviStr &buffer)
{
	bool isUNum;
	parms->getUInt(&isUNum);
	buffer.append(isUNum ? '1' : '0');
	return true;
}
/*
    @doc: str.isempty
    @type:
        function
    @title:
        $str.isempty
    @short:
        Returns 1 if the given string don't have any character.
    @syntax:
        $str.isnumber(string)
    @description:
		Returns 1 if the given string don't have any character (that is, is empty).
*/

static bool str_module_fnc_isempty(KviModule *m,KviCommand *c,KviParameterList *parms,KviStr &buffer)
{
	buffer.append((*(parms->safeFirst())).isEmpty() ? '1' : '0');
	return true;
}
/*
    @doc: str.contains
    @type:
        function
    @title:
        $str.contains
    @short:
        Returns 1 if the first parameter contains the second
    @syntax:
        $str.contains(string, substring)
    @description:
		Returns 1 if the first string parameter contains the second string parameter. 
		This function is case sensitive.
*/

static bool str_module_fnc_contains(KviModule *m,KviCommand *c,KviParameterList *parms,KviStr &buffer)
{
	buffer.append((*(parms->safeFirst())).contains(*(parms->safeNext())) ? '1' : '0');
	return true;
}

/*
    @doc: str.containsnocase
    @type:
        function
    @title:
        $str.containsnocase
    @short:
		Returns 1 if the first parameter contains the second, case insensitive
    @syntax:
        $str.containsnocase(string,substring)
    @description:
        Returns 1 if the first string parameter contains the second string parameter 
		whithout taking in consideration the case of the characters in the string.
*/

static bool str_module_fnc_containsnocase(KviModule *m,KviCommand *c,KviParameterList *parms,KviStr &buffer)
{
	buffer.append((*(parms->safeFirst())).contains(*(parms->safeNext()),0) ? '1' : '0');
	return true;
}

/*
    @doc: str.equal
    @type:
        function
    @title:
        $str.equal
    @short:
        Returns 1 if the two string parameters are equal
    @syntax:
        $str.equal(string1,string2)
    @description:
		Returns 1 if the two string parameters are equal. This function is case sensitive.
*/

static bool str_module_fnc_equal(KviModule *m,KviCommand *c,KviParameterList *parms,KviStr &buffer)
{
	buffer.append(kvi_strEqualCS( (*(parms->safeFirst())).ptr(),(*(parms->safeNext())).ptr() ) ? '1':'0');
	return true;
}

/*
    @doc: str.equalnocase
    @type:
        function
    @title:
        $str.equalnocase
    @short:
        Returns 1 if the two string parameters are equal, case insensitive
    @syntax:
        $str.equalnocase(string1,string2)
    @description:
		Returns 1 if the two strngs parameters are equal, without taking the case of the 
		characters in consideration.
*/

static bool str_module_fnc_equalnocase(KviModule *m,KviCommand *c,KviParameterList *parms,KviStr &buffer)
{
	buffer.append(kvi_strEqualCI( (*(parms->safeFirst())).ptr(),(*(parms->safeNext())).ptr() ) ? '1':'0');
	return true;
}

/*
    @doc: str.cmp
    @type:
        function
    @title:
        $str.cmp
    @short:
        Compare two strings alphabetically
    @syntax:
        $str.cmp(string1,string2)
    @description:
		This function compares two strings alphabetically. If the first string is 'greater'
		than the second, it will return a positive number, a negative number is the second is
		greater and 0 if the two strings are equal.
*/

static bool str_module_fnc_cmp(KviModule *m,KviCommand *c,KviParameterList *parms,KviStr &buffer)
{
	buffer.append(KviStr::Format,"%d",kvi_strcmpCS((*(parms->safeFirst())).ptr(),(*(parms->safeNext())).ptr()));
	return true;
}
/*
    @doc: str.cmpnocase
    @type:
        function
    @title:
        $str.cmpnocase
    @short:
        Compare two strings alphabetically, case insensitive.
    @syntax:
        $str.cmp(string1,string2)
    @description:
        This function compares two strings alphabetically. If the first string is 'greater'
        than the second, it will return a positive number, a negative number is the second is
        greater and 0 if the two strings are equal. This function is case insensitive.
*/
static bool str_module_fnc_cmpnocase(KviModule *m,KviCommand *c,KviParameterList *parms,KviStr &buffer)
{
	buffer.append(KviStr::Format,"%d",kvi_strcmpCI((*(parms->safeFirst())).ptr(),(*(parms->safeNext())).ptr()));
	return true;
}

/*
    @doc: str.find
    @type:
        function
    @title:
        $str.find
    @short:
        Find the index of the nth ocurrence of a substring in a string
    @syntax:
        $str.findfirst(string,substring,ocurrence)
    @description:
		This function search in the string given as the first parameter for the string
		given as his second parameter, and will return the index where the nth ocurrence 
		given as the third parameter is found or -1 if it's not located. It starts 
		counting at 0.
*/

static bool str_module_fnc_find(KviModule *m,KviCommand *c,KviParameterList *parms,KviStr &buffer)
{
	KviStr Str(parms->safeFirstParam());
	KviStr match(parms->safeNextParam());
	int pos = (*(parms->safeNext())).toInt();
	if (pos<1)
	{
		buffer.append("-1");
		return true;
	}
	int cnt = 1;
	int idx;
	int totalIdx = 0;

	while (cnt<=pos)
	{
	 	idx = Str.right(Str.len() - totalIdx).findFirstIdx(match.ptr());
		if(idx == -1)
		{
			buffer.append("-1");
			return true;
		}
		//Idx only gives the index until the pos _before_ the matched string so if this is 
		//not the match we want (cont != 0) we skip it
		totalIdx += (idx + (cnt == pos ? 0 : match.len()));
		++cnt;
	}
	buffer.append(KviStr::Format,"%d",totalIdx);
	return true;
}

/*
    @doc: str.findfirst
    @type:
        function
    @title:
        $str.findfirst
    @short:
        Find the index of a substring in a string
    @syntax:
        $str.findfirst(string1,string2)
    @description:
		This function search in the string given as the first parameter for the string
		given as his second parameter, and will return the index where is first located or
		-1 if it's not located. It starts counting at 0.
*/

static bool str_module_fnc_findfirst(KviModule *m,KviCommand *c,KviParameterList *parms,KviStr &buffer)
{
	buffer.append(KviStr::Format,"%d",(*(parms->safeFirst())).findFirstIdx((*(parms->safeNext())).ptr()));
	return true;
}

/*
    @doc: str.findfirstnocase
    @type:
        function
    @title:
        $str.findfirstnocase
    @short:
        Find the index of a substring in a string, case insensitive
    @syntax:
        $str.findfirstnocase(string1,string2)
    @description:
        This function search in the string given as the first parameter for the string
        given as his second parameter, and will return the index where is first located or
        -1 if it's not located. This function is case insensitive.
*/
static bool str_module_fnc_findfirstnocase(KviModule *m,KviCommand *c,KviParameterList *parms,KviStr &buffer)
{	
	buffer.append(KviStr::Format,"%d",(*(parms->safeFirst())).findFirstIdx((*(parms->safeNext())).ptr(), 0));
	return true;
}

/*
    @doc: str.findlast
    @type:
        function
    @title:
        $str.findlast
    @short:
        Find the last index of a substring in a string
    @syntax:
        $str.findlast(string1,string2)
    @description:
        This function search in the string given as the first parameter for the string
        given as his second parameter, and will return the index where is last located or
        -1 if it's not located.
*/

static bool str_module_fnc_findlast(KviModule *m,KviCommand *c,KviParameterList *parms,KviStr &buffer)
{
	buffer.append(KviStr::Format,"%d",(*(parms->safeFirst())).findLastIdx((*(parms->safeNext())).ptr()));
	return true;
}

/*
    @doc: str.findlastnocase
    @type:
        function
    @title:
        $str.findlastnocase
    @short:
        Find the last index of a substring in a string, case insensitive
    @syntax:
        $str.findlastnocase(string1,string2)
    @description:
        This function search in the string given as the first parameter for the string
        given as his second parameter, and will return the index where is last located or
        -1 if it's not located. This function is case insensitive.
*/

static bool str_module_fnc_findlastnocase(KviModule *m,KviCommand *c,KviParameterList *parms,KviStr &buffer)
{
	buffer.append(KviStr::Format,"%d",(*(parms->safeFirst())).findLastIdx((*(parms->safeNext())).ptr(), 0));
	return true;
}

/*
    @doc: str.left
    @type:
        function
    @title:
        $str.left
    @short:
		Returns a substring starting from the left until the given index.
    @syntax:
        $str.left(string,nchars)
    @description:
		This function returns a substring of the first string parameter which is the
		string starting from the left until the index specified in the second parameter.
*/

static bool str_module_fnc_left(KviModule *m,KviCommand *c,KviParameterList *parms,KviStr &buffer)
{
	buffer.append((*(parms->safeFirst())).left((*(parms->safeNext())).toInt()));
	return true;
}
/*
    @doc: str.right
    @type:
        function
    @title:
        $str.right
    @short:
		Returns a substring starting from the right until the given index.
    @syntax:
        $str.right(string,nchars)
    @description:
		This function returns a substring of the first string parameter which is the
		string starting from the right until the index specified in the second parameter.
		The index start counting at the last character and increase until the first.
*/

static bool str_module_fnc_right(KviModule *m,KviCommand *c,KviParameterList *parms,KviStr &buffer)
{
	buffer.append((*(parms->safeFirst())).right((*(parms->safeNext())).toInt()));
	return true;
}
/*
    @doc: str.mid
    @type:
        function
    @title:
        $str.mid
    @short:
		Returns a substring starting from a given index.
    @syntax:
        $str.mid(string,nchars,startidx)
    @description:
		This function returns a substring of the first string parameter wich is the
		string starting at the (numeric) index given with startidx and counting nchars 
		forward.
*/

static bool str_module_fnc_mid(KviModule *m,KviCommand *c,KviParameterList *parms,KviStr &buffer)
{ 
	buffer.append((*(parms->safeFirst())).middle((*(parms->safeNext())).toInt(),(*(parms->safeNext())).toInt()));
	return true;
}
/*
    @doc: str.append
    @type:
        function
    @title:
        $str.append
    @short:
		Append one string to another.
    @syntax:
        $str.append(string1,string2)
    @description:
		This function returns a string created appending the second string parameter
		to the end of the first string parameter. 
*/

static bool str_module_fnc_append(KviModule *m,KviCommand *c,KviParameterList *parms,KviStr &buffer)
{
	KviStr Str(*(parms->safeFirst()));
	Str.append(*(parms->safeNext()));
	buffer.append(Str);
	return true;
}
/*
    @doc: str.prepend
    @type:
        function
    @title:
        $str.prepend
    @short:
		Prepend one string to another.
    @syntax:
        $str.prepend(string1,string2)
    @description:
		This function returns a string created prepending the second string parameter
		to the start of the first string parameter. 
*/

static bool str_module_fnc_prepend(KviModule *m,KviCommand *c,KviParameterList *parms,KviStr &buffer)
{
	KviStr Str(*(parms->safeFirst()));
	Str.prepend(*(parms->safeNext()));
	buffer.append(Str);
	return true;
}

/*
    @doc: str.insert
    @type:
        function
    @title:
        $str.insert
    @short:
        Inserts a substring in a string at a given index
    @syntax:
        $str.insert(string,substring,index)
    @description:
		Inserts the substring given in the second parameter in the string given in the
		first parameter at the index given in the third parameter, then returns the 
		resulting string.
*/

static bool str_module_fnc_insert(KviModule *m,KviCommand *c,KviParameterList *parms,KviStr &buffer)
{
	buffer.append((*(parms->safeFirst())).insert((*(parms->safeNext())).toInt(),*(parms->safeNext())));
	return true;
}
/*
    @doc: str.strip
    @type:
        function
    @title:
        $str.strip
    @short:
		Returns a whitespace stripped string
    @syntax:
        $str.strip(string)
    @description:
		Returns a left and right whitespace stripped version of the string given as the
		first parameter.
*/

static bool str_module_fnc_strip(KviModule *m,KviCommand *c,KviParameterList *parms,KviStr &buffer)
{
	buffer.append((*(parms->safeFirst())).stripWhiteSpace());
	return true;
}
/*
    @doc: str.stripleft
    @type:
        function
    @title:
        $str.stripleft
    @short:
		Returns a left whitespace stripped string
    @syntax:
        $str.stripright(string)
    @description:
		Returns a left whitespace stripped version of the string given as the
		first parameter.
*/

static bool str_module_fnc_stripleft(KviModule *m,KviCommand *c,KviParameterList *parms,KviStr &buffer)
{
	buffer.append((*(parms->safeFirst())).stripLeftWhiteSpace());
	return true;
}
/*
    @doc: str.stripright
    @type:
        function
    @title:
        $str.stripright
    @short:
		Returns a right whitespace stripped string
    @syntax:
        $str.stripright(string)
    @description:
		Returns a right whitespace stripped version of the string given as the
		first parameter.
*/

static bool str_module_fnc_stripright(KviModule *m,KviCommand *c,KviParameterList *parms,KviStr &buffer)
{
	buffer.append((*(parms->safeFirst())).stripRightWhiteSpace());
	return true;
}
/*
    @doc: str.replace
    @type:
        function
    @title:
        $str.replace
    @short:
		Append one string to another.
    @syntax:
        $str.replace(string,newstr,toreplace)
    @description:
		This function returns a string created replacing all ocurrences of the third parameter
		('toreplace') in the string given as the first parameter ('string') with the string 
		given as the second parameter ('newstr').
*/

static bool str_module_fnc_replace(KviModule *m,KviCommand *c,KviParameterList *parms,KviStr &buffer)
{
	buffer.append((*(parms->safeFirst())).replaceAll((*(parms->safeNext())).ptr(),(*(parms->safeNext())).ptr()));
	return true;
}

/*
    @doc: str.lefttofirst
    @type:
        function
    @title:
        $str.lefttofirst
    @short:
	 	Returns the left part of a string until a given substring
    @syntax:
        $str.lefttofirst(string,substring)
    @description:
		This function returns the left part of the string given as the first parameter
		from the start until the string given as the second parameter is found. It don't 
		include the substring of the second parameter in the returned value. If the second 
		parameter is not found, the entire string is returned.
*/

static bool str_module_fnc_lefttofirst(KviModule *m,KviCommand *c,KviParameterList *parms,KviStr &buffer)
{
	KviStr Str(*(parms->safeFirst()));
	int where = Str.findFirstIdx(*(parms->safeNext()),0);
	if (where != -1)buffer.append(Str.left(where));
	else buffer.append(Str);
	return true;
}
/*
    @doc: str.lefttolast
    @type:
        function
    @title:
        $str.lefttolast
    @short:
	 	Returns the left part of a string until the last ocurrence of a given substring
    @syntax:
        $str.lefttolast(string,substring)
    @description:
		This function returns the left part of the string given as the first parameter
		from the start until the last ocurrence of the string given as the second parameter 
		is found. It don't include the substring of the second parameter in the returned value. 
		If the second parameter is not found, the entire string is returned.
*/

static bool str_module_fnc_lefttolast(KviModule *m,KviCommand *c,KviParameterList *parms,KviStr &buffer)
{
	KviStr Str(*(parms->safeFirst()));
	int where = Str.findLastIdx(*(parms->safeNext()), 0);
	if (where != -1)buffer.append(Str.left(where));
	else buffer.append(Str);
	return true;
}
/*
    @doc: str.rightfromfirst
    @type:
        function
    @title:
        $str.rightfromfirst
    @short:
	 	Returns the right part of a string from the first ocurrence of a given substring
    @syntax:
        $str.rightfromfirst(string,substring)
    @description:
		This function returns the right part of the string given as the first parameter
		from the position where the first ocurrence of the string given as the second parameter 
		is found. It don't include the substring of the second parameter in the returned value. 
		If the second parameter is not found, an empty string is returned..
*/

static bool str_module_fnc_rightfromfirst(KviModule *m,KviCommand *c,KviParameterList *parms,KviStr &buffer)
{
	KviStr Str(*(parms->safeFirst()));
	KviStr match(*(parms->safeNext()));
	int idx = Str.findFirstIdx(match.ptr(), 0);
	if (idx != -1)buffer.append(Str.right(Str.len()-(idx+match.len())));
	else buffer.append("");
	return true;
}
/*
    @doc: str.rightfromlast
    @type:
        function
    @title:
        $str.rightfromlast
    @short:
	 	Returns the right part of a string from the last ocurrence of a given substring
    @syntax:
        $str.rightfromlast(string,substring)
    @description:
		This function returns the right part of the string given as the first parameter
		from the position where the last ocurrence of the string given as the second parameter 
		is found. It don't include the substring of the second parameter in the returned value. 
		If the second parameter is not found, an empty string is returned..
*/

static bool str_module_fnc_rightfromlast(KviModule *m, KviCommand *c,KviParameterList *parms,KviStr &buffer)
{
	KviStr Str(*(parms->safeFirst()));
	KviStr match(*(parms->safeNext()));
	int idx = Str.findLastIdx(match.ptr(), 0);
	if (idx != -1)buffer.append(Str.right(Str.len()-(idx+match.len())));
	else buffer.append("");
	return true;
}			

//First parameter is the wildcard, the second is the string
static bool str_module_fnc_containswild(KviModule *m,KviCommand *c,KviParameterList *parms,KviStr &buffer)
{
	buffer.append(kvi_matchString(*(parms->safeFirst()),*(parms->safeNext())) ? "1" : "0");
	return true;
}
	
/*********************************************************************/
//              Module stuff
/********************************************************************/

static bool str_module_init(KviModule * m)
{
	m->registerFunction("len", str_module_fnc_len);
	m->registerFunction("lowcase", str_module_fnc_lowcase);
	m->registerFunction("upcase", str_module_fnc_upcase);
	m->registerFunction("isnumber", str_module_fnc_isnumber);
	m->registerFunction("isunsignednumber", str_module_fnc_isunsignednumber);
	m->registerFunction("isempty", str_module_fnc_isempty);
	m->registerFunction("contains", str_module_fnc_contains);
	m->registerFunction("containsnocase", str_module_fnc_containsnocase);
	m->registerFunction("equal", str_module_fnc_equal);
	m->registerFunction("equalnocase", str_module_fnc_equalnocase);
	m->registerFunction("cmp", str_module_fnc_cmp); 
	m->registerFunction("cmpnocase", str_module_fnc_cmpnocase); 
	m->registerFunction("find", str_module_fnc_find);
	m->registerFunction("findfirst", str_module_fnc_findfirst); 
	m->registerFunction("findfirstnocase", str_module_fnc_findfirstnocase); 
	m->registerFunction("findlast", str_module_fnc_findlast); 
	m->registerFunction("findlastnocase", str_module_fnc_findlastnocase);
	m->registerFunction("left", str_module_fnc_left); 
	m->registerFunction("right", str_module_fnc_right);
	m->registerFunction("mid", str_module_fnc_mid);
	m->registerFunction("append", str_module_fnc_append);
	m->registerFunction("prepend", str_module_fnc_prepend);
	m->registerFunction("insert", str_module_fnc_insert);
	m->registerFunction("strip", str_module_fnc_strip);
	m->registerFunction("stripleft", str_module_fnc_stripleft);
	m->registerFunction("stripright", str_module_fnc_stripright);
	m->registerFunction("replace", str_module_fnc_replace);
	m->registerFunction("lefttofirst", str_module_fnc_lefttofirst); 
	m->registerFunction("lefttolast", str_module_fnc_lefttolast); 
	m->registerFunction("rightfromfirst", str_module_fnc_rightfromfirst); 
	m->registerFunction("rightfromlast", str_module_fnc_rightfromlast); 
	m->registerFunction("containswild", str_module_fnc_containswild);

//
// str.findFirstWild, str.findLastWild , str.findWild
// str.findFirstRegex , str.findLastRegex , str.findRegex
// 
// str.transliterate
//
// str.leftToFirstWild str.leftToFirstRegex
// str.leftToLastWild str.leftToLastRegex
// str.rightFromFirstWild str.rightFromFirstRegex
// str.rightFromLastWild str.rightFromLastRegex
//
// str.replaceWild str.replaceRegexp
// str.replaceFirst str.replaceFirstWild str.replaceFirstRegex
// str.replaceLast str.replaceLastWild str.replaceLastRegex
//
// str.split str.splitWild str.splitRegexp
//
// str.containsRegexp

	return true;
}

static bool str_module_cleanup(KviModule *m)
{
	return true;
}

KVIMODULEEXPORTDATA KviModuleInfo kvirc_module_info=
{
	"File",                                                 // module name
	"1.0.0",                                                // module version
	"Copyright (C) 2002 Szymon Stefanek (stefanek@tin.it)"\
	"          (C) 2002 Juanjo Alvarez (juanjux@yahoo.es)", // author & (C)
	"Interface to the str system",
	str_module_init,
	0,
	0,
	str_module_cleanup
};
