//   File : controller.cpp
//   Creation date : Thu Apr 30 2002 17:13:12 GMT by Juanjo lvarez
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2002 Juanjo lvarez (juanjux@yahoo.es)
//   Copyright (C) 2002 Szymon Stefanek (kvirc@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "controller.h"
#include "kvi_window.h"
#include "kvi_console.h"
#include "kvi_string.h"
#include "kvi_app.h"
#include "kvi_options.h"

#include <qtimer.h>
#include <qstringlist.h>
#include <qclipboard.h>

extern KviPtrList<SPasteController> * g_pControllerList;

SPasteController::SPasteController(KviWindow * w,int id):m_pClipBuff(NULL),m_pFile(NULL),m_pId(id),m_pWindow(w)
{
    g_pControllerList->append(this);
    //m_pWindow = w;
    m_pTimer = new QTimer(this);
}

SPasteController::~SPasteController(void)
{
    g_pControllerList->removeRef(this);
    if(m_pFile)m_pFile->close();
    m_pTimer->stop();
    delete m_pTimer;
    delete m_pClipBuff;
}

bool SPasteController::pasteFileInit(QString &fileName)
{
    
    m_pFile = new QFile(fileName);
    if(!m_pFile->open(IO_ReadOnly))return false;
    connect(m_pTimer,SIGNAL(timeout()),this,SLOT(pasteFile()));
    m_pTimer->start(KVI_OPTION_UINT(KviOption_uintPasteDelay));
    return true;
}

bool SPasteController::pasteClipboardInit(void)
{
    QString tmp(g_pApp->clipboard()->text());
    m_pClipBuff = new QStringList(QStringList::split("\n", tmp));
    m_clipBuffIterator = m_pClipBuff->begin();
    connect(m_pTimer,SIGNAL(timeout()),this,SLOT(pasteClipboard()));
    m_pTimer->start(KVI_OPTION_UINT(KviOption_uintPasteDelay));
    return true;
}

void SPasteController::pasteFile(void)
{
    QString line;
    if(m_pFile->readLine(line,999) != -1)
    {
        if( (!g_pApp->windowExists(m_pWindow)) || m_pWindow->console()->isNotConnected() )
        { 
            m_pFile->close();
            delete this;
        } else m_pWindow->ownMessage(__q2ascii(line));
    } else { //File finished
        m_pFile->close();
        delete this;
    }
}

void SPasteController::pasteClipboard(void)
{
    if(m_clipBuffIterator != m_pClipBuff->end()) 
    {
        if( (!g_pApp->windowExists(m_pWindow)) || m_pWindow->console()->isNotConnected() )
        {
            debug("La ventana ya no existe!!");
            delete this;
        } else 
        {
            m_pWindow->ownMessage(__q2ascii((*m_clipBuffIterator)));
            ++m_clipBuffIterator;
        }
    } else  delete this;//Clipboard finished
}

#include "controller.moc"
