//FIXME: 
//1. Reorganize it in two files?
//2. Windoze support! (Pragma I need you ;P)
//   File : libkvisnd.cpp
//   Creation date : Thu Dec 27 2002 17:13:12 GMT by Juanjo lvarez
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2002 Juanjo lvarez (juanjux@yahoo.es)
//   Copyright (C) 2002 Szymon Stefanek (kvirc@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//


#include "libkvisnd.h"
#include "kvi_module.h"
#include "kvi_debug.h"
#include "kvi_options.h"
#include "kvi_thread.h"
#include "kvi_uparser.h"
#include "kvi_fileutils.h"
#include "kvi_malloc.h"

#ifdef COMPILE_ON_WINDOWS
	#include <mmsystem.h>
#else //!COMPILE_ON_WINDOWS

#include <qfile.h>

#ifdef HAS_ESD_SUPPORT
	#include <esd.h>
#endif

#include <unistd.h>
#include <errno.h>

#ifdef HAS_OSS_SUPPORT
	#include <fcntl.h>
	#include <sys/ioctl.h>
	#include <linux/soundcard.h>
	#ifdef HAS_AUDIOFILE_SUPPORT
		#include <audiofile.h>
	#endif //HAS_AUDIOFILE_SUPPORT
#endif //HAS_OSS_SUPPORT

#ifdef HAS_ARTS_SUPPORT
	#include <kde/arts/soundserver.h>
#endif

int g_soundSystem = NONE;

#ifdef HAS_OSS_SUPPORT

#ifdef HAS_AUDIOFILE_SUPPORT
#define BUFFER_FRAMES 4096 
void *play_oss_threadFunction(void * arg)
{
	KviStr * filename = (KviStr *)arg;

	AFfilehandle file;
	AFframecount frameCount, framesRead;
	int sampleFormat, sampleWidth, channelCount, format, freq;
	float frameSize;
	void * buffer;

	file = afOpenFile(filename->ptr(),"r",NULL);
	afGetVirtualSampleFormat(file, AF_DEFAULT_TRACK, &sampleFormat, &sampleWidth);
	frameSize = afGetVirtualFrameSize(file, AF_DEFAULT_TRACK, 1);
	channelCount = afGetVirtualChannels(file, AF_DEFAULT_TRACK); 
	buffer = kvi_malloc(int(BUFFER_FRAMES * frameSize));
    
    int audiofd_c = open("/dev/dsp", O_WRONLY | O_EXCL | O_NDELAY);
	QFile audiofd;
    audiofd.open(IO_WriteOnly,audiofd_c);
    
	if(audiofd_c < 0)
	{
		debug("Could not open audio devive /dev/dsp! [OSS]");
		debug("(the device is probably busy)");
		goto exit_thread;
	}
	
	if (sampleWidth == 8) 
		format = AFMT_U8;
	else if (sampleWidth == 16)
		format = AFMT_S16_NE;

	if (ioctl(audiofd.handle(),SNDCTL_DSP_SETFMT, &format) == -1) {
		debug("Could not set format width to DSP! [OSS]");
		goto exit_thread;
	}
	
	if (ioctl(audiofd.handle(), SNDCTL_DSP_CHANNELS, &channelCount) == -1) {
		debug("Could not set DSP channels! [OSS]");
		goto exit_thread;
	}

	freq = (int) afGetRate(file, AF_DEFAULT_TRACK);
	if (ioctl(audiofd.handle(), SNDCTL_DSP_SPEED, &freq) == -1) {
		debug("Could not set DSP speed %d! [OSS]",freq);
		goto exit_thread;
	}

	framesRead = afReadFrames(file, AF_DEFAULT_TRACK, buffer, BUFFER_FRAMES);

	while(framesRead > 0)
	{
		int wrote = audiofd.writeBlock((char *)buffer,(int)(framesRead * frameSize));
		framesRead = afReadFrames(file, AF_DEFAULT_TRACK, buffer,BUFFER_FRAMES); 
	}

exit_thread:
	audiofd.close();
	if(audiofd_c >= 0)close(audiofd_c);
	afCloseFile(file);
	delete filename;
	kvi_free(buffer);
	return 0;
}

#else

#define OSS_BUFFER_SIZE 16384

//-------------------------------------------------
void *play_oss_threadFunction(void * arg)
//FIXME: This makes (on my sound card at least) little glitches before and
//after the sound playing (I guess that's caused by the opening & closing of the
//sound device)
//This version of the function only supports AU Law files (.au)
{
	KviStr * filename = (KviStr *)arg;

	QFile f(filename->ptr());
	int fd = -1;
	char buf[OSS_BUFFER_SIZE];
	int iDataLen = 0;
	int iSize = 0;

	if(!f.open(IO_ReadOnly))
	{
		debug("Could not open sound file %s! [OSS]",filename->ptr());
		delete filename;
		return 0;
	}

	iSize = f.size();

	if(iSize < 24)
	{
		debug("Could not play sound, file %s too small! [OSS]",filename->ptr());
		goto exit_thread;
	}

	if(f.readBlock(buf,24) < 24)
	{
		debug("Error while reading the sound file header (%s)! [OSS]",filename->ptr());
		goto exit_thread;
	}

	iSize -= 24;

	fd = open("/dev/audio",  O_WRONLY | O_EXCL | O_NDELAY);
	if(fd < 0)
	{
		debug("Could not open device file /dev/audio!");
		debug("Maybe other program is using the device? Hint: fuser -uv /dev/audio");
		goto exit_thread;
	}


	while(iSize > 0)
	{
		int iCanRead = OSS_BUFFER_SIZE - iDataLen;
		if(iCanRead > 0)
		{
			int iToRead = iSize > iCanRead ? iCanRead : iSize;
			int iReaded = f.readBlock(buf + iDataLen,iToRead);
			if(iReaded < 1)
			{
				debug("Error while reading the file data (%s)! [OSS]",filename->ptr());
				goto exit_thread;
			}
			iSize -= iReaded;
			iDataLen += iReaded;
		}
		if(iDataLen > 0)
		{
			int iWritten = write(fd,buf,iDataLen);
			if(iWritten < 0)
			{
				if((errno != EINTR) && (errno != EAGAIN))
				{
					debug("Error while writing the audio data (%s)! [OSS]",filename->ptr());
					goto exit_thread;
				}
			}
			iDataLen -= iWritten;
		} else {
			// nothing to write ????
			goto exit_thread;
		}
	}

exit_thread:
	delete filename;
	f.close();
	if(fd > 0)close(fd);
	return 0;
}

#endif // HAS_AUDIOFILE_SUPPORT
#endif // HAS_OSS_SUPPORT

//-------------------------------------------------
#ifdef HAS_ESD_SUPPORT
//Esd has a really nice API...
void *play_esd_threadFunction(void * arg) 
{
	KviStr * filename = (KviStr *)arg;
	if(!esd_play_file(NULL,filename->ptr(),1))
		debug("Could not play sound %s! [ESD]",filename->ptr());
	delete filename;
	return 0;
}
#endif
//-------------------------------------------------

#ifdef HAS_ARTS_SUPPORT 

//using namespace std;
//using namespace Arts;

void *play_arts_threadFunction(void * arg) 
{
	KviStr * filename = (KviStr *)arg;
	Arts::Dispatcher *dispatcher = new Arts::Dispatcher;
	Arts::SimpleSoundServer *server = new Arts::SimpleSoundServer(Arts::Reference("global:Arts_SimpleSoundServer"));
	if(server->isNull())
	{
		debug("Can't connect to sound server to play file %s",filename->ptr());
	} else {
		server->play(filename->ptr());
	}

	delete filename;
	delete server;
	delete dispatcher;
	return 0;
/*

	// (ARTS is too complex , uses too much STDC++)
	// basically ugly :D
	Dispatcher dispatcher;
	SimpleSoundServer server;

	ObjectReference r;
	if(dispatcher.stringToObjectReference(r,"global:Arts_SimpleSoundServer"))
		server = SimpleSoundServer_base::_fromReference(r,true);

	if(server.isNull())
	{
		debug("Can't connect to the sound server to play file %s",filename->ptr());
	} else {
		server.play(filename->ptr());
	}
	delete filename;
	return 0;
*/
}
#endif
//-------------------------------------------------
void *play_nas_threadFunction(void * arg)
{
	KviStr * filename = (KviStr *)arg;
	delete filename;
	return 0;
}
//-------------------------------------------------

int detect_soundsystem() 
{
#ifdef HAS_ARTS_SUPPORT
	Arts::Dispatcher *dispatcher = new Arts::Dispatcher;
	Arts::SimpleSoundServer *server = new Arts::SimpleSoundServer(Arts::Reference("global:Arts_SimpleSoundServer"));
	if(!server->isNull()) {
        //Don't change the order of those deletes!
		if(server)delete server;
		if(dispatcher)delete dispatcher;
		return ARTS;
    }
    else {
        if(server)delete server;
        if(dispatcher)delete dispatcher;
    }
#endif
#ifdef HAS_ESD_SUPPORT
	esd_format_t format = ESD_BITS16 | ESD_STREAM | ESD_PLAY | ESD_MONO;
	int esd_fd = esd_play_stream(format, 8012, NULL, "kvirc");
	if (esd_fd >= 0) {
		return ESD;
	}
#endif
#ifdef HAS_OSS_SUPPORT
	// Fingers crossed... anyway the OSS code has his own error detection
	return OSS;
#endif
	return NONE;
}

#endif //!COMPILE_ON_WINDOWS

//-------------------------------------------------
/*
    @doc: snd.play
    @type:
        command
    @title:
        snd.play
    @short:
        Play a sound file from the disk
    @syntax:
        snd.play <filename>
    @description:
        Play a file, using the sound system specified by the user in the options.[br]
        The supported file formats vary from one sound system to another, but the best
        bet could be Au Law (.au) files. Artsd, EsounD and Linux/OSS with audiofile support also
        support other formats like .wav files but in OSS without audiofile only .au files are
        supported.
		On windows the supported file formats are determined by the drivers installed.
		You should be able to play at least *.wav files.[br]
		(This is a task where the Windows interface is really well done, I must say that :)
*/

static bool snd_module_cmd_play(KviModule *m,KviCommand *c)
{
 	ENTER_CONTEXT(c,"snd_module_cmd_play");
	KviStr fname;
	if(!g_pUserParser->parseCmdFinalPart(c,fname))return false;

	if(fname.isEmpty() || (!kvi_fileExists(fname.ptr())))
	{
		c->warning("File '%s' not found!",fname.ptr());
		return c->leaveContext();
	}

#ifdef COMPILE_ON_WINDOWS
	sndPlaySound(fname.ptr(),SND_ASYNC | SND_NODEFAULT);
#else
	kvi_thread_t k_thread;

	//szFilename must be dinamic so it's not deleted when we exit this function (with
	//all the problems it could cause to the thread if it has not finished yet), so it 
	//gets deleted on the thread to which is passed.
	KviStr * szFilename = new KviStr(fname);

	switch(g_soundSystem)
	{
#ifdef HAS_ESD_SUPPORT
		case ESD:
			kvi_threadCreate(&k_thread,&play_esd_threadFunction,(void *)szFilename);
			break;
#endif
#ifdef HAS_ARTS_SUPPORT
		case ARTS:
			kvi_threadCreate(&k_thread,&play_arts_threadFunction,(void *)szFilename);
			break;
#endif
#ifdef HAS_NAS_SUPPORT
		case NAS:
			kvi_threadCreate(&k_thread,&play_nas_threadFunction,(void *)szFilename);
			break;
#endif
#ifdef HAS_OSS_SUPPORT
		case OSS:
			kvi_threadCreate(&k_thread,&play_oss_threadFunction,(void *)szFilename);
			break;
#endif			
		default:
			break;
	}
#endif //!COMPILE_ON_WINDOWS

	return c->leaveContext();
}
//-------------------------------------------------
#ifndef COMPILE_ON_WINDOWS

static bool snd_module_cmd_autodetect(KviModule *m,KviCommand *c)
{
	if(KVI_OPTION_UINT(KviOption_uintSoundSystem) == 1)
	{
        g_soundSystem = detect_soundsystem();
    }
    return true;
}

#endif //!COMPILE_ON_WINDOWS
//-------------------------------------------------
static bool snd_module_init(KviModule * m)
{

#ifndef COMPILE_ON_WINDOWS
    g_soundSystem = KVI_OPTION_UINT(KviOption_uintSoundSystem);
    if(g_soundSystem == AUTODETECT)
	{
        g_soundSystem = detect_soundsystem();
    }
    m->registerCommand("autodetect", snd_module_cmd_autodetect);
#endif

	m->registerCommand("play", snd_module_cmd_play);
	return true;
}
//-------------------------------------------------
static bool snd_module_cleanup(KviModule *m)
{
	return true;
}
//-------------------------------------------------
KVIMODULEEXPORTDATA KviModuleInfo kvirc_module_info=
{
	"Sound",                                                 // module name
	"1.0.0",                                                // module version
	"          (C) 2002 Juanjo Alvarez (juanjux@yahoo.es)", // author & (C)
	"Sound playing commands",
	snd_module_init,
	0,
	0,
	snd_module_cleanup
};
