//
//   File : setupwizard.cpp
//   Creation date : Sat Oct  6 02:06:53 2001 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//



#include "setupwizard.h"

#include "dirview.h"


#include "kvi_app.h"
#include "kvi_locale.h"
#include "kvi_fileutils.h"
#include "kvi_defaults.h"
#include "kvi_msgbox.h"

#include <qmultilineedit.h>
#include <qdir.h>

#ifdef COMPILE_ON_WINDOWS
	#include <windows.h>
	#include <winnls.h>  // for MultiByteToWideChar
	#include <objbase.h> // CoCreateInstance , CoInitialize & CO.
	#include <shlobj.h>  // IShellLink IPersistFile & CO.
#else
	#include <unistd.h>  // for symlink()
#endif


KviSetupPage::KviSetupPage(KviSetupWizard * w)
: QHBox(w)
{
	setSpacing(8);

	m_pPixmapLabel = new QLabel(this);

	m_pPixmapLabel->setPixmap(*(w->m_pLabelPixmap));
	m_pPixmapLabel->setFrameStyle(QFrame::Sunken | QFrame::WinPanel);
	m_pPixmapLabel->setMargin(0);
	m_pPixmapLabel->setAlignment(Qt::AlignLeft | Qt::AlignTop);
	m_pPixmapLabel->setIndent(0);
	m_pPixmapLabel->setFixedSize(w->m_pLabelPixmap->size());
//	m_pPixmapLabel->setMaximumSize(w->m_pLabelPixmap->size());

	m_pVBox = new QVBox(this);

	m_pTextLabel = new QLabel(m_pVBox);
	m_pTextLabel->setAlignment(Qt::AlignLeft | Qt::AlignTop);
}

KviSetupPage::~KviSetupPage()
{
}


KviSetupWizard::KviSetupWizard()
: QWizard(0,0,true)
{
	KviStr szImagePath;
	g_pApp->getGlobalKvircDirectory(szImagePath,KviApp::Pics,"kvi_setup_label.png");

	m_pLabelPixmap = new QPixmap(szImagePath.ptr());
	if(m_pLabelPixmap->isNull())
	{
		delete m_pLabelPixmap;
		m_pLabelPixmap = new QPixmap(120,400);
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Welcome

	m_pWelcome = new KviSetupPage(this);
	m_pWelcome->m_pTextLabel->setText(__tr( \
			"<h2>Welcome :)</h2><br><br>" \
			"You have just installed a new version of KVIrc " \
			"and you're running it for the first time.<br><br>" \
			"This wizard will guide you through few steps " \
			"required to complete the setup.<br><br>" \
			"Click \"Next\" to proceed."));

	addPage(m_pWelcome,__tr("Welcome"));

	setBackEnabled(m_pWelcome,false);
	setHelpEnabled(m_pWelcome,false);

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// License

	KviSetupPage * m_pLicense = new KviSetupPage(this);
	m_pLicense->m_pTextLabel->setText(__tr( \
			"All the files in this distribution are covered by the GPL license.<br>" \
			"In human terms this can be resumed as follows:<br>" \
			"<ul>" \
			"<li><b>KVIrc is free</b> , use it and have fun! <b>:)</b></li>" \
			"<li>If you use <b>any</b> part of KVIrc in your own projects you MUST release that project with the same license</li>" \
			"</ul><br>" \
			"The \"legalese\" version of the license is in the box below.<br>"));

	QMultiLineEdit * ed = new QMultiLineEdit(m_pLicense->m_pVBox);
	KviStr szLicense;
	KviStr szLicensePath;
	g_pApp->getGlobalKvircDirectory(szLicensePath,KviApp::License,"COPYING");
	
	if(!kvi_loadFile(szLicensePath.ptr(),szLicense))
	{
		szLicense = __tr("Ops...can't find the license file...\n" \
						"It MUST be included in the distribution...\n" \
						"please report to <pragma at kvirc dot net>");
	}
	ed->setText(szLicense.ptr());

	addPage(m_pLicense,__tr("Legalese: The license"));

	setHelpEnabled(m_pLicense,false);

	setCaption(__tr("KVIrc setup"));

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Local dir

	KviSetupPage * m_pDirectory = new KviSetupPage(this);

	m_pDirectoryEdit = new QLineEdit(m_pDirectory->m_pVBox);
//	m_pDirectoryEdit->setReadOnly(true);
	KviStr base;

#ifdef COMPILE_ON_WINDOWS
	KviStr tmp = "C:\\";
	base = tmp;
	tmp.append(KVI_LOCAL_KVIRC_SUBDIRECTORY_NAME);
#else
	KviStr tmp = QDir::homeDirPath();
	base = tmp;
	tmp.ensureLastCharIs(KVI_PATH_SEPARATOR_CHAR);
	tmp.append(KVI_LOCAL_KVIRC_SUBDIRECTORY_NAME);
#endif
	tmp.ensureLastCharIs(KVI_PATH_SEPARATOR_CHAR);
	kvi_adjustFilePath(tmp);
	m_pDirectoryEdit->setText(tmp.ptr());


#ifdef COMPILE_ON_WINDOWS

	m_pDirectory->m_pTextLabel->setText(__tr( \
		"You need to choose a folder now.<br>" \
		"KVIrc will use it to store its configuration and to "
		"save the downloaded files.<br>" \
		"Tip: choose a folder that you will be able to find easily later<br>"));

	addPage(m_pDirectory,__tr("Configuration folder"));
#else
	m_pDirectory->m_pTextLabel->setText(__tr( \
		"You need to choose a directory now.<br>" \
		"KVIrc will use it to store its configuration and to "
		"save the downloaded files.<br>" \
		"Make sure that you have the write permissions to that directory.<br>" \
		"Tip: choose a path that you will be able to find easily later<br>"));

	addPage(m_pDirectory,__tr("Configuration directory"));
#endif

	DirectoryView * w = new DirectoryView(m_pDirectory->m_pVBox);

	connect(w,SIGNAL(folderSelected(const QString &)),this,SLOT(directorySelected(const QString &)));

	w->setDir(base.ptr());
	setHelpEnabled(m_pDirectory,false);


#ifdef COMPILE_ON_WINDOWS
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Link
	m_pLink = new KviSetupPage(this);

	m_pLink->m_pTextLabel->setText(__tr( \
			"KVIrc can make a shortcut to the KVIrc executable on " \
			"your desktop , so you will be able to start it quickly.<br>" \
			"Do you want the shortcut to be made ?"));

	m_pLinkButtonGroup = new QVButtonGroup(m_pLink->m_pVBox);

	m_pLinkYes = new QRadioButton(__tr("Yes"),m_pLinkButtonGroup);
	m_pLinkNo  = new QRadioButton(__tr("No"),m_pLinkButtonGroup);
	
	m_pLinkYes->setChecked(true);

	addPage(m_pLink,__tr("Desktop link"));

	setHelpEnabled(m_pLink,false);
#endif


	/////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Finish
	m_pFinish = new KviSetupPage(this);

	m_pFinish->m_pTextLabel->setText(__tr( \
			"<b>Information gathering done</b><br><br>" \
			"All the informations have been gathered sucesfully.<br>" \
			"Please click \"Finish\" to really commit the operations and startup KVIrc."));

	addPage(m_pFinish,__tr("Commit your selections"));

	setFinishEnabled(m_pFinish,true);
	setHelpEnabled(m_pFinish,false);
}


KviSetupWizard::~KviSetupWizard()
{
	delete m_pLabelPixmap;
}

void KviSetupWizard::directorySelected(const QString &szDir)
{
	KviStr szDirectory = szDir;
	kvi_adjustFilePath(szDirectory);
	szDirectory.ensureLastCharIs(KVI_PATH_SEPARATOR_CHAR);
	szDirectory.append(KVI_LOCAL_KVIRC_SUBDIRECTORY_NAME);
	szDirectory.ensureLastCharIs(KVI_PATH_SEPARATOR_CHAR);
	kvi_adjustFilePath(szDirectory);
	m_pDirectoryEdit->setText(szDirectory.ptr());
}


void KviSetupWizard::accept()
{
	KviStr szDir = m_pDirectoryEdit->text();
	kvi_adjustFilePath(szDir);
	if(!kvi_directoryExists(szDir.ptr()))
	{
		if(!kvi_makeDir(szDir.ptr()))
		{
			kvi_warningBox(__tr("Ops...can't make the directory %s," \
				"you probably miss the write permissions somewhere " \
				"in that path. Please go back and choose another directory."));
			showPage(m_pDirectory);
			return;
		}
	} else {
		kvi_infoBox(__tr("Kvirc setup"),
			__tr("The directory '%s' already exists.\n" \
			"(maybe from a previous Kvirc installation)\n"\
			"If you experience any problems try deleting the old directory:\n" \
			"the setup program will be started automatically again."),szDir.ptr());
	}
	g_pApp->m_szLocalKvircDir = szDir;
	g_pApp->m_szLocalKvircDir.ensureLastCharIs(KVI_PATH_SEPARATOR_CHAR);

#ifndef COMPILE_ON_WINDOWS
	// Make local->global link
	KviStr localPath(KviStr::Format,"%s/global",g_pApp->m_szLocalKvircDir.ptr());
	symlink(g_pApp->m_szGlobalKvircDir.ptr(),localPath.ptr());
#endif

#ifdef COMPILE_ON_WINDOWS

	if(m_pLinkButtonGroup->selected() == m_pLinkYes)
	{
		// Let's make a link on the desktop :)
		// You need this horrible snippet of code to create a shortcut!!!!
		//
		// you have to:
		// - dig in the registry , 
		// - trigger the entire COM subsystem
		// - bring up a couple of OLE interfaces....
		// - use some obscure functions like MultiByteToWideChar
		// - and the finally drop the entire OLE+COM interface in the garbadge
		// ...
		// Isn't this horrible ? (compared to symlink()!)
		//
	
		// Well..let's go (please note that we don't handle most possible errors!
		// otherwise there would be 150 lines for a stupid symlink!)
	
		HKEY hCU;
	    DWORD lpType;
	    ULONG ulSize = MAX_PATH;
		char szLink[MAX_PATH];
	
		// Dig in the registry looking up the Desktop path
	    if(RegOpenKeyEx(HKEY_CURRENT_USER,
			"Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", 
			0,KEY_QUERY_VALUE,&hCU) == ERROR_SUCCESS)
		{
			RegQueryValueEx(hCU,"Desktop",NULL,&lpType,
	        (unsigned char *)&szLink,&ulSize);
			RegCloseKey(hCU);
	    }
	
		// Build our paths
		KviStr szLinkTarget = szLink;
		szLinkTarget.append("\\kvirc.lnk");
	
		KviStr szKvircExec = g_pApp->m_szGlobalKvircDir;
		szKvircExec.append("\\kvirc.exe");
	
		// Trigger a horrible machinery
		CoInitialize(NULL); // we need COM+OLE
	
		// Fiddle with an obscure shell interface
		IShellLink* psl;
	
	    // Get a pointer to the IShellLink interface: this is kinda ugly :)
	    if(CoCreateInstance(CLSID_ShellLink,NULL,CLSCTX_INPROC_SERVER,
					IID_IShellLink,(void **)&psl) == S_OK)
		{
			// just for fun , lookup another shell interface
	
			IPersistFile* ppf;
	
			// Query IShellLink for the IPersistFile interface for 
			// saving the shell link in persistent storage.
			if(psl->QueryInterface(IID_IPersistFile,(void **)&ppf) == S_OK)
			{
				WORD wsz[MAX_PATH];
				// Set the path to the shell link target.
				psl->SetPath(szKvircExec.ptr());
				// Set the description of the shell link.
				psl->SetDescription("kvirc");
		        // Ensure string is ANSI.
				MultiByteToWideChar(CP_ACP,0,szLinkTarget.ptr(),-1,wsz,MAX_PATH);
				// Save the link via the IPersistFile::Save method.
				ppf->Save(wsz,true);    
				ppf->Release();
			}
			psl->Release();
		}
		// And throw OLE & Co. in the garbadge
		CoUninitialize();
	}
	
#endif //COMPILE_ON_WINDOWS

	QWizard::accept();
}

#include "setupwizard.moc"
