//
//   File : libkvisetup.cpp
//   Creation date : Sat Oct  6 02:08:24 2001 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_module.h"

#include "setupwizard.h"

/*

*/
//#warning "We need a nicer dialog box for this :) a module ?"
/*
bool first_time_run()
{
		kvi_infoBox(__tr("Kvirc setup"),
				__tr("Welcome to the Kvirc setup program!\n"\
				"You will be asked to choose an existing directory now.\n"\
				"A '%s' subdirectory will be created inside , and Kvirc will\n"\
				"use it to store its configuration files.\n"\
				"Make sure that you have the write permission to that directory.\n"),
				KVI_LOCAL_KVIRC_SUBDIRECTORY_NAME);

		KviStr home = QDir::homeDirPath();

		// Can't use KviFileDialog : we're still missing the bookmark dirs & co...
		m_szLocalKvircDir=QFileDialog::getExistingDirectory(home.ptr());

		kvi_adjustFilePath(m_szLocalKvircDir);

		//debug("Attempting to make dir %s",m_szLocalKvircDir.ptr());

		if(m_szLocalKvircDir.isEmpty())
		{
			kvi_warningBox(__tr("Setup aborted."));
			exit(-1);
		}

		m_szLocalKvircDir+=KVI_PATH_SEPARATOR;
		m_szLocalKvircDir+=KVI_LOCAL_KVIRC_SUBDIRECTORY_NAME;
		//Now create the dir...
		if(kvi_directoryExists(m_szLocalKvircDir.ptr()))
		{

		} else if(!kvi_makeDir(m_szLocalKvircDir.ptr()))
		{
			//Failed to make the dir...
			kvi_warningBox(__tr("Could not make the directory %s.\n"\
				"Trying alternate default $HOME/%s" ),m_szLocalKvircDir.ptr(),KVI_LOCAL_KVIRC_SUBDIRECTORY_NAME);
			m_szLocalKvircDir=QDir::homeDirPath();
			m_szLocalKvircDir+=KVI_PATH_SEPARATOR;
			m_szLocalKvircDir+=KVI_LOCAL_KVIRC_SUBDIRECTORY_NAME;
			if(kvi_directoryExists(m_szLocalKvircDir.ptr()))
			{
				kvi_infoBox(__tr("Kvirc setup"),
					__tr("The '%s' subdirectory already exists , maybe from a previous Kvirc installation.\n"\
					"It can be used...but if you experience any problems try deleting the old directory\n."\
					"and repeating the setup."),KVI_LOCAL_KVIRC_SUBDIRECTORY_NAME);
			} else if(!kvi_makeDir(m_szLocalKvircDir.ptr()))
			{
				kvi_warningBox(__tr("Could not make directory $HOME/%s.\n"\
					"Bad luck...you have some problems with you enviroinment,\n"\
					"the $HOME/%s path is not writable or it is not a directory.\n"\
					"Setup aborted."),KVI_LOCAL_KVIRC_SUBDIRECTORY_NAME,KVI_LOCAL_KVIRC_SUBDIRECTORY_NAME);
				exit(-1);
			}
		}


}
*/

static void unregisterLocalMetaObjects()
{
	KviModule::unregisterMetaObject("KviSetupWizard");
	KviModule::unregisterMetaObject("KviSetupPage");
	KviModule::unregisterMetaObject("DirectoryView");
}


KVIMODULEEXPORTFUNC bool setup_wizard()
{
	KviSetupWizard * w = new KviSetupWizard();
	int retcode = w->exec();
	delete w;
	unregisterLocalMetaObjects();
	return (retcode == QDialog::Accepted);
}

static bool setup_module_init(KviModule *m)
{
	return true;
}

static bool setup_module_cleanup(KviModule *m)
{
	unregisterLocalMetaObjects();
	return true;
}

static bool setup_module_can_unload(KviModule *m)
{
	return true; // can be always unloaded...this module does basically nothing
}


KVIMODULEEXPORTDATA KviModuleInfo kvirc_module_info =
{
    "Setup wizard",
	"1.0.0",
	"Szymon Stefanek <stefanek@tin.it>" ,
	"First-time-run setup wizard",
    setup_module_init ,
    setup_module_can_unload,
    0,
	setup_module_cleanup
};
