#ifndef _DIRVIEW_H
#define _DIRVIEW_H



#include "kvi_settings.h"

#include <qlistview.h>
#include <qstring.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qtimer.h>


class QWidget;


class Directory : public QListViewItem
{
public:
    Directory( QListView * parent, const QString& filename );
    Directory( Directory * parent, const QString& filename, const QString &col2 )
	: QListViewItem( parent, filename, col2 ), pix( 0 ) {}
    Directory( Directory * parent, const QString& filename );

    QString text( int column ) const;

    QString fullName();

    void setOpen( bool );
    void setup();

    const QPixmap *pixmap( int i ) const;
    void setPixmap( QPixmap *p );

private:
    QFile f;
    Directory * p;
    bool readable;
    QPixmap *pix;

};

class DirectoryView : public QListView
{
	Q_OBJECT
public:
	DirectoryView( QWidget *parent = 0, const char *name = 0);
	~DirectoryView();
signals:
	void folderSelected( const QString & );
protected slots:
	void slotFolderSelected( QListViewItem * );
protected:
	void contentsMousePressEvent( QMouseEvent *e );
	void contentsMouseReleaseEvent( QMouseEvent *e );
private:
    QString fullPath(QListViewItem* item);
    QListViewItem *oldCurrent;
    QPoint presspos;
    bool mousePressed;
public:
	void setDir( const QString &s );
public:
	QPixmap *folderLocked;
	QPixmap *folderClosed;
	QPixmap *folderOpen;
};

#endif
