#ifndef _SCRIPTCENTERWIDGET_H_
#define _SCRIPTCENTERWIDGET_H_
//
//   File : scriptcenterwidget.h
//   Creation date : Thu Oct 05 2000 12:42:59 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include <qwidget.h>

class KviEventEditor;
class KviAliasEditor;
class KviPopupEditor;
class KviRawEditor;

class KviScriptCenterWidget : public QWidget
{
	Q_OBJECT
public:
	KviScriptCenterWidget(QWidget * parent,const char * name);
	~KviScriptCenterWidget();
private:
	KviEventEditor * m_pEventEditor;
	KviAliasEditor * m_pAliasEditor;
	KviPopupEditor * m_pPopupEditor;
	KviRawEditor   * m_pRawEditor;
public:
	virtual void closeEvent(QCloseEvent *e);
	void commit();
	virtual bool focusNextPrevChild(bool next);
protected slots:
	void acceptClicked();
	void rejectClicked();
	void applyClicked();
};


#endif // _SCRIPTCENTERWIDGET_H_
