//
//   File : scriptcenterwidget.cpp
//   Creation date : Thu Oct 05 2000 12:45:44 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "scriptcenterwidget.h"

#include "kvi_locale.h"
#include "kvi_iconmanager.h"

#include "codetester.h"
#include "eventeditor.h"
#include "raweditor.h"
#include "aliaseditor.h"
#include "popupeditor.h"


#include <qlayout.h>
#include <qtabwidget.h>
#include <qpushbutton.h>
#include <qvariant.h>

extern KviScriptCenterWidget * g_pScriptCenterWidget;
extern QRect                   g_rectScriptCenterGeometry;

KviScriptCenterWidget::KviScriptCenterWidget(QWidget * parent,const char * name)
: QWidget(parent,name)
{
	QGridLayout * g = new QGridLayout(this,2,4,2,4);
	QTabWidget * t = new QTabWidget(this,"tab_widget");
	g->addMultiCellWidget(t,0,0,0,3);
	QPushButton * b = new QPushButton(__c2q(__tr("Discard changes")),this);
	connect(b,SIGNAL(clicked()),this,SLOT(rejectClicked()));
	g->addWidget(b,1,1);
	b = new QPushButton(__c2q(__tr("Apply changes")),this);
	connect(b,SIGNAL(clicked()),this,SLOT(applyClicked()));
	g->addWidget(b,1,2);
	b = new QPushButton(__c2q(__tr("Accept changes")),this);
	connect(b,SIGNAL(clicked()),this,SLOT(acceptClicked()));
	g->addWidget(b,1,3);

	KviCodeTester * tester = new KviCodeTester(t);
	t->addTab(tester,*(g_pIconManager->getSmallIcon(KVI_SMALLICON_BOMB)),__c2q(__tr("Tester")));

	m_pAliasEditor = new KviAliasEditor(t);
	t->addTab(m_pAliasEditor,*(g_pIconManager->getSmallIcon(KVI_SMALLICON_ALIAS)),__c2q(__tr("Aliases")));

	m_pEventEditor = new KviEventEditor(t);
	t->addTab(m_pEventEditor,*(g_pIconManager->getSmallIcon(KVI_SMALLICON_EVENT)),__c2q(__tr("Events")));

	m_pRawEditor = new KviRawEditor(t);
	t->addTab(m_pRawEditor,*(g_pIconManager->getSmallIcon(KVI_SMALLICON_RAWEVENT)),__c2q(__tr("Raw events")));


	m_pPopupEditor = new KviPopupEditor(t);
	t->addTab(m_pPopupEditor,*(g_pIconManager->getSmallIcon(KVI_SMALLICON_POPUP)),__c2q(__tr("Popups")));

	setIcon(*(g_pIconManager->getSmallIcon(KVI_SMALLICON_SCRIPTCENTER)));
	setCaption(__c2q(__tr("Script center")));


	if(!parent)setGeometry(g_rectScriptCenterGeometry);
}

KviScriptCenterWidget::~KviScriptCenterWidget()
{
	if(!parent())
	{
		g_rectScriptCenterGeometry = QRect(pos().x(),pos().y(),size().width(),size().height());
	}

	g_pScriptCenterWidget = 0;
}

void KviScriptCenterWidget::commit()
{
	m_pEventEditor->commit();
	m_pAliasEditor->commit();
	m_pPopupEditor->commit();
	m_pRawEditor->commit();
}

void KviScriptCenterWidget::acceptClicked()
{
	commit();
	delete this;
}

void KviScriptCenterWidget::rejectClicked()
{
	delete this;
}

void KviScriptCenterWidget::applyClicked()
{
	commit();
}

void KviScriptCenterWidget::closeEvent(QCloseEvent *e)
{
	e->ignore();
	delete this;
}

bool KviScriptCenterWidget::focusNextPrevChild(bool next)
{
	QWidget * w = focusWidget();
	if(w)
	{
		QVariant v = w->property("KviProperty_FocusOwner");
		if(v.isValid())return false; // Do NOT change the focus widget!
		if(w->parent())v = w->parent()->property("KviProperty_ChildFocusOwner");
		if(v.isValid())return false; // Do NOT change the focus widget!
	}
	return QWidget::focusNextPrevChild(next);
}

#include "m_scriptcenterwidget.moc"
