#ifndef _RAWEDITOR_H_
#define _RAWEDITOR_H_
//
//   File : raweditor.h
//   Creation date : Fri Jan 11 2002 12:34:12 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2002 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_string.h"

#include <qwidget.h>
#include <qlistview.h>
#include <qlineedit.h>

class KviScriptEditor;

class KviRawListViewItem : public QListViewItem
{
public:
	int    m_iIdx;
	KviStr m_szName;
public:
	KviRawListViewItem(QListView * par,int idx);
	~KviRawListViewItem() {};
public:
	virtual QString text(int col) const { return m_szName.ptr(); };
	virtual const QPixmap * pixmap(int col) const;
};

class KviRawHandlerListViewItem : public QListViewItem
{
public:
	KviRawHandlerListViewItem(QListViewItem * par,const char * name,const char * buffer,bool bEnabled)
	: QListViewItem(par), m_szName(name) , m_szBuffer(buffer) , m_bEnabled(bEnabled) {};
	~KviRawHandlerListViewItem() {};
public:
	KviStr m_szName;
	KviStr m_szBuffer;
	bool   m_bEnabled;
	virtual QString text(int col) const { return m_szName.ptr(); };
	virtual const QPixmap * pixmap(int col) const;
};

class QPopupMenu;

class KviRawEditor : public QWidget
{
	Q_OBJECT
public:
	KviRawEditor(QWidget * par);
	~KviRawEditor();
public:
	KviScriptEditor * m_pEditor;
	QListView       * m_pListView;
	QLineEdit       * m_pNameEditor;
	QPopupMenu      * m_pContextPopup;
	KviRawHandlerListViewItem * m_pLastEditedItem;
	bool              m_bOneTimeSetupDone;
public:
	void commit();
	void saveLastEditedItem();
	void getUniqueHandlerName(KviRawListViewItem *it,KviStr &buffer);
protected slots:
	void selectionChanged(QListViewItem *it);
	void itemPressed(QListViewItem *it,const QPoint &pnt,int col);
	void disableCurrentHandler();
	void enableCurrentHandler();
	void removeCurrentHandler();
	void addHandlerForCurrentRaw();
	void addRaw();
protected:
	void showEvent(QShowEvent *e);
private:
	void oneTimeSetup();
};

#endif // _RAWEDITOR_H_
