//
//   File : raweditor.cpp
//   Creation date : Sun Oct 10 2000 23:25:10 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "raweditor.h"

#include <qsplitter.h>
#include <qlayout.h>
#include <qvbox.h>
#include <qpopupmenu.h>
#include <qtooltip.h>
#include <qinputdialog.h>

#include "kvi_scripteditor.h"

#include "kvi_debug.h"
#include "kvi_event.h"
#include "kvi_locale.h"
#include "kvi_iconmanager.h"
#include "kvi_app.h"
#include "kvi_cmdformatter.h"
#include "kvi_eventhandler.h"

KviRawListViewItem::KviRawListViewItem(QListView *par,int idx)
: QListViewItem(par)
{
	m_iIdx = idx;
 	m_szName.setNum(idx);
	if(idx < 100)m_szName.prepend('0');
	if(idx < 10)m_szName.prepend('0');
};

const QPixmap * KviRawListViewItem::pixmap(int col) const
{
	return g_pIconManager->getSmallIcon(firstChild() ? KVI_SMALLICON_RAWEVENT : KVI_SMALLICON_RAWEVENTNOHANDLERS);
}

const QPixmap * KviRawHandlerListViewItem::pixmap(int col) const
{
	return g_pIconManager->getSmallIcon(m_bEnabled ? KVI_SMALLICON_HANDLER : KVI_SMALLICON_HANDLERDISABLED);
}



KviRawEditor::KviRawEditor(QWidget * par)
: QWidget(par,"raw_event_editor")
{
	QGridLayout * l = new QGridLayout(this,1,1,2,2);

	QSplitter * spl = new QSplitter(QSplitter::Horizontal,this);

	l->addWidget(spl,0,0);

	m_pListView = new QListView(spl);
	m_pListView->addColumn(__c2q(__tr("Raw events")));
	m_pListView->setMultiSelection(false);
	m_pListView->setShowSortIndicator(true);
	m_pListView->setRootIsDecorated(true);

	QVBox * box = new QVBox(spl);
	m_pNameEditor = new QLineEdit(box);
	QToolTip::add(m_pNameEditor,__c2q(__tr("Handler name")));
	m_pEditor = kvi_createScriptEditor(box);

	m_bOneTimeSetupDone = false;
	m_pLastEditedItem = 0;
}

KviRawEditor::~KviRawEditor()
{
}

void KviRawEditor::oneTimeSetup()
{
	if(m_bOneTimeSetupDone)return;
	m_bOneTimeSetupDone = true;

	KviRawListViewItem * it;
	KviRawHandlerListViewItem * ch;

	for(int i = 0;i < 999;i++)
	{
		KviPtrList<KviEventHandler> * l = g_pEventManager->rawNumericHandlers(i);

		if(l)
		{
			it = new KviRawListViewItem(m_pListView,i);
			for(KviEventHandler * s = l->first();s;s = l->next())
			{
				if(s->type() == KviEventHandler::Script)
				{
					ch = new KviRawHandlerListViewItem(it,((KviScriptEventHandler *)s)->name(),
					((KviScriptEventHandler *)s)->code(),((KviScriptEventHandler *)s)->enabled());
				}
			}
			it->setOpen(true);
		}
	}


	m_pContextPopup = new QPopupMenu(this);

	connect(m_pListView,SIGNAL(selectionChanged(QListViewItem *)),this,SLOT(selectionChanged(QListViewItem *)));
	connect(m_pListView,SIGNAL(rightButtonPressed(QListViewItem *,const QPoint &,int)),
		this,SLOT(itemPressed(QListViewItem *,const QPoint &,int)));
}

void KviRawEditor::itemPressed(QListViewItem *it,const QPoint &pnt,int col)
{
	__range_valid(m_bOneTimeSetupDone);

	m_pContextPopup->clear();

	if(it)
	{
		if(it->parent())
		{
			if(((KviRawHandlerListViewItem *)it)->m_bEnabled)
			{
				m_pContextPopup->insertItem(
					*(g_pIconManager->getSmallIcon(KVI_SMALLICON_HANDLERDISABLED)),
					__c2q(__tr("Disable this handler")),
					this,SLOT(disableCurrentHandler()));
			} else {
				m_pContextPopup->insertItem(
					*(g_pIconManager->getSmallIcon(KVI_SMALLICON_HANDLER)),
					__c2q(__tr("Enable this handler")),
					this,SLOT(enableCurrentHandler()));
			}
			m_pContextPopup->insertItem(
					*(g_pIconManager->getSmallIcon(KVI_SMALLICON_QUIT)),
					__c2q(__tr("Remove this handler")),
					this,SLOT(removeCurrentHandler()));
		} else {
			m_pContextPopup->insertItem(
				*(g_pIconManager->getSmallIcon(KVI_SMALLICON_HANDLER)),
				__c2q(__tr("Add handler")),
				this,SLOT(addHandlerForCurrentRaw()));
		}

		m_pContextPopup->insertSeparator();

	}

	m_pContextPopup->insertItem(
			*(g_pIconManager->getSmallIcon(KVI_SMALLICON_RAWEVENT)),
			__c2q(__tr("Add raw event")),
			this,SLOT(addRaw()));

	m_pContextPopup->popup(pnt);
}

void KviRawEditor::getUniqueHandlerName(KviRawListViewItem *it,KviStr &buffer)
{
	__range_valid(m_bOneTimeSetupDone);

	KviStr newName = buffer;
	if(newName.isEmpty())newName = __c2q(__tr("unnamed"));

	bool bFound = true;
	int idx = 1;

	while(bFound)
	{
		bFound = false;

		for(KviRawHandlerListViewItem * ch = (KviRawHandlerListViewItem *)(it->firstChild());ch;ch = (KviRawHandlerListViewItem *)ch->nextSibling())
		{
			if(kvi_strEqualCI(newName.ptr(),ch->m_szName.ptr()))
			{
				bFound = true;
				newName.sprintf("%s_%d",buffer.ptr(),idx);
				idx++;
				break;
			}
		}

	}

	buffer = newName;
}

void KviRawEditor::addRaw()
{
	bool bOk = false;

	int iIdx = QInputDialog::getInteger(__c2q(__tr("New raw event handler")),__c2q(__tr("Please enter the RAW message number (0-999)")),0,0,999,1,&bOk,this);

	if(bOk)
	{
		KviRawListViewItem * it;
		for(it = (KviRawListViewItem *)m_pListView->firstChild();it;it = (KviRawListViewItem *)it->nextSibling())
		{
			if(it->m_iIdx == iIdx)
			{
				m_pListView->setSelected(it,true);
//				m_pListView->setCurrentItem(it);
				goto add_handler;
			}
		}

		it = new KviRawListViewItem(m_pListView,iIdx);
		m_pListView->setSelected(it,true);
//		m_pListView->setCurrentItem(it);

add_handler:
		addHandlerForCurrentRaw();

	}
}

void KviRawEditor::addHandlerForCurrentRaw()
{
	__range_valid(m_pOneTimeSetupDone);

	QListViewItem * it = m_pListView->selectedItem();
	if(it)
	{
		if(it->parent() == 0)
		{
			KviStr buffer = __c2q(__tr("default"));
			getUniqueHandlerName((KviRawListViewItem *)it,buffer);
			QListViewItem * ch = new KviRawHandlerListViewItem(it,buffer.ptr(),"",true);
			it->setOpen(true);
			m_pListView->setSelected(ch,true);
		}
	}
}

void KviRawEditor::removeCurrentHandler()
{
	__range_valid(m_pOneTimeSetupDone);
	if(m_pLastEditedItem)
	{
		QListViewItem * it = m_pLastEditedItem;
		m_pLastEditedItem = 0;
		delete it;
		m_pEditor->setEnabled(false);
		m_pNameEditor->setEnabled(false);
	}
}

void KviRawEditor::enableCurrentHandler()
{
	__range_valid(m_pOneTimeSetupDone);
	if(m_pLastEditedItem)
	{
		m_pLastEditedItem->m_bEnabled = true;
		m_pListView->repaintItem(m_pLastEditedItem);
		selectionChanged(m_pLastEditedItem);
	}
}

void KviRawEditor::disableCurrentHandler()
{
	__range_valid(m_pOneTimeSetupDone);
	if(m_pLastEditedItem)
	{
		m_pLastEditedItem->m_bEnabled = false;
		m_pListView->repaintItem(m_pLastEditedItem);
		selectionChanged(m_pLastEditedItem);
	}
}

void KviRawEditor::commit()
{
	if(!m_bOneTimeSetupDone)return; // nothing to commit

	saveLastEditedItem();
	g_pEventManager->clearRawScriptHandlers();
	for(QListViewItem * it = m_pListView->firstChild();it;it = it->nextSibling())
	{
		if(it->firstChild())
		{
			for(QListViewItem * ch = it->firstChild();ch;ch = ch->nextSibling())
			{
				g_pEventManager->registerRawNumericScriptHandler(
					((KviRawListViewItem *)it)->m_iIdx,
					((KviRawHandlerListViewItem *)ch)->m_szName.ptr(),
					((KviRawHandlerListViewItem *)ch)->m_szBuffer.ptr(),
					((KviRawHandlerListViewItem *)ch)->m_bEnabled
				);
			}
		}
	}

	g_pApp->saveRawEvents(); // otherwise this page has never been shown
}

void KviRawEditor::saveLastEditedItem()
{
	__range_valid(m_bOneTimeSetupDone);
	if(!m_pLastEditedItem)return;

	KviStr buffer = m_pNameEditor->text();
	if(!kvi_strEqualCI(buffer.ptr(),m_pLastEditedItem->m_szName.ptr()))
	{
		getUniqueHandlerName((KviRawListViewItem *)(m_pLastEditedItem->parent()),buffer);
	}

	m_pLastEditedItem->m_szName = buffer.ptr();
	QCString tmp;
	m_pEditor->getText(tmp);

	m_pLastEditedItem->m_szBuffer = tmp.data();
}

void KviRawEditor::selectionChanged(QListViewItem * it)
{
	__range_valid(m_bOneTimeSetupDone);
	saveLastEditedItem();
	if(it->parent())
	{
		m_pLastEditedItem = (KviRawHandlerListViewItem *)it;
		m_pNameEditor->setEnabled(true);
		m_pNameEditor->setText(it->text(0));
		m_pEditor->setEnabled(true);
		m_pEditor->setText(((KviRawHandlerListViewItem *)it)->m_szBuffer.ptr());
	} else {
		m_pLastEditedItem = 0;
		m_pNameEditor->setEnabled(false);
		m_pNameEditor->setText("");
		m_pEditor->setEnabled(false);
//		KviStr parms = ((KviRawListViewItem *)it)->m_szParams;
//		if(parms.isEmpty())parms = __tr("none");
//		KviCommandFormatter::indent(parms);
//		KviCommandFormatter::indent(parms);
//		KviStr tmp(KviStr::Format,__tr("\n\n	Raw:\n		%s\n\n	Parameters:\n%s"),
//			((KviRawListViewItem *)it)->m_szName.ptr(),parms.ptr());
//		m_pEditor->setText(tmp.ptr());
	}
}

void KviRawEditor::showEvent(QShowEvent *e)
{
	oneTimeSetup();
	QWidget::showEvent(e);
}

#include "m_raweditor.moc"
