#ifndef _POPUPEDITOR_H_
#define _POPUPEDITOR_H_
//
//   File : popupeditor.h
//   Creation date : Sat Jul 7 2001 15:05:12 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//


#include "kvi_string.h"

#include <qwidget.h>
#include <qlistview.h>
#include <qlineedit.h>
#include <qpopupmenu.h>
#include <qtoolbutton.h>

class KviPopupMenu;


// KviPopupListViewItem
class KviPopupListViewItem : public QListViewItem
{
public:
	enum Type { Item , Menu , Separator , Label , Epilogue , Prologue , ExtMenu };
public:
	KviPopupListViewItem(QListView * pListView,KviPopupListViewItem * after,Type t);
	KviPopupListViewItem(KviPopupListViewItem * parent,KviPopupListViewItem * after,Type t);
public:
	Type                   m_type;
	KviStr                 m_szText;
	KviStr                 m_szCondition;
	KviStr                 m_szIcon;
	KviStr                 m_szCode;
private:
	void init();
public:
	void setItemText(const char * szText);
	void setCondition(const char * szCondition);
	void setIcon(const char * szIcon);
	void setCode(const char * szCode);
};



class KviScriptEditor;

class KviMenuListViewItem;

class KviSinglePopupEditor : public QWidget
{
	Q_OBJECT
public:
	KviSinglePopupEditor(QWidget * par);
	~KviSinglePopupEditor();
protected:
	QToolButton          * m_pMenuButton;
	KviPopupMenu         * m_pClipboard;
	KviPopupListViewItem * m_pLastSelectedItem;
	QListView            * m_pListView;
	QLineEdit            * m_pNameEditor;
	KviScriptEditor      * m_pEditor;
	QLineEdit            * m_pTextEditor;
	QLineEdit            * m_pIconEditor;
	QLineEdit            * m_pConditionEditor;
	QLineEdit            * m_pExtNameEditor;
	QPopupMenu           * m_pContextPopup;
public:
	void edit(KviMenuListViewItem * it);
	KviPopupMenu * getMenu();
protected:
	// theItem is the item above the first item that has to be inserted
	void populateMenu(KviPopupMenu * pop,KviPopupListViewItem * par,KviPopupListViewItem * theItem = 0);
	void saveLastSelectedItem();
	void addItemToMenu(KviPopupMenu * pop,KviPopupListViewItem * par);
	KviPopupListViewItem * findPrologue(KviPopupListViewItem * par);
	KviPopupListViewItem * findEpilogue(KviPopupListViewItem * par);
	KviPopupListViewItem * findFirst(KviPopupListViewItem * par,KviPopupListViewItem::Type t);
	KviPopupListViewItem * newItem(KviPopupListViewItem * par,KviPopupListViewItem * after,KviPopupListViewItem::Type t);
	KviPopupListViewItem * newItemBelow(KviPopupListViewItem * it,KviPopupListViewItem::Type t);
	KviPopupListViewItem * newItemAbove(KviPopupListViewItem * it,KviPopupListViewItem::Type t);
	KviPopupListViewItem * newItemInside(KviPopupListViewItem * it,KviPopupListViewItem::Type t);
	void createNewItemAboveLastSelected(KviPopupListViewItem::Type t);
	void createNewItemBelowLastSelected(KviPopupListViewItem::Type t);
	void createNewItemInsideLastSelected(KviPopupListViewItem::Type t);

protected slots:
	void contextCut();
	void contextCopy();
	void contextPasteBelow();
	void contextPasteAbove();
	void contextPasteInside();
	void contextNewSeparatorBelow();
	void contextNewSeparatorAbove();
	void contextNewSeparatorInside();
	void contextNewItemBelow();
	void contextNewItemAbove();
	void contextNewItemInside();
	void contextNewMenuBelow();
	void contextNewMenuAbove();
	void contextNewMenuInside();
	void contextNewExtMenuBelow();
	void contextNewExtMenuAbove();
	void contextNewExtMenuInside();
	void contextNewLabelBelow();
	void contextNewLabelAbove();
	void contextNewLabelInside();
	void contextNewPrologue();
	void contextNewEpilogue();
	void selectionChanged(QListViewItem * it);
	void itemPressed(QListViewItem *it,const QPoint &pnt,int col);
	void menuGenerateDefPopup();
};



class KviMenuListViewItem : public QListViewItem
{
public:
	KviMenuListViewItem(QListView * par,KviPopupMenu * popup);
	~KviMenuListViewItem();
public:
	KviPopupMenu * m_pPopup;
public:
	void replacePopup(KviPopupMenu * popup);
};


class KviPopupEditor : public QWidget
{
	Q_OBJECT
public:
	KviPopupEditor(QWidget * par);
	~KviPopupEditor();
public:
	KviSinglePopupEditor * m_pEditor;
	QListView            * m_pListView;
	KviMenuListViewItem * m_pLastEditedItem;
	bool                   m_bOneTimeSetupDone;
	QPopupMenu           * m_pContextPopup;
public:
	void commit();
protected slots:
	void selectionChanged(QListViewItem *it);
	void newPopup();
	void removeCurrentPopup();
	void itemPressed(QListViewItem *it,const QPoint &pnt,int col);
protected:
	void showEvent(QShowEvent *e);
private:
	void oneTimeSetup();
	void saveLastEditedItem();
	void getUniquePopupName(KviMenuListViewItem * it,KviStr &buffer);

};

#endif // _POPUPEDITOR_H_
