//
//   File : libkviscriptcenter.cpp
//   Creation date : Thu Oct 05 2000 12:30:25 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"

#include "kvi_module.h"
#include "kvi_uparser.h"
#include "kvi_window.h"
#include "kvi_frame.h"
#include "scriptcenterwidget.h"
#include "kvi_config.h"

#include <qsplitter.h>


KviScriptCenterWidget * g_pScriptCenterWidget = 0;
QRect                   g_rectScriptCenterGeometry;


/*
	@doc: scriptcenter.open
	@type:
		command
	@title:
		scriptcenter.open
	@short:
		Shows the "scriptcenter dialog"
	@syntax:
		scriptcenter.open [-t]
	@description:
		Shows the KVIrc "script center dialog". If the dialog
		is already open it is simply reparented to the current
		frame.[br]
		If the [-t] switch is used , the dialog is opened as toplevel window,
		otherwise it is opened as part of the current frame window.[br]
		This command is exported by the "scriptcenter" module.
*/

static bool scriptcenter_module_cmd_open(KviModule *m,KviCommand *c)
{
	ENTER_CONTEXT(c,"scriptcenter_module_cmd_open");

	KviStr dummy;
	if(!g_pUserParser->parseCmdFinalPart(c,dummy))return false;

	if(g_pScriptCenterWidget)
	{
		if(c->hasSwitch('t'))
		{
			if(g_pScriptCenterWidget->parent())
			{
				g_pScriptCenterWidget->reparent(0,QPoint(0,0),true);
			}
		} else {
			if(g_pScriptCenterWidget->parent() != c->window()->frame()->splitter())
			{
				g_pScriptCenterWidget->reparent(c->window()->frame()->splitter(),QPoint(0,0),true);
			}
		}
	} else {
		g_pScriptCenterWidget = new KviScriptCenterWidget(
			c->hasSwitch('t') ? 0 : c->window()->frame()->splitter(),"script_center");
	}

	g_pScriptCenterWidget->show();
	g_pScriptCenterWidget->raise();
	g_pScriptCenterWidget->setFocus();

	return c->leaveContext();
}

static bool scriptcenter_module_init(KviModule * m)
{
	KviStr fName;
	m->getDefaultConfigFileName(fName);
	KviConfig cfg(fName.ptr());

	g_rectScriptCenterGeometry = cfg.readRectEntry("geometry",QRect(30,30,500,400));

	m->registerCommand("open",scriptcenter_module_cmd_open);
	return true;
}

static bool scriptcenter_module_cleanup(KviModule *m)
{
	KviStr fName;
	m->getDefaultConfigFileName(fName);
	KviConfig cfg(fName.ptr());

	cfg.writeEntry("geometry",g_rectScriptCenterGeometry);

	if(g_pScriptCenterWidget)delete g_pScriptCenterWidget;
	m->unregisterMetaObject("KviScriptCenterWidget");
	m->unregisterMetaObject("KviCodeTester");
	m->unregisterMetaObject("KviEventEditor");
	m->unregisterMetaObject("KviAliasEditor");
	m->unregisterMetaObject("KviPopupEditor");
	m->unregisterMetaObject("KviSinglePopupEditor");
	return true;
}

static bool scriptcenter_module_can_unload(KviModule *m)
{
	return (!g_pScriptCenterWidget);
}

KVIMODULEEXPORTDATA KviModuleInfo kvirc_module_info=
{
	"ScriptCenter",                                         // module name
	"1.0.0",                                                // module version
	"Copyright (C) 2000 Szymon Stefanek (stefanek@tin.it)", // author & (C)
	"Script editor widget",
	scriptcenter_module_init,
	scriptcenter_module_can_unload,
	0,
	scriptcenter_module_cleanup
};
