//
//   File : codetester.cpp
//   Creation date : Fri Oct 06 2000 01:42:59 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "codetester.h"

#include "kvi_scripteditor.h"

#include "kvi_locale.h"

#include "kvi_uparser.h"
#include "kvi_app.h"
#include "kvi_console.h"
#include "kvi_parameterlist.h"

#include <qlayout.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qtoolbutton.h>
#include <qpopupmenu.h>

KviCodeTester::KviCodeTester(QWidget * par)
: QWidget(par,"code_tester")
{
	QGridLayout * g = new QGridLayout(this,2,4,2,2);
	m_pEditor = kvi_createScriptEditor(this);
	g->addMultiCellWidget(m_pEditor,0,0,0,3);
	m_pExecuteButton = new QPushButton(__c2q(__tr("Execute")),this);
	g->addWidget(m_pExecuteButton,1,3);
	connect(m_pExecuteButton,SIGNAL(clicked()),this,SLOT(execute()));
//	QToolButton * b = new QToolButton(DownArrow,this);
//	g->addWidget(b,1,0);

//	QPopupMenu * pop = new QPopupMenu(b);
//	pop->insertItem(__tr("Execute mode"),this,SLOT(switchToExecuteMode()));
//	pop->insertItem(__tr("Find mode"),this,SLOT(switchToFindMode()));
//	b->setPopup(pop);
//	b->setPopupDelay(0);

	m_pModeLabel = new QLabel(__c2q(__tr("Params:")),this);
	g->addWidget(m_pModeLabel,1,1);
	m_pParams = new QLineEdit(this);
	g->addWidget(m_pParams,1,2);

//	m_execMode = Execute;
}

KviCodeTester::~KviCodeTester()
{
}

//#warning "Allow to bind the command to a specified window"

void KviCodeTester::execute()
{
	KviStr parms = m_pParams->text();
	QCString buffer;
	m_pEditor->getText(buffer);
	KviConsole * con = g_pApp->activeConsole();
	KviParameterList * l = new KviParameterList(parms.ptr());
	g_pUserParser->parseCommandBuffer(buffer.data(),con,l);
}

#include "m_codetester.moc"
