#ifndef _ALIASEDITOR_H_
#define _ALIASEDITOR_H_
//
//   File : aliaseditor.h
//   Creation date : Sun Jun 10 2001 03:48:12 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_string.h"

#include <qwidget.h>
#include <qlistview.h>
#include <qlineedit.h>
#include <qpopupmenu.h>

class KviScriptEditor;

class KviAliasListViewItem : public QListViewItem
{
public:
	KviAliasListViewItem(QListView * par,const char * name,const char * buffer);
	~KviAliasListViewItem() {};
public:
	KviStr m_szName;
	KviStr m_szBuffer;
};


class KviAliasEditor : public QWidget
{
	Q_OBJECT
public:
	KviAliasEditor(QWidget * par);
	~KviAliasEditor();
public:
	KviScriptEditor      * m_pEditor;
	QListView            * m_pListView;
	QLineEdit            * m_pNameEditor;
	KviAliasListViewItem * m_pLastEditedItem;
	bool                   m_bOneTimeSetupDone;
	QPopupMenu           * m_pContextPopup;
public:
	void commit();
protected slots:
	void selectionChanged(QListViewItem *it);
	void newAlias();
	void removeCurrentAlias();
	void itemPressed(QListViewItem *it,const QPoint &pnt,int col);
protected:
	void showEvent(QShowEvent *e);
private:
	void oneTimeSetup();
	void saveLastEditedItem();
	void getUniqueHandlerName(KviAliasListViewItem *item,KviStr &buffer);

};

#endif // _ALIASEDITOR_H_
