//
//   File : aliaseditor.cpp
//   Creation date : Sun Jun 10 2001 03:53:10 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "aliaseditor.h"

#include <qsplitter.h>
#include <qlayout.h>
#include <qvbox.h>
#include <qtooltip.h>

#include "kvi_scripteditor.h"

#include "kvi_debug.h"
#include "kvi_locale.h"
#include "kvi_app.h"
#include "kvi_iconmanager.h"
#include "kvi_aliasmanager.h"


KviAliasListViewItem::KviAliasListViewItem(QListView * par,const char * name,const char * buffer)
: QListViewItem(par), m_szName(name), m_szBuffer(buffer)
{
	setPixmap(0,*(g_pIconManager->getSmallIcon(KVI_SMALLICON_ALIAS)));
	setText(0,m_szName.ptr());
}

KviAliasEditor::KviAliasEditor(QWidget * par)
: QWidget(par)
{
	QGridLayout * l = new QGridLayout(this,1,1,2,2);

	QSplitter * spl = new QSplitter(QSplitter::Horizontal,this);

	l->addWidget(spl,0,0);

	m_pListView = new QListView(spl);
	m_pListView->addColumn(__c2q(__tr("Alias")));
	m_pListView->setMultiSelection(false);
	m_pListView->setShowSortIndicator(true);

	QVBox * box = new QVBox(spl);
	m_pNameEditor = new QLineEdit(box);
	QToolTip::add(m_pNameEditor,__c2q(__tr("Alias name")));
	m_pEditor = kvi_createScriptEditor(box);

	m_bOneTimeSetupDone = false;
	m_pLastEditedItem = 0;

	m_pContextPopup = new QPopupMenu(this);

	selectionChanged(0);
}

KviAliasEditor::~KviAliasEditor()
{
}

void KviAliasEditor::oneTimeSetup()
{
	if(m_bOneTimeSetupDone)return;
	m_bOneTimeSetupDone = true;

	QAsciiDict<KviAlias> * a = g_pAliasManager->aliasDict();
	if(!a)return;

	QAsciiDictIterator<KviAlias> it(*a);
	KviAliasListViewItem * item;
	while(it.current())
	{
		KviAlias * alias = it.current();
		item = new KviAliasListViewItem(m_pListView,alias->name(),alias->dataBuffer());
		++it;
	}
	connect(m_pListView,SIGNAL(selectionChanged(QListViewItem *)),this,SLOT(selectionChanged(QListViewItem *)));
	connect(m_pListView,SIGNAL(rightButtonPressed(QListViewItem *,const QPoint &,int)),
		this,SLOT(itemPressed(QListViewItem *,const QPoint &,int)));

}

void KviAliasEditor::itemPressed(QListViewItem *it,const QPoint &pnt,int col)
{
	__range_valid(m_bOneTimeSetupDone);
	m_pContextPopup->clear();

	if(it)
	{
		m_pContextPopup->insertItem(
				*(g_pIconManager->getSmallIcon(KVI_SMALLICON_QUIT)),
				__c2q(__tr("Remove this alias")),
				this,SLOT(removeCurrentAlias()));
		m_pContextPopup->insertSeparator();
	}

	m_pContextPopup->insertItem(
		*(g_pIconManager->getSmallIcon(KVI_SMALLICON_ALIAS)),
		__c2q(__tr("Add new alias")),
		this,SLOT(newAlias()));

	m_pContextPopup->popup(pnt);
}

void KviAliasEditor::removeCurrentAlias()
{
	if(m_pLastEditedItem)
	{
		KviAliasListViewItem * it = m_pLastEditedItem;
		m_pLastEditedItem = 0;
		delete it;
		if(!m_pLastEditedItem)selectionChanged(0);
	}
}

void KviAliasEditor::newAlias()
{
	KviStr newName;
	getUniqueHandlerName(0,newName);
	KviAliasListViewItem * it = new KviAliasListViewItem(m_pListView,newName,"");
	m_pListView->setCurrentItem(it);
}

void KviAliasEditor::saveLastEditedItem()
{
	if(m_pLastEditedItem == 0)return;

	KviStr newName = m_pNameEditor->text();
	if(!kvi_strEqualCI(newName.ptr(),m_pLastEditedItem->m_szName.ptr()))
	{
		getUniqueHandlerName(m_pLastEditedItem,newName);
	}

	m_pLastEditedItem->m_szName = newName;

	QCString tmp;
	m_pEditor->getText(tmp);

	m_pLastEditedItem->m_szBuffer = tmp.data();
	m_pLastEditedItem->setText(0,newName.ptr());
	
}

void KviAliasEditor::selectionChanged(QListViewItem *it)
{
	saveLastEditedItem();

	m_pLastEditedItem = (KviAliasListViewItem *)it;
	if(it)
	{
		m_pNameEditor->setText(((KviAliasListViewItem *)it)->m_szName.ptr());
		m_pEditor->setText(((KviAliasListViewItem *)it)->m_szBuffer.ptr());
	}
	m_pNameEditor->setEnabled(it);
	m_pEditor->setEnabled(it);
}

void KviAliasEditor::showEvent(QShowEvent *e)
{
	oneTimeSetup();
	QWidget::showEvent(e);
}

void KviAliasEditor::commit()
{
	if(!m_bOneTimeSetupDone)return;

	saveLastEditedItem();

	g_pAliasManager->clear();

	KviAliasListViewItem * it = (KviAliasListViewItem *)m_pListView->firstChild();

	while(it)
	{
		KviAlias * a = new KviAlias(it->m_szName.ptr());
		a->setDataBuffer(it->m_szBuffer.ptr());
		g_pAliasManager->addAlias(it->m_szName.ptr(),a);
		it = (KviAliasListViewItem *)it->nextSibling();
	}

	g_pApp->saveAliases();

}


void KviAliasEditor::getUniqueHandlerName(KviAliasListViewItem *item,KviStr &buffer)
{
	__range_valid(m_bOneTimeSetupDone);

	if(buffer.isEmpty())buffer = __tr("unnamed");
	KviStr newName = buffer;

	bool bFound = true;
	int idx = 1;

	while(bFound)
	{
		bFound = false;

		for(KviAliasListViewItem * ch = (KviAliasListViewItem *)(m_pListView->firstChild());ch;ch = (KviAliasListViewItem *)ch->nextSibling())
		{
			if(kvi_strEqualCI(newName.ptr(),ch->m_szName.ptr()) && (ch != item))
			{
				bFound = true;
				newName.sprintf("%s.%d",buffer.ptr(),idx);
				idx++;
				break;
			}
		}

	}

	buffer = newName;
}

#include "m_aliaseditor.moc"
