#ifndef _EDITUSER_H_
#define _EDITUSER_H_
//
//   File : edituser.h
//   Creation date : Sun Dec 24 2000 15:16:17 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_string.h"
#include "kvi_regusersdb.h"

#include <qwidget.h>
#include <qlineedit.h>
#include <qtable.h>
#include <qpopupmenu.h>
#include <qpushbutton.h>
#include <qtabwidget.h>
#include <qlistview.h>
#include <qlistbox.h>
#include <qcombobox.h>
#include <qasciidict.h>

class KviRegisteredUser;
class KviUserEditor;

class KviUserEditorWidget : public QWidget
{
	friend class KviUserEditor;
	Q_OBJECT
protected:
	KviUserEditorWidget(QWidget * par,KviRegisteredUser *u,const char * name = 0);
public:
	~KviUserEditorWidget();
private:
	KviStr          m_szOriginalName;
	QLineEdit     * m_pNameEdit;
	QTable        * m_pMaskTable;
	QTable        * m_pPropertyTable;
	QPushButton   * m_pDelMaskButton;
	QPushButton   * m_pAddMaskButton;
	QPushButton   * m_pDelPropertyButton;
	QPushButton   * m_pAddPropertyButton;
	QPushButton   * m_pChangeButton;
protected:
	const char * originalName(){ return m_szOriginalName; };
private slots:
	void delMaskClicked();
	void addMaskClicked();
	void delPropertyClicked();
	void addPropertyClicked();
	void closeClicked();
	void changeClicked();
	void finishClicked();
	void maskValueChanged(int,int);
	void propertyValueChanged(int,int);
public slots:
	void refillData();
signals:
	void changed();
};

class KviNotifyListEditorWidget : public QWidget
{
	Q_OBJECT
public:
	KviNotifyListEditorWidget(QWidget * par,const char * name = 0);
	~KviNotifyListEditorWidget();
private:
	QListBox	* m_pNickListBox;
	QLineEdit	* m_pNickEdit;
	QComboBox	* m_pUserCombo;
	QPushButton	* m_pAddButton;
	QPushButton	* m_pRemoveButton;
public slots:
	void refillNotifyList();	
private slots:
	void addClicked();
	void removeClicked();
	void itemClicked(QListBoxItem *);
signals:
	void changed();
	
};

class KviUserEditorIndex : public QWidget
{
	Q_OBJECT
public:
	KviUserEditorIndex(QWidget * par,const char * name = 0);
	~KviUserEditorIndex();
private:
	QListView    * m_pListView;
	QPushButton  * m_pAddButton;
	QPushButton  * m_pRemoveButton;
	QPushButton  * m_pEditButton;
	QPushButton  * m_pExportButton;
	QPushButton  * m_pImportButton;
public slots:
	void refillUserList();
	void selectionChanged();
	void addNewUser();
	void editUser();
	void removeUser();

	void exportSelected();
	void importFromFile();
signals:
	void changed();
};

class KviUserEditor : public QWidget
{
	friend class KviUserEditorWidget;
	Q_OBJECT
public:
	KviUserEditor(QWidget * par,const char * name = 0);
	~KviUserEditor();
private:
	QTabWidget                 * m_pTabWidget;
	KviUserEditorIndex         * m_pIndex;
	KviNotifyListEditorWidget  * m_pNotify;
	KviPtrList<KviUserEditorWidget> * m_pEditors;
protected:
	void registerEditor(KviUserEditorWidget * w);
	void unregisterEditor(KviUserEditorWidget *w);
	KviUserEditorWidget * findUserPage(const char * uName);
	virtual void closeEvent(QCloseEvent *e);
public:
	void editUser(const char * uName,bool bAddIfNonExisting = false);
	void removeUser(const char * uName);
private slots:
	void cancelClicked();
	void okClicked();
//private slots:
//	void commitEditor(KviUserEditorWidget *w);
//	void discardEditor(KviUserEditorWidget *w);
};

#endif //_EDITUSER_H_
