//
//   File : optw_userlist.cpp
//   Creation date : Sat Aug 11 2001 03:29:52 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#include "optw_userlist.h"

#include <qlayout.h>

#include "kvi_options.h"
#include "kvi_locale.h"

//#warning "Info tips"

KviUserListLookOptionsWidget::KviUserListLookOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"userlistlook_options_widget")
{
	createLayout(9,1);

	addFontSelector(0,0,0,0,__tr("Font"),KviOption_fontUserListView);
	addColorSelector(0,1,0,1,__tr("Background color"),KviOption_colorUserListViewBackground);
	addColorSelector(0,2,0,2,__tr("Op foreground color"),KviOption_colorUserListViewOpForeground);
	addColorSelector(0,3,0,3,__tr("Half-op foreground color"),KviOption_colorUserListViewHalfOpForeground);
	addColorSelector(0,4,0,4,__tr("Voice foreground color"),KviOption_colorUserListViewVoiceForeground);
	addColorSelector(0,5,0,5,__tr("Normal foreground color"),KviOption_colorUserListViewNormalForeground);
	addColorSelector(0,6,0,6,__tr("Selection foreground color"),KviOption_colorUserListViewSelectionForeground);
	addColorSelector(0,7,0,7,__tr("Selection background color"),KviOption_colorUserListViewSelectionBackground);
	addPixmapSelector(0,8,0,8,__tr("Background image"),KviOption_pixmapUserListViewBackground);

	layout()->setRowStretch(8,1);
}

KviUserListLookOptionsWidget::~KviUserListLookOptionsWidget()
{
}



KviUserListFeaturesOptionsWidget::KviUserListFeaturesOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"userlistfeatures_options_widget")
{
	createLayout(3,1);

	addBoolSelector(0,0,0,0,__tr("Show user channel icons"),KviOption_boolShowUserChannelIcons);
	addBoolSelector(0,1,0,1,__tr("Show user channel state"),KviOption_boolShowUserChannelState);

	addRowSpacer(0,2,0,2);
}

KviUserListFeaturesOptionsWidget::~KviUserListFeaturesOptionsWidget()
{
}

#include "m_optw_userlist.moc"
