//
//   File : optw_transport.cpp
//   Creation date : Mon Nov 13 2000 14:14:22 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "optw_transport.h"

#include <qlayout.h>

#include "kvi_options.h"
#include "kvi_locale.h"

KviTransportOptionsWidget::KviTransportOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"transport_options_widget")
{
#ifdef COMPILE_IPV6_SUPPORT
	createLayout(11,2);
#else
	createLayout(10,2);
#endif
	addBoolSelector(0,0,1,0,__tr("Use proxy host"),KviOption_boolUseProxyHost);
	addSeparator(0,1,1,1);
	addUIntSelector(0,2,1,2,__tr("Connect timeout (5-6000 sec.)"),KviOption_uintIrcSocketTimeout,5,6000,60);
	addUIntSelector(0,3,1,3,__tr("Outgoing data queue flush timeout (100-2000 msec.)"),KviOption_uintSocketQueueFlushTimeout,100,2000,500);
	addSeparator(0,4,1,4);
	connect(
		addBoolSelector(0,5,1,5,__tr("Limit outgoing traffic to"),KviOption_boolLimitOutgoingTraffic),
		SIGNAL(toggled(bool)),
		addUIntSelector(0,6,1,6,__tr("1 message every (10000-10000000 usec.)"),
			KviOption_uintOutgoingTrafficLimitUSeconds,10000,2000000,10000000,KVI_OPTION_BOOL(KviOption_boolLimitOutgoingTraffic)),
		SLOT(setEnabled(bool)));
	addSeparator(0,7,1,7);
	connect(
		addBoolSelector(0,8,0,8,__tr("Bind IRC IPv4 connections to the following interface"),KviOption_boolBindIrcIpV4ConnectionsToSpecifiedAddress),
		SIGNAL(toggled(bool)),
		addStringSelector(1,8,1,8,"",KviOption_stringIpV4ConnectionBindAddress,KVI_OPTION_BOOL(KviOption_boolBindIrcIpV4ConnectionsToSpecifiedAddress)),
		SLOT(setEnabled(bool)));
#ifdef COMPILE_IPV6_SUPPORT
	connect(
		addBoolSelector(0,9,0,9,__tr("Bind IRC IPv4 connections to the following interface"),KviOption_boolBindIrcIpV6ConnectionsToSpecifiedAddress),
		SIGNAL(toggled(bool)),
		addStringSelector(1,9,1,9,"",KviOption_stringIpV6ConnectionBindAddress,KVI_OPTION_BOOL(KviOption_boolBindIrcIpV6ConnectionsToSpecifiedAddress)),
		SLOT(setEnabled(bool)));
	addRowSpacer(0,10,0,10);
#else
	addRowSpacer(0,9,0,9);
#endif //!COMPILE_IPV6_SUPPORT
}

KviTransportOptionsWidget::~KviTransportOptionsWidget()
{
}


#include "m_optw_transport.moc"
