//
//   File : optw_taskbar.cpp
//   Creation date : Wed Jan 16 04:30:39 2002 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "optw_taskbar.h"

#include "kvi_settings.h"
#include "kvi_locale.h"
#include "kvi_options.h"

//#ifdef COMPILE_INFO_TIPS
//	#include <qtooltip.h>
//#endif

KviTaskBarOptionsWidget::KviTaskBarOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"taskbar_options_widget")
{

	createLayout(1,1);

	QLabel * l = addLabel(0,0,0,0,__tr("<center>The pages below contain the old-style and tree task bar options</center>"));
}


KviTaskBarOptionsWidget::~KviTaskBarOptionsWidget()
{
}





KviTreeTaskBarOptionsWidget::KviTreeTaskBarOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"treetaskbar_options_widget")
{

	createLayout(13,1);

	addColorSelector(0,0,0,0,__tr("Background"),KviOption_colorTreeTaskBarBackground);
	addColorSelector(0,1,0,1,__tr("Active background"),KviOption_colorTreeTaskBarActiveBackground);
	addColorSelector(0,2,0,2,__tr("Foreground"),KviOption_colorTreeTaskBarForeground);
	addColorSelector(0,3,0,3,__tr("Active foreground"),KviOption_colorTreeTaskBarActiveForeground);
	addColorSelector(0,4,0,4,__tr("Progress bar"),KviOption_colorTreeTaskBarProgress);
	addColorSelector(0,5,0,5,__tr("Highlight level 1"),KviOption_colorTreeTaskBarHighlight1Foreground);
	addColorSelector(0,6,0,6,__tr("Highlight level 2"),KviOption_colorTreeTaskBarHighlight2Foreground);
	addColorSelector(0,7,0,7,__tr("Highlight level 3"),KviOption_colorTreeTaskBarHighlight3Foreground);
	addColorSelector(0,8,0,8,__tr("Highlight level 4"),KviOption_colorTreeTaskBarHighlight4Foreground);
	addColorSelector(0,9,0,9,__tr("Highlight level 5"),KviOption_colorTreeTaskBarHighlight5Foreground);
	addUIntSelector(0,10,0,10,__tr("Minimum width"),KviOption_uintTreeTaskBarMinimumWidth,24,1024,125);
    addUIntSelector(0,11,0,11,__tr("Maximum width"),KviOption_uintTreeTaskBarMaximumWidth,24,9999,125);
	addPixmapSelector(0,12,0,12,__tr("Background image"),KviOption_pixmapTreeTaskBarBackground);

	layout()->setRowStretch(12,1);

}


KviTreeTaskBarOptionsWidget::~KviTreeTaskBarOptionsWidget()
{
}




KviClassicTaskBarOptionsWidget::KviClassicTaskBarOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"classictaskbar_options_widget")
{

	createLayout(9,1);
	addColorSelector(0,0,0,0,__tr("Normal text"),KviOption_colorTaskBarNormalText);
	addColorSelector(0,1,0,1,__tr("Minimized text"), KviOption_colorTaskBarMinimizedText);
	addColorSelector(0,2,0,2,__tr("Progress bar"),KviOption_colorTaskBarProgressBar);
	addColorSelector(0,3,0,3,__tr("Highlight level 1"),KviOption_colorTaskBarHighlight1Text);
	addColorSelector(0,4,0,4,__tr("Highlight level 2"),KviOption_colorTaskBarHighlight2Text);
	addColorSelector(0,5,0,5,__tr("Highlight level 3"),KviOption_colorTaskBarHighlight3Text);
	addColorSelector(0,6,0,6,__tr("Highlight level 4"),KviOption_colorTaskBarHighlight4Text);
	addColorSelector(0,7,0,7,__tr("Highlight level 5"),KviOption_colorTaskBarHighlight5Text);
	addRowSpacer(0,8,0,8);
}


KviClassicTaskBarOptionsWidget::~KviClassicTaskBarOptionsWidget()
{
}

#include "m_optw_taskbar.moc"
