//
//   File : optw_ssl.cpp
//   Creation date : Thu Jul 20 20:52:30 2001 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "optw_ssl.h"

#include <qlayout.h>

#include "kvi_options.h"
#include "kvi_locale.h"

//#warning "Info tips"


KviSSLOptionsWidget::KviSSLOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"ssl_options_widget")
{
#ifdef COMPILE_SSL_SUPPORT
	createLayout(7,1);

	KviBoolSelector * b = addBoolSelector(0,0,0,0,__tr("Use SSL certificate (PEM format only)"),KviOption_boolUseSSLCertificate);
	connect(b,
		SIGNAL(toggled(bool)),
		addFileSelector(0,1,0,1,__tr("SSL certificate path"),
				KviOption_stringSSLCertificatePath,KVI_OPTION_BOOL(KviOption_boolUseSSLCertificate)),
		SLOT(setEnabled(bool)));
	connect(b,
		SIGNAL(toggled(bool)),
		addPasswordSelector(0,2,0,2,__tr("SSL certificate password (leave empty if not needed)"),
				KviOption_stringSSLCertificatePass,KVI_OPTION_BOOL(KviOption_boolUseSSLCertificate)),
		SLOT(setEnabled(bool)));


	b = addBoolSelector(0,3,0,3,__tr("Use SSL private key"),KviOption_boolUseSSLPrivateKey);
	connect(b,
		SIGNAL(toggled(bool)),
		addFileSelector(0,4,0,4,__tr("SSL private key path"),
				KviOption_stringSSLPrivateKeyPath,KVI_OPTION_BOOL(KviOption_boolUseSSLCertificate)),
		SLOT(setEnabled(bool)));
	connect(b,
		SIGNAL(toggled(bool)),
		addPasswordSelector(0,5,0,5,__tr("SSL private key password (leave empty if not needed)"),
				KviOption_stringSSLPrivateKeyPass,KVI_OPTION_BOOL(KviOption_boolUseSSLCertificate)),
		SLOT(setEnabled(bool)));
	addRowSpacer(0,6,0,6);
#else
	createLayout(1,1);
	addLabel(0,0,0,0,__tr("This executable has no SSL support"));
#endif
}

KviSSLOptionsWidget::~KviSSLOptionsWidget()
{
}

#include "m_optw_ssl.moc"
