#ifndef _OPTW_SERVERS_H_
#define _OPTW_SERVERS_H_

//
//   File : optw_servers.h
//   Creation date : Wed Jun 12 2000 03:29:01 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_optionswidget.h"
#include <qlistview.h>
#include <qdialog.h>

class KviIrcServer;



class KviServerOptionsListViewItem : public QListViewItem
{
public:
	KviServerOptionsListViewItem(QListView *parent,const QPixmap &pm,const char * netname);
	KviServerOptionsListViewItem(QListViewItem *parent,const QPixmap &pm,KviIrcServer *s);
	~KviServerOptionsListViewItem();
public:
	KviIrcServer * m_pServerData;
};

class QLabel;
class QLineEdit;
class KviIpEditor;
class KviIrcServer;
class QCheckBox;
class QPopupMenu;
class KviScriptEditor;

class KviServerDetailsWidget : public QDialog
{
	Q_OBJECT
public:
	KviServerDetailsWidget(QWidget * par,KviIrcServer * s);
	~KviServerDetailsWidget();
protected:
	KviScriptEditor * m_pCommandEditor;
	QLineEdit       * m_pUserEditor;
	QLineEdit       * m_pPassEditor;
	QLineEdit       * m_pNickEditor;
	QLineEdit       * m_pRealEditor;
	QLineEdit       * m_pDescEditor;
	KviIpEditor     * m_pIpEditor;
	QCheckBox       * m_pCacheIpCheck;
	QCheckBox       * m_pUseSSLCheck;
protected:
	virtual void closeEvent(QCloseEvent *e);
public:
	void fillData(KviIrcServer *s);
};


#define KVI_OPTIONS_WIDGET_ICON_KviServerOptionsWidget KVI_SMALLICON_SERVER
#define KVI_OPTIONS_WIDGET_NAME_KviServerOptionsWidget __tr_no_lookup("Irc servers")
#define KVI_OPTIONS_WIDGET_PARENT_KviServerOptionsWidget KviConnectionOptionsWidget

class KviServerOptionsWidget : public KviOptionsWidget
{
	Q_OBJECT
public:
	KviServerOptionsWidget(QWidget * parent);
	~KviServerOptionsWidget();
protected:
	QListView    * m_pListView;
//	QLabel       * m_pRecentLabel;
//	QListBox     * m_pRecentListBox;
	QLabel       * m_pSrvNetLabel;
	QLineEdit    * m_pSrvNetEdit;
	QLabel       * m_pPortLabel;
	QLineEdit    * m_pPortEdit;
	QPushButton  * m_pDetailsButton;
	QPopupMenu   * m_pRecentPopup;
	QPopupMenu   * m_pContextPopup;
	KviIrcServer * m_pClipboard;
	QCheckBox    * m_pIpV6Check;
	QPushButton  * m_pConnectCurrent;
	QPushButton  * m_pConnectNew;
	KviServerOptionsListViewItem * m_pLastEditedItem;
	KviServerDetailsWidget * m_pDetailsDialog;
private:
	void fillServerList();
	void saveLastItem();
	void importFromIni(const char * filename);
	KviServerOptionsListViewItem * findNetItem(const char * netname);
protected slots:
	void listViewItemSelectionChanged(QListViewItem *it);
	void listViewRightButtonPressed(QListViewItem *it,const QPoint &pnt,int col);
	void newNetwork();
	void removeCurrent();
	void newServer();
	void copyServer();
	void pasteServer();
	void importFromIni();
	void clearList();
	void detailsClicked();
	void connectCurrentClicked();
	void connectNewClicked();
	void recentServersPopupAboutToShow();
	void recentServersPopupClicked(int id);
//	void parseCommand(const KviStr & szCommand,KviStr & szServer,KviStr & szPort);
//	void itemRecentClicked(QListBoxItem * it);
//	void itemRecentDoubleClicked(QListBoxItem * it);
public:
	virtual void commit();
};

#endif //!_OPTW_SERVERS_H_
