//
//   File : optw_query.cpp
//   Creation date : Mon Oct 29 15:37:16 2001 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//


#include "optw_query.h"

#include <qlayout.h>

#include "kvi_options.h"
#include "kvi_locale.h"

#ifdef COMPILE_INFO_TIPS
	#include <qtooltip.h>
#endif


KviQueryOptionsWidget::KviQueryOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"query_options_widget")
{
	createLayout(5,1);

	QToolTip::add(
		addBoolSelector(0,0,0,0, __tr("Create query on PRIVMSG"),KviOption_boolCreateQueryOnPrivmsg),
		__tr("<center>This check enables query window creation<br>" \
			"when a private message is received.<br>" \
			"If you disable this, private messages will<br>" \
			"be shown in the active window.</center>"));
	QToolTip::add(
		addBoolSelector(0,1,0,1, __tr("Create query on NOTICE"),KviOption_boolCreateQueryOnNotice),
		__tr("<center>This check enabled query window creation<br>" \
			"when a private notice is received.<br>" \
			"If you disable this, private notices will<br>" \
			"be shown in the active window.</center>"));
	QToolTip::add(
		addBoolSelector(0,2,0,2, __tr("Create minimized query windows"),KviOption_boolCreateMinimizedQuery),
		__tr("<center>This opion causes newly created<br>" \
			"query windows to be immediately minimized.<br>" \
			"Enable this if you don't like queries<br>" \
			"poppingup when you're writing something in a channel :D</center>"));
	QToolTip::add(
		addBoolSelector(0,3,0,3, __tr("Enable query-user tracing"),KviOption_boolEnableQueryTracing),
		__tr("<center>This option will enable query-user tracking:<br>" \
			"the actions of the user that is the actual query<br>" \
			"target will be displayed in the window.<br>" \
			"(You will know when he joins or leaves common channels for example).</center>"));

	addRowSpacer(0,4,0,4);
}

KviQueryOptionsWidget::~KviQueryOptionsWidget()
{
}


#include "m_optw_query.moc"
