//
//   File : optw_notify.cpp
//   Creation date : Sun Oct 28 15:11:29 2001 GMT by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "optw_notify.h"

#include <qlayout.h>

#include "kvi_options.h"
#include "kvi_locale.h"

//#warning "Info tips"


KviNotifyOptionsWidget::KviNotifyOptionsWidget(QWidget * parent)
: KviOptionsWidget(parent,"notify_options_widget")
{
	createLayout(7,1);

	KviBoolSelector * b = addBoolSelector(0,0,0,0,__tr("Use notify list"),KviOption_boolUseNotifyList);
	connect(b,
		SIGNAL(toggled(bool)),
		addBoolSelector(0,1,0,1,__tr("Notify list changes to active window"),
				KviOption_boolNotifyListChangesToActiveWindow,KVI_OPTION_BOOL(KviOption_boolUseNotifyList)),
		SLOT(setEnabled(bool)));
	connect(b,
		SIGNAL(toggled(bool)),
		addBoolSelector(0,2,0,2,__tr("Check USERHOST for online users"),
				KviOption_boolNotifyListSendUserhostForOnlineUsers,KVI_OPTION_BOOL(KviOption_boolUseNotifyList)),
		SLOT(setEnabled(bool)));
	connect(b,
		SIGNAL(toggled(bool)),
		addBoolSelector(0,3,0,3,__tr("Use \"intelligent\" notify list manager"),
				KviOption_boolUseIntelligentNotifyListManager,KVI_OPTION_BOOL(KviOption_boolUseNotifyList)),
		SLOT(setEnabled(bool)));
	connect(b,
		SIGNAL(toggled(bool)),
		addBoolSelector(0,4,0,4,__tr("Use the \"WATCH\" method if the server supports it"),
				KviOption_boolUseWatchListIfAvailable,KVI_OPTION_BOOL(KviOption_boolUseNotifyList)),
		SLOT(setEnabled(bool)));
	connect(b,
		SIGNAL(toggled(bool)),
		addLabel(0,5,0,5,__tr("To add someone to the notify list, use the /notify command.\n" \
				"Tecnically speaking: you must register\n" \
				"his mask in the registered users database and then set his \"notify\"\n" \
				"property to the nicknames that you want to be notified."),KVI_OPTION_BOOL(KviOption_boolUseNotifyList)),
		SLOT(setEnabled(bool)));
	addRowSpacer(0,6,0,6);
}

KviNotifyOptionsWidget::~KviNotifyOptionsWidget()
{
}



#include "m_optw_notify.moc"
